# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['miteclock']

package_data = \
{'': ['*'], 'miteclock': ['completions/*']}

install_requires = \
['attrs>=21.4.0,<22.0.0',
 'backoff>=1.11.1',
 'click-aliases>=1.0.1',
 'click>=7.1.1',
 'requests>=2.23.0',
 'tomlkit>=0.7.2,<0.8.0']

extras_require = \
{':python_version == "3.7"': ['importlib-metadata>=4.10.0,<5.0.0']}

entry_points = \
{'console_scripts': ['m = miteclock.cli:main']}

setup_kwargs = {
    'name': 'miteclock',
    'version': '22.2',
    'description': 'Clock in and out of mite.yo.lk quickly.',
    'long_description': '# miteclock\n\nA command-line for [mite](https://mite.yo.lk/) that gets out of your way!\n\nDo you track time in mite, but wish you could control the clock with a few keystrokes\nfrom the nearest terminal window? Then give miteclock a try!\n\n## Motivation\n\nThe goal of this program is to address aspects of using mite that I, as a terminal and\nkeyboard user, have found inconvenient in daily use:\n\n- Having to search for the mite browser tab or opening a new one when I always have\n  terminal windows handy.\n- Having to switch between mouse (for projects/services) and keyboard (for notes) to\n  create an new entry.\n- Surprising narrow-by-typing behavior in the projects/services menus.\n- Inflexible support for templates, no ability to compose an entry from pre-defined\n  parts.\n\nSee [here](#why-yet-another-mite-cli) for more context.\n\n## Installation and Setup\n\nThis program is tested with Python versions 3.7-3.10. It doesn\'t have many dependencies\nso it is no big deal to install directly in your system Python environment. It\'s wiser\nthough to install it into a dedicated virtualenv and then add a symbolic link to the\nexecutable somewhere in your `PATH`. An even better option is to use the\n[pipx](https://github.com/pipxproject/pipx) wrapper which automatically takes care of\nthese two steps.\n\nInstall with a standard pip command:\n\n```sh\npip install miteclock\n```\n\nNow you should be able to run the following in your terminal:\n\n```sh\nm\n```\n\nThe first time you run it, it will prompt you for your account information and create a\n[TOML](https://github.com/toml-lang/toml) configuration file in your home directory\nnamed `~/.config/miteclock/config.toml`. Then it will show you the help message for the\nprogram. This message and the help for sub-commands should provide enough general\ndocumentation, so the rest of this README is a tutorial to get you started.\n\n## Tutorial\n\n### Controlling the Clock\n\nThere are only two commands to interact with the timer: `m start` starts a clock,\n`m stop` stops it. That\'s it, _that simple_. `m stop` is self-explanatory (run it with\n`--help`), so here we focus on `m start`.\n\n#### Tracking a New Entry\n\nLet\'s say your mite account has the following projects:\n\n- ACME &#x2013; Self-healing container deployments\n- OCP: ED-209\n- CHAZ 2020\n\nIn these projects you perform the following services (Dienstleistungen):\n\n- Development\n- Regular Maintenance\n- Irregular Maintenance\n- QA\n\nFrom your experience with the mite webapp, you know that a time entry has the following\nthree fields:\n\n1. project\n1. service\n1. note\n\nWhat if instead of selecting the project and the service from a drop-down you did so by\npressing just one key? This is much faster, especially if you have more realistic (i.e.\nlarger) sets of projects and services that you\'d have to sift through with the\ndrop-down.\n\nThese keys are known as shortcuts and you can define them in your configuration file.\nFor our example here, let\'s create a few mappings from keys to project/service names. We\nopen our `~/.config/miteclock/config.toml` in a text editor and add the following in the\n`[shortcuts]` table:\n\n```toml\n[shortcuts]\n# Shortcuts for projects.\na = "ACME -- Self-healing container deployments"\no = "OCP: ED-209"\nh = "CHAZ 2020"\nt = "Team-Internal"\n#  Shortcuts for services.\nd = "Development"\nr = "Regular Maintenance"\ni = "Irregular Maintenance"\nq = "QA"\nc = "Communication/Coordination"\n```\n\nNow we can add an activity and start the clock for it with this one command:\n\n```sh\nm start a d \'writing some code\'\n```\n\nThe first two arguments to `start` are expanded into "ACME &#x2013; Self-healing\ncontainer deployments" and "Development" respectively. The last argument is the note. We\nput it in quotes so that it is treated as a single argument.\n\nNote that **order matters** for the expanded items. It **must** be like in the webapp:\n\n1. project\n1. service\n1. note\n\nIf you want to leave any field unspecified, enter an empty string for it. For example if\nyou\'re working for "ACME" but haven\'t narrowed your work down to an exact service or\ntask, run this:\n\n```sh\nm start a \'\' \'\'\n```\n\nLeaving notes empty and filling them out later is so common, that an empty note can be\ncompletely omitted. We can shorten the command above to:\n\n```sh\nm start a \'\'\n```\n\nAnother way to avoid writing out a note is to put it into a shortcut definition. This\nworks well for recurring meetings or tasks where the note stays the same. Let\'s add some\nshortcuts that describe recurring activities for many programmers:\n\n```toml\ndaily = ["t", "c", "daily stand-up"]\nretro = ["t", "c", "retrospective"]\nserver = [\'a\', \'r\', "regular server maintenance"]\n```\n\nNotice how we used the shortcuts we had already defined to create new shortcuts? _It\'s\nshortcuts all the way down!_\n\nThese nested shortcuts can span any **consecutive** part of an activity definition. This\nis valid&#x2026;\n\n```toml\nkickoff = ["c", "kickoff meeting for project"]\n```\n\n&#x2026; and can be used with all your projects, for example:\n\n```sh\nm start h kickoff  # Tracks kickoff meeting for CHAZ 2020\nm start o kickoff  # Tracks kickoff meeting for OCP: ED-209\n```\n\nThis is also valid:\n\n```toml\nacmedev = ["a", "d"]\n```\n\nThis, however, is invalid:\n\n```toml\ninvalid = ["a", "some ACME-related note"]\n```\n\n#### Resume Tracking an Existing Entry\n\nOften you might have to stop the clock for some activity and then start it back up\nlater.\n\nIf you have clocked in some entries for the day and run `m start` without any arguments,\nyou will be presented with a list of the activities you recorded for the day paired with\nkeys you can press to select one of the entries. Note that unlike in the mite webapp,\ntime entries are sorted by the time they were updated last not by the time when they\nwere created.\n\nYou can skip this menu by passing the `-l` flag (or `--last` if you like typing) which\nautomatically starts the last entry for which you had a clock running.\n\nYou can even run the same exact command a second time, e.g.\n\n```sh\nm start a d \'writing some code\'\n# ... some other commands...\nm start a d \'writing some code\'\n```\n\nThere is also `m resume` which is just an alias for `m start -l`.\n\n### Reporting Commands\n\n`m status` will report the current status of the tracker: whether or not the clock is\nrunning and for which entry, which entries have been created today.\n\n`m show` and `m list` show you a list of shortcuts. You can also request a list of\n`projects` or `services` by providing these as arguments to the command. Note that\nespecially the list of projects has known to be long enough that you may want to pipe it\nto a file or filter it with `grep`.\n\n## Contributing\n\nIf you find a problem with the program, please don\'t hesitate to open an issue\n[here](https://github.com/iliakur/miteclock/issues).\n\nIf you want to submit changes, fork this repo, create a branch in your fork that\ncontains your work, open a pull request against the `master` branch in this repo.\n\nFor local development, install the dependencies using\n[poetry](https://github.com/python-poetry/poetry).\n\n```sh\npoetry install\npoetry run pre-commit install\n```\n\nPlease make sure to add tests for any code changes. Assuming the commands above\nsucceeded, run this:\n\n```sh\npoetry run pytest\n```\n\nYou can also use `tox` to test your changes against all supported Python versions:\n\n```sh\npoetry run tox\n```\n\n## Why yet another mite CLI?\n\nThere already are almost half a dozen command-line interfaces in several languages\n([Ruby](https://github.com/Overbryd/mite.cmd),\n[JavaScript](https://github.com/Ephigenia/mite-cli),\n[Go](https://github.com/leanovate/mite-go),\n[Python](https://github.com/port-zero/mite-cli)). There\'s even a\n[PHP wrapper library](https://github.com/derpaschi/Mitey). What is the need for yet\nanother cli?\n\nI find that all the existing interfaces provide both too much functionality and too\nlittle. They try to cover all **possible** tasks, exposing all the gory details of the\nunderlying data along the way. If you regularly import and export time records or manage\nprojects and services for an account, these tools can be very helpful.\n\nThe way most of us use mite though is to start and stop the clock for activities "on the\ngo" throughout the day. This takes advantage of mite\'s built-in tracking capabilities. A\nlot of the activities are recurring, like check-in meetings with clients or team\nmembers. Moreover, most activities on a given day revolve around a handful of projects\nand services.\n\nThis program aims to reduce the book-keeping cost of specifying activities. It lets the\nuser focus on their work while instructing mite to do what it does best: track time. We\ndeliberately expose a simple interface and deal only in relevant concepts.\n\n## Acknowledgements\n\nThis project would not have been possible at all without the folks\n[who run mite](https://mite.yo.lk/) making their API accessible. Many thanks to them for\nthat. I am also grateful to the people who wrote client libraries and cli tools based on\nthe API. This provided context to my efforts and thus helped me define what I wanted to\nfocus on.\n\n## Licence\n\nMIT\n',
    'author': 'Ilia Kurenkov',
    'author_email': 'ilia.kurenkov@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/iliakur/miteclock',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
