# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AttachDiskRequest(JDCloudRequest):
    """
    为一台云主机挂载一块云硬盘，云主机和云硬盘没有正在进行中的的任务时才可挂载。<br>
云主机状态必须是<b>running</b>或<b>stopped</b>状态。<br>
本地盘(local类型)做系统盘的云主机可挂载8块云硬盘，云硬盘(cloud类型)做系统盘的云主机可挂载除系统盘外7块云硬盘。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(AttachDiskRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:attachDisk', 'POST', header, version)
        self.parameters = parameters


class AttachDiskParameters(object):

    def __init__(self, regionId, instanceId, diskId, ):
        """
        :param regionId: 地域ID
        :param instanceId: 云主机ID
        :param diskId: 云硬盘ID
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.diskId = diskId
        self.deviceName = None
        self.autoDelete = None

    def setDeviceName(self, deviceName):
        """
        :param deviceName: (Optional) 设备名[vda,vdb,vdc,vdd,vde,vdf,vdg,vdh,vdi,vmj,vdk,vdl,vdm]，挂载系统盘时必传，且需传vda
        """
        self.deviceName = deviceName

    def setAutoDelete(self, autoDelete):
        """
        :param autoDelete: (Optional) 随云主机删除自动删除此云硬盘，默认为False。仅按配置计费云硬盘支持修改此参数，包年包月云硬盘不可修改。
        """
        self.autoDelete = autoDelete

