# -*- coding: utf-8 -*-
"""
Provides data for the ISO 3166-1 Country codes.

Reference:
    https://en.wikipedia.org/wiki/ISO_3166
"""
countries = [
    ("afghanistan", "af", "afg", "004"),
    ("aland islands", "ax", "ala", "248"),
    ("albania", "al", "alb", "008"),
    ("algeria", "dz", "dza", "012"),
    ("american samoa", "as", "asm", "016"),
    ("andorra", "ad", "and", "020"),
    ("angola", "ao", "ago", "024"),
    ("anguilla", "ai", "aia", "660"),
    ("antarctica", "aq", "ata", "010"),
    ("antigua and barbuda", "ag", "atg", "028"),
    ("argentina", "ar", "arg", "032"),
    ("armenia", "am", "arm", "051"),
    ("aruba", "aw", "abw", "533"),
    ("australia", "au", "aus", "036"),
    ("austria", "at", "aut", "040"),
    ("azerbaijan", "az", "aze", "031"),
    ("bahamas", "bs", "bhs", "044"),
    ("bahrain", "bh", "bhr", "048"),
    ("bangladesh", "bd", "bgd", "050"),
    ("barbados", "bb", "brb", "052"),
    ("belarus", "by", "blr", "112"),
    ("belgium", "be", "bel", "056"),
    ("belize", "bz", "blz", "084"),
    ("benin", "bj", "ben", "204"),
    ("bermuda", "bm", "bmu", "060"),
    ("bhutan", "bt", "btn", "064"),
    ("bolivia", "bo", "bol", "068"),
    ("bosnia and herzegovina", "ba", "bih", "070"),
    ("botswana", "bw", "bwa", "072"),
    ("bouvet island", "bv", "bvt", "074"),
    ("brazil", "br", "bra", "076"),
    ("british virgin islands", "vg", "vgb", "092"),
    ("british indian ocean territory", "io", "iot", "086"),
    ("brunei darussalam", "bn", "brn", "096"),
    ("bulgaria", "bg", "bgr", "100"),
    ("burkina faso", "bf", "bfa", "854"),
    ("burundi", "bi", "bdi", "108"),
    ("cambodia", "kh", "khm", "116"),
    ("cameroon", "cm", "cmr", "120"),
    ("canada", "ca", "can", "124"),
    ("cape verde", "cv", "cpv", "132"),
    ("cayman islands", "ky", "cym", "136"),
    ("central african republic", "cf", "caf", "140"),
    ("chad", "td", "tcd", "148"),
    ("chile", "cl", "chl", "152"),
    ("china", "cn", "chn", "156"),
    ("hong kong, sar china", "hk", "hkg", "344"),
    ("macao, sar china", "mo", "mac", "446"),
    ("christmas island", "cx", "cxr", "162"),
    ("cocos (keeling) islands", "cc", "cck", "166"),
    ("colombia", "co", "col", "170"),
    ("comoros", "km", "com", "174"),
    ("congo(brazzaville)", "cg", "cog", "178"),
    ("congo, (kinshasa)", "cd", "cod", "180"),
    ("cook islands", "ck", "cok", "184"),
    ("costa rica", "cr", "cri", "188"),
    ("côte d'ivoire", "ci", "civ", "384"),
    ("croatia", "hr", "hrv", "191"),
    ("cuba", "cu", "cub", "192"),
    ("cyprus", "cy", "cyp", "196"),
    ("czech republic", "cz", "cze", "203"),
    ("denmark", "dk", "dnk", "208"),
    ("djibouti", "dj", "dji", "262"),
    ("dominica", "dm", "dma", "212"),
    ("dominican republic", "do", "dom", "214"),
    ("ecuador", "ec", "ecu", "218"),
    ("egypt", "eg", "egy", "818"),
    ("el salvador", "sv", "slv", "222"),
    ("equatorial guinea", "gq", "gnq", "226"),
    ("eritrea", "er", "eri", "232"),
    ("estonia", "ee", "est", "233"),
    ("ethiopia", "et", "eth", "231"),
    ("falkland islands (malvinas)", "fk", "flk", "238"),
    ("faroe islands", "fo", "fro", "234"),
    ("fiji", "fj", "fji", "242"),
    ("finland", "fi", "fin", "246"),
    ("france", "fr", "fra", "250"),
    ("french guiana", "gf", "guf", "254"),
    ("french polynesia", "pf", "pyf", "258"),
    ("french southern territories", "tf", "atf", "260"),
    ("gabon", "ga", "gab", "266"),
    ("gambia", "gm", "gmb", "270"),
    ("georgia", "ge", "geo", "268"),
    ("germany", "de", "deu", "276"),
    ("ghana", "gh", "gha", "288"),
    ("gibraltar", "gi", "gib", "292"),
    ("greece", "gr", "grc", "300"),
    ("greenland", "gl", "grl", "304"),
    ("grenada", "gd", "grd", "308"),
    ("guadeloupe", "gp", "glp", "312"),
    ("guam", "gu", "gum", "316"),
    ("guatemala", "gt", "gtm", "320"),
    ("guernsey", "gg", "ggy", "831"),
    ("guinea", "gn", "gin", "324"),
    ("guinea-bissau", "gw", "gnb", "624"),
    ("guyana", "gy", "guy", "328"),
    ("haiti", "ht", "hti", "332"),
    ("heard and mcdonald islands", "hm", "hmd", "334"),
    ("holy see(vatican city state)", "va", "vat", "336"),
    ("honduras", "hn", "hnd", "340"),
    ("hungary", "hu", "hun", "348"),
    ("iceland", "is", "isl", "352"),
    ("india", "in", "ind", "356"),
    ("indonesia", "id", "idn", "360"),
    ("iran, islamic republic of", "ir", "irn", "364"),
    ("iraq", "iq", "irq", "368"),
    ("ireland", "ie", "irl", "372"),
    ("isle of man", "im", "imn", "833"),
    ("israel", "il", "isr", "376"),
    ("italy", "it", "ita", "380"),
    ("jamaica", "jm", "jam", "388"),
    ("japan", "jp", "jpn", "392"),
    ("jersey", "je", "jey", "832"),
    ("jordan", "jo", "jor", "400"),
    ("kazakhstan", "kz", "kaz", "398"),
    ("kenya", "ke", "ken", "404"),
    ("kiribati", "ki", "kir", "296"),
    ("korea(north)", "kp", "prk", "408"),
    ("korea(south)", "kr", "kor", "410"),
    ("kuwait", "kw", "kwt", "414"),
    ("kyrgyzstan", "kg", "kgz", "417"),
    ("lao pdr", "la", "lao", "418"),
    ("latvia", "lv", "lva", "428"),
    ("lebanon", "lb", "lbn", "422"),
    ("lesotho", "ls", "lso", "426"),
    ("liberia", "lr", "lbr", "430"),
    ("libya", "ly", "lby", "434"),
    ("liechtenstein", "li", "lie", "438"),
    ("lithuania", "lt", "ltu", "440"),
    ("luxembourg", "lu", "lux", "442"),
    ("macedonia, republic of", "mk", "mkd", "807"),
    ("madagascar", "mg", "mdg", "450"),
    ("malawi", "mw", "mwi", "454"),
    ("malaysia", "my", "mys", "458"),
    ("maldives", "mv", "mdv", "462"),
    ("mali", "ml", "mli", "466"),
    ("malta", "mt", "mlt", "470"),
    ("marshall islands", "mh", "mhl", "584"),
    ("martinique", "mq", "mtq", "474"),
    ("mauritania", "mr", "mrt", "478"),
    ("mauritius", "mu", "mus", "480"),
    ("mayotte", "yt", "myt", "175"),
    ("mexico", "mx", "mex", "484"),
    ("micronesia, federated states of", "fm", "fsm", "583"),
    ("moldova", "md", "mda", "498"),
    ("monaco", "mc", "mco", "492"),
    ("mongolia", "mn", "mng", "496"),
    ("montenegro", "me", "mne", "499"),
    ("montserrat", "ms", "msr", "500"),
    ("morocco", "ma", "mar", "504"),
    ("mozambique", "mz", "moz", "508"),
    ("myanmar", "mm", "mmr", "104"),
    ("namibia", "na", "nam", "516"),
    ("nauru", "nr", "nru", "520"),
    ("nepal", "np", "npl", "524"),
    ("netherlands", "nl", "nld", "528"),
    ("netherlands antilles", "an", "ant", "530"),
    ("new caledonia", "nc", "ncl", "540"),
    ("new zealand", "nz", "nzl", "554"),
    ("nicaragua", "ni", "nic", "558"),
    ("niger", "ne", "ner", "562"),
    ("nigeria", "ng", "nga", "566"),
    ("niue", "nu", "niu", "570"),
    ("norfolk island", "nf", "nfk", "574"),
    ("northern mariana islands", "mp", "mnp", "580"),
    ("norway", "no", "nor", "578"),
    ("oman", "om", "omn", "512"),
    ("pakistan", "pk", "pak", "586"),
    ("palau", "pw", "plw", "585"),
    ("palestinian territory", "ps", "pse", "275"),
    ("panama", "pa", "pan", "591"),
    ("papua new guinea", "pg", "png", "598"),
    ("paraguay", "py", "pry", "600"),
    ("peru", "pe", "per", "604"),
    ("philippines", "ph", "phl", "608"),
    ("pitcairn", "pn", "pcn", "612"),
    ("poland", "pl", "pol", "616"),
    ("portugal", "pt", "prt", "620"),
    ("puerto rico", "pr", "pri", "630"),
    ("qatar", "qa", "qat", "634"),
    ("réunion", "re", "reu", "638"),
    ("romania", "ro", "rou", "642"),
    ("russian federation", "ru", "rus", "643"),
    ("rwanda", "rw", "rwa", "646"),
    ("saint-barthélemy", "bl", "blm", "652"),
    ("saint helena", "sh", "shn", "654"),
    ("saint kitts and nevis", "kn", "kna", "659"),
    ("saint lucia", "lc", "lca", "662"),
    ("saint-martin (french part)", "mf", "maf", "663"),
    ("saint pierre and miquelon", "pm", "spm", "666"),
    ("saint vincent and grenadines", "vc", "vct", "670"),
    ("samoa", "ws", "wsm", "882"),
    ("san marino", "sm", "smr", "674"),
    ("sao tome and principe", "st", "stp", "678"),
    ("saudi arabia", "sa", "sau", "682"),
    ("senegal", "sn", "sen", "686"),
    ("serbia", "rs", "srb", "688"),
    ("seychelles", "sc", "syc", "690"),
    ("sierra leone", "sl", "sle", "694"),
    ("singapore", "sg", "sgp", "702"),
    ("slovakia", "sk", "svk", "703"),
    ("slovenia", "si", "svn", "705"),
    ("solomon islands", "sb", "slb", "090"),
    ("somalia", "so", "som", "706"),
    ("south africa", "za", "zaf", "710"),
    ("south georgia and the south sandwich islands", "gs", "sgs", "239"),
    ("south sudan", "ss", "ssd", "728"),
    ("spain", "es", "esp", "724"),
    ("sri lanka", "lk", "lka", "144"),
    ("sudan", "sd", "sdn", "736"),
    ("suriname", "sr", "sur", "740"),
    ("svalbard and jan mayen islands", "sj", "sjm", "744"),
    ("swaziland", "sz", "swz", "748"),
    ("sweden", "se", "swe", "752"),
    ("switzerland", "ch", "che", "756"),
    ("syrian arab republic(syria)", "sy", "syr", "760"),
    ("taiwan, republic of china", "tw", "twn", "158"),
    ("tajikistan", "tj", "tjk", "762"),
    ("tanzania, united republic of", "tz", "tza", "834"),
    ("thailand", "th", "tha", "764"),
    ("timor-leste", "tl", "tls", "626"),
    ("togo", "tg", "tgo", "768"),
    ("tokelau", "tk", "tkl", "772"),
    ("tonga", "to", "ton", "776"),
    ("trinidad and tobago", "tt", "tto", "780"),
    ("tunisia", "tn", "tun", "788"),
    ("turkey", "tr", "tur", "792"),
    ("turkmenistan", "tm", "tkm", "795"),
    ("turks and caicos islands", "tc", "tca", "796"),
    ("tuvalu", "tv", "tuv", "798"),
    ("uganda", "ug", "uga", "800"),
    ("ukraine", "ua", "ukr", "804"),
    ("united arab emirates", "ae", "are", "784"),
    ("united kingdom", "gb", "gbr", "826"),
    ("united states of america", "us", "usa", "840"),
    ("us minor outlying islands", "um", "umi", "581"),
    ("us minor islands", "um", "umi", "581"),
    ("uruguay", "uy", "ury", "858"),
    ("uzbekistan", "uz", "uzb", "860"),
    ("vanuatu", "vu", "vut", "548"),
    ("venezuela(bolivarian republic)", "ve", "ven", "862"),
    ("viet nam", "vn", "vnm", "704"),
    ("virgin islands, us", "vi", "vir", "850"),
    ("wallis and futuna islands", "wf", "wlf", "876"),
    ("western sahara", "eh", "esh", "732"),
    ("yemen", "ye", "yem", "887"),
    ("zambia", "zm", "zmb", "894"),
    ("zimbabwe", "zw", "zwe", "716"),
]

def makeColLook(rows, scol, dcol):
    retn = {}
    for x in rows:
        retn[x[scol]] = x[dcol]
    return retn

country2iso = makeColLook(countries, 0, 1)
