"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import exclude_unset

from .models import BasicError, CodeOfConduct

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class CodesOfConductClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_all_codes_of_conduct(
        self,
    ) -> "Response[List[CodeOfConduct]]":
        url = "/codes_of_conduct"

        return self._github.request(
            "GET",
            url,
            response_model=List[CodeOfConduct],
        )

    async def async_get_all_codes_of_conduct(
        self,
    ) -> "Response[List[CodeOfConduct]]":
        url = "/codes_of_conduct"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[CodeOfConduct],
        )

    def get_conduct_code(
        self,
        key: str,
    ) -> "Response[CodeOfConduct]":
        url = f"/codes_of_conduct/{key}"

        return self._github.request(
            "GET",
            url,
            response_model=CodeOfConduct,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_conduct_code(
        self,
        key: str,
    ) -> "Response[CodeOfConduct]":
        url = f"/codes_of_conduct/{key}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodeOfConduct,
            error_models={
                "404": BasicError,
            },
        )
