"use strict";
// Copyright (c) Project Jupyter.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
// TODO: import from @jupyter-widgets/jupyterlab-manager once Output is
// exported by the main module.
const output_1 = require("@jupyter-widgets/jupyterlab-manager/lib/output");
const version_1 = require("./version");
class SidecarModel extends output_1.OutputModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: SidecarModel.model_name, _model_module: SidecarModel.model_module, _model_module_version: SidecarModel.model_module_version, _view_name: SidecarModel.view_name, _view_module: SidecarModel.view_module, _view_module_version: SidecarModel.view_module_version, title: 'Sidecar' });
    }
    initialize(attributes, options) {
        super.initialize(attributes, options);
        this.widget_manager.display_model(undefined, this, {});
    }
}
exports.SidecarModel = SidecarModel;
SidecarModel.serializers = Object.assign({}, output_1.OutputModel.serializers);
SidecarModel.model_name = 'SidecarModel';
SidecarModel.model_module = '@jupyter-widgets/jupyterlab-sidecar';
SidecarModel.model_module_version = version_1.EXTENSION_SPEC_VERSION;
SidecarModel.view_name = 'SidecarView'; // Set to null if no view
SidecarModel.view_module = '@jupyter-widgets/jupyterlab-sidecar'; // Set to null if no view
SidecarModel.view_module_version = version_1.EXTENSION_SPEC_VERSION;
