"use strict";
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
const coreutils_1 = require("@lumino/coreutils");
const base_1 = require("@jupyter-widgets/base");
const jupyterlab_manager_1 = require("@jupyter-widgets/jupyterlab-manager");
const widget_1 = require("./widget");
const version_1 = require("./version");
require("../css/sidecar.css");
const EXTENSION_ID = '@jupyter-widgets/jupyterlab-sidecar';
const sidecarPlugin = {
    id: EXTENSION_ID,
    requires: [base_1.IJupyterWidgetRegistry],
    activate: activateWidgetExtension,
    autoStart: true
};
exports.default = sidecarPlugin;
/**
 * Activate the widget extension.
 */
function activateWidgetExtension(app, registry) {
    let SidecarView = class extends jupyterlab_manager_1.output.OutputView {
        render() {
            if (!this.model.rendered) {
                super.render();
                let w = this._outputView;
                w.addClass('jupyterlab-sidecar');
                w.addClass('jp-LinkedOutputView');
                w.title.label = this.model.get('title');
                w.title.closable = true;
                app.shell['_rightHandler'].sideBar.tabCloseRequested.connect((sender, tab) => {
                    tab.title.owner.dispose();
                });
                w.id = coreutils_1.UUID.uuid4();
                if (Object.keys(this.model.views).length > 1) {
                    w.node.style.display = 'none';
                    let key = Object.keys(this.model.views)[0];
                    this.model.views[key].then((v) => {
                        v._outputView.activate();
                    });
                }
                else {
                    app.shell.add(w, 'right');
                    app.shell.expandRight();
                }
            }
        }
    };
    registry.registerWidget({
        name: '@jupyter-widgets/jupyterlab-sidecar',
        version: version_1.EXTENSION_SPEC_VERSION,
        exports: {
            SidecarModel: widget_1.SidecarModel,
            SidecarView: SidecarView
        }
    });
}
