# coding: utf-8

# (C) Copyright IBM Corp. 2022.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# IBM OpenAPI SDK Code Generator Version: 3.43.5-e0ec19e2-20220124-172004

"""
No description provided (generated by Openapi Generator
https://github.com/openapitools/openapi-generator)

API Version: __VERSION__
"""

from datetime import datetime
from enum import Enum
from typing import Dict, List
import json

from ibm_cloud_sdk_core import BaseService, DetailedResponse
from ibm_cloud_sdk_core.authenticators.authenticator import Authenticator
from ibm_cloud_sdk_core.get_authenticator import get_authenticator_from_environment
from ibm_cloud_sdk_core.utils import convert_model, datetime_to_string, string_to_datetime

from .common import get_sdk_headers

##############################################################################
# Service
##############################################################################


class TransitGatewayApisV1(BaseService):
    """The Transit Gateway Apis V1 service."""

    DEFAULT_SERVICE_URL = 'https://transit.cloud.ibm.com/v1'
    DEFAULT_SERVICE_NAME = 'transit_gateway_apis'

    @classmethod
    def new_instance(cls,
                     version: str,
                     service_name: str = DEFAULT_SERVICE_NAME,
                     ) -> 'TransitGatewayApisV1':
        """
        Return a new client for the Transit Gateway Apis service using the
               specified parameters and external configuration.

        :param str version: Requests the version of the API as of a date in the
               format `YYYY-MM-DD`. Any date up to the current date may be provided.
               Specify the current date to request the latest version.
        """
        if version is None:
            raise ValueError('version must be provided')

        authenticator = get_authenticator_from_environment(service_name)
        service = cls(
            version,
            authenticator
        )
        service.configure_service(service_name)
        return service

    def __init__(self,
                 version: str,
                 authenticator: Authenticator = None,
                 ) -> None:
        """
        Construct a new client for the Transit Gateway Apis service.

        :param str version: Requests the version of the API as of a date in the
               format `YYYY-MM-DD`. Any date up to the current date may be provided.
               Specify the current date to request the latest version.

        :param Authenticator authenticator: The authenticator specifies the authentication mechanism.
               Get up to date information from https://github.com/IBM/python-sdk-core/blob/main/README.md
               about initializing the authenticator of your choice.
        """
        if version is None:
            raise ValueError('version must be provided')

        BaseService.__init__(self,
                             service_url=self.DEFAULT_SERVICE_URL,
                             authenticator=authenticator)
        self.version = version

    #########################
    # Transit Gateways
    #########################

    def list_transit_gateways(self,
                              *,
                              limit: int = None,
                              start: str = None,
                              **kwargs
                              ) -> DetailedResponse:
        """
        Retrieves all Transit Gateways.

        List all Transit Gateways in account the caller is authorized to view.

        :param int limit: (optional) The maximum number of resources to return per
               page.
        :param str start: (optional) A server supplied token determining which
               resource to start the page on.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGatewayCollection` object
        """

        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_transit_gateways')
        headers.update(sdk_headers)

        params = {
            'version': self.version,
            'limit': limit,
            'start': start
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        url = '/transit_gateways'
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def create_transit_gateway(self,
                               location: str,
                               name: str,
                               *,
                               global_: bool = None,
                               resource_group: 'ResourceGroupIdentity' = None,
                               **kwargs
                               ) -> DetailedResponse:
        """
        Creates a Transit Gateway.

        Create a Transit Gateway based on the supplied input template.

        :param str location: Location of Transit Gateway Services.
        :param str name: Name Transit Gateway Services.
        :param bool global_: (optional) Allow global routing for a Transit Gateway.
               If unspecified, the default value is false.
        :param ResourceGroupIdentity resource_group: (optional) The resource group
               to use. If unspecified, the account's [default resource
               group](https://console.bluemix.net/apidocs/resource-manager#introduction)
               is used.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGateway` object
        """

        if location is None:
            raise ValueError('location must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if resource_group is not None:
            resource_group = convert_model(resource_group)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_transit_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'location': location,
            'name': name,
            'global': global_,
            'resource_group': resource_group
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        url = '/transit_gateways'
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    def delete_transit_gateway(self,
                               id: str,
                               **kwargs
                               ) -> DetailedResponse:
        """
        Deletes specified Transit Gateway.

        This request deletes a Transit Gateway. This operation cannot be reversed. For
        this request to succeed, the Transit Gateway must not contain connections.

        :param str id: The Transit Gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_transit_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def get_transit_gateway(self,
                            id: str,
                            **kwargs
                            ) -> DetailedResponse:
        """
        Retrieves specified Transit Gateway.

        This request retrieves a single Transit Gateway specified by the identifier in the
        URL.

        :param str id: The Transit Gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGateway` object
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_transit_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def update_transit_gateway(self,
                               id: str,
                               *,
                               global_: bool = None,
                               name: str = None,
                               **kwargs
                               ) -> DetailedResponse:
        """
        Updates specified Transit Gateway.

        This request updates a Transit Gateway's name and/or global flag.

        :param str id: The Transit Gateway identifier.
        :param bool global_: (optional) Allow global routing for a Transit Gateway.
        :param str name: (optional) The user-defined name for this transit gateway.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGateway` object
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_transit_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'global': global_,
            'name': name
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Transit Connections
    #########################

    def list_connections(self,
                         *,
                         limit: int = None,
                         start: str = None,
                         network_id: str = None,
                         **kwargs
                         ) -> DetailedResponse:
        """
        Retrieves all connections.

        List all transit gateway connections associated with this account.

        :param int limit: (optional) The maximum number of resources to return per
               page.
        :param str start: (optional) A server supplied token determining which
               resource to start the page on.
        :param str network_id: (optional) Search for connections with the given
               network_id value.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitConnectionCollection` object
        """

        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_connections')
        headers.update(sdk_headers)

        params = {
            'version': self.version,
            'limit': limit,
            'start': start,
            'network_id': network_id
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        url = '/connections'
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Transit Gateways Network Connections
    #########################

    def list_transit_gateway_connections(self,
                                         transit_gateway_id: str,
                                         **kwargs
                                         ) -> DetailedResponse:
        """
        Retrieves all connections in a Transit Gateway.

        This request retrieves all connections in a Transit Gateway.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGatewayConnectionCollection` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_transit_gateway_connections')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id']
        path_param_values = self.encode_path_vars(transit_gateway_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections'.format(
            **path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def create_transit_gateway_connection(self,
                                          transit_gateway_id: str,
                                          network_type: str,
                                          *,
                                          base_connection_id: str = None,
                                          base_network_type: str = None,
                                          local_gateway_ip: str = None,
                                          local_tunnel_ip: str = None,
                                          name: str = None,
                                          network_account_id: str = None,
                                          network_id: str = None,
                                          prefix_filters: List['TransitGatewayConnectionPrefixFilter'] = None,
                                          prefix_filters_default: str = None,
                                          remote_bgp_asn: int = None,
                                          remote_gateway_ip: str = None,
                                          remote_tunnel_ip: str = None,
                                          zone: 'ZoneIdentity' = None,
                                          **kwargs
                                          ) -> DetailedResponse:
        """
        Add connection to a Transit Gateway.

        Add a connection to Transit Gateway.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str network_type: Defines what type of network is connected via this
               connection. For access to gre_tunnel or unbound_gre_tunnel connections
               contact IBM support.
        :param str base_connection_id: (optional) network_type 'gre_tunnel'
               connections must be created over an existing network_type 'classic'
               connection. This field must specify the ID of an active transit gateway
               network_type 'classic' connection in the same transit gateway.
               This field is required for network type 'gre_tunnel' connections.
               This field is required to be unspecified for network type 'classic',
               'directlink', 'vpc', 'power_virtual_server' and 'unbound_gre_tunnel'
               connections.
        :param str base_network_type: (optional) The type of network the Unbound
               GRE tunnel is targeting. This field is required for network type
               'unbound_gre_tunnel' connections. This field is required to be unspecified
               for network type 'classic', 'directlink', 'vpc', 'power_virtual_server' and
               'gre_tunnel' connections.
        :param str local_gateway_ip: (optional) Local gateway IP address. This
               field is required for network type 'gre_tunnel' and 'unbound_gre_tunnel'
               connections. This field is required to be unspecified for network type
               'classic', 'directlink', 'vpc' and 'power_virtual_server' connections.
        :param str local_tunnel_ip: (optional) Local tunnel IP address. The
               local_tunnel_ip and remote_tunnel_ip addresses must be in the same /30
               network. Neither can be the network nor broadcast addresses.
               This field is required for network type 'gre_tunnel' and
               'unbound_gre_tunnel' connections.
               This field is required to be unspecified for network type 'classic',
               'directlink', 'vpc' and 'power_virtual_server' connections.
        :param str name: (optional) The user-defined name for this transit gateway
               connection. Network type 'vpc'  connections are defaulted to the name of
               the VPC.  Network type 'classic' connections are named 'Classic'.
               This field is required for network type 'gre_tunnel' and
               'unbound_gre_tunnel' connections.
               This field is optional for network type 'classic', 'directlink', 'vpc' and
               'power_virtual_server' connections.
        :param str network_account_id: (optional) The ID of the account which owns
               the network that is being connected. Generally only used if the network is
               in a different account than the gateway. This field is required for type
               'unbound_gre_tunnel' when the associated_network_type is 'classic' and the
               GRE tunnel is in a different account than the gateway.
        :param str network_id: (optional) The ID of the network being connected via
               this connection. For network types 'vpc','power_virtual_server' and
               'directlink' this is the CRN of the VPC / PowerVS / Direct Link gateway
               respectively. This field is required for network type 'vpc',
               'power_virtual_server' and 'directlink' connections. This field is required
               to be unspecified for network type 'classic', 'gre_tunnel' and
               'unbound_gre_tunnel' connections.
        :param List[TransitGatewayConnectionPrefixFilter] prefix_filters:
               (optional) Array of prefix route filters for a transit gateway connection.
               Prefix filters can be specified for netowrk type 'vpc', 'classic',
               'power_virtual_server' and 'directlink' connections. They are not allowed
               for type 'gre_tunnel' connections. This is order dependent with those first
               in the array being applied first, and those at the end of the array being
               applied last, or just before applying the default. This field is optional
               for network type 'classic', 'vpc', 'directlink', and 'power_virtual_server'
               connections. This field is required to be unspecified for network type
               'gre_tunnel' and 'unbound_gre_tunnel' connections.
        :param str prefix_filters_default: (optional) Default setting of permit or
               deny which applies to any routes that don't match a specified filter. This
               field is optional for network type 'classic', 'vpc', 'directlink', and
               'power_virtual_server' connections. This field is required to be
               unspecified for network type 'gre_tunnel' and 'unbound_gre_tunnel'
               connections.
        :param int remote_bgp_asn: (optional) Remote network BGP ASN. The following
               ASN values are reserved and unavailable 64512-64513, 65100, 65201-65234,
               65402-65433, 65500 and 4201065000-4201065999. If 'remote_bgp_asn' is
               omitted on gre_tunnel or unbound_gre_tunnel connection create requests IBM
               will assign an ASN.
               This field is optional for network type 'gre_tunnel' and
               'unbound_gre_tunnel' connections.
               This field is required to be unspecified for network type 'classic',
               'directlink', 'vpc' and 'power_virtual_server' connections.
        :param str remote_gateway_ip: (optional) Remote gateway IP address. This
               field is required for network type 'gre_tunnel' and 'unbound_gre_tunnel'
               connections. This field is required to be unspecified for network type
               'classic', 'directlink', 'vpc' and 'power_virtual_server' connections.
        :param str remote_tunnel_ip: (optional) Remote tunnel IP address. The
               local_tunnel_ip and remote_tunnel_ip addresses must be in the same /30
               network. Neither can be the network nor broadcast addresses.
               This field is required for network type 'gre_tunnel' and
               'unbound_gre_tunnel' connections.
               This field is required to be unspecified for network type 'classic',
               'directlink', 'vpc' and 'power_virtual_server' connections.
        :param ZoneIdentity zone: (optional) Specify the connection's location.
               The specified availability zone must reside in the gateway's region.
               Use the IBM Cloud global catalog to list zones within the desired region.
               This field is required for network type 'gre_tunnel' and
               'unbound_gre_tunnel' connections.
               This field is required to be unspecified for network type 'classic',
               'directlink', 'vpc' and 'power_virtual_server' connections.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGatewayConnectionCust` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if network_type is None:
            raise ValueError('network_type must be provided')
        if prefix_filters is not None:
            prefix_filters = [convert_model(x) for x in prefix_filters]
        if zone is not None:
            zone = convert_model(zone)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_transit_gateway_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'network_type': network_type,
            'base_connection_id': base_connection_id,
            'base_network_type': base_network_type,
            'local_gateway_ip': local_gateway_ip,
            'local_tunnel_ip': local_tunnel_ip,
            'name': name,
            'network_account_id': network_account_id,
            'network_id': network_id,
            'prefix_filters': prefix_filters,
            'prefix_filters_default': prefix_filters_default,
            'remote_bgp_asn': remote_bgp_asn,
            'remote_gateway_ip': remote_gateway_ip,
            'remote_tunnel_ip': remote_tunnel_ip,
            'zone': zone
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id']
        path_param_values = self.encode_path_vars(transit_gateway_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections'.format(
            **path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    def delete_transit_gateway_connection(self,
                                          transit_gateway_id: str,
                                          id: str,
                                          **kwargs
                                          ) -> DetailedResponse:
        """
        Remove connection from Transit Gateway.

        After the specified connection is detached, entities still within the Transit
        Gateway will no longer be able to communicate directly to it through the IBM Cloud
        private backbone.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_transit_gateway_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['transit_gateway_id', 'id']
        path_param_values = self.encode_path_vars(transit_gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections/{id}'.format(
            **path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def get_transit_gateway_connection(self,
                                       transit_gateway_id: str,
                                       id: str,
                                       **kwargs
                                       ) -> DetailedResponse:
        """
        Retrieves specified Transit Gateway connection.

        This request retrieves a connection from the Transit Gateway.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGatewayConnectionCust` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_transit_gateway_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id', 'id']
        path_param_values = self.encode_path_vars(transit_gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections/{id}'.format(
            **path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def update_transit_gateway_connection(self,
                                          transit_gateway_id: str,
                                          id: str,
                                          *,
                                          name: str = None,
                                          prefix_filters_default: str = None,
                                          **kwargs
                                          ) -> DetailedResponse:
        """
        Updates specified Transit Gateway connection.

        Update the name of a connection to a Transit Gateway.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param str name: (optional) The user-defined name for this transit gateway.
               If specified as empty string or nil,  the name will be the network name
               (the name of the VPC in the case of network type 'vpc',  and the word
               Classic, in the case of network type 'classic').
        :param str prefix_filters_default: (optional) Default setting of permit or
               deny which applies to any routes that don't match a specified filter.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGatewayConnectionCust` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_transit_gateway_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'name': name,
            'prefix_filters_default': prefix_filters_default
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id', 'id']
        path_param_values = self.encode_path_vars(transit_gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections/{id}'.format(
            **path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    def create_transit_gateway_connection_actions(self,
                                                  transit_gateway_id: str,
                                                  id: str,
                                                  action: str,
                                                  **kwargs
                                                  ) -> DetailedResponse:
        """
        Perform actions on a connection for a Transit Gateway.

        Allow a network owner to approve or reject a cross-account connection request.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param str action: The action that is to be performed against the
               connection request.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if action is None:
            raise ValueError('action must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_transit_gateway_connection_actions')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'action': action
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['transit_gateway_id', 'id']
        path_param_values = self.encode_path_vars(transit_gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections/{id}/actions'.format(
            **path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Transit Location
    #########################

    def list_gateway_locations(self,
                               **kwargs
                               ) -> DetailedResponse:
        """
        List all locations that support Transit Gateways.

        List all locations that support Transit Gateways.

        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TSCollection` object
        """

        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_gateway_locations')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        url = '/locations'
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def get_gateway_location(self,
                             name: str,
                             **kwargs
                             ) -> DetailedResponse:
        """
        Show the details of a given Transit Gateway location.

        Get the details of a Transit Gateway Location.

        :param str name: The Transit Gateway location Name.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TSLocation` object
        """

        if name is None:
            raise ValueError('name must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_gateway_location')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['name']
        path_param_values = self.encode_path_vars(name)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/locations/{name}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Transit Gateway Connection Prefix Filters
    #########################

    def list_transit_gateway_connection_prefix_filters(self,
                                                       transit_gateway_id: str,
                                                       id: str,
                                                       **kwargs
                                                       ) -> DetailedResponse:
        """
        Retrieves all prefix filters in a Transit Gateway connection.

        This request retrieves all prefix filters in a Transit Gateway connection.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `PrefixFilterCollection` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_transit_gateway_connection_prefix_filters')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id', 'id']
        path_param_values = self.encode_path_vars(transit_gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections/{id}/prefix_filters'.format(
            **path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def create_transit_gateway_connection_prefix_filter(self,
                                                        transit_gateway_id: str,
                                                        id: str,
                                                        action: str,
                                                        prefix: str,
                                                        *,
                                                        before: str = None,
                                                        ge: int = None,
                                                        le: int = None,
                                                        **kwargs
                                                        ) -> DetailedResponse:
        """
        Add a prefix filter to a Transit Gateway Connection.

        Add a prefix filter to a Transit Gateway Connection.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param str action: Whether to permit or deny prefix filter.
        :param str prefix: IP Prefix.
        :param str before: (optional) Identifier of prefix filter to handle the
               ordering and follow semantics:
               - When a filter reference another filter in it's before field, then the
               filter making the reference is applied before
                 the referenced filter. For example: if filter A references filter B in
               its before field, A is applied before B.
               - When a new filter is added that has the same before as an existing
               filter, then the older filter will have its before
                 field updated to point to the new filter. Starting with the above
               example: if filter C is added and it references B in its
                 before field, then A's before field should be modified to point to C, so
               the order of application would be A, C and finally B.
               - A filter that has an empty before reference will be applied last (though
               the date order mentioned above will still apply).
                 So continuing the above examples, if filter B has an empty before field,
               then it will be applied last, but if filter D
                 is created with an empty before field, then B's before field will be
               modified to point to D, so B will be applied before D.
        :param int ge: (optional) IP Prefix GE.
        :param int le: (optional) IP Prefix LE.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `PrefixFilterCust` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if action is None:
            raise ValueError('action must be provided')
        if prefix is None:
            raise ValueError('prefix must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_transit_gateway_connection_prefix_filter')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'action': action,
            'prefix': prefix,
            'before': before,
            'ge': ge,
            'le': le
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id', 'id']
        path_param_values = self.encode_path_vars(transit_gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections/{id}/prefix_filters'.format(
            **path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    def replace_transit_gateway_connection_prefix_filter(self,
                                                         transit_gateway_id: str,
                                                         id: str,
                                                         prefix_filters: List['PrefixFilterPut'],
                                                         **kwargs
                                                         ) -> DetailedResponse:
        """
        Replaces the prefix filters of the Transit Gateway Connection.

        Replaces the prefix filters of the Transit Gateway Connection.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param List[PrefixFilterPut] prefix_filters: Array of prefix filters.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `PrefixFilterCollection` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if prefix_filters is None:
            raise ValueError('prefix_filters must be provided')
        prefix_filters = [convert_model(x) for x in prefix_filters]
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='replace_transit_gateway_connection_prefix_filter')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'prefix_filters': prefix_filters
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id', 'id']
        path_param_values = self.encode_path_vars(transit_gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections/{id}/prefix_filters'.format(
            **path_param_dict)
        request = self.prepare_request(method='PUT',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    def delete_transit_gateway_connection_prefix_filter(self,
                                                        transit_gateway_id: str,
                                                        id: str,
                                                        filter_id: str,
                                                        **kwargs
                                                        ) -> DetailedResponse:
        """
        Remove prefix filter from Transit Gateway Connection.

        Delete a prefix filter.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param str filter_id: Prefix filter identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if filter_id is None:
            raise ValueError('filter_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_transit_gateway_connection_prefix_filter')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['transit_gateway_id', 'id', 'filter_id']
        path_param_values = self.encode_path_vars(
            transit_gateway_id, id, filter_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections/{id}/prefix_filters/{filter_id}'.format(
            **path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def get_transit_gateway_connection_prefix_filter(self,
                                                     transit_gateway_id: str,
                                                     id: str,
                                                     filter_id: str,
                                                     **kwargs
                                                     ) -> DetailedResponse:
        """
        Retrieves specified Transit Gateway connection prefix filter.

        This request retrieves a prefix filter from the Transit Gateway Connection.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param str filter_id: Prefix filter identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `PrefixFilterCust` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if filter_id is None:
            raise ValueError('filter_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_transit_gateway_connection_prefix_filter')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id', 'id', 'filter_id']
        path_param_values = self.encode_path_vars(
            transit_gateway_id, id, filter_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections/{id}/prefix_filters/{filter_id}'.format(
            **path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def update_transit_gateway_connection_prefix_filter(self,
                                                        transit_gateway_id: str,
                                                        id: str,
                                                        filter_id: str,
                                                        *,
                                                        action: str = None,
                                                        before: str = None,
                                                        ge: int = None,
                                                        le: int = None,
                                                        prefix: str = None,
                                                        **kwargs
                                                        ) -> DetailedResponse:
        """
        Updates specified Transit Gateway connection prefix filter.

        Update prefix filter for a Transit Gateway Connection.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param str filter_id: Prefix filter identifier.
        :param str action: (optional) Whether to permit or deny prefix filter.
        :param str before: (optional) Identifier of prefix filter to handle the
               ordering and follow semantics:
               - When a filter reference another filter in it's before field, then the
               filter making the reference is applied before
                 the referenced filter. For example: if filter A references filter B in
               its before field, A is applied before B.
               - When a new filter is added that has the same before as an existing
               filter, then the older filter will have its before
                 field updated to point to the new filter. Starting with the above
               example: if filter C is added and it references B in its
                 before field, then A's before field should be modified to point to C, so
               the order of application would be A, C and finally B.
               - A filter that has an empty before reference will be applied last (though
               the date order mentioned above will still apply).
                 So continuing the above examples, if filter B has an empty before field,
               then it will be applied last, but if filter D
                 is created with an empty before field, then B's before field will be
               modified to point to D, so B will be applied before D.
        :param int ge: (optional) IP Prefix GE.
        :param int le: (optional) IP Prefix LE.
        :param str prefix: (optional) IP Prefix.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `PrefixFilterCust` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if filter_id is None:
            raise ValueError('filter_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_transit_gateway_connection_prefix_filter')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'action': action,
            'before': before,
            'ge': ge,
            'le': le,
            'prefix': prefix
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id', 'id', 'filter_id']
        path_param_values = self.encode_path_vars(
            transit_gateway_id, id, filter_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/connections/{id}/prefix_filters/{filter_id}'.format(
            **path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Transit Gateway Route Reports
    #########################

    def list_transit_gateway_route_reports(self,
                                           transit_gateway_id: str,
                                           **kwargs
                                           ) -> DetailedResponse:
        """
        List route reports.

        Retrieve all route reports for the specified Transit Gateway.  There will normally
        be at most one completed report and one pending report.  Additionally, completed
        route reports are written to IBM Cloud Activity Tracker.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `RouteReportCollection` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_transit_gateway_route_reports')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id']
        path_param_values = self.encode_path_vars(transit_gateway_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/route_reports'.format(
            **path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def create_transit_gateway_route_report(self,
                                            transit_gateway_id: str,
                                            **kwargs
                                            ) -> DetailedResponse:
        """
        Request a route report.

        Request route report generation.  While report generation is in progress,
        additional requests to generate a report are ignored and return the current
        pending report.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `RouteReport` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_transit_gateway_route_report')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id']
        path_param_values = self.encode_path_vars(transit_gateway_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/route_reports'.format(
            **path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def delete_transit_gateway_route_report(self,
                                            transit_gateway_id: str,
                                            id: str,
                                            **kwargs
                                            ) -> DetailedResponse:
        """
        Delete route report.

        Delete a route report.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: Route report identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_transit_gateway_route_report')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['transit_gateway_id', 'id']
        path_param_values = self.encode_path_vars(transit_gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/route_reports/{id}'.format(
            **path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    def get_transit_gateway_route_report(self,
                                         transit_gateway_id: str,
                                         id: str,
                                         **kwargs
                                         ) -> DetailedResponse:
        """
        Retrieve route report.

        Retrieve a route report.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: Route report identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `RouteReport` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_transit_gateway_route_report')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['transit_gateway_id', 'id']
        path_param_values = self.encode_path_vars(transit_gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/transit_gateways/{transit_gateway_id}/route_reports/{id}'.format(
            **path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


##############################################################################
# Models
##############################################################################


class PrefixFilterCollection():
    """
    prefix filters.

    :attr List[PrefixFilterCust] prefix_filters: Array of prefix filters.
    """

    def __init__(self,
                 prefix_filters: List['PrefixFilterCust']) -> None:
        """
        Initialize a PrefixFilterCollection object.

        :param List[PrefixFilterCust] prefix_filters: Array of prefix filters.
        """
        self.prefix_filters = prefix_filters

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'PrefixFilterCollection':
        """Initialize a PrefixFilterCollection object from a json dictionary."""
        args = {}
        if 'prefix_filters' in _dict:
            args['prefix_filters'] = [PrefixFilterCust.from_dict(
                x) for x in _dict.get('prefix_filters')]
        else:
            raise ValueError(
                'Required property \'prefix_filters\' not present in PrefixFilterCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a PrefixFilterCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'prefix_filters') and self.prefix_filters is not None:
            _dict['prefix_filters'] = [x.to_dict()
                                       for x in self.prefix_filters]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this PrefixFilterCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'PrefixFilterCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'PrefixFilterCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class PrefixFilterCust():
    """
    prefix filter.

    :attr str action: Whether to permit or deny prefix filter.
    :attr str before: (optional) Identifier of prefix filter that handles the
          ordering and follow semantics:
          - When a filter reference another filter in it's before field, then the filter
          making the reference is applied before
            the referenced filter. For example: if filter A references filter B in its
          before field, A is applied before B.
          - When a new filter is added that has the same before as an existing filter,
          then the older filter will have its before
            field updated to point to the new filter. Starting with the above example: if
          filter C is added and it references B in its
            before field, then A's before field should be modified to point to C, so the
          order of application would be A, C and finally B.
          - A filter that has an empty before reference will be applied last (though the
          date order mentioned above will still apply).
            So continuing the above examples, if filter B has an empty before field, then
          it will be applied last, but if filter D
            is created with an empty before field, then B's before field will be modified
          to point to D, so B will be applied before D.
    :attr datetime created_at: The date and time that this prefix filter was
          created.
    :attr int ge: (optional) IP Prefix GE.
    :attr str id: Prefix Filter identifier.
    :attr int le: (optional) IP Prefix LE.
    :attr str prefix: IP Prefix.
    :attr datetime updated_at: (optional) The date and time that this prefix filter
          was last updated.
    """

    def __init__(self,
                 action: str,
                 created_at: datetime,
                 id: str,
                 prefix: str,
                 *,
                 before: str = None,
                 ge: int = None,
                 le: int = None,
                 updated_at: datetime = None) -> None:
        """
        Initialize a PrefixFilterCust object.

        :param str action: Whether to permit or deny prefix filter.
        :param datetime created_at: The date and time that this prefix filter was
               created.
        :param str id: Prefix Filter identifier.
        :param str prefix: IP Prefix.
        :param str before: (optional) Identifier of prefix filter that handles the
               ordering and follow semantics:
               - When a filter reference another filter in it's before field, then the
               filter making the reference is applied before
                 the referenced filter. For example: if filter A references filter B in
               its before field, A is applied before B.
               - When a new filter is added that has the same before as an existing
               filter, then the older filter will have its before
                 field updated to point to the new filter. Starting with the above
               example: if filter C is added and it references B in its
                 before field, then A's before field should be modified to point to C, so
               the order of application would be A, C and finally B.
               - A filter that has an empty before reference will be applied last (though
               the date order mentioned above will still apply).
                 So continuing the above examples, if filter B has an empty before field,
               then it will be applied last, but if filter D
                 is created with an empty before field, then B's before field will be
               modified to point to D, so B will be applied before D.
        :param int ge: (optional) IP Prefix GE.
        :param int le: (optional) IP Prefix LE.
        :param datetime updated_at: (optional) The date and time that this prefix
               filter was last updated.
        """
        self.action = action
        self.before = before
        self.created_at = created_at
        self.ge = ge
        self.id = id
        self.le = le
        self.prefix = prefix
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'PrefixFilterCust':
        """Initialize a PrefixFilterCust object from a json dictionary."""
        args = {}
        if 'action' in _dict:
            args['action'] = _dict.get('action')
        else:
            raise ValueError(
                'Required property \'action\' not present in PrefixFilterCust JSON')
        if 'before' in _dict:
            args['before'] = _dict.get('before')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError(
                'Required property \'created_at\' not present in PrefixFilterCust JSON')
        if 'ge' in _dict:
            args['ge'] = _dict.get('ge')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError(
                'Required property \'id\' not present in PrefixFilterCust JSON')
        if 'le' in _dict:
            args['le'] = _dict.get('le')
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        else:
            raise ValueError(
                'Required property \'prefix\' not present in PrefixFilterCust JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a PrefixFilterCust object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'action') and self.action is not None:
            _dict['action'] = self.action
        if hasattr(self, 'before') and self.before is not None:
            _dict['before'] = self.before
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'ge') and self.ge is not None:
            _dict['ge'] = self.ge
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'le') and self.le is not None:
            _dict['le'] = self.le
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this PrefixFilterCust object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'PrefixFilterCust') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'PrefixFilterCust') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class ActionEnum(str, Enum):
        """
        Whether to permit or deny prefix filter.
        """
        PERMIT = 'permit'
        DENY = 'deny'


class PrefixFilterPut():
    """
    A prefix filter create template.

    :attr str action: Whether to permit or deny prefix filter.
    :attr int ge: (optional) IP Prefix GE.
    :attr int le: (optional) IP Prefix LE.
    :attr str prefix: IP Prefix.
    """

    def __init__(self,
                 action: str,
                 prefix: str,
                 *,
                 ge: int = None,
                 le: int = None) -> None:
        """
        Initialize a PrefixFilterPut object.

        :param str action: Whether to permit or deny prefix filter.
        :param str prefix: IP Prefix.
        :param int ge: (optional) IP Prefix GE.
        :param int le: (optional) IP Prefix LE.
        """
        self.action = action
        self.ge = ge
        self.le = le
        self.prefix = prefix

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'PrefixFilterPut':
        """Initialize a PrefixFilterPut object from a json dictionary."""
        args = {}
        if 'action' in _dict:
            args['action'] = _dict.get('action')
        else:
            raise ValueError(
                'Required property \'action\' not present in PrefixFilterPut JSON')
        if 'ge' in _dict:
            args['ge'] = _dict.get('ge')
        if 'le' in _dict:
            args['le'] = _dict.get('le')
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        else:
            raise ValueError(
                'Required property \'prefix\' not present in PrefixFilterPut JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a PrefixFilterPut object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'action') and self.action is not None:
            _dict['action'] = self.action
        if hasattr(self, 'ge') and self.ge is not None:
            _dict['ge'] = self.ge
        if hasattr(self, 'le') and self.le is not None:
            _dict['le'] = self.le
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this PrefixFilterPut object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'PrefixFilterPut') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'PrefixFilterPut') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class ActionEnum(str, Enum):
        """
        Whether to permit or deny prefix filter.
        """
        PERMIT = 'permit'
        DENY = 'deny'


class ResourceGroupIdentity():
    """
    The resource group to use. If unspecified, the account's [default resource
    group](https://console.bluemix.net/apidocs/resource-manager#introduction) is used.

    :attr str id: The unique identifier for this resource group.
    """

    def __init__(self,
                 id: str) -> None:
        """
        Initialize a ResourceGroupIdentity object.

        :param str id: The unique identifier for this resource group.
        """
        self.id = id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ResourceGroupIdentity':
        """Initialize a ResourceGroupIdentity object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError(
                'Required property \'id\' not present in ResourceGroupIdentity JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ResourceGroupIdentity object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ResourceGroupIdentity object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ResourceGroupIdentity') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ResourceGroupIdentity') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class ResourceGroupReference():
    """
    The resource group to use. If unspecified, the account's [default resource
    group](https://console.bluemix.net/apidocs/resource-manager#introduction) is used.

    :attr str id: The unique identifier for this resource group.
    :attr str href: The URL for this resource group.
    """

    def __init__(self,
                 id: str,
                 href: str) -> None:
        """
        Initialize a ResourceGroupReference object.

        :param str id: The unique identifier for this resource group.
        :param str href: The URL for this resource group.
        """
        self.id = id
        self.href = href

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ResourceGroupReference':
        """Initialize a ResourceGroupReference object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError(
                'Required property \'id\' not present in ResourceGroupReference JSON')
        if 'href' in _dict:
            args['href'] = _dict.get('href')
        else:
            raise ValueError(
                'Required property \'href\' not present in ResourceGroupReference JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ResourceGroupReference object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'href') and self.href is not None:
            _dict['href'] = self.href
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ResourceGroupReference object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ResourceGroupReference') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ResourceGroupReference') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class RouteReport():
    """
    route report.

    :attr List[RouteReportConnection] connections: Array of connections with their
          routes.
    :attr datetime created_at: Date and time route report was requested.
    :attr str id: Report identifier.
    :attr List[RouteReportOverlappingRouteGroup] overlapping_routes: Array of
          overlapping routes.
    :attr str status: Route report status. The list of enumerated values for this
          property may expand in the future. Code and processes using this field must
          tolerate unexpected values.
    :attr datetime updated_at: (optional) Date and time route report was last
          modified.
    """

    def __init__(self,
                 connections: List['RouteReportConnection'],
                 created_at: datetime,
                 id: str,
                 overlapping_routes: List['RouteReportOverlappingRouteGroup'],
                 status: str,
                 *,
                 updated_at: datetime = None) -> None:
        """
        Initialize a RouteReport object.

        :param List[RouteReportConnection] connections: Array of connections with
               their routes.
        :param datetime created_at: Date and time route report was requested.
        :param str id: Report identifier.
        :param List[RouteReportOverlappingRouteGroup] overlapping_routes: Array of
               overlapping routes.
        :param str status: Route report status. The list of enumerated values for
               this property may expand in the future. Code and processes using this field
               must tolerate unexpected values.
        :param datetime updated_at: (optional) Date and time route report was last
               modified.
        """
        self.connections = connections
        self.created_at = created_at
        self.id = id
        self.overlapping_routes = overlapping_routes
        self.status = status
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReport':
        """Initialize a RouteReport object from a json dictionary."""
        args = {}
        if 'connections' in _dict:
            args['connections'] = [RouteReportConnection.from_dict(
                x) for x in _dict.get('connections')]
        else:
            raise ValueError(
                'Required property \'connections\' not present in RouteReport JSON')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError(
                'Required property \'created_at\' not present in RouteReport JSON')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError(
                'Required property \'id\' not present in RouteReport JSON')
        if 'overlapping_routes' in _dict:
            args['overlapping_routes'] = [RouteReportOverlappingRouteGroup.from_dict(
                x) for x in _dict.get('overlapping_routes')]
        else:
            raise ValueError(
                'Required property \'overlapping_routes\' not present in RouteReport JSON')
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        else:
            raise ValueError(
                'Required property \'status\' not present in RouteReport JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReport object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'connections') and self.connections is not None:
            _dict['connections'] = [x.to_dict() for x in self.connections]
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'overlapping_routes') and self.overlapping_routes is not None:
            _dict['overlapping_routes'] = [x.to_dict()
                                           for x in self.overlapping_routes]
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReport object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReport') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReport') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class StatusEnum(str, Enum):
        """
        Route report status. The list of enumerated values for this property may expand in
        the future. Code and processes using this field must tolerate unexpected values.
        """
        COMPLETE = 'complete'
        PENDING = 'pending'


class RouteReportCollection():
    """
    route reports.

    :attr List[RouteReport] route_reports: Array of route reports.
    """

    def __init__(self,
                 route_reports: List['RouteReport']) -> None:
        """
        Initialize a RouteReportCollection object.

        :param List[RouteReport] route_reports: Array of route reports.
        """
        self.route_reports = route_reports

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportCollection':
        """Initialize a RouteReportCollection object from a json dictionary."""
        args = {}
        if 'route_reports' in _dict:
            args['route_reports'] = [RouteReport.from_dict(
                x) for x in _dict.get('route_reports')]
        else:
            raise ValueError(
                'Required property \'route_reports\' not present in RouteReportCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'route_reports') and self.route_reports is not None:
            _dict['route_reports'] = [x.to_dict() for x in self.route_reports]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class RouteReportConnection():
    """
    route report connection.

    :attr List[RouteReportConnectionBgp] bgps: (optional) Array of connection's
          bgps.
    :attr str id: (optional) connection ID.
    :attr str name: (optional) connection name.
    :attr List[RouteReportConnectionRoute] routes: (optional) Array of connection's
          routes.
    :attr str type: (optional) connection type.
    """

    def __init__(self,
                 *,
                 bgps: List['RouteReportConnectionBgp'] = None,
                 id: str = None,
                 name: str = None,
                 routes: List['RouteReportConnectionRoute'] = None,
                 type: str = None) -> None:
        """
        Initialize a RouteReportConnection object.

        :param List[RouteReportConnectionBgp] bgps: (optional) Array of
               connection's bgps.
        :param str id: (optional) connection ID.
        :param str name: (optional) connection name.
        :param List[RouteReportConnectionRoute] routes: (optional) Array of
               connection's routes.
        :param str type: (optional) connection type.
        """
        self.bgps = bgps
        self.id = id
        self.name = name
        self.routes = routes
        self.type = type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportConnection':
        """Initialize a RouteReportConnection object from a json dictionary."""
        args = {}
        if 'bgps' in _dict:
            args['bgps'] = [RouteReportConnectionBgp.from_dict(
                x) for x in _dict.get('bgps')]
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        if 'routes' in _dict:
            args['routes'] = [RouteReportConnectionRoute.from_dict(
                x) for x in _dict.get('routes')]
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportConnection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'bgps') and self.bgps is not None:
            _dict['bgps'] = [x.to_dict() for x in self.bgps]
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'routes') and self.routes is not None:
            _dict['routes'] = [x.to_dict() for x in self.routes]
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportConnection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportConnection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportConnection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class RouteReportConnectionBgp():
    """
    connection bgp details.

    :attr str as_path: (optional) AS path.
    :attr bool is_used: (optional) Indicates whether current route is used or not.
    :attr str local_preference: (optional) local preference.
    :attr str prefix: (optional) prefix.
    """

    def __init__(self,
                 *,
                 as_path: str = None,
                 is_used: bool = None,
                 local_preference: str = None,
                 prefix: str = None) -> None:
        """
        Initialize a RouteReportConnectionBgp object.

        :param str as_path: (optional) AS path.
        :param bool is_used: (optional) Indicates whether current route is used or
               not.
        :param str local_preference: (optional) local preference.
        :param str prefix: (optional) prefix.
        """
        self.as_path = as_path
        self.is_used = is_used
        self.local_preference = local_preference
        self.prefix = prefix

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportConnectionBgp':
        """Initialize a RouteReportConnectionBgp object from a json dictionary."""
        args = {}
        if 'as_path' in _dict:
            args['as_path'] = _dict.get('as_path')
        if 'is_used' in _dict:
            args['is_used'] = _dict.get('is_used')
        if 'local_preference' in _dict:
            args['local_preference'] = _dict.get('local_preference')
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportConnectionBgp object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'as_path') and self.as_path is not None:
            _dict['as_path'] = self.as_path
        if hasattr(self, 'is_used') and self.is_used is not None:
            _dict['is_used'] = self.is_used
        if hasattr(self, 'local_preference') and self.local_preference is not None:
            _dict['local_preference'] = self.local_preference
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportConnectionBgp object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportConnectionBgp') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportConnectionBgp') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class RouteReportConnectionRoute():
    """
    connection used route.

    :attr str prefix: (optional) prefix.
    """

    def __init__(self,
                 *,
                 prefix: str = None) -> None:
        """
        Initialize a RouteReportConnectionRoute object.

        :param str prefix: (optional) prefix.
        """
        self.prefix = prefix

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportConnectionRoute':
        """Initialize a RouteReportConnectionRoute object from a json dictionary."""
        args = {}
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportConnectionRoute object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportConnectionRoute object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportConnectionRoute') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportConnectionRoute') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class RouteReportOverlappingRoute():
    """
    overlapping route details.

    :attr str connection_id: (optional) connection ID.
    :attr str prefix: (optional) overlapping prefix.
    """

    def __init__(self,
                 *,
                 connection_id: str = None,
                 prefix: str = None) -> None:
        """
        Initialize a RouteReportOverlappingRoute object.

        :param str connection_id: (optional) connection ID.
        :param str prefix: (optional) overlapping prefix.
        """
        self.connection_id = connection_id
        self.prefix = prefix

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportOverlappingRoute':
        """Initialize a RouteReportOverlappingRoute object from a json dictionary."""
        args = {}
        if 'connection_id' in _dict:
            args['connection_id'] = _dict.get('connection_id')
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportOverlappingRoute object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'connection_id') and self.connection_id is not None:
            _dict['connection_id'] = self.connection_id
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportOverlappingRoute object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportOverlappingRoute') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportOverlappingRoute') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class RouteReportOverlappingRouteGroup():
    """
    Collection of overlapping route.

    :attr List[RouteReportOverlappingRoute] routes: (optional) Array of overlapping
          connection/prefix pairs.
    """

    def __init__(self,
                 *,
                 routes: List['RouteReportOverlappingRoute'] = None) -> None:
        """
        Initialize a RouteReportOverlappingRouteGroup object.

        :param List[RouteReportOverlappingRoute] routes: (optional) Array of
               overlapping connection/prefix pairs.
        """
        self.routes = routes

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportOverlappingRouteGroup':
        """Initialize a RouteReportOverlappingRouteGroup object from a json dictionary."""
        args = {}
        if 'routes' in _dict:
            args['routes'] = [RouteReportOverlappingRoute.from_dict(
                x) for x in _dict.get('routes')]
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportOverlappingRouteGroup object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'routes') and self.routes is not None:
            _dict['routes'] = [x.to_dict() for x in self.routes]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportOverlappingRouteGroup object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportOverlappingRouteGroup') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportOverlappingRouteGroup') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TSCollection():
    """
    A list of Transit Gateway locations.

    :attr List[TSLocationBasic] locations: Collection of Transit Gateway locations.
    """

    def __init__(self,
                 locations: List['TSLocationBasic']) -> None:
        """
        Initialize a TSCollection object.

        :param List[TSLocationBasic] locations: Collection of Transit Gateway
               locations.
        """
        self.locations = locations

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TSCollection':
        """Initialize a TSCollection object from a json dictionary."""
        args = {}
        if 'locations' in _dict:
            args['locations'] = [TSLocationBasic.from_dict(
                x) for x in _dict.get('locations')]
        else:
            raise ValueError(
                'Required property \'locations\' not present in TSCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TSCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'locations') and self.locations is not None:
            _dict['locations'] = [x.to_dict() for x in self.locations]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TSCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TSCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TSCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TSLocalLocation():
    """
    Details of a local connection location.

    :attr str display_name: (optional) A descriptive display name for the location.
    :attr str name: (optional) The name of the location.
    :attr List[str] supported_connection_types: (optional) Array of supported
          connection types.
    :attr str type: (optional) The type of the location, determining is this a
          multi-zone region, a single data center, or a point of presence. The list of
          enumerated values for this property may expand in the future. Code and processes
          using this field must tolerate unexpected values.
    """

    def __init__(self,
                 *,
                 display_name: str = None,
                 name: str = None,
                 supported_connection_types: List[str] = None,
                 type: str = None) -> None:
        """
        Initialize a TSLocalLocation object.

        :param str display_name: (optional) A descriptive display name for the
               location.
        :param str name: (optional) The name of the location.
        :param List[str] supported_connection_types: (optional) Array of supported
               connection types.
        :param str type: (optional) The type of the location, determining is this a
               multi-zone region, a single data center, or a point of presence. The list
               of enumerated values for this property may expand in the future. Code and
               processes using this field must tolerate unexpected values.
        """
        self.display_name = display_name
        self.name = name
        self.supported_connection_types = supported_connection_types
        self.type = type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TSLocalLocation':
        """Initialize a TSLocalLocation object from a json dictionary."""
        args = {}
        if 'display_name' in _dict:
            args['display_name'] = _dict.get('display_name')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        if 'supported_connection_types' in _dict:
            args['supported_connection_types'] = _dict.get(
                'supported_connection_types')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TSLocalLocation object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'display_name') and self.display_name is not None:
            _dict['display_name'] = self.display_name
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'supported_connection_types') and self.supported_connection_types is not None:
            _dict['supported_connection_types'] = self.supported_connection_types
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TSLocalLocation object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TSLocalLocation') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TSLocalLocation') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        The type of the location, determining is this a multi-zone region, a single data
        center, or a point of presence. The list of enumerated values for this property
        may expand in the future. Code and processes using this field must tolerate
        unexpected values.
        """
        REGION = 'region'
        DC = 'dc'


class TSLocation():
    """
    Details of a Transit Gateway location.

    :attr str billing_location: The geographical location of this location, used for
          billing purposes.
    :attr str name: Name of the Location.
    :attr str type: The type of the location, determining is this a multi-zone
          region, a single data center, or a point of presence.
    :attr List[TSLocalLocation] local_connection_locations: The set of network
          locations that are considered local for this Transit Gateway location.
    """

    def __init__(self,
                 billing_location: str,
                 name: str,
                 type: str,
                 local_connection_locations: List['TSLocalLocation']) -> None:
        """
        Initialize a TSLocation object.

        :param str billing_location: The geographical location of this location,
               used for billing purposes.
        :param str name: Name of the Location.
        :param str type: The type of the location, determining is this a multi-zone
               region, a single data center, or a point of presence.
        :param List[TSLocalLocation] local_connection_locations: The set of network
               locations that are considered local for this Transit Gateway location.
        """
        self.billing_location = billing_location
        self.name = name
        self.type = type
        self.local_connection_locations = local_connection_locations

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TSLocation':
        """Initialize a TSLocation object from a json dictionary."""
        args = {}
        if 'billing_location' in _dict:
            args['billing_location'] = _dict.get('billing_location')
        else:
            raise ValueError(
                'Required property \'billing_location\' not present in TSLocation JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError(
                'Required property \'name\' not present in TSLocation JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError(
                'Required property \'type\' not present in TSLocation JSON')
        if 'local_connection_locations' in _dict:
            args['local_connection_locations'] = [TSLocalLocation.from_dict(
                x) for x in _dict.get('local_connection_locations')]
        else:
            raise ValueError(
                'Required property \'local_connection_locations\' not present in TSLocation JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TSLocation object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'billing_location') and self.billing_location is not None:
            _dict['billing_location'] = self.billing_location
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'local_connection_locations') and self.local_connection_locations is not None:
            _dict['local_connection_locations'] = [x.to_dict()
                                                   for x in self.local_connection_locations]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TSLocation object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TSLocation') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TSLocation') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TSLocationBasic():
    """
    Details of a Transit Gateway location.

    :attr str billing_location: The geographical location of this location, used for
          billing purposes.
    :attr str name: Name of the Location.
    :attr str type: The type of the location, determining is this a multi-zone
          region, a single data center, or a point of presence.
    """

    def __init__(self,
                 billing_location: str,
                 name: str,
                 type: str) -> None:
        """
        Initialize a TSLocationBasic object.

        :param str billing_location: The geographical location of this location,
               used for billing purposes.
        :param str name: Name of the Location.
        :param str type: The type of the location, determining is this a multi-zone
               region, a single data center, or a point of presence.
        """
        self.billing_location = billing_location
        self.name = name
        self.type = type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TSLocationBasic':
        """Initialize a TSLocationBasic object from a json dictionary."""
        args = {}
        if 'billing_location' in _dict:
            args['billing_location'] = _dict.get('billing_location')
        else:
            raise ValueError(
                'Required property \'billing_location\' not present in TSLocationBasic JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError(
                'Required property \'name\' not present in TSLocationBasic JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError(
                'Required property \'type\' not present in TSLocationBasic JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TSLocationBasic object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'billing_location') and self.billing_location is not None:
            _dict['billing_location'] = self.billing_location
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TSLocationBasic object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TSLocationBasic') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TSLocationBasic') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TransitConnection():
    """
    Transit gateway connection.

    :attr str base_connection_id: (optional) network_type 'gre_tunnel' connections
          use 'base_connection_id' to specify the id of a network_type 'classic'
          connection the tunnel is configured over. The specified connection must reside
          in the same transit gateway and be in an active state. The 'classic' connection
          cannot be deleted until any 'gre_tunnel' connections using it are deleted. This
          field only applies to and is required for network type 'gre_tunnel' connections.
    :attr datetime created_at: The date and time that this connection was created.
    :attr str id: The unique identifier for this connection.
    :attr int local_bgp_asn: (optional) Local network BGP ASN.  This field only
          applies to network type 'gre_tunnel' connections.
    :attr str local_gateway_ip: (optional) Local gateway IP address.  This field
          only applies to network type 'gre_tunnel' connections.
    :attr str local_tunnel_ip: (optional) Local tunnel IP address.  This field only
          applies to network type 'gre_tunnel' connections.
    :attr int mtu: (optional) GRE tunnel MTU.  This field only applies to network
          type 'gre_tunnel' connections.
    :attr str name: The user-defined name for this transit gateway connection.
    :attr str network_account_id: (optional) The ID of the account which owns the
          connected network. Generally only used if the network is in a different IBM
          Cloud account than the gateway.
    :attr str network_id: (optional) The ID of the network being connected via this
          connection. This field is required for some types, such as 'vpc',
          'power_virtual_server' and 'directlink'. For network types
          'vpc','power_virtual_server' and 'directlink' this is the CRN of the VPC /
          PowerVS / Direct Link gateway respectively.
    :attr str network_type: Defines what type of network is connected via this
          connection. The list of enumerated values for this property may expand in the
          future. Code and processes using this field must tolerate unexpected values.
    :attr List[TransitGatewayConnectionPrefixFilterReference] prefix_filters:
          (optional) Array of prefix route filters for a transit gateway connection. This
          is order dependent with those first in the array being applied first, and those
          at the end of the array is applied last, or just before the default.
    :attr str prefix_filters_default: Default setting of permit or deny which
          applies to any routes that don't match a specified filter.
    :attr int remote_bgp_asn: (optional) Remote network BGP ASN.  This field only
          applies to network type 'gre_tunnel' connections.
    :attr str remote_gateway_ip: (optional) Remote gateway IP address.  This field
          only applies to network type 'gre_tunnel' connections.
    :attr str remote_tunnel_ip: (optional) Remote tunnel IP address.  This field
          only applies to network type 'gre_tunnel' connections.
    :attr str request_status: (optional) Only visible for cross account connections,
          this field represents the status of a connection request between IBM Cloud
          accounts. The list of enumerated values for this property may expand in the
          future. Code and processes using this field must tolerate unexpected values.
    :attr str status: Connection state. The list of enumerated values for this
          property may expand in the future. Code and processes using this field must
          tolerate unexpected values.
    :attr TransitGatewayReference transit_gateway: Reference to the transit gateway
          that contains this connection.
    :attr datetime updated_at: (optional) The date and time that this connection was
          last updated.
    :attr ZoneReference zone: (optional) Location of GRE tunnel.  This field only
          applies to network type 'gre_tunnel' connections.
    """

    def __init__(self,
                 created_at: datetime,
                 id: str,
                 name: str,
                 network_type: str,
                 prefix_filters_default: str,
                 status: str,
                 transit_gateway: 'TransitGatewayReference',
                 *,
                 base_connection_id: str = None,
                 local_bgp_asn: int = None,
                 local_gateway_ip: str = None,
                 local_tunnel_ip: str = None,
                 mtu: int = None,
                 network_account_id: str = None,
                 network_id: str = None,
                 prefix_filters: List['TransitGatewayConnectionPrefixFilterReference'] = None,
                 remote_bgp_asn: int = None,
                 remote_gateway_ip: str = None,
                 remote_tunnel_ip: str = None,
                 request_status: str = None,
                 updated_at: datetime = None,
                 zone: 'ZoneReference' = None) -> None:
        """
        Initialize a TransitConnection object.

        :param datetime created_at: The date and time that this connection was
               created.
        :param str id: The unique identifier for this connection.
        :param str name: The user-defined name for this transit gateway connection.
        :param str network_type: Defines what type of network is connected via this
               connection. The list of enumerated values for this property may expand in
               the future. Code and processes using this field must tolerate unexpected
               values.
        :param str prefix_filters_default: Default setting of permit or deny which
               applies to any routes that don't match a specified filter.
        :param str status: Connection state. The list of enumerated values for this
               property may expand in the future. Code and processes using this field must
               tolerate unexpected values.
        :param TransitGatewayReference transit_gateway: Reference to the transit
               gateway that contains this connection.
        :param str base_connection_id: (optional) network_type 'gre_tunnel'
               connections use 'base_connection_id' to specify the id of a network_type
               'classic' connection the tunnel is configured over. The specified
               connection must reside in the same transit gateway and be in an active
               state. The 'classic' connection cannot be deleted until any 'gre_tunnel'
               connections using it are deleted. This field only applies to and is
               required for network type 'gre_tunnel' connections.
        :param int local_bgp_asn: (optional) Local network BGP ASN.  This field
               only applies to network type 'gre_tunnel' connections.
        :param str local_gateway_ip: (optional) Local gateway IP address.  This
               field only applies to network type 'gre_tunnel' connections.
        :param str local_tunnel_ip: (optional) Local tunnel IP address.  This field
               only applies to network type 'gre_tunnel' connections.
        :param int mtu: (optional) GRE tunnel MTU.  This field only applies to
               network type 'gre_tunnel' connections.
        :param str network_account_id: (optional) The ID of the account which owns
               the connected network. Generally only used if the network is in a different
               IBM Cloud account than the gateway.
        :param str network_id: (optional) The ID of the network being connected via
               this connection. This field is required for some types, such as 'vpc',
               'power_virtual_server' and 'directlink'. For network types
               'vpc','power_virtual_server' and 'directlink' this is the CRN of the VPC /
               PowerVS / Direct Link gateway respectively.
        :param List[TransitGatewayConnectionPrefixFilterReference] prefix_filters:
               (optional) Array of prefix route filters for a transit gateway connection.
               This is order dependent with those first in the array being applied first,
               and those at the end of the array is applied last, or just before the
               default.
        :param int remote_bgp_asn: (optional) Remote network BGP ASN.  This field
               only applies to network type 'gre_tunnel' connections.
        :param str remote_gateway_ip: (optional) Remote gateway IP address.  This
               field only applies to network type 'gre_tunnel' connections.
        :param str remote_tunnel_ip: (optional) Remote tunnel IP address.  This
               field only applies to network type 'gre_tunnel' connections.
        :param str request_status: (optional) Only visible for cross account
               connections, this field represents the status of a connection request
               between IBM Cloud accounts. The list of enumerated values for this property
               may expand in the future. Code and processes using this field must tolerate
               unexpected values.
        :param datetime updated_at: (optional) The date and time that this
               connection was last updated.
        :param ZoneReference zone: (optional) Location of GRE tunnel.  This field
               only applies to network type 'gre_tunnel' connections.
        """
        self.base_connection_id = base_connection_id
        self.created_at = created_at
        self.id = id
        self.local_bgp_asn = local_bgp_asn
        self.local_gateway_ip = local_gateway_ip
        self.local_tunnel_ip = local_tunnel_ip
        self.mtu = mtu
        self.name = name
        self.network_account_id = network_account_id
        self.network_id = network_id
        self.network_type = network_type
        self.prefix_filters = prefix_filters
        self.prefix_filters_default = prefix_filters_default
        self.remote_bgp_asn = remote_bgp_asn
        self.remote_gateway_ip = remote_gateway_ip
        self.remote_tunnel_ip = remote_tunnel_ip
        self.request_status = request_status
        self.status = status
        self.transit_gateway = transit_gateway
        self.updated_at = updated_at
        self.zone = zone

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitConnection':
        """Initialize a TransitConnection object from a json dictionary."""
        args = {}
        if 'base_connection_id' in _dict:
            args['base_connection_id'] = _dict.get('base_connection_id')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError(
                'Required property \'created_at\' not present in TransitConnection JSON')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError(
                'Required property \'id\' not present in TransitConnection JSON')
        if 'local_bgp_asn' in _dict:
            args['local_bgp_asn'] = _dict.get('local_bgp_asn')
        if 'local_gateway_ip' in _dict:
            args['local_gateway_ip'] = _dict.get('local_gateway_ip')
        if 'local_tunnel_ip' in _dict:
            args['local_tunnel_ip'] = _dict.get('local_tunnel_ip')
        if 'mtu' in _dict:
            args['mtu'] = _dict.get('mtu')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError(
                'Required property \'name\' not present in TransitConnection JSON')
        if 'network_account_id' in _dict:
            args['network_account_id'] = _dict.get('network_account_id')
        if 'network_id' in _dict:
            args['network_id'] = _dict.get('network_id')
        if 'network_type' in _dict:
            args['network_type'] = _dict.get('network_type')
        else:
            raise ValueError(
                'Required property \'network_type\' not present in TransitConnection JSON')
        if 'prefix_filters' in _dict:
            args['prefix_filters'] = [TransitGatewayConnectionPrefixFilterReference.from_dict(
                x) for x in _dict.get('prefix_filters')]
        if 'prefix_filters_default' in _dict:
            args['prefix_filters_default'] = _dict.get(
                'prefix_filters_default')
        else:
            raise ValueError(
                'Required property \'prefix_filters_default\' not present in TransitConnection JSON')
        if 'remote_bgp_asn' in _dict:
            args['remote_bgp_asn'] = _dict.get('remote_bgp_asn')
        if 'remote_gateway_ip' in _dict:
            args['remote_gateway_ip'] = _dict.get('remote_gateway_ip')
        if 'remote_tunnel_ip' in _dict:
            args['remote_tunnel_ip'] = _dict.get('remote_tunnel_ip')
        if 'request_status' in _dict:
            args['request_status'] = _dict.get('request_status')
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        else:
            raise ValueError(
                'Required property \'status\' not present in TransitConnection JSON')
        if 'transit_gateway' in _dict:
            args['transit_gateway'] = TransitGatewayReference.from_dict(
                _dict.get('transit_gateway'))
        else:
            raise ValueError(
                'Required property \'transit_gateway\' not present in TransitConnection JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        if 'zone' in _dict:
            args['zone'] = ZoneReference.from_dict(_dict.get('zone'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitConnection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'base_connection_id') and self.base_connection_id is not None:
            _dict['base_connection_id'] = self.base_connection_id
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'local_bgp_asn') and self.local_bgp_asn is not None:
            _dict['local_bgp_asn'] = self.local_bgp_asn
        if hasattr(self, 'local_gateway_ip') and self.local_gateway_ip is not None:
            _dict['local_gateway_ip'] = self.local_gateway_ip
        if hasattr(self, 'local_tunnel_ip') and self.local_tunnel_ip is not None:
            _dict['local_tunnel_ip'] = self.local_tunnel_ip
        if hasattr(self, 'mtu') and self.mtu is not None:
            _dict['mtu'] = self.mtu
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'network_account_id') and self.network_account_id is not None:
            _dict['network_account_id'] = self.network_account_id
        if hasattr(self, 'network_id') and self.network_id is not None:
            _dict['network_id'] = self.network_id
        if hasattr(self, 'network_type') and self.network_type is not None:
            _dict['network_type'] = self.network_type
        if hasattr(self, 'prefix_filters') and self.prefix_filters is not None:
            _dict['prefix_filters'] = [x.to_dict()
                                       for x in self.prefix_filters]
        if hasattr(self, 'prefix_filters_default') and self.prefix_filters_default is not None:
            _dict['prefix_filters_default'] = self.prefix_filters_default
        if hasattr(self, 'remote_bgp_asn') and self.remote_bgp_asn is not None:
            _dict['remote_bgp_asn'] = self.remote_bgp_asn
        if hasattr(self, 'remote_gateway_ip') and self.remote_gateway_ip is not None:
            _dict['remote_gateway_ip'] = self.remote_gateway_ip
        if hasattr(self, 'remote_tunnel_ip') and self.remote_tunnel_ip is not None:
            _dict['remote_tunnel_ip'] = self.remote_tunnel_ip
        if hasattr(self, 'request_status') and self.request_status is not None:
            _dict['request_status'] = self.request_status
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        if hasattr(self, 'transit_gateway') and self.transit_gateway is not None:
            _dict['transit_gateway'] = self.transit_gateway.to_dict()
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'zone') and self.zone is not None:
            _dict['zone'] = self.zone.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitConnection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitConnection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitConnection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class NetworkTypeEnum(str, Enum):
        """
        Defines what type of network is connected via this connection. The list of
        enumerated values for this property may expand in the future. Code and processes
        using this field must tolerate unexpected values.
        """
        CLASSIC = 'classic'
        DIRECTLINK = 'directlink'
        GRE_TUNNEL = 'gre_tunnel'
        UNBOUND_GRE_TUNNEL = 'unbound_gre_tunnel'
        VPC = 'vpc'
        POWER_VIRTUAL_SERVER = 'power_virtual_server'

    class PrefixFiltersDefaultEnum(str, Enum):
        """
        Default setting of permit or deny which applies to any routes that don't match a
        specified filter.
        """
        PERMIT = 'permit'
        DENY = 'deny'

    class RequestStatusEnum(str, Enum):
        """
        Only visible for cross account connections, this field represents the status of a
        connection request between IBM Cloud accounts. The list of enumerated values for
        this property may expand in the future. Code and processes using this field must
        tolerate unexpected values.
        """
        PENDING = 'pending'
        APPROVED = 'approved'
        REJECTED = 'rejected'
        EXPIRED = 'expired'
        DETACHED = 'detached'

    class StatusEnum(str, Enum):
        """
        Connection state. The list of enumerated values for this property may expand in
        the future. Code and processes using this field must tolerate unexpected values.
        """
        ATTACHED = 'attached'
        FAILED = 'failed'
        PENDING = 'pending'
        DELETING = 'deleting'
        DETACHING = 'detaching'
        DETACHED = 'detached'
        SUSPENDING = 'suspending'
        SUSPENDED = 'suspended'


class TransitConnectionCollection():
    """
    Transit gateway connections.

    :attr List[TransitConnection] connections: Array of transit gateway connections.
    :attr TransitConnectionCollectionFirst first: A reference to the first page of
          resources.
    :attr int limit: The maximum number of connections returned on one request.
    :attr TransitConnectionCollectionNext next: (optional) A reference to the next
          page of resources; this reference is included for all pages except the last
          page.
    """

    def __init__(self,
                 connections: List['TransitConnection'],
                 first: 'TransitConnectionCollectionFirst',
                 limit: int,
                 *,
                 next: 'TransitConnectionCollectionNext' = None) -> None:
        """
        Initialize a TransitConnectionCollection object.

        :param List[TransitConnection] connections: Array of transit gateway
               connections.
        :param TransitConnectionCollectionFirst first: A reference to the first
               page of resources.
        :param int limit: The maximum number of connections returned on one
               request.
        :param TransitConnectionCollectionNext next: (optional) A reference to the
               next page of resources; this reference is included for all pages except the
               last page.
        """
        self.connections = connections
        self.first = first
        self.limit = limit
        self.next = next

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitConnectionCollection':
        """Initialize a TransitConnectionCollection object from a json dictionary."""
        args = {}
        if 'connections' in _dict:
            args['connections'] = [TransitConnection.from_dict(
                x) for x in _dict.get('connections')]
        else:
            raise ValueError(
                'Required property \'connections\' not present in TransitConnectionCollection JSON')
        if 'first' in _dict:
            args['first'] = TransitConnectionCollectionFirst.from_dict(
                _dict.get('first'))
        else:
            raise ValueError(
                'Required property \'first\' not present in TransitConnectionCollection JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError(
                'Required property \'limit\' not present in TransitConnectionCollection JSON')
        if 'next' in _dict:
            args['next'] = TransitConnectionCollectionNext.from_dict(
                _dict.get('next'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitConnectionCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'connections') and self.connections is not None:
            _dict['connections'] = [x.to_dict() for x in self.connections]
        if hasattr(self, 'first') and self.first is not None:
            _dict['first'] = self.first.to_dict()
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'next') and self.next is not None:
            _dict['next'] = self.next.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitConnectionCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitConnectionCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitConnectionCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TransitConnectionCollectionFirst():
    """
    A reference to the first page of resources.

    :attr str href: url.
    """

    def __init__(self,
                 href: str) -> None:
        """
        Initialize a TransitConnectionCollectionFirst object.

        :param str href: url.
        """
        self.href = href

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitConnectionCollectionFirst':
        """Initialize a TransitConnectionCollectionFirst object from a json dictionary."""
        args = {}
        if 'href' in _dict:
            args['href'] = _dict.get('href')
        else:
            raise ValueError(
                'Required property \'href\' not present in TransitConnectionCollectionFirst JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitConnectionCollectionFirst object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'href') and self.href is not None:
            _dict['href'] = self.href
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitConnectionCollectionFirst object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitConnectionCollectionFirst') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitConnectionCollectionFirst') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TransitConnectionCollectionNext():
    """
    A reference to the next page of resources; this reference is included for all pages
    except the last page.

    :attr str href: (optional) url.
    :attr str start: (optional) server generated start token for next page of
          resources.
    """

    def __init__(self,
                 *,
                 href: str = None,
                 start: str = None) -> None:
        """
        Initialize a TransitConnectionCollectionNext object.

        :param str href: (optional) url.
        :param str start: (optional) server generated start token for next page of
               resources.
        """
        self.href = href
        self.start = start

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitConnectionCollectionNext':
        """Initialize a TransitConnectionCollectionNext object from a json dictionary."""
        args = {}
        if 'href' in _dict:
            args['href'] = _dict.get('href')
        if 'start' in _dict:
            args['start'] = _dict.get('start')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitConnectionCollectionNext object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'href') and self.href is not None:
            _dict['href'] = self.href
        if hasattr(self, 'start') and self.start is not None:
            _dict['start'] = self.start
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitConnectionCollectionNext object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitConnectionCollectionNext') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitConnectionCollectionNext') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TransitGateway():
    """
    Details of a Transit Gateway.

    :attr str id: The unique identifier for this Transit Gateway.
    :attr str crn: The CRN for this Transit Gateway.
    :attr str name: A human readable name for the transit gateway.
    :attr str location: Location of Transit Gateway Services.
    :attr datetime created_at: The date and time that this gateway was created.
    :attr bool global_: Allow global routing for a Transit Gateway.
    :attr ResourceGroupReference resource_group: (optional) The resource group to
          use. If unspecified, the account's [default resource
          group](https://console.bluemix.net/apidocs/resource-manager#introduction) is
          used.
    :attr str status: The status of the Transit Gateway. The list of enumerated
          values for this property may expand in the future. Code and processes using this
          field must tolerate unexpected values.
    :attr datetime updated_at: (optional) The date and time that this gateway was
          last updated.
    """

    def __init__(self,
                 id: str,
                 crn: str,
                 name: str,
                 location: str,
                 created_at: datetime,
                 global_: bool,
                 status: str,
                 *,
                 resource_group: 'ResourceGroupReference' = None,
                 updated_at: datetime = None) -> None:
        """
        Initialize a TransitGateway object.

        :param str id: The unique identifier for this Transit Gateway.
        :param str crn: The CRN for this Transit Gateway.
        :param str name: A human readable name for the transit gateway.
        :param str location: Location of Transit Gateway Services.
        :param datetime created_at: The date and time that this gateway was
               created.
        :param bool global_: Allow global routing for a Transit Gateway.
        :param str status: The status of the Transit Gateway. The list of
               enumerated values for this property may expand in the future. Code and
               processes using this field must tolerate unexpected values.
        :param ResourceGroupReference resource_group: (optional) The resource group
               to use. If unspecified, the account's [default resource
               group](https://console.bluemix.net/apidocs/resource-manager#introduction)
               is used.
        :param datetime updated_at: (optional) The date and time that this gateway
               was last updated.
        """
        self.id = id
        self.crn = crn
        self.name = name
        self.location = location
        self.created_at = created_at
        self.global_ = global_
        self.resource_group = resource_group
        self.status = status
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGateway':
        """Initialize a TransitGateway object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError(
                'Required property \'id\' not present in TransitGateway JSON')
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError(
                'Required property \'crn\' not present in TransitGateway JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError(
                'Required property \'name\' not present in TransitGateway JSON')
        if 'location' in _dict:
            args['location'] = _dict.get('location')
        else:
            raise ValueError(
                'Required property \'location\' not present in TransitGateway JSON')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError(
                'Required property \'created_at\' not present in TransitGateway JSON')
        if 'global' in _dict:
            args['global_'] = _dict.get('global')
        else:
            raise ValueError(
                'Required property \'global\' not present in TransitGateway JSON')
        if 'resource_group' in _dict:
            args['resource_group'] = ResourceGroupReference.from_dict(
                _dict.get('resource_group'))
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        else:
            raise ValueError(
                'Required property \'status\' not present in TransitGateway JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGateway object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'location') and self.location is not None:
            _dict['location'] = self.location
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'global_') and self.global_ is not None:
            _dict['global'] = self.global_
        if hasattr(self, 'resource_group') and self.resource_group is not None:
            _dict['resource_group'] = self.resource_group.to_dict()
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGateway object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGateway') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGateway') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class StatusEnum(str, Enum):
        """
        The status of the Transit Gateway. The list of enumerated values for this property
        may expand in the future. Code and processes using this field must tolerate
        unexpected values.
        """
        AVAILABLE = 'available'
        FAILED = 'failed'
        PENDING = 'pending'
        DELETING = 'deleting'
        SUSPENDING = 'suspending'
        SUSPENDED = 'suspended'


class TransitGatewayCollection():
    """
    A list of Transit Gateways.

    :attr TransitGatewayCollectionFirst first: A reference to the first page of
          resources.
    :attr int limit: The maximum number of gateways returned on one request.
    :attr TransitGatewayCollectionNext next: (optional) A reference to the next page
          of resources; this reference is included for all pages except the last page.
    :attr List[TransitGateway] transit_gateways: Collection of Transit Services
          gateways.
    """

    def __init__(self,
                 first: 'TransitGatewayCollectionFirst',
                 limit: int,
                 transit_gateways: List['TransitGateway'],
                 *,
                 next: 'TransitGatewayCollectionNext' = None) -> None:
        """
        Initialize a TransitGatewayCollection object.

        :param TransitGatewayCollectionFirst first: A reference to the first page
               of resources.
        :param int limit: The maximum number of gateways returned on one request.
        :param List[TransitGateway] transit_gateways: Collection of Transit
               Services gateways.
        :param TransitGatewayCollectionNext next: (optional) A reference to the
               next page of resources; this reference is included for all pages except the
               last page.
        """
        self.first = first
        self.limit = limit
        self.next = next
        self.transit_gateways = transit_gateways

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayCollection':
        """Initialize a TransitGatewayCollection object from a json dictionary."""
        args = {}
        if 'first' in _dict:
            args['first'] = TransitGatewayCollectionFirst.from_dict(
                _dict.get('first'))
        else:
            raise ValueError(
                'Required property \'first\' not present in TransitGatewayCollection JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError(
                'Required property \'limit\' not present in TransitGatewayCollection JSON')
        if 'next' in _dict:
            args['next'] = TransitGatewayCollectionNext.from_dict(
                _dict.get('next'))
        if 'transit_gateways' in _dict:
            args['transit_gateways'] = [TransitGateway.from_dict(
                x) for x in _dict.get('transit_gateways')]
        else:
            raise ValueError(
                'Required property \'transit_gateways\' not present in TransitGatewayCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'first') and self.first is not None:
            _dict['first'] = self.first.to_dict()
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'next') and self.next is not None:
            _dict['next'] = self.next.to_dict()
        if hasattr(self, 'transit_gateways') and self.transit_gateways is not None:
            _dict['transit_gateways'] = [x.to_dict()
                                         for x in self.transit_gateways]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TransitGatewayCollectionFirst():
    """
    A reference to the first page of resources.

    :attr str href: url.
    """

    def __init__(self,
                 href: str) -> None:
        """
        Initialize a TransitGatewayCollectionFirst object.

        :param str href: url.
        """
        self.href = href

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayCollectionFirst':
        """Initialize a TransitGatewayCollectionFirst object from a json dictionary."""
        args = {}
        if 'href' in _dict:
            args['href'] = _dict.get('href')
        else:
            raise ValueError(
                'Required property \'href\' not present in TransitGatewayCollectionFirst JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayCollectionFirst object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'href') and self.href is not None:
            _dict['href'] = self.href
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayCollectionFirst object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayCollectionFirst') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayCollectionFirst') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TransitGatewayCollectionNext():
    """
    A reference to the next page of resources; this reference is included for all pages
    except the last page.

    :attr str href: url.
    :attr str start: server generated start token for next page of resources.
    """

    def __init__(self,
                 href: str,
                 start: str) -> None:
        """
        Initialize a TransitGatewayCollectionNext object.

        :param str href: url.
        :param str start: server generated start token for next page of resources.
        """
        self.href = href
        self.start = start

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayCollectionNext':
        """Initialize a TransitGatewayCollectionNext object from a json dictionary."""
        args = {}
        if 'href' in _dict:
            args['href'] = _dict.get('href')
        else:
            raise ValueError(
                'Required property \'href\' not present in TransitGatewayCollectionNext JSON')
        if 'start' in _dict:
            args['start'] = _dict.get('start')
        else:
            raise ValueError(
                'Required property \'start\' not present in TransitGatewayCollectionNext JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayCollectionNext object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'href') and self.href is not None:
            _dict['href'] = self.href
        if hasattr(self, 'start') and self.start is not None:
            _dict['start'] = self.start
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayCollectionNext object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayCollectionNext') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayCollectionNext') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TransitGatewayConnectionCollection():
    """
    A set of Transit Gateway network connections.

    :attr List[TransitGatewayConnectionCust] connections: Array of transit gateways
          network Connections.
    """

    def __init__(self,
                 connections: List['TransitGatewayConnectionCust']) -> None:
        """
        Initialize a TransitGatewayConnectionCollection object.

        :param List[TransitGatewayConnectionCust] connections: Array of transit
               gateways network Connections.
        """
        self.connections = connections

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayConnectionCollection':
        """Initialize a TransitGatewayConnectionCollection object from a json dictionary."""
        args = {}
        if 'connections' in _dict:
            args['connections'] = [TransitGatewayConnectionCust.from_dict(
                x) for x in _dict.get('connections')]
        else:
            raise ValueError(
                'Required property \'connections\' not present in TransitGatewayConnectionCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayConnectionCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'connections') and self.connections is not None:
            _dict['connections'] = [x.to_dict() for x in self.connections]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayConnectionCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayConnectionCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayConnectionCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TransitGatewayConnectionCust():
    """
    Connection included in transit gateway.

    :attr str base_network_type: (optional) The type of network the GRE tunnel is
          targeting.
    :attr str name: The user-defined name for this transit gateway connection.
    :attr str network_id: (optional) The ID of the network being connected via this
          connection. This field is required for some types, such as 'vpc',
          'power_virtual_server' and 'directlink'. For network types
          'vpc','power_virtual_server' and 'directlink' this is the CRN of the VPC /
          PowerVS / Direct Link gateway respectively.
    :attr str network_type: Defines what type of network is connected via this
          connection. The list of enumerated values for this property may expand in the
          future. Code and processes using this field must tolerate unexpected values.
    :attr str id: The unique identifier for this Transit Gateway Connection.
    :attr str base_connection_id: (optional) network_type 'gre_tunnel' connections
          use 'base_connection_id' to specify the ID of a network_type 'classic'
          connection the tunnel is configured over. The specified connection must reside
          in the same transit gateway and be in an active state. The 'classic' connection
          cannot be deleted until any 'gre_tunnel' connections using it are deleted. This
          field only applies to and is required for network type 'gre_tunnel' connections.
    :attr datetime created_at: The date and time that this connection was created.
    :attr int local_bgp_asn: (optional) Local network BGP ASN.  This field only
          applies to network type 'gre_tunnel' and 'unbound_gre_tunnel' connections.
    :attr str local_gateway_ip: (optional) Local gateway IP address.  This field
          only applies to network type 'gre_tunnel' and 'unbound_gre_tunnel' connections.
    :attr str local_tunnel_ip: (optional) Local tunnel IP address.  This field only
          applies to network type 'gre_tunnel' and 'unbound_gre_tunnel' connections.
    :attr int mtu: (optional) GRE tunnel MTU.  This field only applies to network
          type 'gre_tunnel' and 'unbound_gre_tunnel' connections.
    :attr str network_account_id: (optional) The ID of the account which owns the
          connected network. Generally only used if the network is in a different IBM
          Cloud account than the gateway.
    :attr List[TransitGatewayConnectionPrefixFilterReference] prefix_filters:
          (optional) Array of prefix route filters for a transit gateway connection. This
          is order dependent with those first in the array being applied first, and those
          at the end of the array is applied last, or just before the default.
    :attr str prefix_filters_default: Default setting of permit or deny which
          applies to any routes that don't match a specified filter.
    :attr int remote_bgp_asn: (optional) Remote network BGP ASN.  This field only
          applies to network type 'gre_tunnel' and 'unbound_gre_tunnel' connections.
    :attr str remote_gateway_ip: (optional) Remote gateway IP address.  This field
          only applies to network type 'gre_tunnel' and 'unbound_gre_tunnel' connections.
    :attr str remote_tunnel_ip: (optional) Remote tunnel IP address.  This field
          only applies to network type 'gre_tunnel' and 'unbound_gre_tunnel' connections.
    :attr str request_status: (optional) Only visible for cross account connections,
          this field represents the status of a connection request between IBM Cloud
          accounts. The list of enumerated values for this property may expand in the
          future. Code and processes using this field must tolerate unexpected values.
    :attr str status: (optional) Connection's current configuration state. The list
          of enumerated values for this property may expand in the future. Code and
          processes using this field must tolerate unexpected values.
    :attr datetime updated_at: (optional) The date and time that this connection was
          last updated.
    :attr TransitGatewayConnectionCustZone zone: (optional) Location of GRE tunnel.
          This field only applies to network type 'gre_tunnel' and 'unbound_gre_tunnel'
          connections.
    """

    def __init__(self,
                 name: str,
                 network_type: str,
                 id: str,
                 created_at: datetime,
                 prefix_filters_default: str,
                 *,
                 base_network_type: str = None,
                 network_id: str = None,
                 base_connection_id: str = None,
                 local_bgp_asn: int = None,
                 local_gateway_ip: str = None,
                 local_tunnel_ip: str = None,
                 mtu: int = None,
                 network_account_id: str = None,
                 prefix_filters: List['TransitGatewayConnectionPrefixFilterReference'] = None,
                 remote_bgp_asn: int = None,
                 remote_gateway_ip: str = None,
                 remote_tunnel_ip: str = None,
                 request_status: str = None,
                 status: str = None,
                 updated_at: datetime = None,
                 zone: 'TransitGatewayConnectionCustZone' = None) -> None:
        """
        Initialize a TransitGatewayConnectionCust object.

        :param str name: The user-defined name for this transit gateway connection.
        :param str network_type: Defines what type of network is connected via this
               connection. The list of enumerated values for this property may expand in
               the future. Code and processes using this field must tolerate unexpected
               values.
        :param str id: The unique identifier for this Transit Gateway Connection.
        :param datetime created_at: The date and time that this connection was
               created.
        :param str prefix_filters_default: Default setting of permit or deny which
               applies to any routes that don't match a specified filter.
        :param str base_network_type: (optional) The type of network the GRE tunnel
               is targeting.
        :param str network_id: (optional) The ID of the network being connected via
               this connection. This field is required for some types, such as 'vpc',
               'power_virtual_server' and 'directlink'. For network types
               'vpc','power_virtual_server' and 'directlink' this is the CRN of the VPC /
               PowerVS / Direct Link gateway respectively.
        :param str base_connection_id: (optional) network_type 'gre_tunnel'
               connections use 'base_connection_id' to specify the ID of a network_type
               'classic' connection the tunnel is configured over. The specified
               connection must reside in the same transit gateway and be in an active
               state. The 'classic' connection cannot be deleted until any 'gre_tunnel'
               connections using it are deleted. This field only applies to and is
               required for network type 'gre_tunnel' connections.
        :param int local_bgp_asn: (optional) Local network BGP ASN.  This field
               only applies to network type 'gre_tunnel' and 'unbound_gre_tunnel'
               connections.
        :param str local_gateway_ip: (optional) Local gateway IP address.  This
               field only applies to network type 'gre_tunnel' and 'unbound_gre_tunnel'
               connections.
        :param str local_tunnel_ip: (optional) Local tunnel IP address.  This field
               only applies to network type 'gre_tunnel' and 'unbound_gre_tunnel'
               connections.
        :param int mtu: (optional) GRE tunnel MTU.  This field only applies to
               network type 'gre_tunnel' and 'unbound_gre_tunnel' connections.
        :param str network_account_id: (optional) The ID of the account which owns
               the connected network. Generally only used if the network is in a different
               IBM Cloud account than the gateway.
        :param List[TransitGatewayConnectionPrefixFilterReference] prefix_filters:
               (optional) Array of prefix route filters for a transit gateway connection.
               This is order dependent with those first in the array being applied first,
               and those at the end of the array is applied last, or just before the
               default.
        :param int remote_bgp_asn: (optional) Remote network BGP ASN.  This field
               only applies to network type 'gre_tunnel' and 'unbound_gre_tunnel'
               connections.
        :param str remote_gateway_ip: (optional) Remote gateway IP address.  This
               field only applies to network type 'gre_tunnel' and 'unbound_gre_tunnel'
               connections.
        :param str remote_tunnel_ip: (optional) Remote tunnel IP address.  This
               field only applies to network type 'gre_tunnel' and 'unbound_gre_tunnel'
               connections.
        :param str request_status: (optional) Only visible for cross account
               connections, this field represents the status of a connection request
               between IBM Cloud accounts. The list of enumerated values for this property
               may expand in the future. Code and processes using this field must tolerate
               unexpected values.
        :param str status: (optional) Connection's current configuration state. The
               list of enumerated values for this property may expand in the future. Code
               and processes using this field must tolerate unexpected values.
        :param datetime updated_at: (optional) The date and time that this
               connection was last updated.
        :param TransitGatewayConnectionCustZone zone: (optional) Location of GRE
               tunnel.  This field only applies to network type 'gre_tunnel' and
               'unbound_gre_tunnel' connections.
        """
        self.base_network_type = base_network_type
        self.name = name
        self.network_id = network_id
        self.network_type = network_type
        self.id = id
        self.base_connection_id = base_connection_id
        self.created_at = created_at
        self.local_bgp_asn = local_bgp_asn
        self.local_gateway_ip = local_gateway_ip
        self.local_tunnel_ip = local_tunnel_ip
        self.mtu = mtu
        self.network_account_id = network_account_id
        self.prefix_filters = prefix_filters
        self.prefix_filters_default = prefix_filters_default
        self.remote_bgp_asn = remote_bgp_asn
        self.remote_gateway_ip = remote_gateway_ip
        self.remote_tunnel_ip = remote_tunnel_ip
        self.request_status = request_status
        self.status = status
        self.updated_at = updated_at
        self.zone = zone

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayConnectionCust':
        """Initialize a TransitGatewayConnectionCust object from a json dictionary."""
        args = {}
        if 'base_network_type' in _dict:
            args['base_network_type'] = _dict.get('base_network_type')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError(
                'Required property \'name\' not present in TransitGatewayConnectionCust JSON')
        if 'network_id' in _dict:
            args['network_id'] = _dict.get('network_id')
        if 'network_type' in _dict:
            args['network_type'] = _dict.get('network_type')
        else:
            raise ValueError(
                'Required property \'network_type\' not present in TransitGatewayConnectionCust JSON')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError(
                'Required property \'id\' not present in TransitGatewayConnectionCust JSON')
        if 'base_connection_id' in _dict:
            args['base_connection_id'] = _dict.get('base_connection_id')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError(
                'Required property \'created_at\' not present in TransitGatewayConnectionCust JSON')
        if 'local_bgp_asn' in _dict:
            args['local_bgp_asn'] = _dict.get('local_bgp_asn')
        if 'local_gateway_ip' in _dict:
            args['local_gateway_ip'] = _dict.get('local_gateway_ip')
        if 'local_tunnel_ip' in _dict:
            args['local_tunnel_ip'] = _dict.get('local_tunnel_ip')
        if 'mtu' in _dict:
            args['mtu'] = _dict.get('mtu')
        if 'network_account_id' in _dict:
            args['network_account_id'] = _dict.get('network_account_id')
        if 'prefix_filters' in _dict:
            args['prefix_filters'] = [TransitGatewayConnectionPrefixFilterReference.from_dict(
                x) for x in _dict.get('prefix_filters')]
        if 'prefix_filters_default' in _dict:
            args['prefix_filters_default'] = _dict.get(
                'prefix_filters_default')
        else:
            raise ValueError(
                'Required property \'prefix_filters_default\' not present in TransitGatewayConnectionCust JSON')
        if 'remote_bgp_asn' in _dict:
            args['remote_bgp_asn'] = _dict.get('remote_bgp_asn')
        if 'remote_gateway_ip' in _dict:
            args['remote_gateway_ip'] = _dict.get('remote_gateway_ip')
        if 'remote_tunnel_ip' in _dict:
            args['remote_tunnel_ip'] = _dict.get('remote_tunnel_ip')
        if 'request_status' in _dict:
            args['request_status'] = _dict.get('request_status')
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        if 'zone' in _dict:
            args['zone'] = TransitGatewayConnectionCustZone.from_dict(
                _dict.get('zone'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayConnectionCust object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'base_network_type') and self.base_network_type is not None:
            _dict['base_network_type'] = self.base_network_type
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'network_id') and self.network_id is not None:
            _dict['network_id'] = self.network_id
        if hasattr(self, 'network_type') and self.network_type is not None:
            _dict['network_type'] = self.network_type
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'base_connection_id') and self.base_connection_id is not None:
            _dict['base_connection_id'] = self.base_connection_id
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'local_bgp_asn') and self.local_bgp_asn is not None:
            _dict['local_bgp_asn'] = self.local_bgp_asn
        if hasattr(self, 'local_gateway_ip') and self.local_gateway_ip is not None:
            _dict['local_gateway_ip'] = self.local_gateway_ip
        if hasattr(self, 'local_tunnel_ip') and self.local_tunnel_ip is not None:
            _dict['local_tunnel_ip'] = self.local_tunnel_ip
        if hasattr(self, 'mtu') and self.mtu is not None:
            _dict['mtu'] = self.mtu
        if hasattr(self, 'network_account_id') and self.network_account_id is not None:
            _dict['network_account_id'] = self.network_account_id
        if hasattr(self, 'prefix_filters') and self.prefix_filters is not None:
            _dict['prefix_filters'] = [x.to_dict()
                                       for x in self.prefix_filters]
        if hasattr(self, 'prefix_filters_default') and self.prefix_filters_default is not None:
            _dict['prefix_filters_default'] = self.prefix_filters_default
        if hasattr(self, 'remote_bgp_asn') and self.remote_bgp_asn is not None:
            _dict['remote_bgp_asn'] = self.remote_bgp_asn
        if hasattr(self, 'remote_gateway_ip') and self.remote_gateway_ip is not None:
            _dict['remote_gateway_ip'] = self.remote_gateway_ip
        if hasattr(self, 'remote_tunnel_ip') and self.remote_tunnel_ip is not None:
            _dict['remote_tunnel_ip'] = self.remote_tunnel_ip
        if hasattr(self, 'request_status') and self.request_status is not None:
            _dict['request_status'] = self.request_status
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'zone') and self.zone is not None:
            _dict['zone'] = self.zone.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayConnectionCust object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayConnectionCust') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayConnectionCust') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class BaseNetworkTypeEnum(str, Enum):
        """
        The type of network the GRE tunnel is targeting.
        """
        CLASSIC = 'classic'

    class NetworkTypeEnum(str, Enum):
        """
        Defines what type of network is connected via this connection. The list of
        enumerated values for this property may expand in the future. Code and processes
        using this field must tolerate unexpected values.
        """
        CLASSIC = 'classic'
        DIRECTLINK = 'directlink'
        GRE_TUNNEL = 'gre_tunnel'
        UNBOUND_GRE_TUNNEL = 'unbound_gre_tunnel'
        VPC = 'vpc'
        POWER_VIRTUAL_SERVER = 'power_virtual_server'

    class PrefixFiltersDefaultEnum(str, Enum):
        """
        Default setting of permit or deny which applies to any routes that don't match a
        specified filter.
        """
        PERMIT = 'permit'
        DENY = 'deny'

    class RequestStatusEnum(str, Enum):
        """
        Only visible for cross account connections, this field represents the status of a
        connection request between IBM Cloud accounts. The list of enumerated values for
        this property may expand in the future. Code and processes using this field must
        tolerate unexpected values.
        """
        PENDING = 'pending'
        APPROVED = 'approved'
        REJECTED = 'rejected'
        EXPIRED = 'expired'
        DETACHED = 'detached'

    class StatusEnum(str, Enum):
        """
        Connection's current configuration state. The list of enumerated values for this
        property may expand in the future. Code and processes using this field must
        tolerate unexpected values.
        """
        ATTACHED = 'attached'
        FAILED = 'failed'
        PENDING = 'pending'
        DELETING = 'deleting'
        DETACHING = 'detaching'
        DETACHED = 'detached'
        SUSPENDING = 'suspending'
        SUSPENDED = 'suspended'


class TransitGatewayConnectionCustZone():
    """
    Location of GRE tunnel.  This field only applies to network type 'gre_tunnel' and
    'unbound_gre_tunnel' connections.

    :attr str name: Availability zone name.
    """

    def __init__(self,
                 name: str) -> None:
        """
        Initialize a TransitGatewayConnectionCustZone object.

        :param str name: Availability zone name.
        """
        self.name = name

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayConnectionCustZone':
        """Initialize a TransitGatewayConnectionCustZone object from a json dictionary."""
        args = {}
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError(
                'Required property \'name\' not present in TransitGatewayConnectionCustZone JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayConnectionCustZone object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayConnectionCustZone object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayConnectionCustZone') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayConnectionCustZone') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class TransitGatewayConnectionPrefixFilter():
    """
    A prefix filter for a Transit Gateway connection.

    :attr str action: Whether to permit or deny prefix filter.
    :attr int ge: (optional) IP Prefix GE.
    :attr int le: (optional) IP Prefix LE.
    :attr str prefix: IP Prefix.
    """

    def __init__(self,
                 action: str,
                 prefix: str,
                 *,
                 ge: int = None,
                 le: int = None) -> None:
        """
        Initialize a TransitGatewayConnectionPrefixFilter object.

        :param str action: Whether to permit or deny prefix filter.
        :param str prefix: IP Prefix.
        :param int ge: (optional) IP Prefix GE.
        :param int le: (optional) IP Prefix LE.
        """
        self.action = action
        self.ge = ge
        self.le = le
        self.prefix = prefix

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayConnectionPrefixFilter':
        """Initialize a TransitGatewayConnectionPrefixFilter object from a json dictionary."""
        args = {}
        if 'action' in _dict:
            args['action'] = _dict.get('action')
        else:
            raise ValueError(
                'Required property \'action\' not present in TransitGatewayConnectionPrefixFilter JSON')
        if 'ge' in _dict:
            args['ge'] = _dict.get('ge')
        if 'le' in _dict:
            args['le'] = _dict.get('le')
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        else:
            raise ValueError(
                'Required property \'prefix\' not present in TransitGatewayConnectionPrefixFilter JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayConnectionPrefixFilter object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'action') and self.action is not None:
            _dict['action'] = self.action
        if hasattr(self, 'ge') and self.ge is not None:
            _dict['ge'] = self.ge
        if hasattr(self, 'le') and self.le is not None:
            _dict['le'] = self.le
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayConnectionPrefixFilter object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayConnectionPrefixFilter') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayConnectionPrefixFilter') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class ActionEnum(str, Enum):
        """
        Whether to permit or deny prefix filter.
        """
        PERMIT = 'permit'
        DENY = 'deny'


class TransitGatewayConnectionPrefixFilterReference():
    """
    A prefix filter reference object for a Transit Gateway connection.

    :attr str action: Whether to permit or deny prefix filter.
    :attr str before: (optional) Identifier of prefix filter that handles the
          ordering and follow semantics:
          - When a filter reference another filter in it's before field, then the filter
          making the reference is applied before
            the referenced filter. For example: if filter A references filter B in its
          before field, A is applied before B.
          - When a new filter is added that has the same before as an existing filter,
          then the older filter will have its before
            field updated to point to the new filter. Starting with the above example: if
          filter C is added and it references B in its
            before field, then A's before field should be modified to point to C, so the
          order of application would be A, C and finally B.
          - A filter that has an empty before reference will be applied last (though the
          date order mentioned above will still apply).
            So continuing the above examples, if filter B has an empty before field, then
          it will be applied last, but if filter D
            is created with an empty before field, then B's before field will be modified
          to point to D, so B will be applied before D.
    :attr datetime created_at: The date and time that this prefix filter was
          created.
    :attr int ge: (optional) IP Prefix GE.
    :attr str id: Prefix Filter identifier.
    :attr int le: (optional) IP Prefix LE.
    :attr str prefix: IP Prefix.
    :attr datetime updated_at: (optional) The date and time that this prefix filter
          was last updated.
    """

    def __init__(self,
                 action: str,
                 created_at: datetime,
                 id: str,
                 prefix: str,
                 *,
                 before: str = None,
                 ge: int = None,
                 le: int = None,
                 updated_at: datetime = None) -> None:
        """
        Initialize a TransitGatewayConnectionPrefixFilterReference object.

        :param str action: Whether to permit or deny prefix filter.
        :param datetime created_at: The date and time that this prefix filter was
               created.
        :param str id: Prefix Filter identifier.
        :param str prefix: IP Prefix.
        :param str before: (optional) Identifier of prefix filter that handles the
               ordering and follow semantics:
               - When a filter reference another filter in it's before field, then the
               filter making the reference is applied before
                 the referenced filter. For example: if filter A references filter B in
               its before field, A is applied before B.
               - When a new filter is added that has the same before as an existing
               filter, then the older filter will have its before
                 field updated to point to the new filter. Starting with the above
               example: if filter C is added and it references B in its
                 before field, then A's before field should be modified to point to C, so
               the order of application would be A, C and finally B.
               - A filter that has an empty before reference will be applied last (though
               the date order mentioned above will still apply).
                 So continuing the above examples, if filter B has an empty before field,
               then it will be applied last, but if filter D
                 is created with an empty before field, then B's before field will be
               modified to point to D, so B will be applied before D.
        :param int ge: (optional) IP Prefix GE.
        :param int le: (optional) IP Prefix LE.
        :param datetime updated_at: (optional) The date and time that this prefix
               filter was last updated.
        """
        self.action = action
        self.before = before
        self.created_at = created_at
        self.ge = ge
        self.id = id
        self.le = le
        self.prefix = prefix
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayConnectionPrefixFilterReference':
        """Initialize a TransitGatewayConnectionPrefixFilterReference object from a json dictionary."""
        args = {}
        if 'action' in _dict:
            args['action'] = _dict.get('action')
        else:
            raise ValueError(
                'Required property \'action\' not present in TransitGatewayConnectionPrefixFilterReference JSON')
        if 'before' in _dict:
            args['before'] = _dict.get('before')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError(
                'Required property \'created_at\' not present in TransitGatewayConnectionPrefixFilterReference JSON')
        if 'ge' in _dict:
            args['ge'] = _dict.get('ge')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError(
                'Required property \'id\' not present in TransitGatewayConnectionPrefixFilterReference JSON')
        if 'le' in _dict:
            args['le'] = _dict.get('le')
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        else:
            raise ValueError(
                'Required property \'prefix\' not present in TransitGatewayConnectionPrefixFilterReference JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayConnectionPrefixFilterReference object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'action') and self.action is not None:
            _dict['action'] = self.action
        if hasattr(self, 'before') and self.before is not None:
            _dict['before'] = self.before
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'ge') and self.ge is not None:
            _dict['ge'] = self.ge
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'le') and self.le is not None:
            _dict['le'] = self.le
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayConnectionPrefixFilterReference object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayConnectionPrefixFilterReference') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayConnectionPrefixFilterReference') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class ActionEnum(str, Enum):
        """
        Whether to permit or deny prefix filter.
        """
        PERMIT = 'permit'
        DENY = 'deny'


class TransitGatewayReference():
    """
    Transit gateway reference.

    :attr str crn: gateway CRN.
    :attr str id: gateway ID.
    :attr str name: transit gateway name.
    """

    def __init__(self,
                 crn: str,
                 id: str,
                 name: str) -> None:
        """
        Initialize a TransitGatewayReference object.

        :param str crn: gateway CRN.
        :param str id: gateway ID.
        :param str name: transit gateway name.
        """
        self.crn = crn
        self.id = id
        self.name = name

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayReference':
        """Initialize a TransitGatewayReference object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError(
                'Required property \'crn\' not present in TransitGatewayReference JSON')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError(
                'Required property \'id\' not present in TransitGatewayReference JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError(
                'Required property \'name\' not present in TransitGatewayReference JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayReference object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayReference object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayReference') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayReference') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class ZoneIdentity():
    """
    ZoneIdentity.

    """

    def __init__(self) -> None:
        """
        Initialize a ZoneIdentity object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
            ", ".join(['ZoneIdentityByName']))
        raise Exception(msg)


class ZoneReference():
    """
    Availability zone reference.

    :attr str name: Availability zone name.
    """

    def __init__(self,
                 name: str) -> None:
        """
        Initialize a ZoneReference object.

        :param str name: Availability zone name.
        """
        self.name = name

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ZoneReference':
        """Initialize a ZoneReference object from a json dictionary."""
        args = {}
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError(
                'Required property \'name\' not present in ZoneReference JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ZoneReference object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ZoneReference object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ZoneReference') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ZoneReference') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class ZoneIdentityByName(ZoneIdentity):
    """
    Availability zone.

    :attr str name: (optional) Availability zone name.
    """

    def __init__(self,
                 *,
                 name: str = None) -> None:
        """
        Initialize a ZoneIdentityByName object.

        :param str name: (optional) Availability zone name.
        """
        # pylint: disable=super-init-not-called
        self.name = name

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ZoneIdentityByName':
        """Initialize a ZoneIdentityByName object from a json dictionary."""
        args = {}
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ZoneIdentityByName object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ZoneIdentityByName object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ZoneIdentityByName') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ZoneIdentityByName') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other
