"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerlessKubernetesCluster = exports.ServerlessKubernetesClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cs_generated_1 = require("./cs.generated");
Object.defineProperty(exports, "ServerlessKubernetesClusterProperty", { enumerable: true, get: function () { return cs_generated_1.RosServerlessKubernetesCluster; } });
/**
 * A ROS resource type:  `ALIYUN::CS::ServerlessKubernetesCluster`
 */
class ServerlessKubernetesCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::CS::ServerlessKubernetesCluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosServerlessKubernetesCluster = new cs_generated_1.RosServerlessKubernetesCluster(this, id, {
            kubernetesVersion: props.kubernetesVersion,
            endpointPublicAccess: props.endpointPublicAccess,
            zoneId: props.zoneId,
            vSwitchIds: props.vSwitchIds,
            securityGroupId: props.securityGroupId,
            vSwitchId: props.vSwitchId,
            addons: props.addons,
            natGateway: props.natGateway ? props.natGateway : false,
            name: props.name,
            vpcId: props.vpcId,
            serviceCidr: props.serviceCidr ? props.serviceCidr : '172.19.0.0/20',
            tags: props.tags,
            privateZone: props.privateZone,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosServerlessKubernetesCluster;
        this.attrClusterId = rosServerlessKubernetesCluster.attrClusterId;
        this.attrTaskId = rosServerlessKubernetesCluster.attrTaskId;
        this.attrWorkerRamRoleName = rosServerlessKubernetesCluster.attrWorkerRamRoleName;
    }
}
exports.ServerlessKubernetesCluster = ServerlessKubernetesCluster;
//# sourceMappingURL=data:application/json;base64,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