# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-04-14 11:57
from django.db import migrations


def forwards(apps, schema_editor):
    """Create email settings for previously create plans if they don't have"""
    TestPlan = apps.get_model('testplans', 'TestPlan')
    TestPlanEmailSettings = apps.get_model(
        'testplans', 'TestPlanEmailSettings')

    for plan in TestPlan.objects.all().only('pk'):
        if not TestPlanEmailSettings.objects.filter(plan=plan).exists():
            TestPlanEmailSettings.objects.create(plan=plan)


class Migration(migrations.Migration):

    dependencies = [
        ('testplans', '0004_remove_model_TestPlanActivity'),
    ]

    operations = [
        migrations.RunPython(forwards)
    ]
