# -*- coding: utf-8 -*-
#
# nitrate documentation build configuration file, created by
# sphinx-quickstart on Tue Nov 26 22:58:55 2013.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import django
import sys
import os
from datetime import datetime

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(1, os.path.abspath('../../src/'))

os.environ['DJANGO_SETTINGS_MODULE'] = 'tcms.settings.test'
django.setup()

with open('../../VERSION.txt', 'r') as f:
    pkg_version = f.read().strip()

# The short X.Y version.
version = pkg_version
# The full version, including alpha/beta/rc tags.
release = pkg_version

extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'sphinx_rtd_theme',
]

templates_path = ['_templates']
source_suffix = '.rst'
master_doc = 'index'

project = 'Nitrate'
copyright = f'2013 - {datetime.utcnow().year}, Red Hat, Inc.'

exclude_patterns = []
pygments_style = 'sphinx'

html_static_path = ['_static']
htmlhelp_basename = 'nitratedoc'

html_theme = 'sphinx_rtd_theme'
html_logo = '_static/logo.png'
html_favicon = '_static/logo.png'
html_theme_options = {
    'logo_only': True,
}

intersphinx_mapping = {'http://docs.python.org/': None}
