/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as elasticsearch from 'aws-cdk-lib/aws-elasticsearch';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as cognito from 'aws-cdk-lib/aws-cognito';
import { Construct } from 'constructs';
import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
/**
 * @summary The properties for the CognitoToApiGatewayToLambda Construct
 */
export interface LambdaToElasticSearchAndKibanaProps {
    /**
     * Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * User provided props to override the default props for the Lambda function.
     *
     * @default - Default props are used
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Optional user provided props to override the default props for the Elasticsearch Service.
     *
     * @default - Default props are used
     */
    readonly esDomainProps?: elasticsearch.CfnDomainProps;
    /**
     * Cognito & ES Domain Name.
     *
     * @default - None
     */
    readonly domainName: string;
    /**
     * Optional Cognito Domain Name, if provided it will be used for Cognito Domain, and domainName will be used for the Elasticsearch Domain.
     *
     * @default - None
     */
    readonly cognitoDomainName?: string;
    /**
     * Whether to create recommended CloudWatch alarms.
     *
     * @default - Alarms are created
     */
    readonly createCloudWatchAlarms?: boolean;
    /**
     * Optional Name for the ElasticSearch domain endpoint environment variable set for the Lambda function.
     *
     * @default - None
     */
    readonly domainEndpointEnvironmentVariableName?: string;
}
export declare class LambdaToElasticSearchAndKibana extends Construct {
    readonly userPool: cognito.UserPool;
    readonly identityPool: cognito.CfnIdentityPool;
    readonly userPoolClient: cognito.UserPoolClient;
    readonly elasticsearchDomain: elasticsearch.CfnDomain;
    readonly elasticsearchRole: iam.Role;
    readonly lambdaFunction: lambda.Function;
    readonly cloudwatchAlarms?: cloudwatch.Alarm[];
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the CognitoToApiGatewayToLambda class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: LambdaToElasticSearchAndKibanaProps);
}
