# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['rich_cli']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0.0,<9.0.0',
 'requests>=2.0.0,<3.0.0',
 'rich-rst>=1.1.7,<2.0.0',
 'rich>=12.0.0,<13.0.0',
 'textual>=0.1.15,<0.2.0']

entry_points = \
{'console_scripts': ['rich = rich_cli.__main__:run'],
 'pipx.run': ['rich-cli = rich_cli.__main__:run']}

setup_kwargs = {
    'name': 'rich-cli',
    'version': '1.6.0',
    'description': 'Command Line Interface to Rich',
    'long_description': '# Rich CLI\n\nRich-cli is a command line toolbox for fancy output in the terminal, built with [Rich](https://github.com/Textualize/rich).\n\nUse the `rich` command to highlight a variety of file types in the terminal, with specialized rendering for Markdown and JSON files. Additionally you can markup and format text from the command line.\n\n![splash image](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/rich-cli-splash.jpg)\n\n## Installation\n\nThere are a few options for installing Rich-CLI.\n\n### Windows / Linux\n\nYou can install Rich-CLI with [pipx](https://pypa.github.io/pipx/).\n\n```\npipx install rich-cli\n```\n\n### MacOS\n\nYou can install Rich-CLI with [Homebew](https://brew.sh/).\n\n```\nbrew tap textualize/rich\nbrew install rich\n```\n\n### Universal\n\nRich-CLI may be installed as a Python package.\n\nℹ️ It is reccomended to create a *virtual environment* first, to avoid any dependency conflicts.\n\n```\npython -m pip install rich-cli\n```\n\n## Rich command\n\nOnce installed you should have the `rich` command in your path. Run the following to see usage / help:\n\n```\nrich --help\n```\n\n## Syntax highlighting\n\nTo syntax highlight a file enter `rich` followed by a path. Many file formats are supported.\n\n```\nrich loop.py\n```\n\n![syntax1](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/syntax1.png)\n\nAdd the `--line-number` or `-n` switch to enable line numbers. Add `--guides` or `-g` to enable indentation guides.\n\n```\nrich loop.py -n -g\n```\n\n![syntax2](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/syntax2.png)\n\nYou can specify a [theme](https://pygments.org/styles/) with `--theme`.\n\n```\nrich loop.py --theme dracula\n```\n\nYou can set the default theme via the `RICH_THEME` environment variable. So the following is equivalent to the above command:\n\n```\nRICH_THEME=dracula rich loop.py\n```\n\n![syntax3](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/syntax3.png)\n\nBy default, `rich` will wrap lines if they don\'t fit within the available width. You can disable this behavior with `--no-wrap`.\n\n`Rich` will try to deduce the format of the via from the filename. If you want to override the auto-detected _lexer_ you can explicitly set it with the `--lexer` or `-x` switch.\n\n## Markdown\n\nYou can request markdown rendering by adding the `--markdown` switch or `-m`. If the file ends with `.md` markdown will be auto-detected.\n\n```\nrich README.md\n```\n\n![markdown1](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/markdown1.png)\n\nIf your terminal supports hyperlinks, you can add `--hyperlinks` or `-y` which will output hyperlinks rather than full URLs.\n\n```\nrich README.md --hyperlinks\n```\n\n## JSON\n\nYou can request JSON pretty formatting and highlighting with the `--json` or `-j` switches. If the file ends with `.json` then JSON will be auto-detected.\n\n```\nrich cats.json\n```\n\n![json1](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/json1.png)\n\n## CSV\n\nRich can display the contents of a CSV (or TSV) as a table. If the file ends with `.csv` or `.tsv` then CSV will be auto-detected.\n\n```\nrich deniro.csv\n```\n\n![csv1](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/csv1.png)\n\n### Rules\n\nYou can render a horizontal rule with `--rule` or `-u`. Specify a rule style with `--rule-style`. Set the character(s) to render the line with `--rule-char`.\n\n```\nrich "Hello [b]World[/b]!" --rule\nrich "Hello [b]World[/b]!" --rule --rule-style "red"\nrich "Hello [b]World[/b]!" --rule --rule-style "red" --rule-char "="\n```\n\n![syntax1](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/rules1.png)\n\n## Pager\n\nAdd `--pager` to display the content with a built in pager application.\n\nScroll the pager with cursor keys, page up/down, home, end. Alternatively use the scrollbar which will be visible to the right of the terminal.\n\n```\nrich __main__.py -n -g --theme monokai --pager\n```\n\n![pager](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/pager1.png)\n\n## Network\n\nThe `rich` command can read files from the internet you give it a URL starting with `http://` or `https://`.\n\n```\nrich https://raw.githubusercontent.com/Textualize/rich-cli/main/README.md --markdown\n```\n\n![network](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/network1.png)\n\n## Exporting\n\nIn addition to rendering to the console, `rich` can write an HTML file. This works with any command. Add `--export-html` or `-o` followed by the output path.\n\n```\nrich README.md -o readme.html\n```\n\nAfter running this command you should find a "readme.html" in your current working directory.\n\n## Rich Printing\n\nIf you add the `--print` or `--p` option then Rich will treat the first argument as [console markup](https://rich.readthedocs.io/en/latest/markup.html) which allows you to insert styles with a markup similar in design to bbcode.\n\n```\nrich "Hello, [bold magenta]World[/]!" --print\n```\n\n![printing1](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/printing1.png)\n\n### Soft wrapping\n\nRich will word wrap your text by default by inserting newlines where appropriate. If you don\'t want this behavior you can enable _soft_ wrapping with `--soft`.\n\n## Reading from Stdin\n\nWhere `rich` accepts a path, you can enter `-` which reads the content from stdin. You may want this if you are piping output from another process.\n\nNote that when rich isn\'t writing directly to the terminal it will disable ansi color codes, so you may want to add `--force-terminal` or `-F` to tell `rich` you want to keep ansi codes in the output.\n\n```\ncat README.md | rich - --markdown --force-terminal\n```\n\n## General Options\n\nThere are a number of additional switches you may add to modify the content rendered to the terminal. These options are universal and apply to all of the above features.\n\n### Style\n\nYou can set a style to apply to the output with `--style` or `-s`. The styles are specified with [this syntax](https://rich.readthedocs.io/en/latest/style.html).\n\n```\nrich "Hello, [b]World[/b]!" --print --style "on blue"\n```\n\n![style1](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/style1.png)\n\n### Alignment\n\nYou can align output to the left, center, or right with the `--left`, `--center`, or `--right` options, or their single letter counterparts: `-l`, `-c`, or `-r`.\n\n```\nrich "Hello [b]World[/b]!" --print --center\n```\n\n![alignment1](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/alignment1.png)\n\n### Width\n\nYou can set the width of the output with `--width` or `-w` and the desired width. Note that the default behavior is to wrap text.\n\n```\nrich "I must not fear. Fear is the mind-killer. Fear is the little-death that brings total obliteration." -p -w 40\n```\n\n![width](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/width1.png)\n\n### Text Justify\n\nYou can set how `rich` will justify text with `--text-left`, `--text-right`, `--text-center`, and `--text-full`; or the single letter equivalents: `-L`, `-R`, `-C`, and `-F`.\n\nThe difference between `--left` and `--text-left` may not be obvious unless you specify the width of the output. The `--left`, `--center`, and `--right` options will center the block of text within the terminal dimensions. Whereas, the `--text-left`, `--text-center`, and `--text-right` options define how text is rendered _within_ that block.\n\nIn the following examples, we specify a width of 40 (`-w 40`) which is center aligned with the `-c` switch. Note how the `-R`, `-C` and `-F` apply the text justification within the 40 character block:\n\n```\nrich "I must not fear. Fear is the mind-killer. Fear is the little-death that brings total obliteration." -p -w 40 -c -L\nrich "I must not fear. Fear is the mind-killer. Fear is the little-death that brings total obliteration." -p -w 40 -c -R\nrich "I must not fear. Fear is the mind-killer. Fear is the little-death that brings total obliteration." -p -w 40 -c -C\nrich "I must not fear. Fear is the mind-killer. Fear is the little-death that brings total obliteration." -p -w 40 -c -F\n```\n\n### Padding\n\nYou can apply _padding_ around the output with `--padding` or `-d`.\n\n```\nrich "Hello [b]World[/b]!" -p -c --padding 3 --style "on blue"\n```\n\n![padding1](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/padding1.png)\n\n### Panel\n\nYou can draw a _panel_ around content with `--panel` or `-a`, which takes one of a number of [styles](https://rich.readthedocs.io/en/latest/appendix/box.html).\n\n```\nrich "Hello, [b]World[/b]!" -p -a heavy\n```\n\n![panel1](https://raw.githubusercontent.com/Textualize/rich-cli/main/imgs/panel1.png)\n',
    'author': 'Will McGugan',
    'author_email': 'willmcgugan@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Textualize/rich-cli',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
