"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
function base62Encode(int) {
    const characterSet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    if (int === 0)
        return '0';
    let s = '';
    while (int > 0) {
        s = characterSet[int % 62] + s;
        int = Math.floor(int / 62);
    }
    return s;
}
;
function getEnv(name) {
    const value = process.env[name];
    if (!value) {
        throw new Error(`The environment variable ${name} is not defined`);
    }
    return value;
}
const documentClient = new aws_sdk_1.DynamoDB.DocumentClient({ apiVersion: '2012-08-10' });
const s3 = new aws_sdk_1.S3({ apiVersion: '2006-03-01' });
async function handler(event) {
    var _a, _b;
    try {
        console.log('Event: %j', event);
        const body = JSON.parse((_a = event.body) !== null && _a !== void 0 ? _a : '{}');
        if (!body.url) {
            return {
                statusCode: 400,
                body: '',
            };
        }
        // Get next counter value
        const update = await documentClient.update({
            TableName: getEnv('TABLE_NAME'),
            Key: { key: 'counter' },
            UpdateExpression: 'ADD #value :incr',
            ExpressionAttributeNames: { '#value': 'value' },
            ExpressionAttributeValues: { ':incr': 1 },
            ReturnValues: 'UPDATED_NEW',
        }).promise();
        const value = (_b = update.Attributes) === null || _b === void 0 ? void 0 : _b.value;
        if (!value) {
            throw new Error('Cannot get next counter value');
        }
        const key = base62Encode(value);
        console.log('Key: %j', key);
        // Put zero-byte object with redirection on S3
        const putObject = await s3.putObject({
            Bucket: getEnv('BUCKET_NAME'),
            Key: key,
            WebsiteRedirectLocation: body.url,
            ACL: 'public-read',
        }).promise();
        console.log('Put object: %j', putObject);
        // Return short url
        return {
            statusCode: 201,
            body: JSON.stringify({
                url: body.url,
                shortUrl: `https://${getEnv('DOMAIN_NAME')}/${key}`,
            }),
        };
    }
    catch (err) {
        console.log(err);
        return {
            statusCode: 500,
            body: '',
        };
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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