import { Duration } from 'aws-cdk-lib';
import * as apigateway from 'aws-cdk-lib/aws-apigateway';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as route53 from 'aws-cdk-lib/aws-route53';
import { Construct } from 'constructs';
/**
 * Properties for a UrlShortener.
 *
 * @stability stable
 */
export interface UrlShortenerProps {
    /**
     * The hosted zone for the short URLs domain.
     *
     * @stability stable
     */
    readonly hostedZone: route53.IHostedZone;
    /**
     * Expiration for short urls.
     *
     * @default cdk.Duration.days(365)
     * @stability stable
     */
    readonly expiration?: Duration;
    /**
     * An interface VPC endpoint for API gateway.
     *
     * Specifying this property will
     * make the API private.
     *
     * @default - API is public
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-private-apis.html
     * @stability stable
     */
    readonly apiGatewayEndpoint?: ec2.IInterfaceVpcEndpoint;
}
/**
 * URL shortener.
 *
 * @stability stable
 */
export declare class UrlShortener extends Construct {
    /**
     * The endpoint of the URL shortener API.
     *
     * @stability stable
     */
    readonly apiEndpoint: string;
    /**
     * The underlying API Gateway REST API.
     *
     * @stability stable
     */
    readonly api: apigateway.LambdaRestApi;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: UrlShortenerProps);
}
