import { Duration } from 'aws-cdk-lib';
import { Schedule } from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
/**
 * Properties for a ToolkitCleaner.
 *
 * @stability stable
 */
export interface ToolkitCleanerProps {
    /**
     * The schedule for the cleaner.
     *
     * @default - every day
     * @stability stable
     */
    readonly schedule?: Schedule;
    /**
     * Whether to clean on schedule.
     *
     * If you'd like to run the cleanup manually
     * via the console, set to `false`.
     *
     * @default true
     * @stability stable
     */
    readonly scheduleEnabled?: boolean;
    /**
     * Only output number of assets and total size that would be deleted but without actually deleting assets.
     *
     * @stability stable
     */
    readonly dryRun?: boolean;
    /**
     * Retain unused assets that were created recently.
     *
     * @default - all unused assets are removed
     * @stability stable
     */
    readonly retainAssetsNewerThan?: Duration;
}
/**
 * Clean unused S3 and ECR assets from your CDK Toolkit.
 *
 * @stability stable
 */
export declare class ToolkitCleaner extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ToolkitCleanerProps);
}
