"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const ecr = new aws_sdk_1.ECR();
async function handler(assetHashes) {
    var _a;
    if (!process.env.REPOSITORY_NAME) {
        throw new Error('Missing REPOSITORY_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextToken;
    let finished = false;
    while (!finished) {
        const response = await ecr.describeImages({
            repositoryName: process.env.REPOSITORY_NAME,
            nextToken,
        }).promise();
        const toDelete = (_a = response.imageDetails) === null || _a === void 0 ? void 0 : _a.filter(x => {
            let pred = x.imageTags && !assetHashes.includes(x.imageTags[0]);
            if (process.env.RETAIN_MILLISECONDS) {
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && x.imagePushedAt && x.imagePushedAt < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await ecr.batchDeleteImage({
                    repositoryName: process.env.REPOSITORY_NAME,
                    imageIds: toDelete.map(x => ({ imageTag: x.imageTags[0] })),
                }).promise();
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => { var _a; return acc + ((_a = x.imageSizeInBytes) !== null && _a !== void 0 ? _a : 0); }, 0);
        }
        nextToken = response.nextToken;
        if (nextToken === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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