import * as cloudfront from 'aws-cdk-lib/aws-cloudfront';
import * as route53 from 'aws-cdk-lib/aws-route53';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * Properties for a StaticWebsite.
 *
 * @stability stable
 */
export interface StaticWebsiteProps {
    /**
     * The domain name for this static website.
     *
     * @stability stable
     * @example
     *
     * www.my-static-website.com
     */
    readonly domainName: string;
    /**
     * The hosted zone where records should be added.
     *
     * @stability stable
     */
    readonly hostedZone: route53.IHostedZone;
    /**
     * A backend configuration that will be saved as `config.json` in the S3 bucket of the static website.
     *
     * The frontend can query this config by doing `fetch('/config.json')`.
     *
     * @stability stable
     * @example
     *
     * { userPoolId: '1234', apiEndoint: 'https://www.my-api.com/api' }
     */
    readonly backendConfiguration?: any;
    /**
     * A list of domain names that should redirect to `domainName`.
     *
     * @default - the domain name of the hosted zone
     * @stability stable
     */
    readonly redirects?: string[];
    /**
     * Response headers policy for the default behavior.
     *
     * @default - a new policy is created with best practice security headers
     * @stability stable
     */
    readonly responseHeadersPolicy?: cloudfront.ResponseHeadersPolicy;
}
/**
 * A CloudFront static website hosted on S3.
 *
 * @stability stable
 */
export declare class StaticWebsite extends Construct {
    /**
     * Best practice security headers used as default.
     *
     * @stability stable
     */
    static defaultSecurityHeadersBehavior: cloudfront.ResponseSecurityHeadersBehavior;
    /**
     * The CloudFront distribution of this static website.
     *
     * @stability stable
     */
    readonly distribution: cloudfront.Distribution;
    /**
     * The S3 bucket of this static website.
     *
     * @stability stable
     */
    readonly bucket: s3.Bucket;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: StaticWebsiteProps);
}
