"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.startExecution = exports.cfnResponseFailed = exports.cfnResponseSuccess = exports.CREATE_FAILED_PHYSICAL_ID_MARKER = void 0;
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const http_1 = require("./http");
exports.CREATE_FAILED_PHYSICAL_ID_MARKER = 'AWSCDK::StateMachineProvider::CREATE_FAILED';
async function cfnResponseSuccess(event) {
    var _a, _b, _c, _d, _e, _f;
    console.log('Event: %j', event);
    await http_1.respond('SUCCESS', {
        ...event.Input,
        PhysicalResourceId: (_c = (_b = (_a = event.Output) === null || _a === void 0 ? void 0 : _a.PhysicalResourceId) !== null && _b !== void 0 ? _b : event.Input.PhysicalResourceId) !== null && _c !== void 0 ? _c : event.Input.RequestId,
        Data: (_e = (_d = event.Output) === null || _d === void 0 ? void 0 : _d.Data) !== null && _e !== void 0 ? _e : {},
        NoEcho: (_f = event.Output) === null || _f === void 0 ? void 0 : _f.NoEcho,
    });
}
exports.cfnResponseSuccess = cfnResponseSuccess;
async function cfnResponseFailed(event) {
    var _a, _b;
    console.log('Event: %j', event);
    const parsedCause = JSON.parse(event.Cause);
    const executionResult = {
        ...parsedCause,
        Input: JSON.parse(parsedCause.Input),
    };
    console.log('Execution result: %j', executionResult);
    let physicalResourceId = (_b = (_a = executionResult.Output) === null || _a === void 0 ? void 0 : _a.PhysicalResourceId) !== null && _b !== void 0 ? _b : executionResult.Input.PhysicalResourceId;
    if (!physicalResourceId) {
        // special case: if CREATE fails, which usually implies, we usually don't
        // have a physical resource id. in this case, the subsequent DELETE
        // operation does not have any meaning, and will likely fail as well. to
        // address this, we use a marker so the provider framework can simply
        // ignore the subsequent DELETE.
        if (executionResult.Input.RequestType === 'Create') {
            console.log('CREATE failed, responding with a marker physical resource id so that the subsequent DELETE will be ignored');
            physicalResourceId = exports.CREATE_FAILED_PHYSICAL_ID_MARKER;
        }
        else {
            console.log(`ERROR: Malformed event. "PhysicalResourceId" is required: ${JSON.stringify(event)}`);
        }
    }
    await http_1.respond('FAILED', {
        ...executionResult.Input,
        Reason: `${event.Error}: ${event.Cause}`,
        PhysicalResourceId: physicalResourceId,
    });
}
exports.cfnResponseFailed = cfnResponseFailed;
async function startExecution(event) {
    try {
        console.log('Event: %j', event);
        if (!process.env.STATE_MACHINE_ARN) {
            throw new Error('Missing STATE_MACHINE_ARN.');
        }
        // ignore DELETE event when the physical resource ID is the marker that
        // indicates that this DELETE is a subsequent DELETE to a failed CREATE
        // operation.
        if (event.RequestType === 'Delete' && event.PhysicalResourceId === exports.CREATE_FAILED_PHYSICAL_ID_MARKER) {
            console.log('ignoring DELETE event caused by a failed CREATE event');
            await http_1.respond('SUCCESS', event);
            return;
        }
        const stepFunctions = new aws_sdk_1.StepFunctions();
        await stepFunctions.startExecution({
            stateMachineArn: process.env.STATE_MACHINE_ARN,
            input: JSON.stringify(event),
        }).promise();
    }
    catch (err) {
        console.log(err);
        await http_1.respond('FAILED', {
            ...event,
            Reason: err.message,
        });
    }
}
exports.startExecution = startExecution;
//# sourceMappingURL=data:application/json;base64,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