"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.verifyRequestSignature = void 0;
const crypto = require("crypto");
function verifyRequestSignature(options) {
    const fiveMinutesAgo = Math.floor(Date.now() / 1000) - (60 * 5);
    if (options.requestTimestamp < fiveMinutesAgo) {
        console.error('Slack request signing verification outdated');
        return false;
    }
    const hmac = crypto.createHmac('sha256', options.signingSecret);
    const [version, hash] = options.requestSignature.split('=');
    hmac.update(`${version}:${options.requestTimestamp}:${options.body}`);
    const hex = hmac.digest('hex');
    if (hash.length !== hex.length ||
        !crypto.timingSafeEqual(Buffer.from(hash), Buffer.from(hex))) {
        console.error('Slack request signing verification failed');
        return false;
    }
    return true;
}
exports.verifyRequestSignature = verifyRequestSignature;
//# sourceMappingURL=data:application/json;base64,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