"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
async function handler(event) {
    console.log('Event: %j', event);
    const sesNotification = event.Records[0].ses;
    if (!process.env.SOURCE_WHITELIST) {
        console.log('Missing SOURCE_WHITELIST');
        return { disposition: 'STOP_RULE' };
    }
    if (!new RegExp(process.env.SOURCE_WHITELIST).test(sesNotification.mail.source)) {
        console.log(`${sesNotification.mail.source} does not match /${process.env.SOURCE_WHITELIST}/`);
        return { disposition: 'STOP_RULE' };
    }
    return { disposition: 'CONTINUE' };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid2hpdGVsaXN0LmxhbWJkYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9lbWFpbC1yZWNlaXZlci93aGl0ZWxpc3QubGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLCtCQUErQjtBQUN4QixLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQXlCO0lBQ3JELE9BQU8sQ0FBQyxHQUFHLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQyxDQUFDO0lBRWhDLE1BQU0sZUFBZSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDO0lBRTdDLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGdCQUFnQixFQUFFO1FBQ2pDLE9BQU8sQ0FBQyxHQUFHLENBQUMsMEJBQTBCLENBQUMsQ0FBQztRQUN4QyxPQUFPLEVBQUUsV0FBVyxFQUFFLFdBQVcsRUFBRSxDQUFDO0tBQ3JDO0lBRUQsSUFBSSxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUMvRSxPQUFPLENBQUMsR0FBRyxDQUFDLEdBQUcsZUFBZSxDQUFDLElBQUksQ0FBQyxNQUFNLG9CQUFvQixPQUFPLENBQUMsR0FBRyxDQUFDLGdCQUFnQixHQUFHLENBQUMsQ0FBQztRQUMvRixPQUFPLEVBQUUsV0FBVyxFQUFFLFdBQVcsRUFBRSxDQUFDO0tBQ3JDO0lBRUQsT0FBTyxFQUFFLFdBQVcsRUFBRSxVQUFVLEVBQUUsQ0FBQztBQUNyQyxDQUFDO0FBaEJELDBCQWdCQyIsInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludC1kaXNhYmxlIG5vLWNvbnNvbGUgKi9cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBoYW5kbGVyKGV2ZW50OiBBV1NMYW1iZGEuU0VTRXZlbnQpOiBQcm9taXNlPHsgZGlzcG9zaXRpb246IHN0cmluZyB9PiB7XG4gIGNvbnNvbGUubG9nKCdFdmVudDogJWonLCBldmVudCk7XG5cbiAgY29uc3Qgc2VzTm90aWZpY2F0aW9uID0gZXZlbnQuUmVjb3Jkc1swXS5zZXM7XG5cbiAgaWYgKCFwcm9jZXNzLmVudi5TT1VSQ0VfV0hJVEVMSVNUKSB7XG4gICAgY29uc29sZS5sb2coJ01pc3NpbmcgU09VUkNFX1dISVRFTElTVCcpO1xuICAgIHJldHVybiB7IGRpc3Bvc2l0aW9uOiAnU1RPUF9SVUxFJyB9O1xuICB9XG5cbiAgaWYgKCFuZXcgUmVnRXhwKHByb2Nlc3MuZW52LlNPVVJDRV9XSElURUxJU1QpLnRlc3Qoc2VzTm90aWZpY2F0aW9uLm1haWwuc291cmNlKSkge1xuICAgIGNvbnNvbGUubG9nKGAke3Nlc05vdGlmaWNhdGlvbi5tYWlsLnNvdXJjZX0gZG9lcyBub3QgbWF0Y2ggLyR7cHJvY2Vzcy5lbnYuU09VUkNFX1dISVRFTElTVH0vYCk7XG4gICAgcmV0dXJuIHsgZGlzcG9zaXRpb246ICdTVE9QX1JVTEUnIH07XG4gIH1cblxuICByZXR1cm4geyBkaXNwb3NpdGlvbjogJ0NPTlRJTlVFJyB9O1xufVxuIl19