#####################################################################
# mid.py
#
# (c) Copyright 2021, Benjamin Parzella. All rights reserved.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This software is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#####################################################################
"""MID data item."""
from .. import variables
from .base import DataItemBase


class MID(DataItemBase):
    """
    Material ID.

    :Types:
       - :class:`Binary <secsgem.secs.variables.Binary>`
       - :class:`String <secsgem.secs.variables.String>`

    **Used In Function**
        - :class:`SecsS02F27 <secsgem.secs.functions.SecsS02F27>`
        - :class:`SecsS03F02 <secsgem.secs.functions.SecsS03F02>`
        - :class:`SecsS03F04 <secsgem.secs.functions.SecsS03F04>`
        - :class:`SecsS03F07 <secsgem.secs.functions.SecsS03F07>`
        - :class:`SecsS03F09 <secsgem.secs.functions.SecsS03F09>`
        - :class:`SecsS03F12 <secsgem.secs.functions.SecsS03F12>`
        - :class:`SecsS03F13 <secsgem.secs.functions.SecsS03F13>`
        - :class:`SecsS04F01 <secsgem.secs.functions.SecsS04F01>`
        - :class:`SecsS04F03 <secsgem.secs.functions.SecsS04F03>`
        - :class:`SecsS04F05 <secsgem.secs.functions.SecsS04F05>`
        - :class:`SecsS04F07 <secsgem.secs.functions.SecsS04F07>`
        - :class:`SecsS04F09 <secsgem.secs.functions.SecsS04F09>`
        - :class:`SecsS04F11 <secsgem.secs.functions.SecsS04F11>`
        - :class:`SecsS04F13 <secsgem.secs.functions.SecsS04F13>`
        - :class:`SecsS04F15 <secsgem.secs.functions.SecsS04F15>`
        - :class:`SecsS04F17 <secsgem.secs.functions.SecsS04F17>`
        - :class:`SecsS07F07 <secsgem.secs.functions.SecsS07F07>`
        - :class:`SecsS07F08 <secsgem.secs.functions.SecsS07F08>`
        - :class:`SecsS07F10 <secsgem.secs.functions.SecsS07F10>`
        - :class:`SecsS07F11 <secsgem.secs.functions.SecsS07F11>`
        - :class:`SecsS07F13 <secsgem.secs.functions.SecsS07F13>`
        - :class:`SecsS07F35 <secsgem.secs.functions.SecsS07F35>`
        - :class:`SecsS07F36 <secsgem.secs.functions.SecsS07F36>`
        - :class:`SecsS12F01 <secsgem.secs.functions.SecsS12F01>`
        - :class:`SecsS12F03 <secsgem.secs.functions.SecsS12F03>`
        - :class:`SecsS12F04 <secsgem.secs.functions.SecsS12F04>`
        - :class:`SecsS12F05 <secsgem.secs.functions.SecsS12F05>`
        - :class:`SecsS12F07 <secsgem.secs.functions.SecsS12F07>`
        - :class:`SecsS12F09 <secsgem.secs.functions.SecsS12F09>`
        - :class:`SecsS12F11 <secsgem.secs.functions.SecsS12F11>`
        - :class:`SecsS12F13 <secsgem.secs.functions.SecsS12F13>`
        - :class:`SecsS12F14 <secsgem.secs.functions.SecsS12F14>`
        - :class:`SecsS12F15 <secsgem.secs.functions.SecsS12F15>`
        - :class:`SecsS12F16 <secsgem.secs.functions.SecsS12F16>`
        - :class:`SecsS12F17 <secsgem.secs.functions.SecsS12F17>`
        - :class:`SecsS12F18 <secsgem.secs.functions.SecsS12F18>`
        - :class:`SecsS16F11 <secsgem.secs.functions.SecsS16F11>`
        - :class:`SecsS16F13 <secsgem.secs.functions.SecsS16F13>`
        - :class:`SecsS16F15 <secsgem.secs.functions.SecsS16F15>`
        - :class:`SecsS18F10 <secsgem.secs.functions.SecsS18F10>`
        - :class:`SecsS18F11 <secsgem.secs.functions.SecsS18F11>`

    """

    __type__ = variables.Dynamic
    __allowedtypes__ = [variables.String, variables.Binary]
    __count__ = 80
