# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class UpdateIndicatorReputationData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'investigation_id': 'str',
        'do_not_whitelist': 'bool',
        'entry_id': 'str',
        'manual_score': 'bool',
        'reason': 'str',
        'reputation': 'int',
        'reputations': 'list[str]',
        'value': 'str'
    }

    attribute_map = {
        'investigation_id': 'InvestigationId',
        'do_not_whitelist': 'doNotWhitelist',
        'entry_id': 'entryId',
        'manual_score': 'manualScore',
        'reason': 'reason',
        'reputation': 'reputation',
        'reputations': 'reputations',
        'value': 'value'
    }

    def __init__(self, investigation_id=None, do_not_whitelist=None, entry_id=None, manual_score=None, reason=None, reputation=None, reputations=None, value=None):  # noqa: E501
        """UpdateIndicatorReputationData - a model defined in Swagger"""  # noqa: E501

        self._investigation_id = None
        self._do_not_whitelist = None
        self._entry_id = None
        self._manual_score = None
        self._reason = None
        self._reputation = None
        self._reputations = None
        self._value = None
        self.discriminator = None

        if investigation_id is not None:
            self.investigation_id = investigation_id
        if do_not_whitelist is not None:
            self.do_not_whitelist = do_not_whitelist
        if entry_id is not None:
            self.entry_id = entry_id
        if manual_score is not None:
            self.manual_score = manual_score
        if reason is not None:
            self.reason = reason
        if reputation is not None:
            self.reputation = reputation
        if reputations is not None:
            self.reputations = reputations
        if value is not None:
            self.value = value

    @property
    def investigation_id(self):
        """Gets the investigation_id of this UpdateIndicatorReputationData.  # noqa: E501


        :return: The investigation_id of this UpdateIndicatorReputationData.  # noqa: E501
        :rtype: str
        """
        return self._investigation_id

    @investigation_id.setter
    def investigation_id(self, investigation_id):
        """Sets the investigation_id of this UpdateIndicatorReputationData.


        :param investigation_id: The investigation_id of this UpdateIndicatorReputationData.  # noqa: E501
        :type: str
        """

        self._investigation_id = investigation_id

    @property
    def do_not_whitelist(self):
        """Gets the do_not_whitelist of this UpdateIndicatorReputationData.  # noqa: E501


        :return: The do_not_whitelist of this UpdateIndicatorReputationData.  # noqa: E501
        :rtype: bool
        """
        return self._do_not_whitelist

    @do_not_whitelist.setter
    def do_not_whitelist(self, do_not_whitelist):
        """Sets the do_not_whitelist of this UpdateIndicatorReputationData.


        :param do_not_whitelist: The do_not_whitelist of this UpdateIndicatorReputationData.  # noqa: E501
        :type: bool
        """

        self._do_not_whitelist = do_not_whitelist

    @property
    def entry_id(self):
        """Gets the entry_id of this UpdateIndicatorReputationData.  # noqa: E501


        :return: The entry_id of this UpdateIndicatorReputationData.  # noqa: E501
        :rtype: str
        """
        return self._entry_id

    @entry_id.setter
    def entry_id(self, entry_id):
        """Sets the entry_id of this UpdateIndicatorReputationData.


        :param entry_id: The entry_id of this UpdateIndicatorReputationData.  # noqa: E501
        :type: str
        """

        self._entry_id = entry_id

    @property
    def manual_score(self):
        """Gets the manual_score of this UpdateIndicatorReputationData.  # noqa: E501


        :return: The manual_score of this UpdateIndicatorReputationData.  # noqa: E501
        :rtype: bool
        """
        return self._manual_score

    @manual_score.setter
    def manual_score(self, manual_score):
        """Sets the manual_score of this UpdateIndicatorReputationData.


        :param manual_score: The manual_score of this UpdateIndicatorReputationData.  # noqa: E501
        :type: bool
        """

        self._manual_score = manual_score

    @property
    def reason(self):
        """Gets the reason of this UpdateIndicatorReputationData.  # noqa: E501


        :return: The reason of this UpdateIndicatorReputationData.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this UpdateIndicatorReputationData.


        :param reason: The reason of this UpdateIndicatorReputationData.  # noqa: E501
        :type: str
        """

        self._reason = reason

    @property
    def reputation(self):
        """Gets the reputation of this UpdateIndicatorReputationData.  # noqa: E501


        :return: The reputation of this UpdateIndicatorReputationData.  # noqa: E501
        :rtype: int
        """
        return self._reputation

    @reputation.setter
    def reputation(self, reputation):
        """Sets the reputation of this UpdateIndicatorReputationData.


        :param reputation: The reputation of this UpdateIndicatorReputationData.  # noqa: E501
        :type: int
        """

        self._reputation = reputation

    @property
    def reputations(self):
        """Gets the reputations of this UpdateIndicatorReputationData.  # noqa: E501


        :return: The reputations of this UpdateIndicatorReputationData.  # noqa: E501
        :rtype: list[str]
        """
        return self._reputations

    @reputations.setter
    def reputations(self, reputations):
        """Sets the reputations of this UpdateIndicatorReputationData.


        :param reputations: The reputations of this UpdateIndicatorReputationData.  # noqa: E501
        :type: list[str]
        """

        self._reputations = reputations

    @property
    def value(self):
        """Gets the value of this UpdateIndicatorReputationData.  # noqa: E501


        :return: The value of this UpdateIndicatorReputationData.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this UpdateIndicatorReputationData.


        :param value: The value of this UpdateIndicatorReputationData.  # noqa: E501
        :type: str
        """

        self._value = value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UpdateIndicatorReputationData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateIndicatorReputationData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
