# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class NotifyTimings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'complete_after_replies': 'int',
        'retries_count': 'int',
        'retries_interval': 'int'
    }

    attribute_map = {
        'complete_after_replies': 'completeAfterReplies',
        'retries_count': 'retriesCount',
        'retries_interval': 'retriesInterval'
    }

    def __init__(self, complete_after_replies=None, retries_count=None, retries_interval=None):  # noqa: E501
        """NotifyTimings - a model defined in Swagger"""  # noqa: E501

        self._complete_after_replies = None
        self._retries_count = None
        self._retries_interval = None
        self.discriminator = None

        if complete_after_replies is not None:
            self.complete_after_replies = complete_after_replies
        if retries_count is not None:
            self.retries_count = retries_count
        if retries_interval is not None:
            self.retries_interval = retries_interval

    @property
    def complete_after_replies(self):
        """Gets the complete_after_replies of this NotifyTimings.  # noqa: E501


        :return: The complete_after_replies of this NotifyTimings.  # noqa: E501
        :rtype: int
        """
        return self._complete_after_replies

    @complete_after_replies.setter
    def complete_after_replies(self, complete_after_replies):
        """Sets the complete_after_replies of this NotifyTimings.


        :param complete_after_replies: The complete_after_replies of this NotifyTimings.  # noqa: E501
        :type: int
        """

        self._complete_after_replies = complete_after_replies

    @property
    def retries_count(self):
        """Gets the retries_count of this NotifyTimings.  # noqa: E501


        :return: The retries_count of this NotifyTimings.  # noqa: E501
        :rtype: int
        """
        return self._retries_count

    @retries_count.setter
    def retries_count(self, retries_count):
        """Sets the retries_count of this NotifyTimings.


        :param retries_count: The retries_count of this NotifyTimings.  # noqa: E501
        :type: int
        """

        self._retries_count = retries_count

    @property
    def retries_interval(self):
        """Gets the retries_interval of this NotifyTimings.  # noqa: E501


        :return: The retries_interval of this NotifyTimings.  # noqa: E501
        :rtype: int
        """
        return self._retries_interval

    @retries_interval.setter
    def retries_interval(self, retries_interval):
        """Sets the retries_interval of this NotifyTimings.


        :param retries_interval: The retries_interval of this NotifyTimings.  # noqa: E501
        :type: int
        """

        self._retries_interval = retries_interval

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NotifyTimings, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NotifyTimings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
