# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.advance_arg import AdvanceArg  # noqa: F401,E501
from demisto_client.demisto_api.models.notify_timings import NotifyTimings  # noqa: F401,E501


class NotifiableItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bcc': 'AdvanceArg',
        'body': 'AdvanceArg',
        'cc': 'AdvanceArg',
        'default_option': 'str',
        'format': 'str',
        'methods': 'list[str]',
        'reply_options': 'list[str]',
        'subject': 'AdvanceArg',
        'timings': 'NotifyTimings',
        'to': 'AdvanceArg'
    }

    attribute_map = {
        'bcc': 'bcc',
        'body': 'body',
        'cc': 'cc',
        'default_option': 'defaultOption',
        'format': 'format',
        'methods': 'methods',
        'reply_options': 'replyOptions',
        'subject': 'subject',
        'timings': 'timings',
        'to': 'to'
    }

    def __init__(self, bcc=None, body=None, cc=None, default_option=None, format=None, methods=None, reply_options=None, subject=None, timings=None, to=None):  # noqa: E501
        """NotifiableItem - a model defined in Swagger"""  # noqa: E501

        self._bcc = None
        self._body = None
        self._cc = None
        self._default_option = None
        self._format = None
        self._methods = None
        self._reply_options = None
        self._subject = None
        self._timings = None
        self._to = None
        self.discriminator = None

        if bcc is not None:
            self.bcc = bcc
        if body is not None:
            self.body = body
        if cc is not None:
            self.cc = cc
        if default_option is not None:
            self.default_option = default_option
        if format is not None:
            self.format = format
        if methods is not None:
            self.methods = methods
        if reply_options is not None:
            self.reply_options = reply_options
        if subject is not None:
            self.subject = subject
        if timings is not None:
            self.timings = timings
        if to is not None:
            self.to = to

    @property
    def bcc(self):
        """Gets the bcc of this NotifiableItem.  # noqa: E501


        :return: The bcc of this NotifiableItem.  # noqa: E501
        :rtype: AdvanceArg
        """
        return self._bcc

    @bcc.setter
    def bcc(self, bcc):
        """Sets the bcc of this NotifiableItem.


        :param bcc: The bcc of this NotifiableItem.  # noqa: E501
        :type: AdvanceArg
        """

        self._bcc = bcc

    @property
    def body(self):
        """Gets the body of this NotifiableItem.  # noqa: E501


        :return: The body of this NotifiableItem.  # noqa: E501
        :rtype: AdvanceArg
        """
        return self._body

    @body.setter
    def body(self, body):
        """Sets the body of this NotifiableItem.


        :param body: The body of this NotifiableItem.  # noqa: E501
        :type: AdvanceArg
        """

        self._body = body

    @property
    def cc(self):
        """Gets the cc of this NotifiableItem.  # noqa: E501


        :return: The cc of this NotifiableItem.  # noqa: E501
        :rtype: AdvanceArg
        """
        return self._cc

    @cc.setter
    def cc(self, cc):
        """Sets the cc of this NotifiableItem.


        :param cc: The cc of this NotifiableItem.  # noqa: E501
        :type: AdvanceArg
        """

        self._cc = cc

    @property
    def default_option(self):
        """Gets the default_option of this NotifiableItem.  # noqa: E501


        :return: The default_option of this NotifiableItem.  # noqa: E501
        :rtype: str
        """
        return self._default_option

    @default_option.setter
    def default_option(self, default_option):
        """Sets the default_option of this NotifiableItem.


        :param default_option: The default_option of this NotifiableItem.  # noqa: E501
        :type: str
        """

        self._default_option = default_option

    @property
    def format(self):
        """Gets the format of this NotifiableItem.  # noqa: E501


        :return: The format of this NotifiableItem.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this NotifiableItem.


        :param format: The format of this NotifiableItem.  # noqa: E501
        :type: str
        """

        self._format = format

    @property
    def methods(self):
        """Gets the methods of this NotifiableItem.  # noqa: E501


        :return: The methods of this NotifiableItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._methods

    @methods.setter
    def methods(self, methods):
        """Sets the methods of this NotifiableItem.


        :param methods: The methods of this NotifiableItem.  # noqa: E501
        :type: list[str]
        """

        self._methods = methods

    @property
    def reply_options(self):
        """Gets the reply_options of this NotifiableItem.  # noqa: E501


        :return: The reply_options of this NotifiableItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._reply_options

    @reply_options.setter
    def reply_options(self, reply_options):
        """Sets the reply_options of this NotifiableItem.


        :param reply_options: The reply_options of this NotifiableItem.  # noqa: E501
        :type: list[str]
        """

        self._reply_options = reply_options

    @property
    def subject(self):
        """Gets the subject of this NotifiableItem.  # noqa: E501


        :return: The subject of this NotifiableItem.  # noqa: E501
        :rtype: AdvanceArg
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this NotifiableItem.


        :param subject: The subject of this NotifiableItem.  # noqa: E501
        :type: AdvanceArg
        """

        self._subject = subject

    @property
    def timings(self):
        """Gets the timings of this NotifiableItem.  # noqa: E501


        :return: The timings of this NotifiableItem.  # noqa: E501
        :rtype: NotifyTimings
        """
        return self._timings

    @timings.setter
    def timings(self, timings):
        """Sets the timings of this NotifiableItem.


        :param timings: The timings of this NotifiableItem.  # noqa: E501
        :type: NotifyTimings
        """

        self._timings = timings

    @property
    def to(self):
        """Gets the to of this NotifiableItem.  # noqa: E501


        :return: The to of this NotifiableItem.  # noqa: E501
        :rtype: AdvanceArg
        """
        return self._to

    @to.setter
    def to(self, to):
        """Sets the to of this NotifiableItem.


        :param to: The to of this NotifiableItem.  # noqa: E501
        :type: AdvanceArg
        """

        self._to = to

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NotifiableItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NotifiableItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
