# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.command import Command  # noqa: F401,E501
from demisto_client.demisto_api.models.script_sub_type import ScriptSubType  # noqa: F401,E501
from demisto_client.demisto_api.models.script_type import ScriptType  # noqa: F401,E501


class IntegrationScript(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'commands': 'list[Command]',
        'docker_image': 'str',
        'feed': 'bool',
        'is_fetch': 'bool',
        'is_fetch_credentials': 'bool',
        'long_running': 'bool',
        'long_running_port_mapping': 'bool',
        'run_once': 'bool',
        'script': 'str',
        'subtype': 'ScriptSubType',
        'type': 'ScriptType'
    }

    attribute_map = {
        'commands': 'commands',
        'docker_image': 'dockerImage',
        'feed': 'feed',
        'is_fetch': 'isFetch',
        'is_fetch_credentials': 'isFetchCredentials',
        'long_running': 'longRunning',
        'long_running_port_mapping': 'longRunningPortMapping',
        'run_once': 'runOnce',
        'script': 'script',
        'subtype': 'subtype',
        'type': 'type'
    }

    def __init__(self, commands=None, docker_image=None, feed=None, is_fetch=None, is_fetch_credentials=None, long_running=None, long_running_port_mapping=None, run_once=None, script=None, subtype=None, type=None):  # noqa: E501
        """IntegrationScript - a model defined in Swagger"""  # noqa: E501

        self._commands = None
        self._docker_image = None
        self._feed = None
        self._is_fetch = None
        self._is_fetch_credentials = None
        self._long_running = None
        self._long_running_port_mapping = None
        self._run_once = None
        self._script = None
        self._subtype = None
        self._type = None
        self.discriminator = None

        if commands is not None:
            self.commands = commands
        if docker_image is not None:
            self.docker_image = docker_image
        if feed is not None:
            self.feed = feed
        if is_fetch is not None:
            self.is_fetch = is_fetch
        if is_fetch_credentials is not None:
            self.is_fetch_credentials = is_fetch_credentials
        if long_running is not None:
            self.long_running = long_running
        if long_running_port_mapping is not None:
            self.long_running_port_mapping = long_running_port_mapping
        if run_once is not None:
            self.run_once = run_once
        if script is not None:
            self.script = script
        if subtype is not None:
            self.subtype = subtype
        if type is not None:
            self.type = type

    @property
    def commands(self):
        """Gets the commands of this IntegrationScript.  # noqa: E501


        :return: The commands of this IntegrationScript.  # noqa: E501
        :rtype: list[Command]
        """
        return self._commands

    @commands.setter
    def commands(self, commands):
        """Sets the commands of this IntegrationScript.


        :param commands: The commands of this IntegrationScript.  # noqa: E501
        :type: list[Command]
        """

        self._commands = commands

    @property
    def docker_image(self):
        """Gets the docker_image of this IntegrationScript.  # noqa: E501


        :return: The docker_image of this IntegrationScript.  # noqa: E501
        :rtype: str
        """
        return self._docker_image

    @docker_image.setter
    def docker_image(self, docker_image):
        """Sets the docker_image of this IntegrationScript.


        :param docker_image: The docker_image of this IntegrationScript.  # noqa: E501
        :type: str
        """

        self._docker_image = docker_image

    @property
    def feed(self):
        """Gets the feed of this IntegrationScript.  # noqa: E501


        :return: The feed of this IntegrationScript.  # noqa: E501
        :rtype: bool
        """
        return self._feed

    @feed.setter
    def feed(self, feed):
        """Sets the feed of this IntegrationScript.


        :param feed: The feed of this IntegrationScript.  # noqa: E501
        :type: bool
        """

        self._feed = feed

    @property
    def is_fetch(self):
        """Gets the is_fetch of this IntegrationScript.  # noqa: E501


        :return: The is_fetch of this IntegrationScript.  # noqa: E501
        :rtype: bool
        """
        return self._is_fetch

    @is_fetch.setter
    def is_fetch(self, is_fetch):
        """Sets the is_fetch of this IntegrationScript.


        :param is_fetch: The is_fetch of this IntegrationScript.  # noqa: E501
        :type: bool
        """

        self._is_fetch = is_fetch

    @property
    def is_fetch_credentials(self):
        """Gets the is_fetch_credentials of this IntegrationScript.  # noqa: E501


        :return: The is_fetch_credentials of this IntegrationScript.  # noqa: E501
        :rtype: bool
        """
        return self._is_fetch_credentials

    @is_fetch_credentials.setter
    def is_fetch_credentials(self, is_fetch_credentials):
        """Sets the is_fetch_credentials of this IntegrationScript.


        :param is_fetch_credentials: The is_fetch_credentials of this IntegrationScript.  # noqa: E501
        :type: bool
        """

        self._is_fetch_credentials = is_fetch_credentials

    @property
    def long_running(self):
        """Gets the long_running of this IntegrationScript.  # noqa: E501


        :return: The long_running of this IntegrationScript.  # noqa: E501
        :rtype: bool
        """
        return self._long_running

    @long_running.setter
    def long_running(self, long_running):
        """Sets the long_running of this IntegrationScript.


        :param long_running: The long_running of this IntegrationScript.  # noqa: E501
        :type: bool
        """

        self._long_running = long_running

    @property
    def long_running_port_mapping(self):
        """Gets the long_running_port_mapping of this IntegrationScript.  # noqa: E501


        :return: The long_running_port_mapping of this IntegrationScript.  # noqa: E501
        :rtype: bool
        """
        return self._long_running_port_mapping

    @long_running_port_mapping.setter
    def long_running_port_mapping(self, long_running_port_mapping):
        """Sets the long_running_port_mapping of this IntegrationScript.


        :param long_running_port_mapping: The long_running_port_mapping of this IntegrationScript.  # noqa: E501
        :type: bool
        """

        self._long_running_port_mapping = long_running_port_mapping

    @property
    def run_once(self):
        """Gets the run_once of this IntegrationScript.  # noqa: E501


        :return: The run_once of this IntegrationScript.  # noqa: E501
        :rtype: bool
        """
        return self._run_once

    @run_once.setter
    def run_once(self, run_once):
        """Sets the run_once of this IntegrationScript.


        :param run_once: The run_once of this IntegrationScript.  # noqa: E501
        :type: bool
        """

        self._run_once = run_once

    @property
    def script(self):
        """Gets the script of this IntegrationScript.  # noqa: E501


        :return: The script of this IntegrationScript.  # noqa: E501
        :rtype: str
        """
        return self._script

    @script.setter
    def script(self, script):
        """Sets the script of this IntegrationScript.


        :param script: The script of this IntegrationScript.  # noqa: E501
        :type: str
        """

        self._script = script

    @property
    def subtype(self):
        """Gets the subtype of this IntegrationScript.  # noqa: E501


        :return: The subtype of this IntegrationScript.  # noqa: E501
        :rtype: ScriptSubType
        """
        return self._subtype

    @subtype.setter
    def subtype(self, subtype):
        """Sets the subtype of this IntegrationScript.


        :param subtype: The subtype of this IntegrationScript.  # noqa: E501
        :type: ScriptSubType
        """

        self._subtype = subtype

    @property
    def type(self):
        """Gets the type of this IntegrationScript.  # noqa: E501


        :return: The type of this IntegrationScript.  # noqa: E501
        :rtype: ScriptType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this IntegrationScript.


        :param type: The type of this IntegrationScript.  # noqa: E501
        :type: ScriptType
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(IntegrationScript, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IntegrationScript):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
