# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.feed_indicators import FeedIndicators  # noqa: F401,E501
from demisto_client.demisto_api.models.incidents import Incidents  # noqa: F401,E501
from demisto_client.demisto_api.models.mapper import Mapper  # noqa: F401,E501
from demisto_client.demisto_api.models.version import Version  # noqa: F401,E501


class InstanceClassifier(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'brand_name': 'str',
        'commit_message': 'str',
        'custom': 'bool',
        'default_incident_type': 'str',
        'feed': 'bool',
        'from_server_version': 'Version',
        'id': 'str',
        'incident_samples': 'Incidents',
        'indicator_samples': 'FeedIndicators',
        'instance_id': 'str',
        'instance_name': 'str',
        'is_default': 'bool',
        'item_version': 'Version',
        'key_type_map': 'dict(str, str)',
        'mapping': 'dict(str, Mapper)',
        'modified': 'datetime',
        'pack_id': 'str',
        'primary_term': 'int',
        'propagation_labels': 'list[str]',
        'sequence_number': 'int',
        'should_commit': 'bool',
        'sort_values': 'list[str]',
        'version': 'int'
    }

    attribute_map = {
        'brand_name': 'brandName',
        'commit_message': 'commitMessage',
        'custom': 'custom',
        'default_incident_type': 'defaultIncidentType',
        'feed': 'feed',
        'from_server_version': 'fromServerVersion',
        'id': 'id',
        'incident_samples': 'incidentSamples',
        'indicator_samples': 'indicatorSamples',
        'instance_id': 'instanceId',
        'instance_name': 'instanceName',
        'is_default': 'isDefault',
        'item_version': 'itemVersion',
        'key_type_map': 'keyTypeMap',
        'mapping': 'mapping',
        'modified': 'modified',
        'pack_id': 'packID',
        'primary_term': 'primaryTerm',
        'propagation_labels': 'propagationLabels',
        'sequence_number': 'sequenceNumber',
        'should_commit': 'shouldCommit',
        'sort_values': 'sortValues',
        'version': 'version'
    }

    def __init__(self, brand_name=None, commit_message=None, custom=None, default_incident_type=None, feed=None, from_server_version=None, id=None, incident_samples=None, indicator_samples=None, instance_id=None, instance_name=None, is_default=None, item_version=None, key_type_map=None, mapping=None, modified=None, pack_id=None, primary_term=None, propagation_labels=None, sequence_number=None, should_commit=None, sort_values=None, version=None):  # noqa: E501
        """InstanceClassifier - a model defined in Swagger"""  # noqa: E501

        self._brand_name = None
        self._commit_message = None
        self._custom = None
        self._default_incident_type = None
        self._feed = None
        self._from_server_version = None
        self._id = None
        self._incident_samples = None
        self._indicator_samples = None
        self._instance_id = None
        self._instance_name = None
        self._is_default = None
        self._item_version = None
        self._key_type_map = None
        self._mapping = None
        self._modified = None
        self._pack_id = None
        self._primary_term = None
        self._propagation_labels = None
        self._sequence_number = None
        self._should_commit = None
        self._sort_values = None
        self._version = None
        self.discriminator = None

        if brand_name is not None:
            self.brand_name = brand_name
        if commit_message is not None:
            self.commit_message = commit_message
        if custom is not None:
            self.custom = custom
        if default_incident_type is not None:
            self.default_incident_type = default_incident_type
        if feed is not None:
            self.feed = feed
        if from_server_version is not None:
            self.from_server_version = from_server_version
        if id is not None:
            self.id = id
        if incident_samples is not None:
            self.incident_samples = incident_samples
        if indicator_samples is not None:
            self.indicator_samples = indicator_samples
        if instance_id is not None:
            self.instance_id = instance_id
        if instance_name is not None:
            self.instance_name = instance_name
        if is_default is not None:
            self.is_default = is_default
        if item_version is not None:
            self.item_version = item_version
        if key_type_map is not None:
            self.key_type_map = key_type_map
        if mapping is not None:
            self.mapping = mapping
        if modified is not None:
            self.modified = modified
        if pack_id is not None:
            self.pack_id = pack_id
        if primary_term is not None:
            self.primary_term = primary_term
        if propagation_labels is not None:
            self.propagation_labels = propagation_labels
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if should_commit is not None:
            self.should_commit = should_commit
        if sort_values is not None:
            self.sort_values = sort_values
        if version is not None:
            self.version = version

    @property
    def brand_name(self):
        """Gets the brand_name of this InstanceClassifier.  # noqa: E501


        :return: The brand_name of this InstanceClassifier.  # noqa: E501
        :rtype: str
        """
        return self._brand_name

    @brand_name.setter
    def brand_name(self, brand_name):
        """Sets the brand_name of this InstanceClassifier.


        :param brand_name: The brand_name of this InstanceClassifier.  # noqa: E501
        :type: str
        """

        self._brand_name = brand_name

    @property
    def commit_message(self):
        """Gets the commit_message of this InstanceClassifier.  # noqa: E501


        :return: The commit_message of this InstanceClassifier.  # noqa: E501
        :rtype: str
        """
        return self._commit_message

    @commit_message.setter
    def commit_message(self, commit_message):
        """Sets the commit_message of this InstanceClassifier.


        :param commit_message: The commit_message of this InstanceClassifier.  # noqa: E501
        :type: str
        """

        self._commit_message = commit_message

    @property
    def custom(self):
        """Gets the custom of this InstanceClassifier.  # noqa: E501


        :return: The custom of this InstanceClassifier.  # noqa: E501
        :rtype: bool
        """
        return self._custom

    @custom.setter
    def custom(self, custom):
        """Sets the custom of this InstanceClassifier.


        :param custom: The custom of this InstanceClassifier.  # noqa: E501
        :type: bool
        """

        self._custom = custom

    @property
    def default_incident_type(self):
        """Gets the default_incident_type of this InstanceClassifier.  # noqa: E501


        :return: The default_incident_type of this InstanceClassifier.  # noqa: E501
        :rtype: str
        """
        return self._default_incident_type

    @default_incident_type.setter
    def default_incident_type(self, default_incident_type):
        """Sets the default_incident_type of this InstanceClassifier.


        :param default_incident_type: The default_incident_type of this InstanceClassifier.  # noqa: E501
        :type: str
        """

        self._default_incident_type = default_incident_type

    @property
    def feed(self):
        """Gets the feed of this InstanceClassifier.  # noqa: E501


        :return: The feed of this InstanceClassifier.  # noqa: E501
        :rtype: bool
        """
        return self._feed

    @feed.setter
    def feed(self, feed):
        """Sets the feed of this InstanceClassifier.


        :param feed: The feed of this InstanceClassifier.  # noqa: E501
        :type: bool
        """

        self._feed = feed

    @property
    def from_server_version(self):
        """Gets the from_server_version of this InstanceClassifier.  # noqa: E501


        :return: The from_server_version of this InstanceClassifier.  # noqa: E501
        :rtype: Version
        """
        return self._from_server_version

    @from_server_version.setter
    def from_server_version(self, from_server_version):
        """Sets the from_server_version of this InstanceClassifier.


        :param from_server_version: The from_server_version of this InstanceClassifier.  # noqa: E501
        :type: Version
        """

        self._from_server_version = from_server_version

    @property
    def id(self):
        """Gets the id of this InstanceClassifier.  # noqa: E501


        :return: The id of this InstanceClassifier.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this InstanceClassifier.


        :param id: The id of this InstanceClassifier.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def incident_samples(self):
        """Gets the incident_samples of this InstanceClassifier.  # noqa: E501


        :return: The incident_samples of this InstanceClassifier.  # noqa: E501
        :rtype: Incidents
        """
        return self._incident_samples

    @incident_samples.setter
    def incident_samples(self, incident_samples):
        """Sets the incident_samples of this InstanceClassifier.


        :param incident_samples: The incident_samples of this InstanceClassifier.  # noqa: E501
        :type: Incidents
        """

        self._incident_samples = incident_samples

    @property
    def indicator_samples(self):
        """Gets the indicator_samples of this InstanceClassifier.  # noqa: E501


        :return: The indicator_samples of this InstanceClassifier.  # noqa: E501
        :rtype: FeedIndicators
        """
        return self._indicator_samples

    @indicator_samples.setter
    def indicator_samples(self, indicator_samples):
        """Sets the indicator_samples of this InstanceClassifier.


        :param indicator_samples: The indicator_samples of this InstanceClassifier.  # noqa: E501
        :type: FeedIndicators
        """

        self._indicator_samples = indicator_samples

    @property
    def instance_id(self):
        """Gets the instance_id of this InstanceClassifier.  # noqa: E501


        :return: The instance_id of this InstanceClassifier.  # noqa: E501
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """Sets the instance_id of this InstanceClassifier.


        :param instance_id: The instance_id of this InstanceClassifier.  # noqa: E501
        :type: str
        """

        self._instance_id = instance_id

    @property
    def instance_name(self):
        """Gets the instance_name of this InstanceClassifier.  # noqa: E501


        :return: The instance_name of this InstanceClassifier.  # noqa: E501
        :rtype: str
        """
        return self._instance_name

    @instance_name.setter
    def instance_name(self, instance_name):
        """Sets the instance_name of this InstanceClassifier.


        :param instance_name: The instance_name of this InstanceClassifier.  # noqa: E501
        :type: str
        """

        self._instance_name = instance_name

    @property
    def is_default(self):
        """Gets the is_default of this InstanceClassifier.  # noqa: E501


        :return: The is_default of this InstanceClassifier.  # noqa: E501
        :rtype: bool
        """
        return self._is_default

    @is_default.setter
    def is_default(self, is_default):
        """Sets the is_default of this InstanceClassifier.


        :param is_default: The is_default of this InstanceClassifier.  # noqa: E501
        :type: bool
        """

        self._is_default = is_default

    @property
    def item_version(self):
        """Gets the item_version of this InstanceClassifier.  # noqa: E501


        :return: The item_version of this InstanceClassifier.  # noqa: E501
        :rtype: Version
        """
        return self._item_version

    @item_version.setter
    def item_version(self, item_version):
        """Sets the item_version of this InstanceClassifier.


        :param item_version: The item_version of this InstanceClassifier.  # noqa: E501
        :type: Version
        """

        self._item_version = item_version

    @property
    def key_type_map(self):
        """Gets the key_type_map of this InstanceClassifier.  # noqa: E501


        :return: The key_type_map of this InstanceClassifier.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._key_type_map

    @key_type_map.setter
    def key_type_map(self, key_type_map):
        """Sets the key_type_map of this InstanceClassifier.


        :param key_type_map: The key_type_map of this InstanceClassifier.  # noqa: E501
        :type: dict(str, str)
        """

        self._key_type_map = key_type_map

    @property
    def mapping(self):
        """Gets the mapping of this InstanceClassifier.  # noqa: E501


        :return: The mapping of this InstanceClassifier.  # noqa: E501
        :rtype: dict(str, Mapper)
        """
        return self._mapping

    @mapping.setter
    def mapping(self, mapping):
        """Sets the mapping of this InstanceClassifier.


        :param mapping: The mapping of this InstanceClassifier.  # noqa: E501
        :type: dict(str, Mapper)
        """

        self._mapping = mapping

    @property
    def modified(self):
        """Gets the modified of this InstanceClassifier.  # noqa: E501


        :return: The modified of this InstanceClassifier.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this InstanceClassifier.


        :param modified: The modified of this InstanceClassifier.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def pack_id(self):
        """Gets the pack_id of this InstanceClassifier.  # noqa: E501


        :return: The pack_id of this InstanceClassifier.  # noqa: E501
        :rtype: str
        """
        return self._pack_id

    @pack_id.setter
    def pack_id(self, pack_id):
        """Sets the pack_id of this InstanceClassifier.


        :param pack_id: The pack_id of this InstanceClassifier.  # noqa: E501
        :type: str
        """

        self._pack_id = pack_id

    @property
    def primary_term(self):
        """Gets the primary_term of this InstanceClassifier.  # noqa: E501


        :return: The primary_term of this InstanceClassifier.  # noqa: E501
        :rtype: int
        """
        return self._primary_term

    @primary_term.setter
    def primary_term(self, primary_term):
        """Sets the primary_term of this InstanceClassifier.


        :param primary_term: The primary_term of this InstanceClassifier.  # noqa: E501
        :type: int
        """

        self._primary_term = primary_term

    @property
    def propagation_labels(self):
        """Gets the propagation_labels of this InstanceClassifier.  # noqa: E501


        :return: The propagation_labels of this InstanceClassifier.  # noqa: E501
        :rtype: list[str]
        """
        return self._propagation_labels

    @propagation_labels.setter
    def propagation_labels(self, propagation_labels):
        """Sets the propagation_labels of this InstanceClassifier.


        :param propagation_labels: The propagation_labels of this InstanceClassifier.  # noqa: E501
        :type: list[str]
        """

        self._propagation_labels = propagation_labels

    @property
    def sequence_number(self):
        """Gets the sequence_number of this InstanceClassifier.  # noqa: E501


        :return: The sequence_number of this InstanceClassifier.  # noqa: E501
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this InstanceClassifier.


        :param sequence_number: The sequence_number of this InstanceClassifier.  # noqa: E501
        :type: int
        """

        self._sequence_number = sequence_number

    @property
    def should_commit(self):
        """Gets the should_commit of this InstanceClassifier.  # noqa: E501


        :return: The should_commit of this InstanceClassifier.  # noqa: E501
        :rtype: bool
        """
        return self._should_commit

    @should_commit.setter
    def should_commit(self, should_commit):
        """Sets the should_commit of this InstanceClassifier.


        :param should_commit: The should_commit of this InstanceClassifier.  # noqa: E501
        :type: bool
        """

        self._should_commit = should_commit

    @property
    def sort_values(self):
        """Gets the sort_values of this InstanceClassifier.  # noqa: E501


        :return: The sort_values of this InstanceClassifier.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this InstanceClassifier.


        :param sort_values: The sort_values of this InstanceClassifier.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def version(self):
        """Gets the version of this InstanceClassifier.  # noqa: E501


        :return: The version of this InstanceClassifier.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this InstanceClassifier.


        :param version: The version of this InstanceClassifier.  # noqa: E501
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InstanceClassifier, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InstanceClassifier):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
