# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.indicator_filter import IndicatorFilter  # noqa: F401,E501


class GenericIndicatorUpdateBatch(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'all': 'bool',
        'columns': 'list[str]',
        'do_not_whitelist': 'bool',
        'filter': 'IndicatorFilter',
        'ids': 'list[str]',
        'reason': 'str',
        'reputations': 'list[str]'
    }

    attribute_map = {
        'all': 'all',
        'columns': 'columns',
        'do_not_whitelist': 'doNotWhitelist',
        'filter': 'filter',
        'ids': 'ids',
        'reason': 'reason',
        'reputations': 'reputations'
    }

    def __init__(self, all=None, columns=None, do_not_whitelist=None, filter=None, ids=None, reason=None, reputations=None):  # noqa: E501
        """GenericIndicatorUpdateBatch - a model defined in Swagger"""  # noqa: E501

        self._all = None
        self._columns = None
        self._do_not_whitelist = None
        self._filter = None
        self._ids = None
        self._reason = None
        self._reputations = None
        self.discriminator = None

        if all is not None:
            self.all = all
        if columns is not None:
            self.columns = columns
        if do_not_whitelist is not None:
            self.do_not_whitelist = do_not_whitelist
        if filter is not None:
            self.filter = filter
        if ids is not None:
            self.ids = ids
        if reason is not None:
            self.reason = reason
        if reputations is not None:
            self.reputations = reputations

    @property
    def all(self):
        """Gets the all of this GenericIndicatorUpdateBatch.  # noqa: E501


        :return: The all of this GenericIndicatorUpdateBatch.  # noqa: E501
        :rtype: bool
        """
        return self._all

    @all.setter
    def all(self, all):
        """Sets the all of this GenericIndicatorUpdateBatch.


        :param all: The all of this GenericIndicatorUpdateBatch.  # noqa: E501
        :type: bool
        """

        self._all = all

    @property
    def columns(self):
        """Gets the columns of this GenericIndicatorUpdateBatch.  # noqa: E501


        :return: The columns of this GenericIndicatorUpdateBatch.  # noqa: E501
        :rtype: list[str]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """Sets the columns of this GenericIndicatorUpdateBatch.


        :param columns: The columns of this GenericIndicatorUpdateBatch.  # noqa: E501
        :type: list[str]
        """

        self._columns = columns

    @property
    def do_not_whitelist(self):
        """Gets the do_not_whitelist of this GenericIndicatorUpdateBatch.  # noqa: E501


        :return: The do_not_whitelist of this GenericIndicatorUpdateBatch.  # noqa: E501
        :rtype: bool
        """
        return self._do_not_whitelist

    @do_not_whitelist.setter
    def do_not_whitelist(self, do_not_whitelist):
        """Sets the do_not_whitelist of this GenericIndicatorUpdateBatch.


        :param do_not_whitelist: The do_not_whitelist of this GenericIndicatorUpdateBatch.  # noqa: E501
        :type: bool
        """

        self._do_not_whitelist = do_not_whitelist

    @property
    def filter(self):
        """Gets the filter of this GenericIndicatorUpdateBatch.  # noqa: E501


        :return: The filter of this GenericIndicatorUpdateBatch.  # noqa: E501
        :rtype: IndicatorFilter
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """Sets the filter of this GenericIndicatorUpdateBatch.


        :param filter: The filter of this GenericIndicatorUpdateBatch.  # noqa: E501
        :type: IndicatorFilter
        """

        self._filter = filter

    @property
    def ids(self):
        """Gets the ids of this GenericIndicatorUpdateBatch.  # noqa: E501


        :return: The ids of this GenericIndicatorUpdateBatch.  # noqa: E501
        :rtype: list[str]
        """
        return self._ids

    @ids.setter
    def ids(self, ids):
        """Sets the ids of this GenericIndicatorUpdateBatch.


        :param ids: The ids of this GenericIndicatorUpdateBatch.  # noqa: E501
        :type: list[str]
        """

        self._ids = ids

    @property
    def reason(self):
        """Gets the reason of this GenericIndicatorUpdateBatch.  # noqa: E501


        :return: The reason of this GenericIndicatorUpdateBatch.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this GenericIndicatorUpdateBatch.


        :param reason: The reason of this GenericIndicatorUpdateBatch.  # noqa: E501
        :type: str
        """

        self._reason = reason

    @property
    def reputations(self):
        """Gets the reputations of this GenericIndicatorUpdateBatch.  # noqa: E501


        :return: The reputations of this GenericIndicatorUpdateBatch.  # noqa: E501
        :rtype: list[str]
        """
        return self._reputations

    @reputations.setter
    def reputations(self, reputations):
        """Sets the reputations of this GenericIndicatorUpdateBatch.


        :param reputations: The reputations of this GenericIndicatorUpdateBatch.  # noqa: E501
        :type: list[str]
        """

        self._reputations = reputations

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GenericIndicatorUpdateBatch, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GenericIndicatorUpdateBatch):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
