# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.question import Question  # noqa: F401,E501


class DataCollectionForm(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'expired': 'bool',
        'questions': 'list[Question]',
        'sender': 'str',
        'title': 'str',
        'total_answers': 'int'
    }

    attribute_map = {
        'description': 'description',
        'expired': 'expired',
        'questions': 'questions',
        'sender': 'sender',
        'title': 'title',
        'total_answers': 'totalAnswers'
    }

    def __init__(self, description=None, expired=None, questions=None, sender=None, title=None, total_answers=None):  # noqa: E501
        """DataCollectionForm - a model defined in Swagger"""  # noqa: E501

        self._description = None
        self._expired = None
        self._questions = None
        self._sender = None
        self._title = None
        self._total_answers = None
        self.discriminator = None

        if description is not None:
            self.description = description
        if expired is not None:
            self.expired = expired
        if questions is not None:
            self.questions = questions
        if sender is not None:
            self.sender = sender
        if title is not None:
            self.title = title
        if total_answers is not None:
            self.total_answers = total_answers

    @property
    def description(self):
        """Gets the description of this DataCollectionForm.  # noqa: E501


        :return: The description of this DataCollectionForm.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DataCollectionForm.


        :param description: The description of this DataCollectionForm.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def expired(self):
        """Gets the expired of this DataCollectionForm.  # noqa: E501


        :return: The expired of this DataCollectionForm.  # noqa: E501
        :rtype: bool
        """
        return self._expired

    @expired.setter
    def expired(self, expired):
        """Sets the expired of this DataCollectionForm.


        :param expired: The expired of this DataCollectionForm.  # noqa: E501
        :type: bool
        """

        self._expired = expired

    @property
    def questions(self):
        """Gets the questions of this DataCollectionForm.  # noqa: E501


        :return: The questions of this DataCollectionForm.  # noqa: E501
        :rtype: list[Question]
        """
        return self._questions

    @questions.setter
    def questions(self, questions):
        """Sets the questions of this DataCollectionForm.


        :param questions: The questions of this DataCollectionForm.  # noqa: E501
        :type: list[Question]
        """

        self._questions = questions

    @property
    def sender(self):
        """Gets the sender of this DataCollectionForm.  # noqa: E501


        :return: The sender of this DataCollectionForm.  # noqa: E501
        :rtype: str
        """
        return self._sender

    @sender.setter
    def sender(self, sender):
        """Sets the sender of this DataCollectionForm.


        :param sender: The sender of this DataCollectionForm.  # noqa: E501
        :type: str
        """

        self._sender = sender

    @property
    def title(self):
        """Gets the title of this DataCollectionForm.  # noqa: E501


        :return: The title of this DataCollectionForm.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this DataCollectionForm.


        :param title: The title of this DataCollectionForm.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def total_answers(self):
        """Gets the total_answers of this DataCollectionForm.  # noqa: E501


        :return: The total_answers of this DataCollectionForm.  # noqa: E501
        :rtype: int
        """
        return self._total_answers

    @total_answers.setter
    def total_answers(self, total_answers):
        """Sets the total_answers of this DataCollectionForm.


        :param total_answers: The total_answers of this DataCollectionForm.  # noqa: E501
        :type: int
        """

        self._total_answers = total_answers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DataCollectionForm, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DataCollectionForm):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
