# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.argument import Argument  # noqa: F401,E501
from demisto_client.demisto_api.models.important import Important  # noqa: F401,E501
from demisto_client.demisto_api.models.output import Output  # noqa: F401,E501


class Command(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'arguments': 'list[Argument]',
        'cartesian': 'bool',
        'deprecated': 'bool',
        'description': 'str',
        'execution': 'bool',
        'hidden': 'bool',
        'important': 'list[Important]',
        'name': 'str',
        'outputs': 'list[Output]',
        'permitted': 'bool',
        'sensitive': 'bool',
        'timeout': 'int'
    }

    attribute_map = {
        'arguments': 'arguments',
        'cartesian': 'cartesian',
        'deprecated': 'deprecated',
        'description': 'description',
        'execution': 'execution',
        'hidden': 'hidden',
        'important': 'important',
        'name': 'name',
        'outputs': 'outputs',
        'permitted': 'permitted',
        'sensitive': 'sensitive',
        'timeout': 'timeout'
    }

    def __init__(self, arguments=None, cartesian=None, deprecated=None, description=None, execution=None, hidden=None, important=None, name=None, outputs=None, permitted=None, sensitive=None, timeout=None):  # noqa: E501
        """Command - a model defined in Swagger"""  # noqa: E501

        self._arguments = None
        self._cartesian = None
        self._deprecated = None
        self._description = None
        self._execution = None
        self._hidden = None
        self._important = None
        self._name = None
        self._outputs = None
        self._permitted = None
        self._sensitive = None
        self._timeout = None
        self.discriminator = None

        if arguments is not None:
            self.arguments = arguments
        if cartesian is not None:
            self.cartesian = cartesian
        if deprecated is not None:
            self.deprecated = deprecated
        if description is not None:
            self.description = description
        if execution is not None:
            self.execution = execution
        if hidden is not None:
            self.hidden = hidden
        if important is not None:
            self.important = important
        if name is not None:
            self.name = name
        if outputs is not None:
            self.outputs = outputs
        if permitted is not None:
            self.permitted = permitted
        if sensitive is not None:
            self.sensitive = sensitive
        if timeout is not None:
            self.timeout = timeout

    @property
    def arguments(self):
        """Gets the arguments of this Command.  # noqa: E501


        :return: The arguments of this Command.  # noqa: E501
        :rtype: list[Argument]
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """Sets the arguments of this Command.


        :param arguments: The arguments of this Command.  # noqa: E501
        :type: list[Argument]
        """

        self._arguments = arguments

    @property
    def cartesian(self):
        """Gets the cartesian of this Command.  # noqa: E501


        :return: The cartesian of this Command.  # noqa: E501
        :rtype: bool
        """
        return self._cartesian

    @cartesian.setter
    def cartesian(self, cartesian):
        """Sets the cartesian of this Command.


        :param cartesian: The cartesian of this Command.  # noqa: E501
        :type: bool
        """

        self._cartesian = cartesian

    @property
    def deprecated(self):
        """Gets the deprecated of this Command.  # noqa: E501


        :return: The deprecated of this Command.  # noqa: E501
        :rtype: bool
        """
        return self._deprecated

    @deprecated.setter
    def deprecated(self, deprecated):
        """Sets the deprecated of this Command.


        :param deprecated: The deprecated of this Command.  # noqa: E501
        :type: bool
        """

        self._deprecated = deprecated

    @property
    def description(self):
        """Gets the description of this Command.  # noqa: E501


        :return: The description of this Command.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Command.


        :param description: The description of this Command.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def execution(self):
        """Gets the execution of this Command.  # noqa: E501


        :return: The execution of this Command.  # noqa: E501
        :rtype: bool
        """
        return self._execution

    @execution.setter
    def execution(self, execution):
        """Sets the execution of this Command.


        :param execution: The execution of this Command.  # noqa: E501
        :type: bool
        """

        self._execution = execution

    @property
    def hidden(self):
        """Gets the hidden of this Command.  # noqa: E501


        :return: The hidden of this Command.  # noqa: E501
        :rtype: bool
        """
        return self._hidden

    @hidden.setter
    def hidden(self, hidden):
        """Sets the hidden of this Command.


        :param hidden: The hidden of this Command.  # noqa: E501
        :type: bool
        """

        self._hidden = hidden

    @property
    def important(self):
        """Gets the important of this Command.  # noqa: E501


        :return: The important of this Command.  # noqa: E501
        :rtype: list[Important]
        """
        return self._important

    @important.setter
    def important(self, important):
        """Sets the important of this Command.


        :param important: The important of this Command.  # noqa: E501
        :type: list[Important]
        """

        self._important = important

    @property
    def name(self):
        """Gets the name of this Command.  # noqa: E501


        :return: The name of this Command.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Command.


        :param name: The name of this Command.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def outputs(self):
        """Gets the outputs of this Command.  # noqa: E501


        :return: The outputs of this Command.  # noqa: E501
        :rtype: list[Output]
        """
        return self._outputs

    @outputs.setter
    def outputs(self, outputs):
        """Sets the outputs of this Command.


        :param outputs: The outputs of this Command.  # noqa: E501
        :type: list[Output]
        """

        self._outputs = outputs

    @property
    def permitted(self):
        """Gets the permitted of this Command.  # noqa: E501


        :return: The permitted of this Command.  # noqa: E501
        :rtype: bool
        """
        return self._permitted

    @permitted.setter
    def permitted(self, permitted):
        """Sets the permitted of this Command.


        :param permitted: The permitted of this Command.  # noqa: E501
        :type: bool
        """

        self._permitted = permitted

    @property
    def sensitive(self):
        """Gets the sensitive of this Command.  # noqa: E501


        :return: The sensitive of this Command.  # noqa: E501
        :rtype: bool
        """
        return self._sensitive

    @sensitive.setter
    def sensitive(self, sensitive):
        """Sets the sensitive of this Command.


        :param sensitive: The sensitive of this Command.  # noqa: E501
        :type: bool
        """

        self._sensitive = sensitive

    @property
    def timeout(self):
        """Gets the timeout of this Command.  # noqa: E501


        :return: The timeout of this Command.  # noqa: E501
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this Command.


        :param timeout: The timeout of this Command.  # noqa: E501
        :type: int
        """

        self._timeout = timeout

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Command, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Command):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
