# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.argument import Argument  # noqa: F401,E501
from demisto_client.demisto_api.models.duration import Duration  # noqa: F401,E501
from demisto_client.demisto_api.models.important import Important  # noqa: F401,E501
from demisto_client.demisto_api.models.output import Output  # noqa: F401,E501
from demisto_client.demisto_api.models.script_sub_type import ScriptSubType  # noqa: F401,E501
from demisto_client.demisto_api.models.script_target import ScriptTarget  # noqa: F401,E501
from demisto_client.demisto_api.models.script_type import ScriptType  # noqa: F401,E501


class AutomationScript(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'arguments': 'list[Argument]',
        'comment': 'str',
        'commit_message': 'str',
        'context_keys': 'list[str]',
        'depends_on': 'dict(str, list[str])',
        'deprecated': 'bool',
        'docker_image': 'str',
        'enabled': 'bool',
        'has_role': 'bool',
        'hidden': 'bool',
        'id': 'str',
        'important': 'list[Important]',
        'locked': 'bool',
        'modified': 'datetime',
        'name': 'str',
        'outputs': 'list[Output]',
        'prev_name': 'str',
        'previous_roles': 'list[str]',
        'pswd': 'str',
        'raw_tags': 'list[str]',
        'roles': 'list[str]',
        'run_as': 'str',
        'run_once': 'bool',
        'script': 'str',
        'script_target': 'ScriptTarget',
        'searchable_name': 'str',
        'sensitive': 'bool',
        'should_commit': 'bool',
        'sort_values': 'list[str]',
        'subtype': 'ScriptSubType',
        'system': 'bool',
        'tags': 'list[str]',
        'timeout': 'Duration',
        'type': 'ScriptType',
        'user': 'str',
        'vc_should_ignore': 'bool',
        'version': 'int',
        'visual_script': 'str'
    }

    attribute_map = {
        'arguments': 'arguments',
        'comment': 'comment',
        'commit_message': 'commitMessage',
        'context_keys': 'contextKeys',
        'depends_on': 'dependsOn',
        'deprecated': 'deprecated',
        'docker_image': 'dockerImage',
        'enabled': 'enabled',
        'has_role': 'hasRole',
        'hidden': 'hidden',
        'id': 'id',
        'important': 'important',
        'locked': 'locked',
        'modified': 'modified',
        'name': 'name',
        'outputs': 'outputs',
        'prev_name': 'prevName',
        'previous_roles': 'previousRoles',
        'pswd': 'pswd',
        'raw_tags': 'rawTags',
        'roles': 'roles',
        'run_as': 'runAs',
        'run_once': 'runOnce',
        'script': 'script',
        'script_target': 'scriptTarget',
        'searchable_name': 'searchableName',
        'sensitive': 'sensitive',
        'should_commit': 'shouldCommit',
        'sort_values': 'sortValues',
        'subtype': 'subtype',
        'system': 'system',
        'tags': 'tags',
        'timeout': 'timeout',
        'type': 'type',
        'user': 'user',
        'vc_should_ignore': 'vcShouldIgnore',
        'version': 'version',
        'visual_script': 'visualScript'
    }

    def __init__(self, arguments=None, comment=None, commit_message=None, context_keys=None, depends_on=None, deprecated=None, docker_image=None, enabled=None, has_role=None, hidden=None, id=None, important=None, locked=None, modified=None, name=None, outputs=None, prev_name=None, previous_roles=None, pswd=None, raw_tags=None, roles=None, run_as=None, run_once=None, script=None, script_target=None, searchable_name=None, sensitive=None, should_commit=None, sort_values=None, subtype=None, system=None, tags=None, timeout=None, type=None, user=None, vc_should_ignore=None, version=None, visual_script=None):  # noqa: E501
        """AutomationScript - a model defined in Swagger"""  # noqa: E501

        self._arguments = None
        self._comment = None
        self._commit_message = None
        self._context_keys = None
        self._depends_on = None
        self._deprecated = None
        self._docker_image = None
        self._enabled = None
        self._has_role = None
        self._hidden = None
        self._id = None
        self._important = None
        self._locked = None
        self._modified = None
        self._name = None
        self._outputs = None
        self._prev_name = None
        self._previous_roles = None
        self._pswd = None
        self._raw_tags = None
        self._roles = None
        self._run_as = None
        self._run_once = None
        self._script = None
        self._script_target = None
        self._searchable_name = None
        self._sensitive = None
        self._should_commit = None
        self._sort_values = None
        self._subtype = None
        self._system = None
        self._tags = None
        self._timeout = None
        self._type = None
        self._user = None
        self._vc_should_ignore = None
        self._version = None
        self._visual_script = None
        self.discriminator = None

        if arguments is not None:
            self.arguments = arguments
        if comment is not None:
            self.comment = comment
        if commit_message is not None:
            self.commit_message = commit_message
        if context_keys is not None:
            self.context_keys = context_keys
        if depends_on is not None:
            self.depends_on = depends_on
        if deprecated is not None:
            self.deprecated = deprecated
        if docker_image is not None:
            self.docker_image = docker_image
        if enabled is not None:
            self.enabled = enabled
        if has_role is not None:
            self.has_role = has_role
        if hidden is not None:
            self.hidden = hidden
        if id is not None:
            self.id = id
        if important is not None:
            self.important = important
        if locked is not None:
            self.locked = locked
        if modified is not None:
            self.modified = modified
        if name is not None:
            self.name = name
        if outputs is not None:
            self.outputs = outputs
        if prev_name is not None:
            self.prev_name = prev_name
        if previous_roles is not None:
            self.previous_roles = previous_roles
        if pswd is not None:
            self.pswd = pswd
        if raw_tags is not None:
            self.raw_tags = raw_tags
        if roles is not None:
            self.roles = roles
        if run_as is not None:
            self.run_as = run_as
        if run_once is not None:
            self.run_once = run_once
        if script is not None:
            self.script = script
        if script_target is not None:
            self.script_target = script_target
        if searchable_name is not None:
            self.searchable_name = searchable_name
        if sensitive is not None:
            self.sensitive = sensitive
        if should_commit is not None:
            self.should_commit = should_commit
        if sort_values is not None:
            self.sort_values = sort_values
        if subtype is not None:
            self.subtype = subtype
        if system is not None:
            self.system = system
        if tags is not None:
            self.tags = tags
        if timeout is not None:
            self.timeout = timeout
        if type is not None:
            self.type = type
        if user is not None:
            self.user = user
        if vc_should_ignore is not None:
            self.vc_should_ignore = vc_should_ignore
        if version is not None:
            self.version = version
        if visual_script is not None:
            self.visual_script = visual_script

    @property
    def arguments(self):
        """Gets the arguments of this AutomationScript.  # noqa: E501


        :return: The arguments of this AutomationScript.  # noqa: E501
        :rtype: list[Argument]
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """Sets the arguments of this AutomationScript.


        :param arguments: The arguments of this AutomationScript.  # noqa: E501
        :type: list[Argument]
        """

        self._arguments = arguments

    @property
    def comment(self):
        """Gets the comment of this AutomationScript.  # noqa: E501


        :return: The comment of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this AutomationScript.


        :param comment: The comment of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._comment = comment

    @property
    def commit_message(self):
        """Gets the commit_message of this AutomationScript.  # noqa: E501


        :return: The commit_message of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._commit_message

    @commit_message.setter
    def commit_message(self, commit_message):
        """Sets the commit_message of this AutomationScript.


        :param commit_message: The commit_message of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._commit_message = commit_message

    @property
    def context_keys(self):
        """Gets the context_keys of this AutomationScript.  # noqa: E501


        :return: The context_keys of this AutomationScript.  # noqa: E501
        :rtype: list[str]
        """
        return self._context_keys

    @context_keys.setter
    def context_keys(self, context_keys):
        """Sets the context_keys of this AutomationScript.


        :param context_keys: The context_keys of this AutomationScript.  # noqa: E501
        :type: list[str]
        """

        self._context_keys = context_keys

    @property
    def depends_on(self):
        """Gets the depends_on of this AutomationScript.  # noqa: E501

        This fields indicates which commands this script depends on  # noqa: E501

        :return: The depends_on of this AutomationScript.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._depends_on

    @depends_on.setter
    def depends_on(self, depends_on):
        """Sets the depends_on of this AutomationScript.

        This fields indicates which commands this script depends on  # noqa: E501

        :param depends_on: The depends_on of this AutomationScript.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._depends_on = depends_on

    @property
    def deprecated(self):
        """Gets the deprecated of this AutomationScript.  # noqa: E501


        :return: The deprecated of this AutomationScript.  # noqa: E501
        :rtype: bool
        """
        return self._deprecated

    @deprecated.setter
    def deprecated(self, deprecated):
        """Sets the deprecated of this AutomationScript.


        :param deprecated: The deprecated of this AutomationScript.  # noqa: E501
        :type: bool
        """

        self._deprecated = deprecated

    @property
    def docker_image(self):
        """Gets the docker_image of this AutomationScript.  # noqa: E501


        :return: The docker_image of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._docker_image

    @docker_image.setter
    def docker_image(self, docker_image):
        """Sets the docker_image of this AutomationScript.


        :param docker_image: The docker_image of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._docker_image = docker_image

    @property
    def enabled(self):
        """Gets the enabled of this AutomationScript.  # noqa: E501


        :return: The enabled of this AutomationScript.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this AutomationScript.


        :param enabled: The enabled of this AutomationScript.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def has_role(self):
        """Gets the has_role of this AutomationScript.  # noqa: E501

        Internal field to make queries on role faster  # noqa: E501

        :return: The has_role of this AutomationScript.  # noqa: E501
        :rtype: bool
        """
        return self._has_role

    @has_role.setter
    def has_role(self, has_role):
        """Sets the has_role of this AutomationScript.

        Internal field to make queries on role faster  # noqa: E501

        :param has_role: The has_role of this AutomationScript.  # noqa: E501
        :type: bool
        """

        self._has_role = has_role

    @property
    def hidden(self):
        """Gets the hidden of this AutomationScript.  # noqa: E501


        :return: The hidden of this AutomationScript.  # noqa: E501
        :rtype: bool
        """
        return self._hidden

    @hidden.setter
    def hidden(self, hidden):
        """Sets the hidden of this AutomationScript.


        :param hidden: The hidden of this AutomationScript.  # noqa: E501
        :type: bool
        """

        self._hidden = hidden

    @property
    def id(self):
        """Gets the id of this AutomationScript.  # noqa: E501


        :return: The id of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AutomationScript.


        :param id: The id of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def important(self):
        """Gets the important of this AutomationScript.  # noqa: E501


        :return: The important of this AutomationScript.  # noqa: E501
        :rtype: list[Important]
        """
        return self._important

    @important.setter
    def important(self, important):
        """Sets the important of this AutomationScript.


        :param important: The important of this AutomationScript.  # noqa: E501
        :type: list[Important]
        """

        self._important = important

    @property
    def locked(self):
        """Gets the locked of this AutomationScript.  # noqa: E501


        :return: The locked of this AutomationScript.  # noqa: E501
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this AutomationScript.


        :param locked: The locked of this AutomationScript.  # noqa: E501
        :type: bool
        """

        self._locked = locked

    @property
    def modified(self):
        """Gets the modified of this AutomationScript.  # noqa: E501


        :return: The modified of this AutomationScript.  # noqa: E501
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this AutomationScript.


        :param modified: The modified of this AutomationScript.  # noqa: E501
        :type: datetime
        """

        self._modified = modified

    @property
    def name(self):
        """Gets the name of this AutomationScript.  # noqa: E501


        :return: The name of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AutomationScript.


        :param name: The name of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def outputs(self):
        """Gets the outputs of this AutomationScript.  # noqa: E501


        :return: The outputs of this AutomationScript.  # noqa: E501
        :rtype: list[Output]
        """
        return self._outputs

    @outputs.setter
    def outputs(self, outputs):
        """Sets the outputs of this AutomationScript.


        :param outputs: The outputs of this AutomationScript.  # noqa: E501
        :type: list[Output]
        """

        self._outputs = outputs

    @property
    def prev_name(self):
        """Gets the prev_name of this AutomationScript.  # noqa: E501


        :return: The prev_name of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._prev_name

    @prev_name.setter
    def prev_name(self, prev_name):
        """Sets the prev_name of this AutomationScript.


        :param prev_name: The prev_name of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._prev_name = prev_name

    @property
    def previous_roles(self):
        """Gets the previous_roles of this AutomationScript.  # noqa: E501

        PreviousRoleName - do not change this field manually  # noqa: E501

        :return: The previous_roles of this AutomationScript.  # noqa: E501
        :rtype: list[str]
        """
        return self._previous_roles

    @previous_roles.setter
    def previous_roles(self, previous_roles):
        """Sets the previous_roles of this AutomationScript.

        PreviousRoleName - do not change this field manually  # noqa: E501

        :param previous_roles: The previous_roles of this AutomationScript.  # noqa: E501
        :type: list[str]
        """

        self._previous_roles = previous_roles

    @property
    def pswd(self):
        """Gets the pswd of this AutomationScript.  # noqa: E501


        :return: The pswd of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._pswd

    @pswd.setter
    def pswd(self, pswd):
        """Sets the pswd of this AutomationScript.


        :param pswd: The pswd of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._pswd = pswd

    @property
    def raw_tags(self):
        """Gets the raw_tags of this AutomationScript.  # noqa: E501


        :return: The raw_tags of this AutomationScript.  # noqa: E501
        :rtype: list[str]
        """
        return self._raw_tags

    @raw_tags.setter
    def raw_tags(self, raw_tags):
        """Sets the raw_tags of this AutomationScript.


        :param raw_tags: The raw_tags of this AutomationScript.  # noqa: E501
        :type: list[str]
        """

        self._raw_tags = raw_tags

    @property
    def roles(self):
        """Gets the roles of this AutomationScript.  # noqa: E501

        The role assigned to this investigation  # noqa: E501

        :return: The roles of this AutomationScript.  # noqa: E501
        :rtype: list[str]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this AutomationScript.

        The role assigned to this investigation  # noqa: E501

        :param roles: The roles of this AutomationScript.  # noqa: E501
        :type: list[str]
        """

        self._roles = roles

    @property
    def run_as(self):
        """Gets the run_as of this AutomationScript.  # noqa: E501


        :return: The run_as of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._run_as

    @run_as.setter
    def run_as(self, run_as):
        """Sets the run_as of this AutomationScript.


        :param run_as: The run_as of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._run_as = run_as

    @property
    def run_once(self):
        """Gets the run_once of this AutomationScript.  # noqa: E501


        :return: The run_once of this AutomationScript.  # noqa: E501
        :rtype: bool
        """
        return self._run_once

    @run_once.setter
    def run_once(self, run_once):
        """Sets the run_once of this AutomationScript.


        :param run_once: The run_once of this AutomationScript.  # noqa: E501
        :type: bool
        """

        self._run_once = run_once

    @property
    def script(self):
        """Gets the script of this AutomationScript.  # noqa: E501


        :return: The script of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._script

    @script.setter
    def script(self, script):
        """Sets the script of this AutomationScript.


        :param script: The script of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._script = script

    @property
    def script_target(self):
        """Gets the script_target of this AutomationScript.  # noqa: E501


        :return: The script_target of this AutomationScript.  # noqa: E501
        :rtype: ScriptTarget
        """
        return self._script_target

    @script_target.setter
    def script_target(self, script_target):
        """Sets the script_target of this AutomationScript.


        :param script_target: The script_target of this AutomationScript.  # noqa: E501
        :type: ScriptTarget
        """

        self._script_target = script_target

    @property
    def searchable_name(self):
        """Gets the searchable_name of this AutomationScript.  # noqa: E501


        :return: The searchable_name of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._searchable_name

    @searchable_name.setter
    def searchable_name(self, searchable_name):
        """Sets the searchable_name of this AutomationScript.


        :param searchable_name: The searchable_name of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._searchable_name = searchable_name

    @property
    def sensitive(self):
        """Gets the sensitive of this AutomationScript.  # noqa: E501


        :return: The sensitive of this AutomationScript.  # noqa: E501
        :rtype: bool
        """
        return self._sensitive

    @sensitive.setter
    def sensitive(self, sensitive):
        """Sets the sensitive of this AutomationScript.


        :param sensitive: The sensitive of this AutomationScript.  # noqa: E501
        :type: bool
        """

        self._sensitive = sensitive

    @property
    def should_commit(self):
        """Gets the should_commit of this AutomationScript.  # noqa: E501


        :return: The should_commit of this AutomationScript.  # noqa: E501
        :rtype: bool
        """
        return self._should_commit

    @should_commit.setter
    def should_commit(self, should_commit):
        """Sets the should_commit of this AutomationScript.


        :param should_commit: The should_commit of this AutomationScript.  # noqa: E501
        :type: bool
        """

        self._should_commit = should_commit

    @property
    def sort_values(self):
        """Gets the sort_values of this AutomationScript.  # noqa: E501


        :return: The sort_values of this AutomationScript.  # noqa: E501
        :rtype: list[str]
        """
        return self._sort_values

    @sort_values.setter
    def sort_values(self, sort_values):
        """Sets the sort_values of this AutomationScript.


        :param sort_values: The sort_values of this AutomationScript.  # noqa: E501
        :type: list[str]
        """

        self._sort_values = sort_values

    @property
    def subtype(self):
        """Gets the subtype of this AutomationScript.  # noqa: E501


        :return: The subtype of this AutomationScript.  # noqa: E501
        :rtype: ScriptSubType
        """
        return self._subtype

    @subtype.setter
    def subtype(self, subtype):
        """Sets the subtype of this AutomationScript.


        :param subtype: The subtype of this AutomationScript.  # noqa: E501
        :type: ScriptSubType
        """

        self._subtype = subtype

    @property
    def system(self):
        """Gets the system of this AutomationScript.  # noqa: E501


        :return: The system of this AutomationScript.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this AutomationScript.


        :param system: The system of this AutomationScript.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def tags(self):
        """Gets the tags of this AutomationScript.  # noqa: E501


        :return: The tags of this AutomationScript.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this AutomationScript.


        :param tags: The tags of this AutomationScript.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def timeout(self):
        """Gets the timeout of this AutomationScript.  # noqa: E501


        :return: The timeout of this AutomationScript.  # noqa: E501
        :rtype: Duration
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this AutomationScript.


        :param timeout: The timeout of this AutomationScript.  # noqa: E501
        :type: Duration
        """

        self._timeout = timeout

    @property
    def type(self):
        """Gets the type of this AutomationScript.  # noqa: E501


        :return: The type of this AutomationScript.  # noqa: E501
        :rtype: ScriptType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this AutomationScript.


        :param type: The type of this AutomationScript.  # noqa: E501
        :type: ScriptType
        """

        self._type = type

    @property
    def user(self):
        """Gets the user of this AutomationScript.  # noqa: E501


        :return: The user of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this AutomationScript.


        :param user: The user of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._user = user

    @property
    def vc_should_ignore(self):
        """Gets the vc_should_ignore of this AutomationScript.  # noqa: E501


        :return: The vc_should_ignore of this AutomationScript.  # noqa: E501
        :rtype: bool
        """
        return self._vc_should_ignore

    @vc_should_ignore.setter
    def vc_should_ignore(self, vc_should_ignore):
        """Sets the vc_should_ignore of this AutomationScript.


        :param vc_should_ignore: The vc_should_ignore of this AutomationScript.  # noqa: E501
        :type: bool
        """

        self._vc_should_ignore = vc_should_ignore

    @property
    def version(self):
        """Gets the version of this AutomationScript.  # noqa: E501


        :return: The version of this AutomationScript.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this AutomationScript.


        :param version: The version of this AutomationScript.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def visual_script(self):
        """Gets the visual_script of this AutomationScript.  # noqa: E501


        :return: The visual_script of this AutomationScript.  # noqa: E501
        :rtype: str
        """
        return self._visual_script

    @visual_script.setter
    def visual_script(self, visual_script):
        """Sets the visual_script of this AutomationScript.


        :param visual_script: The visual_script of this AutomationScript.  # noqa: E501
        :type: str
        """

        self._visual_script = visual_script

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AutomationScript, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AutomationScript):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
