# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pylav',
 'pylav._internals',
 'pylav.constants',
 'pylav.constants.config',
 'pylav.core',
 'pylav.enums',
 'pylav.enums.plugins',
 'pylav.events',
 'pylav.events.plugins',
 'pylav.events.track',
 'pylav.exceptions',
 'pylav.extension',
 'pylav.extension.bundled_node',
 'pylav.extension.flowery',
 'pylav.extension.flowery.lyrics',
 'pylav.extension.m3u',
 'pylav.extension.radio',
 'pylav.extension.red',
 'pylav.extension.red.converters',
 'pylav.extension.red.ui',
 'pylav.extension.red.ui.buttons',
 'pylav.extension.red.ui.menus',
 'pylav.extension.red.ui.modals',
 'pylav.extension.red.ui.prompts',
 'pylav.extension.red.ui.selectors',
 'pylav.extension.red.ui.selectors.options',
 'pylav.extension.red.ui.sources',
 'pylav.extension.red.utils',
 'pylav.helpers',
 'pylav.helpers.discord',
 'pylav.helpers.discord.converters',
 'pylav.helpers.emojis',
 'pylav.helpers.format',
 'pylav.logging',
 'pylav.nodes',
 'pylav.nodes.api',
 'pylav.nodes.api.responses',
 'pylav.nodes.api.responses.filters',
 'pylav.nodes.api.responses.filters.plugins',
 'pylav.nodes.api.responses.plugins',
 'pylav.nodes.websockets',
 'pylav.players',
 'pylav.players.filters',
 'pylav.players.filters.plugins',
 'pylav.players.query',
 'pylav.players.query.obj',
 'pylav.players.tracks',
 'pylav.players.tracks.obj',
 'pylav.storage',
 'pylav.storage.controllers',
 'pylav.storage.controllers.players',
 'pylav.storage.database',
 'pylav.storage.database.cache',
 'pylav.storage.database.tables',
 'pylav.storage.migrations',
 'pylav.storage.migrations.high_level',
 'pylav.storage.migrations.high_level.always',
 'pylav.storage.migrations.high_level.one_offs',
 'pylav.storage.migrations.low_level',
 'pylav.storage.models',
 'pylav.storage.models.node',
 'pylav.storage.models.player',
 'pylav.type_hints',
 'pylav.utils',
 'pylav.utils.vendor',
 'pylav.utils.vendor.lavalink_py',
 'pylav.utils.vendor.redbot',
 'pylav.vendor']

package_data = \
{'': ['*'],
 'pylav': ['config_migrations/locales/*',
           'converters/locales/*',
           'filters/locales/*',
           'locales/*',
           'localfiles/locales/*',
           'm3u8_parser/locales/*',
           'migrations/locales/*',
           'radio/locales/*',
           'sql/clients/locales/*',
           'sql/locales/*',
           'sql/tables/locales/*',
           'vendored/aiopath/aiopath_310/locales/*',
           'vendored/aiopath/locales/*',
           'vendored/locales/*'],
 'pylav._internals': ['locales/*'],
 'pylav.constants': ['locales/*'],
 'pylav.constants.config': ['locales/*'],
 'pylav.core': ['locales/*'],
 'pylav.enums': ['locales/*'],
 'pylav.enums.plugins': ['locales/*'],
 'pylav.events': ['locales/*'],
 'pylav.events.plugins': ['locales/*'],
 'pylav.events.track': ['locales/*'],
 'pylav.exceptions': ['locales/*'],
 'pylav.extension': ['locales/*'],
 'pylav.extension.bundled_node': ['locales/*'],
 'pylav.extension.flowery': ['locales/*'],
 'pylav.extension.flowery.lyrics': ['locales/*'],
 'pylav.extension.m3u': ['locales/*'],
 'pylav.extension.radio': ['locales/*'],
 'pylav.extension.red': ['locales/*'],
 'pylav.extension.red.converters': ['locales/*'],
 'pylav.extension.red.ui': ['locales/*'],
 'pylav.extension.red.ui.buttons': ['locales/*'],
 'pylav.extension.red.ui.menus': ['locales/*'],
 'pylav.extension.red.ui.modals': ['locales/*'],
 'pylav.extension.red.ui.prompts': ['locales/*'],
 'pylav.extension.red.ui.selectors': ['locales/*'],
 'pylav.extension.red.ui.selectors.options': ['locales/*'],
 'pylav.extension.red.ui.sources': ['locales/*'],
 'pylav.extension.red.utils': ['locales/*'],
 'pylav.helpers': ['locales/*'],
 'pylav.helpers.discord': ['locales/*'],
 'pylav.helpers.discord.converters': ['locales/*'],
 'pylav.helpers.emojis': ['locales/*'],
 'pylav.helpers.format': ['locales/*'],
 'pylav.logging': ['locales/*'],
 'pylav.nodes': ['locales/*'],
 'pylav.nodes.api': ['locales/*'],
 'pylav.nodes.api.responses': ['locales/*'],
 'pylav.nodes.api.responses.filters': ['locales/*'],
 'pylav.nodes.api.responses.filters.plugins': ['locales/*'],
 'pylav.nodes.api.responses.plugins': ['locales/*'],
 'pylav.nodes.websockets': ['locales/*'],
 'pylav.players': ['locales/*'],
 'pylav.players.filters': ['locales/*'],
 'pylav.players.filters.plugins': ['locales/*'],
 'pylav.players.query': ['locales/*'],
 'pylav.players.tracks': ['locales/*'],
 'pylav.storage': ['locales/*'],
 'pylav.storage.controllers': ['locales/*'],
 'pylav.storage.controllers.players': ['locales/*'],
 'pylav.storage.database': ['locales/*'],
 'pylav.storage.database.cache': ['locales/*'],
 'pylav.storage.database.tables': ['locales/*'],
 'pylav.storage.migrations': ['locales/*'],
 'pylav.storage.migrations.high_level': ['locales/*'],
 'pylav.storage.migrations.high_level.always': ['locales/*'],
 'pylav.storage.migrations.high_level.one_offs': ['locales/*'],
 'pylav.storage.migrations.low_level': ['locales/*'],
 'pylav.storage.models': ['locales/*'],
 'pylav.storage.models.node': ['locales/*'],
 'pylav.storage.models.player': ['locales/*'],
 'pylav.type_hints': ['locales/*'],
 'pylav.utils': ['locales/*'],
 'pylav.utils.vendor': ['locales/*'],
 'pylav.utils.vendor.lavalink_py': ['locales/*'],
 'pylav.utils.vendor.redbot': ['locales/*'],
 'pylav.vendor': ['locales/*']}

install_requires = \
['APScheduler>=3.9.1.post1,<4.0.0',
 'Brotli>=1.0.9,<2.0.0',
 'PyYAML>=6.0,<7.0',
 'aiohttp-client-cache>=0.8.0,<0.9.0',
 'aiopath>=0.6.11,<0.7.0',
 'asyncpg>=0.27.0,<0.28.0',
 'asyncspotify>=0.12.1,<0.13.0',
 'asyncstdlib>=3.10.5,<4.0.0',
 'cached-property>=1.5.2,<2.0.0',
 'cashews[dill,redis]>=5.0.0,<6.0.0',
 'dacite>=1.7.0,<2.0.0',
 'deepdiff6>=6.2.0,<7.0.0',
 'expiringdict>=1.2.2,<2.0.0',
 'humanize>=4.4.0,<5.0.0',
 'iso8601>=1.1.0,<2.0.0',
 'netaddr>=0.8.0,<0.9.0',
 'numpy>=1.24.1,<2.0.0',
 'piccolo[all]>=0.103.0,<0.104.0',
 'pip>=22.3.1,<23.0.0',
 'setuptools>=65.6.3,<66.0.0',
 'tabulate[widechars]>=0.9.0,<0.10.0',
 'ujson>=5.6.0,<6.0.0',
 'wheel>=0.38.4,<0.39.0']

extras_require = \
{':extra == "redis" or extra == "all" or extra == "all-nored"': ['redis>=4.4.0,<5.0.0'],
 'all': ['orjson>=3.8.3,<4.0.0'],
 'all-nored': ['Red-Commons>=1.0.0,<2.0.0',
               'aiohttp[speedups]>=3.8.3,<4.0.0',
               'apsw>=3.40.0.0,<4.0.0.0',
               'importlib-metadata>=5.2.0,<6.0.0',
               'orjson>=3.8.3,<4.0.0',
               'orjson>=3.8.3,<4.0.0',
               'packaging>=22.0,<23.0',
               'platformdirs>=2.6.2,<3.0.0',
               'psutil>=5.9.4,<6.0.0',
               'python-dateutil>=2.8.2,<3.0.0',
               'pytz>=2022.7,<2023.0',
               'rich>=13.0.0,<14.0.0',
               'typing-extensions>=4.4.0,<5.0.0'],
 'all-nored:sys_platform != "win32" and platform_python_implementation == "CPython"': ['uvloop>=0.17.0,<0.18.0'],
 'nored': ['Red-Commons>=1.0.0,<2.0.0',
           'aiohttp[speedups]>=3.8.3,<4.0.0',
           'apsw>=3.40.0.0,<4.0.0.0',
           'importlib-metadata>=5.2.0,<6.0.0',
           'orjson>=3.8.3,<4.0.0',
           'packaging>=22.0,<23.0',
           'platformdirs>=2.6.2,<3.0.0',
           'psutil>=5.9.4,<6.0.0',
           'python-dateutil>=2.8.2,<3.0.0',
           'pytz>=2022.7,<2023.0',
           'rich>=13.0.0,<14.0.0',
           'typing-extensions>=4.4.0,<5.0.0'],
 'nored:sys_platform != "win32" and platform_python_implementation == "CPython"': ['uvloop>=0.17.0,<0.18.0'],
 'speed': ['orjson>=3.8.3,<4.0.0']}

setup_kwargs = {
    'name': 'py-lav',
    'version': '1.0.4',
    'description': ' A Lavalink WebSocket & API wrapper for discord.py',
    'long_description': "[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/Drapersniper/Py-Lav/master.svg)](https://results.pre-commit.ci/latest/github/Drapersniper/Py-Lav/master)\n[![GitHub license](https://img.shields.io/github/license/Drapersniper/Py-Lav.svg)](https://github.com/Drapersniper/Py-Lav/blob/master/LICENSE)\n[![Support Server](https://img.shields.io/discord/970987707834720266)](https://discord.com/invite/Sjh2TSCYQB)\n[![PyPi](https://img.shields.io/pypi/v/Py-Lav?style=plastic)](https://pypi.org/project/Py-Lav/)\n[![Documentation Status](https://readthedocs.org/projects/pylav/badge/?version=latest)](https://pylav.readthedocs.io/en/latest/?badge=latest)\n[![Crowdin](https://badges.crowdin.net/pylav/localized.svg)](https://crowdin.com/project/pylav)\n\n\n# Documentation\n### Installation\n - [Click Here](SETUP.md)\n---------------------------\n### Requirements\n- PostgresSQL 14 server\n  - MacOS: [PostgresSQL](https://www.postgresql.org/download/macosx/)\n  - Windows: [PostgresSQL](https://www.postgresql.org/download/windows/)\n  - Linux: [PostgresSQL](https://www.postgresql.org/download/linux/)\n- Python 3.11\n- [Discord.py](https://github.com/Rapptz/discord.py) 2.1.0+ bot\n- [Lavalink](https://github.com/freyacodes/Lavalink) v4.0.0+ server\n---------------------------\n## Supported sources\n### [Built-in](https://github.com/freyacodes/Lavalink):\n  - youtube\n  - soundcloud\n  - bandcamp\n  - twitch\n  - vimeo\n  - http\n  - local\n### With [LavaSrc](https://github.com/TopiSenpai/LavaSrc)\n  - spotify\n  - applemusic\n  - deezer\n### With [DuncteBot-plugin](https://github.com/DuncteBot/skybot-lavalink-plugin):\n  - getyarn.io\n  - clypit\n  - tts\n  - pornhub\n  - reddit\n  - ocremix\n  - tiktok\n  - mixcloud\n  - soundgasm\n### With [Google Cloud TTS](https://github.com/DuncteBot/tts-plugin):\n  - gcloud-tts\n### With [Sponsorblock-Plugin](https://github.com/Topis-Lavalink-Plugins/Sponsorblock-Plugin):\n  - sponsorblock\n\n## Supported Lavalink features\n  - Supports all features of [Lavalink](https://github.com/freyacodes/Lavalink)\n    - Filters\n    - IP Rotation\n    - Plug-ins\n\nFeatures\n---------------------------\n- Multiple node support\n  - Node region assignment based on IP\n- Track cache for the last 30 days to reduce the number of duplicated queries\n- Managed local node with auto-restart and auto update\n- Many helper methods and functions\n- Support for multiple cogs to access the library at once\n- Playlists and EQ saved at a library level to be shared with cogs\n- Player state persistence\n    - Upon library state being shutdown all player states are saved and restored on library startup\n- History of played tracks available for players\n- RadioBrowser.org API to retrieve radio stations available for players\n- Lyrics API to retrieve lyrics for tracks provided by [Flowery](https://flowery.pw)\n- M3U, PLS and PYLAV text file parser to convert contents into a playlist (p.s. Lavalink must support the format/coded of files still)\n\n\nCredits\n---------------------------\n- [Topi](https://github.com/TopiSenpai) for all the work done to Lavalink and implementing direct requests to make PyLav even better.\n- [Devoxin - Lavalink.py](https://github.com/Devoxin/Lavalink.py) for the original ideas for implementation.\n- [Ryan](https://github.com/ryan5453) for the amazing [Lyrics API](https://flowery.pw) used for lyrics.\n- [globocom/m3u8](https://github.com/globocom/m3u8) for the M3U8 parser which I made asynchronous found in [m3u8_parser](pylav/extension/m3u).\n- [andreztz/pyradios](https://github.com/andreztz/pyradios) for the radio parser which I made asynchronous found in [radio](pylav/extension/radio).\n- [Lifeismana](https://github.com/Lifeismana) for the custom Red-DiscordBot docker image which added Python3.11 support until Phasecore's image is updated.\n",
    'author': 'Draper',
    'author_email': '27962761+Drapersniper@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Drapersniper/PyLav',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.11,<4.0',
}


setup(**setup_kwargs)
