"""SI fast correctors cycle data."""

import numpy as _np


PARMS = {
    # psname             dt[s], max_amp[A], period[s], nrcycles, tau[s], sin**2
    'SI-01M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-01M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-01M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-01M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-01C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-01C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-01C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-01C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-02M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-02M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-02M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-02M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-02C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-02C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-02C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-02C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-03M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-03M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-03M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-03M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-03C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-03C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-03C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-03C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-04M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-04M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-04M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-04M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-04C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-04C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-04C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-04C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-05M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-05M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-05M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-05M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-05C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-05C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-05C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-05C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-06M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-06M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-06M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-06M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-06C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-06C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-06C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-06C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-07M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-07M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-07M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-07M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-07C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-07C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-07C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-07C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-08M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-08M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-08M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-08M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-08C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-08C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-08C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-08C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-09M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-09M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-09M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-09M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-09C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-09C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-09C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-09C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-10M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-10M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-10M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-10M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-10C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-10C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-10C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-10C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-11M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-11M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-11M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-11M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-11C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-11C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-11C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-11C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-12M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-12M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-12M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-12M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-12C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-12C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-12C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-12C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-13M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-13M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-13M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-13M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-13C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-13C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-13C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-13C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-14M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-14M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-14M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-14M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-14C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-14C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-14C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-14C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-15M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-15M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-15M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-15M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-15C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-15C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-15C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-15C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-16M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-16M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-16M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-16M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-16C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-16C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-16C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-16C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-17M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-17M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-17M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-17M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-17C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-17C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-17C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-17C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-18M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-18M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-18M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-18M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-18C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-18C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-18C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-18C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-19M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-19M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-19M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-19M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-19C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-19C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-19C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-19C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-20M1:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-20M1:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-20M2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-20M2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-20C2:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-20C2:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
    'SI-20C3:PS-FCH':    [0.5, 0.95, 24, 8, 48, False],
    'SI-20C3:PS-FCV':    [0.5, 0.95, 24, 8, 48, False],
}


def fc_get_default_waveform(psname):
    """Return cycle waveform."""
    [dtime, ampl, period, nr_periods, tau, square] = PARMS[psname]
    wfm = 2*_np.pi/period
    nrpts = nr_periods * int(period / dtime)
    vec = list(range(0, nrpts))
    time = dtime * _np.array(vec)
    nexp = 2 if square else 1
    time0 = _np.arctan(2*_np.pi*tau*nexp)/wfm
    sin = _np.sin(2*_np.pi*time/period)
    exp = _np.exp(- (time - time0)/tau)
    amp = ampl/(_np.sin(wfm*time0))**nexp
    func = amp * exp * sin**nexp
    time = _np.append(time, time[-1] + dtime)
    func = _np.append(func, 0.0)
    func *= ampl/max(func)  # makes sure max point is 'ampl'
    return time, func
