"""Parameters of the IOCs of the AP discipline."""
from copy import deepcopy as _dcopy

_off = 0
_on = 1


def get_dict():
    """Return configuration type dictionary."""
    module_name = __name__.split('.')[-1]
    _dict = {
        'config_type_name': module_name,
        'value': _dcopy(_template_dict),
        'check': False,
    }
    return _dict


# When using this type of configuration to set the machine,
# the list of PVs should be processed in the same order they are stored
# in the configuration. The second numeric parameter in the pair is the
# delay [s] the client should wait before setting the next PV.


_si_bbb_frontbackend = [
    ['SI-Glob:DI-BbBProc-L:FBE_BE_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBE_Z_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBE_X_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBE_Y_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBE_BE_PHASE', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_SERVO_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_X_PHASE_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_Y_PHASE_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_SERVO_MODE', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_SERVO_SIGN', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_SERVO_GAIN', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_SERVO_OFFSET', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_SERVO_X_TRACK', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_SERVO_Y_TRACK', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_FAN_MODE', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_FAN_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FBELT_SERVO_MAXDELTA', 0.0, 0.0],

    ['SI-Glob:DI-BbBProc-V:FBE_BE_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBE_Z_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBE_X_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBE_Y_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBE_BE_PHASE', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_SERVO_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_X_PHASE_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_Y_PHASE_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_SERVO_MODE', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_SERVO_SIGN', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_SERVO_GAIN', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_SERVO_OFFSET', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_SERVO_X_TRACK', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_SERVO_Y_TRACK', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_FAN_MODE', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_FAN_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FBELT_SERVO_MAXDELTA', 0.0, 0.0],

    ['SI-Glob:DI-BbBProc-H:FBE_BE_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBE_Z_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBE_X_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBE_Y_ATT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBE_BE_PHASE', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_SERVO_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_X_PHASE_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_Y_PHASE_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_SERVO_MODE', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_SERVO_SIGN', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_SERVO_GAIN', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_SERVO_OFFSET', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_SERVO_X_TRACK', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_SERVO_Y_TRACK', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_FAN_MODE', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_FAN_SETPT', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FBELT_SERVO_MAXDELTA', 0.0, 0.0],
    ]

_si_bbb_l = [
    ['SI-Glob:DI-BbBProc-L:SETSEL', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:SHIFTGAIN', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:PROC_DS', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:SAT_THRESHOLD', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:GDEN', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:CSET0', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-L:CSET1', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-L:CSET2', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-L:CSET3', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-L:FB_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-L:CF_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-L:FB_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-L:CF_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-L:DRIVE0_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-L:DRIVE1_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-L:DRIVE2_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-L:DRIVE0_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-L:DRIVE1_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-L:DRIVE2_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-L:PHTRK_LOOPCTRL', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:DRIVE2_TRACK', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:PHTRK_MOD', 0, 0.0],
    ['SI-Glob:DI-BbBProc-L:TADC', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:TDAC', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:DELAY', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:OFF_FIDS', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:FID_DELAY', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:ECLDEL0', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:ECLDEL1', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:ECLDEL2', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:ECLDEL3', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:MCLRAW_0_FWDLOSS', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:MCLRAW_0_REVLOSS', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:MCLRAW_1_FWDLOSS', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-L:MCLRAW_1_REVLOSS', 0.0, 0.0],
    ]

_si_bbb_h = [
    ['SI-Glob:DI-BbBProc-H:SETSEL', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:SHIFTGAIN', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:PROC_DS', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:SAT_THRESHOLD', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:GDEN', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:CSET0', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-H:CSET1', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-H:CSET2', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-H:CSET3', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-H:FB_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-H:CF_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-H:FB_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-H:CF_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-H:CLEAN_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-H:CLEAN_ENABLE', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:CLEAN_PERIOD', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:CLEAN_SPAN', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:CLEAN_TUNE', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:CLEAN_AMPL', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:DRIVE0_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-H:DRIVE1_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-H:DRIVE2_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-H:DRIVE0_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-H:DRIVE1_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-H:DRIVE2_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-H:PHTRK_LOOPCTRL', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:DRIVE2_TRACK', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:PHTRK_MOD', 0, 0.0],
    ['SI-Glob:DI-BbBProc-H:TADC', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:TDAC', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:DELAY', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:OFF_FIDS', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:FID_DELAY', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:ECLDEL0', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:ECLDEL1', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:ECLDEL2', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-H:ECLDEL3', 0.0, 0.0],
    ['SI-Glob:DI-BbBAmpH:Enbl-Sel', 0, 0.0],
    ['SI-Glob:DI-BbBAmpH:GainAuto-Sel', 0, 0.0],
    ['SI-Glob:DI-BbBAmpH:Gain-SP', 0.0, 0.0],
    ['SI-Glob:DI-BbBAmpH:GainStep-SP', 0.0, 0.0],
    ]

_si_bbb_v = [
    ['SI-Glob:DI-BbBProc-V:SETSEL', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:SHIFTGAIN', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:PROC_DS', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:SAT_THRESHOLD', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:GDEN', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:CSET0', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-V:CSET1', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-V:CSET2', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-V:CSET3', [0.0]*31, 0.0],
    ['SI-Glob:DI-BbBProc-V:FB_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-V:CF_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-V:FB_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-V:CF_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-V:CLEAN_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-V:CLEAN_ENABLE', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:CLEAN_PERIOD', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:CLEAN_SPAN', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:CLEAN_TUNE', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:CLEAN_AMPL', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:DRIVE0_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-V:DRIVE1_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-V:DRIVE2_MASK', [0]*864, 0.0],
    ['SI-Glob:DI-BbBProc-V:DRIVE0_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-V:DRIVE1_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-V:DRIVE2_PATTERN', '', 0.0],
    ['SI-Glob:DI-BbBProc-V:PHTRK_LOOPCTRL', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:DRIVE2_TRACK', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:PHTRK_MOD', 0, 0.0],
    ['SI-Glob:DI-BbBProc-V:TADC', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:TDAC', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:DELAY', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:OFF_FIDS', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:FID_DELAY', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:ECLDEL0', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:ECLDEL1', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:ECLDEL2', 0.0, 0.0],
    ['SI-Glob:DI-BbBProc-V:ECLDEL3', 0.0, 0.0],
    ['SI-Glob:DI-BbBAmpV:Enbl-Sel', 0, 0.0],
    ['SI-Glob:DI-BbBAmpV:GainAuto-Sel', 0, 0.0],
    ['SI-Glob:DI-BbBAmpV:Gain-SP', 0.0, 0.0],
    ['SI-Glob:DI-BbBAmpV:GainStep-SP', 0.0, 0.0],
    ]

_si_sofb = [
    ['SI-Glob:AP-SOFB:SOFBMode-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:RefOrbX-SP', [0.0, ]*800, 0.0],
    ['SI-Glob:AP-SOFB:RefOrbY-SP', [0.0, ]*800, 0.0],
    ['SI-Glob:AP-SOFB:SmoothNrPts-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:OrbAcqRate-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:SmoothMethod-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:LoopFreq-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:LoopMaxOrbDistortion-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:LoopPIDKpCH-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:LoopPIDKpCV-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:LoopPIDKpRF-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:LoopPIDKiCH-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:LoopPIDKiCV-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:LoopPIDKiRF-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:LoopPIDKdCH-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:LoopPIDKdCV-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:LoopPIDKdRF-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MaxKickCH-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MaxKickCV-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MaxDeltaKickCH-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MaxDeltaKickCV-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:MaxDeltaKickRF-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:CorrSync-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:CorrPSSOFBWait-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:CorrPSSOFBEnbl-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:FOFBDownloadKicks-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:FOFBUpdateRefOrb-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:FOFBNullSpaceProj-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:FOFBZeroDistortionAtBPMs-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:FOFBDownloadKicksPerc-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:FOFBUpdateRefOrbPerc-SP', 0, 0.0],
    ['SI-Glob:AP-SOFB:RespMat-SP', [0.0, ]*449600, 0.0],
    ['SI-Glob:AP-SOFB:RespMatMode-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:BPMXEnblList-SP', [0, ]*800, 0.0],
    ['SI-Glob:AP-SOFB:BPMYEnblList-SP', [0, ]*800, 0.0],
    ['SI-Glob:AP-SOFB:CHEnblList-SP', [0, ]*120, 0.0],
    ['SI-Glob:AP-SOFB:CVEnblList-SP', [0, ]*160, 0.0],
    ['SI-Glob:AP-SOFB:RFEnbl-Sel', 0, 0.0],
    ['SI-Glob:AP-SOFB:MinSingValue-SP', 0.0, 0.0],
    ['SI-Glob:AP-SOFB:TikhonovRegConst-SP', 0.0, 0.0],
    ]


_si_fofb = [
    ['SI-Glob:AP-FOFB:LoopGainH-SP', 0.0, 0.0],
    ['SI-Glob:AP-FOFB:LoopGainV-SP', 0.0, 0.0],
    ['SI-Glob:AP-FOFB:LoopMaxOrbDistortion-SP', 0.0, 0.0],
    ['SI-Glob:AP-FOFB:LoopMaxOrbDistortionEnbl-Sel', 0, 0.0],
    ['SI-Glob:AP-FOFB:LoopPacketLossDetecEnbl-Sel', 0, 0.0],
    ['SI-Glob:AP-FOFB:CorrSetCurrZeroDuration-SP', 0, 0.0],
    ['SI-Glob:AP-FOFB:CHAccSatMax-SP', 0.0, 0.0],
    ['SI-Glob:AP-FOFB:CVAccSatMax-SP', 0.0, 0.0],
    ['SI-Glob:AP-FOFB:TimeFrameLen-SP', 0.0, 0.0],
    ['SI-Glob:AP-FOFB:CtrlrSyncUseEnblList-Sel', 0, 0.0],
    ['SI-Glob:AP-FOFB:KickBufferSize-SP', 0, 0.0],
    ['SI-Glob:AP-FOFB:RefOrbX-SP', [0.0, ]*160, 0.0],
    ['SI-Glob:AP-FOFB:RefOrbY-SP', [0.0, ]*160, 0.0],
    ['SI-Glob:AP-FOFB:BPMXEnblList-SP', [0, ]*160, 0.0],
    ['SI-Glob:AP-FOFB:BPMYEnblList-SP', [0, ]*160, 0.0],
    ['SI-Glob:AP-FOFB:CHEnblList-SP', [0, ]*80, 0.0],
    ['SI-Glob:AP-FOFB:CVEnblList-SP', [0, ]*80, 0.0],
    ['SI-Glob:AP-FOFB:UseRF-Sel', 0, 0.0],
    ['SI-Glob:AP-FOFB:RespMat-SP', [0.0, ]*51520, 0.0],
    ['SI-Glob:AP-FOFB:MinSingValue-SP', 0.0, 0.0],
    ['SI-Glob:AP-FOFB:TikhonovRegConst-SP', 0.0, 0.0],
    ['SI-Glob:AP-FOFB:InvRespMatNormMode-Sel', 0, 0.0],
]


pvs = _si_sofb + _si_fofb
pvs += _si_bbb_frontbackend + _si_bbb_l + _si_bbb_h + _si_bbb_v
_template_dict = {'pvs': pvs}
