/**
 * @license
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @fileoverview The interface for a Blockly component that can be registered.
 *    (Ex. Toolbox, Fields, Renderers)
 */

'use strict';

/**
 * The interface for a Blockly component that can be registered.
 *    (Ex. Toolbox, Fields, Renderers)
 * @namespace Blockly.IRegistrable
 */
goog.module('Blockly.IRegistrable');


/**
 * The interface for a Blockly component that can be registered.
 * @interface
 * @alias Blockly.IRegistrable
 */
const IRegistrable = function() {};

exports.IRegistrable = IRegistrable;
