import argparse, JsonParser, traceback
import Settings.Environment as Environment
import Settings.Configuration as Configuration
from EventHub.Response import Response
from EventHub.EventHubProducer import EventHubProducer

def run():
    events_json = JsonParser.parse(args.events)
    event_type = args.type
    client_code = args.code
    account_name = args.account
    env_name = args.env
    return send_events(event_type, env_name, client_code, account_name, events_json)

def send_events(event_type, env_name, client_code, account_name, events):
    try:
        Environment.set_environment(env_name)  
        producer = EventHubProducer(Configuration.get_connection_string(), Configuration.get_eventhub_name())
        producer.send_batch_with_partition_key(event_type, event_type, client_code, account_name, events)
        return Response(True, "").toJSON()
    except Exception as eh_err:
        return Response(False, traceback.format_exc()).toJSON()  

#Declare script parameters
parser = argparse.ArgumentParser()
parser.add_argument("--env", help="Sets environment. Development, Production, QA or Learn", type=str)
parser.add_argument("--code", help="Sets Storis client code", type=str)
parser.add_argument("--events", help="Sets Storis client code")
parser.add_argument("--account", help="Sets Storis Account name")
parser.add_argument("--type", help="Sets Storis Event type")

args, unknown = parser.parse_known_args()


    
