import logging
import pathlib

# Third party imports
import pandas as pd

# Local application imports
from asic.reader import FileReader

from ..metadata import FileItemInfo

logger = logging.getLogger(__name__)

afac_format = {
    "type": "csv",
    "sep": ";",
    "encoding": "cp1252",
    "dt_fields": {},
    "dtype": {
        "AGENTE": str,
        "PERDIDA REAL (kWh)": float,
        "DEMANDA REAL (kWh)": float,
        "GENERACION REAL (kWh)": float,
        "COMPRAS EN BOLSA (KWH)": float,
        "COMPRAS EN BOLSA ($)": float,
        "VENTAS EN BOLSA (KWH)": float,
        "VENTAS EN BOLSA ($)": float,
        "COMPRAS EN DESVIACION (KWH)": float,
        "COMPRAS EN DESVIACION ($)": float,
        "VENTAS EN DESVIACION (KWH)": float,
        "VENTAS EN DESVIACION ($)": float,
        "COMPRAS EN RECONCILIACION (KWH)": float,
        "COMPRAS EN RECONCILIACION ($)": float,
        "VENTAS EN RECONCILIACION (KWH)": float,
        "VENTAS EN RECONCILIACION ($)": float,
        "COMPRAS EN CONTRATOS (kWh)": float,
        "VENTAS EN CONTRATOS (kWh)": float,
        "COMPRAS ENERGIA EN BOLSA (KWH)": float,
        "COMPRAS ENERGIA EN BOLSA ($)": float,
        "VENTAS ENERGIA EN BOLSA (KWH)": float,
        "VENTAS ENERGIA EN BOLSA ($)": float,
        "VR CARGO POR CONFIABILIDAD ($)": float,
        "VD CARGO POR CONFIABILIDAD ($)": float,
        "NETO CXC ($)": float,
        "COMPRAS CARGO POR CONFIABILIDAD ($)": float,
        "VENTAS CARGO POR CONFIABILIDAD ($)": float,
        "COMPRAS EN BOLSA NACIONAL (KWH)": float,
        "COMPRAS EN BOLSA NACIONAL ($)": float,
        "VENTAS EN BOLSA NACIONAL (KWH)": float,
        "VENTAS EN BOLSA NACIONAL ($)": float,
        "COMPRAS EN BOLSA INTERNACIONAL (KWH)": float,
        "COMPRAS EN BOLSA INTERNACIONAL ($)": float,
        "VENTAS EN BOLSA INTERNACIONAL (KWH)": float,
        "VENTAS EN BOLSA INTERNACIONAL ($)": float,
        "SERVICIOS AGC ($)": float,
        "RESPONSABILIDAD COMERCIAL AGC (KWH)": float,
        "RESPONSABILIDAD COMERCIAL AGC ($)": float,
        "TOTAL COMPRAS ($)": float,
        "TOTAL VENTAS ($)": float,
        "VALOR A PAGAR POR SRPF ($)": float,
        "VALOR A RECIBIR POR SRPF ($)": float,
        "TOTAL RESTRICCIONES ($)": float,
        "RENTAS DE CONGESTION ($)": float,
        "RESTRICCIONES ALIVIADAS ($)": float,
        "VEBO (KWH)": float,
        "RENTAS DE CONGESTIÓN POR IMPORTACIÓN ($)": float,
        "DISTRIBUCIÓN SALDO NETO TIE EN MÉRITO ($)": float,
        "DISTRIBUCIÓN SALDO NETO TIE FUERA DE MÉRITO ($)": float,
        "COMPRAS BOLSA CON SALDO NETO TIE MÉRITO ($)": float,
        "RENDIMIENTOS FINANCIEROS POR EXPORTACIONES TIE($)": float,
        "ALIVIO POR CIOEF ($)": float,
        "COMPRAS NDC ($)": float,
        "VENTAS DESVIACIONES OEFH ($)": float,
        "COMPRAS DESVIACIONES OEFH ($)": float,
        "DEVOLUCION DINEROS DEL CARGO POR CONFIABILIDAD ($)": float,
        "COBRO DINERO CARGO POR CONFIABILIDAD ($)": float,
        "COMPRAS ARRANQUE Y PARADA ($)": float,
        "VENTAS ARRANQUE Y PARADA ($)": float,
        "Ventas por EEVE ($)": float,
        "Compras por EEVE ($)": float,
        "Restricciones por EEVE ($)": float,
        "Cobro uso respaldo($)": float,
        "Alivio restricciones RES 05/2010 ($)": float,
        "COMPRAS EN BOLSA TIES($)": float,
        " VENTAS EN BOLSA TIES ($)": float,
        " MAGNITUD EN Kwh  DE COMPRAS EN BOLSA DE TIES": float,
        " MAGNITUD EN kwh DE VENTAS EN BOLSA TIES": float,
        "ALIVIO POR EJECUCION DE GARANTIA ($)": float,
        "VALOR TOTAL EJECUCION DE GARANTIA ($)": float,
        "Alivio por VCSRCFVD($)": float,
        "VOEFV a cargo por la OEFV adquirida en la SRCFV($)": float,
        "VMOEFV a cargo al Margen del Precio MP SRCFV ($):": float,
        "Costo de Exportación ($)": float,
        "Total Costo de Exportación ($)": float,
        "Total de Generación Ideal en kWh del Agente": float,
        "Total de Holgura de AGC en kWh asignados al Agente": float,
        "Energía vendida y embalsada Asignada kWh": float,
        "VR Demanda Res 155/2014": float,
        "Alivio Asociado a la Resolución CREG 024/2015 en $": float,
        "Cobro Autogeneradores Res 024/2015": float,
        "Valor a favor para generador. Res 178/2015": float,
        "Valor a cargo para comercializador. Res 178/2015": float,
        "Valor a cargo para generador. Res 195/2015": float,
        "Valor a favor para generador. Res 195/2015": float,
        "Valor a favor para comercializador. Res 195/2015": float,
        "Valor a cargo para comercializador. Res 195/2015": float,
        "VALOR A CARGO PAGOS DE ENERGIA EXCEDENTARIA ($)": float,
        "VALOR A FAVOR POR ENERGIA EXCEDENTARIA ($)": float,
        "VC_RD resolución 011 de 2015": float,
        "VF_RD resolución 011 de 2015": float,
        "Valor a Favor delta ajuste RD": float,
        "Valor a Cargo delta ajuste RD": float,
        "VALOR A CARGO R026-2016 ($).": float,
        "VALOR A FAVOR R026-2016 ($).": float,
        "VALOR A FAVOR R029-2016 ($).": float,
        "RF039 resolución 039 de 2016": float,
        "RC039 resolución 039 de 2016": float,
        "Balance Final 029 de 2016": float,
        "Valor a cargo para comercializador. RES. 062 2013": float,
        "Valor a favor para generador. RES. 062 2013": float,
        "Valor del DE TIE. RES. 049 2018 (kWh)": float,
        "Valor del DE TIE. RES. 049 2018 ($)": float,
        "Magnitud desviación despacho. RES. 060 2019 (kWh)": float,
        "Valor Desviación Despacho. RES. 060 2019 ($)": float,
        "Magnitud desviación Redespacho. RES. 060 2019(kWh)": float,
        "Valor Desviación ReDespacho. RES. 060 2019 (kWh)": float,
        "Desviación Generación Variable. RES. 060 2019(kWh)": float,
        "Alivio desviaciones Res. CREG 060/2019 ($)": float,
        "VALOR PAGO AJUSTE RES. 140 2017 ($)": float,
        "VALOR COBRO AJUSTE RES. 140 2017 ($)": float,
        "VALOR PAGO EXCEDENTE RES. 140 2017 ($)": float,
        "VALOR COBRO FALTANTE RES. 140 2017 ($)": float,
    },
}


class AFAC(FileReader):
    def __init__(self):
        return super().__init__(afac_format.copy())


def afac_preprocess(filepath: pathlib.Path, item: FileItemInfo) -> pd.DataFrame:
    """
    AFAC: se publica un archivo por mes.
    versiones: TXR,TXF
    AGENTE:
     EPSC: el codigo del agente ##AQUI VA ENERBIT##
    """
    afac_reader = AFAC()
    total = afac_reader.read(filepath)
    if item.day is None:
        item.day = 1
    total["FECHA"] = f"{item.year:04d}-{item.month:02d}-{item.day:02d}"
    total["FECHA"] = pd.to_datetime(
        total["FECHA"],
        format="%Y-%m-%d",
    )
    total = total[total["AGENTE"] == item.agent]
    # retur_col = [
    #     "FECHA",
    #     "AGENTE",
    #     "PERDIDA REAL (kWh)",
    #     "DEMANDA REAL (kWh)",
    #     "GENERACION REAL (kWh)",
    #     "COMPRAS EN BOLSA (KWH)",
    #     "COMPRAS EN BOLSA ($)",
    #     "VENTAS EN BOLSA (KWH)",
    #     "VENTAS EN BOLSA ($)",
    #     "COMPRAS EN DESVIACION (KWH)",
    #     "COMPRAS EN DESVIACION ($)",
    #     "VENTAS EN DESVIACION (KWH)",
    #     "VENTAS EN DESVIACION ($)",
    #     "COMPRAS EN RECONCILIACION (KWH)",
    #     "COMPRAS EN RECONCILIACION ($)",
    #     "VENTAS EN RECONCILIACION (KWH)",
    #     "VENTAS EN RECONCILIACION ($)",
    #     "COMPRAS EN CONTRATOS (kWh)",
    #     "VENTAS EN CONTRATOS (kWh)",
    #     "COMPRAS ENERGIA EN BOLSA (KWH)",
    #     "COMPRAS ENERGIA EN BOLSA ($)",
    #     "VENTAS ENERGIA EN BOLSA (KWH)",
    #     "VENTAS ENERGIA EN BOLSA ($)",
    #     "VR CARGO POR CONFIABILIDAD ($)",
    #     "VD CARGO POR CONFIABILIDAD ($)",
    #     "NETO CXC ($)",
    #     "COMPRAS CARGO POR CONFIABILIDAD ($)",
    #     "VENTAS CARGO POR CONFIABILIDAD ($)",
    #     "COMPRAS EN BOLSA NACIONAL (KWH)",
    #     "COMPRAS EN BOLSA NACIONAL ($)",
    #     "VENTAS EN BOLSA NACIONAL (KWH)",
    #     "VENTAS EN BOLSA NACIONAL ($)",
    #     "COMPRAS EN BOLSA INTERNACIONAL (KWH)",
    #     "COMPRAS EN BOLSA INTERNACIONAL ($)",
    #     "VENTAS EN BOLSA INTERNACIONAL (KWH)",
    #     "VENTAS EN BOLSA INTERNACIONAL ($)",
    #     "SERVICIOS AGC ($)",
    #     "RESPONSABILIDAD COMERCIAL AGC (KWH)",
    #     "RESPONSABILIDAD COMERCIAL AGC ($)",
    #     "TOTAL COMPRAS ($)",
    #     "TOTAL VENTAS ($)",
    #     "VALOR A PAGAR POR SRPF ($)",
    #     "VALOR A RECIBIR POR SRPF ($)",
    #     "TOTAL RESTRICCIONES ($)",
    #     "RENTAS DE CONGESTION ($)",
    #     "RESTRICCIONES ALIVIADAS ($)",
    #     "VEBO (KWH)",
    #     "RENTAS DE CONGESTIÓN POR IMPORTACIÓN ($)",
    #     "DISTRIBUCIÓN SALDO NETO TIE EN MÉRITO ($)",
    #     "DISTRIBUCIÓN SALDO NETO TIE FUERA DE MÉRITO ($)",
    #     "COMPRAS BOLSA CON SALDO NETO TIE MÉRITO ($)",
    #     "RENDIMIENTOS FINANCIEROS POR EXPORTACIONES TIE($)",
    #     "ALIVIO POR CIOEF ($)",
    #     "COMPRAS NDC ($)",
    #     "VENTAS DESVIACIONES OEFH ($)",
    #     "COMPRAS DESVIACIONES OEFH ($)",
    #     "DEVOLUCION DINEROS DEL CARGO POR CONFIABILIDAD ($)",
    #     "COBRO DINERO CARGO POR CONFIABILIDAD ($)",
    #     "COMPRAS ARRANQUE Y PARADA ($)",
    #     "VENTAS ARRANQUE Y PARADA ($)",
    #     "Ventas por EEVE ($)",
    #     "Compras por EEVE ($)",
    #     "Restricciones por EEVE ($)",
    #     "Cobro uso respaldo($)",
    #     "Alivio restricciones RES 05/2010 ($)",
    #     "COMPRAS EN BOLSA TIES($)",
    #     " VENTAS EN BOLSA TIES ($)",
    #     " MAGNITUD EN Kwh  DE COMPRAS EN BOLSA DE TIES",
    #     " MAGNITUD EN kwh DE VENTAS EN BOLSA TIES",
    #     "ALIVIO POR EJECUCION DE GARANTIA ($)",
    #     "VALOR TOTAL EJECUCION DE GARANTIA ($)",
    #     "Alivio por VCSRCFVD($)",
    #     "VOEFV a cargo por la OEFV adquirida en la SRCFV($)",
    #     "VMOEFV a cargo al Margen del Precio MP SRCFV ($):",
    #     "Costo de Exportación ($)",
    #     "Total Costo de Exportación ($)",
    #     "Total de Generación Ideal en kWh del Agente",
    #     "Total de Holgura de AGC en kWh asignados al Agente",
    #     "Energía vendida y embalsada Asignada kWh",
    #     "VR Demanda Res 155/2014",
    #     "Alivio Asociado a la Resolución CREG 024/2015 en $",
    #     "Cobro Autogeneradores Res 024/2015",
    #     "Valor a favor para generador. Res 178/2015",
    #     "Valor a cargo para comercializador. Res 178/2015",
    #     "Valor a cargo para generador. Res 195/2015",
    #     "Valor a favor para generador. Res 195/2015",
    #     "Valor a favor para comercializador. Res 195/2015",
    #     "Valor a cargo para comercializador. Res 195/2015",
    #     "VALOR A CARGO PAGOS DE ENERGIA EXCEDENTARIA ($)",
    #     "VALOR A FAVOR POR ENERGIA EXCEDENTARIA ($)",
    #     "VC_RD resolución 011 de 2015",
    #     "VF_RD resolución 011 de 2015",
    #     "Valor a Favor delta ajuste RD",
    #     "Valor a Cargo delta ajuste RD",
    #     "VALOR A CARGO R026-2016 ($).",
    #     "VALOR A FAVOR R026-2016 ($).",
    #     "VALOR A FAVOR R029-2016 ($).",
    #     "RF039 resolución 039 de 2016",
    #     "RC039 resolución 039 de 2016",
    #     "Balance Final 029 de 2016",
    #     "Valor a cargo para comercializador. RES. 062 2013",
    #     "Valor a favor para generador. RES. 062 2013",
    #     "Valor del DE TIE. RES. 049 2018 (kWh)",
    #     "Valor del DE TIE. RES. 049 2018 ($)",
    #     "Magnitud desviación despacho. RES. 060 2019 (kWh)",
    #     "Valor Desviación Despacho. RES. 060 2019 ($)",
    #     "Magnitud desviación Redespacho. RES. 060 2019(kWh)",
    #     "Valor Desviación ReDespacho. RES. 060 2019 (kWh)",
    #     "Desviación Generación Variable. RES. 060 2019(kWh)",
    #     "Alivio desviaciones Res. CREG 060/2019 ($)",
    #     "VALOR PAGO AJUSTE RES. 140 2017 ($)",
    #     "VALOR COBRO AJUSTE RES. 140 2017 ($)",
    #     "VALOR PAGO EXCEDENTE RES. 140 2017 ($)"
    # ]
    return total
