#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection
from ...exceptions import NimOSAPIOperationUnsupported


class Token(Resource):
    """Manage user's session information.

    # Parameters
    id            : Object identifier for the session token.
    session_token : Token used for authentication.
    username      : User name for the session.
    password      : Password for the user. A password is required for creating a token.
    app_name      : Application name.
    sdk_name      : SDK name.
    source_ip     : IP address from which the session originates.
    creation_time : Time when this token was created.
    last_modified : Time when this token was last modified.
    expiry_time   : Time when this token will expire.
    server_uuid   : Non mandatory 36 character uuid returned by the server. Currently only the witness REST server returns one.
    """
    def report_user_details(self, **kwargs):
        """Reports the user details for this token.

        # Parameters
        id : ID for the session token.
        """

        return self._collection.report_user_details(
            self.id,
            **kwargs
        )

    def update(self, **kwargs):
        raise NimOSAPIOperationUnsupported("update operation not supported")


class TokenList(Collection):
    resource = Token
    resource_type = "tokens"

    def report_user_details(self, id, **kwargs):
        """Reports the user details for this token.

        # Parameters
        id : ID for the session token.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'report_user_details',
            id=id,
            **kwargs
        )

    def create(self, **kwargs):
        resp = self._client.create_resource(self.resource_type, **kwargs)
        return self.resource(resp['id'], resp, client=self._client, collection=self)

    def update(self, **kwargs):
        raise NimOSAPIOperationUnsupported("update operation not supported")
