#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection
from ...exceptions import NimOSAPIOperationUnsupported


class SpaceDomain(Resource):
    """A space domain is created for each application category and block size for each each pool.

    # Parameters
    id                       : Identifier for the space domain.
    pool_id                  : Identifier associated with the pool in the storage pool table.
    pool_name                : Name of the pool containing the space domain.
    app_category_id          : Identifier of the application category associated with the space domain.
    app_category_name        : Name of the application category associated with the space domain.
    perf_policy_names        : Name of the performance policies associated with the space domain.
    sample_rate              : Sample rate value.
    volume_count             : Number of volumes belonging to the space domain.
    deduped_volume_count     : Number of deduplicated volumes belonging to the space domain.
    volumes                  : Volumes belonging to the space domain.
    block_size               : Block size in bytes of volumes belonging to the space domain.
    deduped                  : Volumes in space domain are deduplicated by default.
    encrypted                : Volumes in space domain are encrypted.
    usage                    : Physical space usage of volumes in the space domain.
    vol_logical_usage        : Logical usage of volumes in the space domain.
    snap_logical_usage       : Logical usage of snapshots in the space domain.
    vol_mapped_usage         : Mapped usage of volumes in the space domain, useful for computing clone savings.
    logical_dedupe_usage     : Logical space usage of volumes when deduped.
    physical_dedupe_usage    : Physical space usage of volumes including snapshots when deduped.
    savings_compression      : Space usage savings in the space domain due to compression.
    savings_dedupe           : Space usage savings in the space domain due to deduplication.
    savings_clone            : Space usage savings in the space domain due to cloning of volumes.
    compressed_usage_bytes   : Compressed usage of volumes and snapshots in the space domain.
    uncompressed_usage_bytes : Uncompressed usage of volumes and snapshots in the space domain.
    compression_ratio        : Compression savings for the space domain expressed as ratio.
    dedupe_ratio             : Deduplication savings for the space domain expressed as ratio.
    clone_ratio              : Clone savings for the space domain expressed as ratio.
    """

    def create(self, **kwargs):
        raise NimOSAPIOperationUnsupported("create operation not supported")

    def delete(self, **kwargs):
        raise NimOSAPIOperationUnsupported("delete operation not supported")

    def update(self, **kwargs):
        raise NimOSAPIOperationUnsupported("update operation not supported")


class SpaceDomainList(Collection):
    resource = SpaceDomain
    resource_type = "space_domains"

    def create(self, **kwargs):
        raise NimOSAPIOperationUnsupported("create operation not supported")

    def delete(self, **kwargs):
        raise NimOSAPIOperationUnsupported("delete operation not supported")

    def update(self, **kwargs):
        raise NimOSAPIOperationUnsupported("update operation not supported")
