#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection


class ProtectionSchedule(Resource):
    """Manage protection schedules used in protection templates.

    # Parameters
    id                            : Identifier for protection schedule.
    name                          : Name of snapshot schedule to create.
    description                   : Description of the schedule.
    volcoll_or_prottmpl_type      : Type of the protection policy this schedule is attached to. Valid values are protection_template and volume_collection.
    volcoll_or_prottmpl_id        : Identifier of the protection policy (protection_template or volume_collection) in which this protection schedule is attached to.
    period                        : Repeat interval for snapshots with respect to the period_unit.  For example, a value of 2 with the 'period_unit' of 'hours' results in one
                                    snapshot every 2 hours.
    period_unit                   : Time unit over which to take the number of snapshots specified in 'period'. For example, a value of 'days' with a 'period' of '1' results in
                                    one snapshot every day.
    at_time                       : Time of day when snapshot should be taken. In case repeat frequency specifies more than one snapshot in a day then the until_time option
                                    specifies until what time of day to take snapshots.
    until_time                    : Time of day to stop taking snapshots. Applicable only when repeat frequency specifies more than one snapshot in a day.
    days                          : Specifies which days snapshots should be taken.
    num_retain                    : Number of snapshots to retain. If replication is enabled on this schedule the array will always retain the latest replicated snapshot, which
                                    may exceed the specified retention value. This is necessary to ensure efficient replication performance.
    downstream_partner            : Specifies the partner name if snapshots created by this schedule should be replicated.
    downstream_partner_name       : Specifies the partner name if snapshots created by this schedule should be replicated.
    downstream_partner_id         : Specifies the partner ID if snapshots created by this schedule should be replicated. In an update operation, if snapshots should be replicated,
                                    set this attribute to the ID of the replication partner. If snapshots should not be replicated, set this attribute to the empty string.
    upstream_partner_name         : Specifies the partner name from which snapshots created by this schedule are replicated.
    upstream_partner_id           : Specifies the partner ID from which snapshots created by this schedule are replicated.
    replicate_every               : Specifies which snapshots should be replicated. If snapshots are replicated and this option is not specified, every snapshot is replicated.
    num_retain_replica            : Number of snapshots to retain on the replica.
    repl_alert_thres              : Replication alert threshold in seconds. If the replication of a snapshot takes more than this amount of time to complete an alert will be
                                    generated. Enter 0 to disable this alert.
    snap_verify                   : Run verification tool on snapshot created by this schedule. This option can only be used with snapshot schedules of a protection template that
                                    has application synchronization. The tool used to verify snapshot depends on the type of application. For example, if application
                                    synchronization is VSS and the application ID is Exchange, eseutil tool is run on the snapshots. If verification fails, the logs are not
                                    truncated.
    skip_db_consistency_check     : Skip consistency check for database files on snapshots created by this schedule. This option only applies to snapshot schedules of a protection
                                    template with application synchronization set to VSS, application ID set to MS Exchange 2010 or later w/DAG, this schedule's snap_verify option
                                    set to yes, and its disable_appsync option set to false. Skipping consistency checks is only recommended if each database in a DAG has multiple
                                    copies.
    disable_appsync               : Disables application synchronized snapshots and creates crash consistent snapshots instead.
    schedule_type                 : Normal schedules have internal timers which drive snapshot creation. An externally driven schedule has no internal timers. All snapshot
                                    activity is driven by an external trigger. In other words, these schedules are used only for externally driven manual snapshots.
    active                        : A schedule is active only if it is owned by the same owner as the volume collection. Only active schedules of a volume collection participate
                                    in the creation of snapshots and replication.
    creation_time                 : Time when this protection schedule was created.
    last_modified                 : Time when this protection schedule was last modified.
    last_mod_sched_time           : Time when the timing of the protection schedule was last modified.
    last_replicated_snapcoll_name : Specifies the name of last replicated snapshot collection.
    last_replicated_snapcoll_id   : Specifies the snapshot collection ID of last replicated snapshot collection.
    last_replicated_at_time       : Time when last snapshot collection was replicated.
    last_snap_time                : Time when last snapshot was taken.
    next_snap_time                : Time when next snapshot will be taken.
    next_repl_snap_time           : Time when next snapshot will be replicated.
    snap_counter                  : This is only used by custom read handler for internal calculations.
    sched_owner_id                : Identifier of the group that owns this schedule.
    sched_owner_name              : Name of the group that owns this schedule.
    last_config_change_time       : The last timing configutation changed.
    vol_status_list               : The list of the replication status of volumes undergoing replication.
    sync_repl_vol_status_list     : A list of the replication status of volumes undergoing synchronous replication.
    use_downstream_for_DR         : Break synchronous replication for the specified volume collection and present downstream volumes to host(s). Downstream volumes in the volume
                                    collection will be set to online and presented to the host(s) using new serial and LUN numbers. No changes will be made to the upstream
                                    volumes, their serial and LUN numbers, and their online state. The existing ACLs on the upstream volumes will be copied to the downstream
                                    volumes. Use this in conjunction with an empty downstream_partner_id. This unconfigures synchronous replication when the partner is removed
                                    from the last replicating schedule in the specified volume collection and presents the downstream volumes to host(s). Host(s) will need to be
                                    configured to access the new volumes with the newly assigned serial and LUN numbers. Use this option to expose downstream volumes in a
                                    synchronously replicated volume collection to host(s) only when the upstream partner is confirmed to be down and there is no communication
                                    between partners. Do not execute this operation if a previous Group Management Service takeover has been performed on a different array. Do not
                                    perform a subsequent Group Management Service takeover on a different array as it will lead to irreconcilable conflicts. This limitation is
                                    cleared once the Group management service backup array has successfully synchronized after reconnection.
    """


class ProtectionScheduleList(Collection):
    resource = ProtectionSchedule
    resource_type = "protection_schedules"
