#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection


class Pool(Resource):
    """Manage pools. Pools are an aggregation of arrays.

    # Parameters
    id                            : Identifier for the pool.
    name                          : Name of pool.
    full_name                     : Fully qualified name of pool.
    search_name                   : Name of pool used for object search.
    description                   : Text description of pool.
    creation_time                 : Time when this pool was created.
    last_modified                 : Time when this pool was last modified.
    capacity                      : Total storage space of the pool in bytes.
    usage                         : Used space of the pool in bytes.
    savings                       : Overall space usage savings in the pool.
    savings_data_reduction        : Space usage savings in the pool that does not include thin-provisioning savings.
    savings_compression           : Space usage savings in the pool due to compression.
    savings_dedupe                : Space usage savings in the pool due to deduplication.
    savings_clone                 : Space usage savings in the pool due to cloning of volumes.
    savings_vol_thin_provisioning : Space usage savings in the pool due to thin provisioning of volumes.
    reserve                       : Reserved space of the pool in bytes. Sum of volume reserve in the pool.
    unused_reserve                : Unused reserve space of the pool in bytes.
    free_space                    : Free space of the pool in bytes.
    cache_capacity                : Total usable cache capacity of the pool in bytes.
    pinnable_cache_capacity       : Total pinnable cache capacity of the pool in bytes.
    pinned_cache_capacity         : Total pinned cache capacity of the pool in bytes.
    dedupe_capacity_bytes         : The dedupe capacity of a hybrid pool. Does not apply to all-flash pools.
    dedupe_usage_bytes            : The dedupe usage of a hybrid pool. Does not apply to all-flash pools.
    savings_ratio                 : Overall space usage savings in the pool expressed as ratio.
    data_reduction_ratio          : Space usage savings in the pool expressed as ratio that does not include thin-provisioning savings.
    compression_ratio             : Compression savings for the pool expressed as ratio.
    dedupe_ratio                  : Dedupe savings for the pool expressed as ratio.
    clone_ratio                   : Clone savings for the pool expressed as ratio.
    vol_thin_provisioning_ratio   : Thin provisioning savings for volumes in the pool expressed as ratio.
    snapcoll_count                : Snapshot collection count.
    snap_count                    : Snapshot count.
    array_count                   : Number of arrays in the pool.
    vol_count                     : Number of volumes assigned to the pool.
    array_list                    : List of arrays in the pool with detailed information. When create/update array list, only arrays' ID is required.
    unassigned_array_list         : List of arrays being unassigned from the pool.
    vol_list                      : The list of volumes in the pool.
    pinned_vol_list               : The list of pinned volumes in the pool.
    folder_list                   : The list of fully qualified names of folders in the pool.
    force                         : Forcibly delete the specified pool even if it contains deleted volumes whose space is being reclaimed. Forcibly remove an array from array_list
                                    via an update operation even if the array is not reachable. There should no volumes currently in the pool for the forced update operation to
                                    succeed.
    usage_valid                   : Indicates whether the usage of pool is valid.
    uncompressed_vol_usage_bytes  : Uncompressed usage of volumes in the pool.
    uncompressed_snap_usage_bytes : Uncompressed usage of snapshots in the pool.
    all_flash                     : Indicate whether the pool is an all_flash pool.
    dedupe_capable                : Indicates whether the pool is capable of hosting deduped volumes.
    dedupe_all_volumes_capable    : Indicates whether the pool can enable dedupe by default.
    dedupe_all_volumes            : Indicates if dedupe is enabled by default for new volumes on this pool.
    is_default                    : Indicates if this is the default pool.
    """
    def merge(self, target_pool_id, **kwargs):
        """Merge the specified pool into the target pool. All volumes on the specified pool are moved to the target pool and the specified pool is then deleted. All the arrays in the
        pool are assigned to the target pool.

        # Parameters
        id             : ID of the specified pool.
        target_pool_id : ID of the target pool.
        force          : Forcibly merge the specified pool into target pool.
        """

        return self._collection.merge(
            self.id,
            target_pool_id,
            **kwargs
        )


class PoolList(Collection):
    resource = Pool
    resource_type = "pools"

    def merge(self, id, target_pool_id, **kwargs):
        """Merge the specified pool into the target pool. All volumes on the specified pool are moved to the target pool and the specified pool is then deleted. All the arrays in the
        pool are assigned to the target pool.

        # Parameters
        id             : ID of the specified pool.
        target_pool_id : ID of the target pool.
        force          : Forcibly merge the specified pool into target pool.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'merge',
            id=id,
            target_pool_id=target_pool_id,
            **kwargs
        )
