#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection
from ...exceptions import NimOSAPIOperationUnsupported


class KeyManager(Resource):
    """Key Manager stores encryption keys for the array volumes / dedupe domains.

    # Parameters
    id          : Identifier for External Key Manager.
    name        : Name of external key manager.
    description : Description of external key manager.
    hostname    : Hostname or IP Address for the External Key Manager.
    port        : Port number for the External Key Manager.
    protocol    : KMIP protocol supported by External Key Manager.
    username    : External Key Manager username. String up to 255 printable characters.
    password    : External Key Manager user password. String up to 255 printable characters.
    active      : Whether the given key manager is active or not.
    status      : Connection status of a given external key manager.
    vendor      : KMIP vendor name.
    """
    def remove(self, **kwargs):
        """Remove external key manager. You must migrate the keys to an inactive external key manager before removing the active key manager. If you remove the active external key
        manager the passphrase is used to enable the internal key manager.

        # Parameters
        id         : ID of the external key manager.
        passphrase : Passphrase used to protect the master key, required during deletion of external key manager.
        """

        return self._collection.remove(
            self.id,
            **kwargs
        )
    def migrate_keys(self, **kwargs):
        """Migrate volume encryption keys from the active key manager to the destination id given in the input. After successfully migrating the encryption keys, the destination key
        manager is made the active key manager.

        # Parameters
        id : ID of the destination external key manager.
        """

        return self._collection.migrate_keys(
            self.id,
            **kwargs
        )

    def delete(self, **kwargs):
        raise NimOSAPIOperationUnsupported("delete operation not supported")


class KeyManagerList(Collection):
    resource = KeyManager
    resource_type = "key_managers"

    def remove(self, id, **kwargs):
        """Remove external key manager. You must migrate the keys to an inactive external key manager before removing the active key manager. If you remove the active external key
        manager the passphrase is used to enable the internal key manager.

        # Parameters
        id         : ID of the external key manager.
        passphrase : Passphrase used to protect the master key, required during deletion of external key manager.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'remove',
            id=id,
            **kwargs
        )

    def migrate_keys(self, id, **kwargs):
        """Migrate volume encryption keys from the active key manager to the destination id given in the input. After successfully migrating the encryption keys, the destination key
        manager is made the active key manager.

        # Parameters
        id : ID of the destination external key manager.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'migrate_keys',
            id=id,
            **kwargs
        )

    def delete(self, **kwargs):
        raise NimOSAPIOperationUnsupported("delete operation not supported")
