#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection


class Folder(Resource):
    """Folders are a way to group volumes, as well as a way to apply space constraints to them.

    # Parameters
    id                            : Identifier for the folder.
    name                          : Name of folder.
    fqn                           : Fully qualified name of folder in the pool.
    full_name                     : Fully qualified name of folder in the group.
    search_name                   : Name of folder used for object search.
    description                   : Text description of folder.
    pool_name                     : Name of the pool where the folder resides.
    pool_id                       : ID of the pool where the folder resides.
    limit_bytes_specified         : Indicates whether the folder has a limit.
    limit_bytes                   : Folder limit size in bytes. By default, a folder (except SMIS and VVol types) does not have a limit. If limit_bytes is not specified when a
                                    folder is created, or if limit_bytes is set to the largest possible 64-bit signed integer (9223372036854775807), then the folder has no limit.
                                    Otherwise, a limit smaller than the capacity of the pool can be set. On output, if the folder has a limit, the limit_bytes_specified attribute
                                    will be true and limit_bytes will be the limit. If the folder does not have a limit, the limit_bytes_specified attribute will be false and
                                    limit_bytes will be interpreted based on the value of the usage_valid attribute. If the usage_valid attribute is true, limits_byte will be the
                                    capacity of the pool. Otherwise, limits_bytes is not meaningful and can be null. SMIS and VVol folders require a size limit. This attribute is
                                    superseded by limit_size_bytes.
    limit_size_bytes              : Folder size limit in bytes. If limit_size_bytes is not specified when a folder is created, or if limit_size_bytes is set to -1, then the folder
                                    has no limit. Otherwise, a limit smaller than the capacity of the pool can be set. Folders with an agent_type of 'smis' or 'vvol' must have a
                                    size limit.
    provisioned_limit_size_bytes  : Limit on the provisioned size of volumes in a folder. If provisioned_limit_size_bytes is not specified when a folder is created, or if
                                    provisioned_limit_size_bytes is set to -1, then the folder has no provisioned size limit.
    overdraft_limit_pct           : Amount of space to consider as overdraft range for this folder as a percentage of folder used limit. Valid values are from 0% - 200%. This is
                                    the limit above the folder usage limit beyond which enforcement action(volume offline/non-writable) is issued.
    capacity_bytes                : Capacity of the folder in bytes. If the folder's size has a usage limit, capacity_bytes will be the folder's usage limit. If the folder's size
                                    does not have a usage limit, capacity_bytes will be the pool's capacity. This field is meaningful only when the usage_valid attribute is true.
    free_space_bytes              : Free space in the folder in bytes. If the folder has a usage limit, free_space_bytes will be the folder's free space (the folder's usage limit
                                    minus the folder's space usage). If the folder does not have a usage limit, free_space_bytes will be the pool's free space. This field is
                                    meaningful only when the usage_valid attribute is true.
    provisioned_bytes             : Sum of provisioned size of volumes in the folder.
    usage_bytes                   : Sum of mapped usage and snapshot uncompressed usage of volumes in the folder.
    volume_mapped_bytes           : Sum of mapped usage of volumes in the folder.
    usage_valid                   : Indicate whether the space usage attributes of folder are valid.
    agent_type                    : External management agent type.
    inherited_vol_perfpol_id      : Identifier of the default performance policy for a newly created volume.
    inherited_vol_perfpol_name    : Name of the default performance policy for a newly created volume.
    unused_reserve_bytes          : Unused reserve of volumes in the folder in bytes. This field is meaningful only when the usage_valid attribute is true.
    unused_snap_reserve_bytes     : Unused reserve of snapshots of volumes in the folder in bytes. This field is meaningful only when the usage_valid attribute is true.
    compressed_vol_usage_bytes    : Compressed usage of volumes in the folder. This field is meaningful only when the usage_valid attribute is true.
    compressed_snap_usage_bytes   : Compressed usage of snapshots in the folder. This field is meaningful only when the usage_valid attribute is true.
    uncompressed_vol_usage_bytes  : Uncompressed usage of volumes in the folder. This field is meaningful only when the usage_valid attribute is true.
    uncompressed_snap_usage_bytes : Uncompressed usage of snapshots in the folder. This field is meaningful only when the usage_valid attribute is true.
    vol_compression_ratio         : Compression ratio of volumes in the folder. This field is meaningful only when the usage_valid attribute is true.
    snap_compression_ratio        : Compression ratio of snapshots in the folder. This field is meaningful only when the usage_valid attribute is true.
    compression_ratio             : Compression savings for the folder expressed as ratio. This field is meaningful only when the usage_valid attribute is true.
    creation_time                 : Time when this folder was created.
    last_modified                 : Time when this folder was last modified.
    num_snaps                     : Number of snapshots inside the folder. This attribute is deprecated and has no meaningful value.
    num_snapcolls                 : Number of snapshot collections inside the folder. This attribute is deprecated and has no meaningful value.
    app_uuid                      : Application identifier of the folder.
    volume_list                   : List of volumes contained by the folder.
    appserver_id                  : Identifier of the application server associated with the folder.
    appserver_name                : Name of the application server associated with the folder.
    folset_id                     : Identifier of the folder set associated with the folder. Only VVol folder can be associated with the folder set. The folder and the containing
                                    folder set must be associated with the same application server.
    folset_name                   : Name of the folder set associated with the folder. Only VVol folder can be associated with the folder set. The folder and the containing folder
                                    set must be associated with the same application server.
    limit_iops                    : IOPS limit for this folder. If limit_iops is not specified when a folder is created, or if limit_iops is set to -1, then the folder has no IOPS
                                    limit. IOPS limit should be in range [256, 4294967294] or -1 for unlimited.
    limit_mbps                    : Throughput limit for this folder in MB/s. If limit_mbps is not specified when a folder is created, or if limit_mbps is set to -1, then the
                                    folder has no throughput limit. MBPS limit should be in range [1, 4294967294] or -1 for unlimited.
    access_protocol               : Access protocol of the folder. This attribute is used by the VASA Provider to determine the access protocol of the bind request. If not
                                    specified in the creation request, it will be the access protocol supported by the group. If the group supports multiple protocols, the default
                                    will be Fibre Channel. This field is meaningful only to VVol folder.
    tenant_id                     : Tenant ID of the folder. This is used to determine what tenant context the folder belongs to.
    """
    def set_dedupe(self, dedupe_enabled, **kwargs):
        """Set dedupe enabled/disabled for all applicable volumes inside a folder.

        # Parameters
        dedupe_enabled : Enable/disable dedupe.
        id             : Folder containing the volumes to enable/disable dedupe on.
        """

        return self._collection.set_dedupe(
            self.id,
            dedupe_enabled,
            **kwargs
        )


class FolderList(Collection):
    resource = Folder
    resource_type = "folders"

    def set_dedupe(self, id, dedupe_enabled, **kwargs):
        """Set dedupe enabled/disabled for all applicable volumes inside a folder.

        # Parameters
        dedupe_enabled : Enable/disable dedupe.
        id             : Folder containing the volumes to enable/disable dedupe on.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'set_dedupe',
            dedupe_enabled=dedupe_enabled,
            id=id,
            **kwargs
        )
