#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection
from ...exceptions import NimOSAPIOperationUnsupported


class FibreChannelInterface(Resource):
    """Represent information of specified Fibre Channel interfaces. Fibre Channel interfaces are hosted on Fibre Channel ports to provide data access.

    # Parameters
    id                   : Identifier for the Fibre Channel interface.
    array_name_or_serial : Name or serial number of array where the interface is hosted.
    partial_response_ok  : Indicate that it is ok to provide partially available response.
    controller_name      : Name (A or B) of the controller where the interface is hosted.
    fc_port_id           : ID of the port with which the interface is associated.
    name                 : Name of Fibre Channel interface.
    wwnn                 : WWNN (World Wide Node Name) for this Fibre Channel interface.
    wwpn                 : WWPN (World Wide Port Name) for this Fibre Channel interface.
    peerzone             : Active peer zone for this Fibre Channel interface.
    online               : Identify whether the Fibre Channel interface is online.
    firmware_version     : Version of the Fibre Channel firmware.
    logical_port_number  : Logical port number for the Fibre Channel port.
    fc_port_name         : Name of Fibre Channel port.
    bus_location         : PCI bus location of the HBA for this Fibre Channel port.
    slot                 : HBA slot number for this Fibre Channel port.
    orientation          : Orientation of FC ports on a HBA. An orientation of 'right_to_left' indicates that ports are ordered as 3,2,1,0 on the slot. Possible values:
                           'left_to_right', 'right_to_left'.
    port                 : HBA port number for this Fibre Channel port.
    link_info            : Information about the Fibre Channel link at which interface is operating.
    fabric_info          : Fibre Channel fabric information.
    """

    def create(self, **kwargs):
        raise NimOSAPIOperationUnsupported("create operation not supported")

    def delete(self, **kwargs):
        raise NimOSAPIOperationUnsupported("delete operation not supported")


class FibreChannelInterfaceList(Collection):
    resource = FibreChannelInterface
    resource_type = "fibre_channel_interfaces"

    def create(self, **kwargs):
        raise NimOSAPIOperationUnsupported("create operation not supported")

    def delete(self, **kwargs):
        raise NimOSAPIOperationUnsupported("delete operation not supported")
