# Generated by Django 3.0.8 on 2020-07-24 23:56

from django.contrib.auth.management import create_permissions
from django.db import migrations


def delete_notification_user_permissions(apps, schema_editor):
    Permission = apps.get_model('auth', 'Permission')
    Permission.objects.filter(
        content_type__app_label='openwisp_notifications',
        content_type__model='notificationuser',
    ).delete()


def populate_notification_user_permissions(apps, schema_editor):
    # Populate Permissions
    app_config = apps.get_app_config('openwisp_notifications')
    app_config.models_module = True
    create_permissions(app_config, apps=apps, verbosity=0)
    app_config.models_module = None


class Migration(migrations.Migration):

    dependencies = [
        ('openwisp_notifications', '0004_notificationsetting'),
    ]

    operations = [
        migrations.RunPython(
            delete_notification_user_permissions,
            reverse_code=populate_notification_user_permissions,
        ),
        migrations.DeleteModel(name='NotificationUser'),
    ]
