# Copyright Iris contributors
#
# This file is part of Iris and is released under the LGPL license.
# See COPYING and COPYING.LESSER in the root of the repository for full
# licensing details.
"""
This file contains a dictionary of standard value names that are mapped
to another dictionary of other standard name attributes. Currently only
the `canonical_unit` exists in these attribute dictionaries.

This file is automatically generated. Do not edit this file by hand.

The file will be generated during a standard build/installation::

    python setup.py build
    python setup.py install

Also, the file can be re-generated in the source distribution via::

    python setup.py std_names

Or for more control (e.g. to use an alternative XML file) via::

    python tools/generate_std_names.py XML_FILE MODULE_FILE

"""

STD_NAMES = {'acoustic_signal_roundtrip_travel_time_in_sea_water': {'canonical_units': 's'},
 'aerodynamic_particle_diameter': {'canonical_units': 'm'},
 'aerodynamic_resistance': {'canonical_units': 'm-1 s'},
 'aerosol_angstrom_exponent': {'canonical_units': '1'},
 'age_of_sea_ice': {'canonical_units': 'year'},
 'age_of_stratospheric_air': {'canonical_units': 's'},
 'age_of_surface_snow': {'canonical_units': 'day'},
 'aggregate_quality_flag': {'canonical_units': '1'},
 'air_density': {'canonical_units': 'kg m-3'},
 'air_equivalent_potential_temperature': {'canonical_units': 'K'},
 'air_equivalent_temperature': {'canonical_units': 'K'},
 'air_potential_temperature': {'canonical_units': 'K'},
 'air_pressure': {'canonical_units': 'Pa'},
 'air_pressure_anomaly': {'canonical_units': 'Pa'},
 'air_pressure_at_cloud_base': {'canonical_units': 'Pa'},
 'air_pressure_at_cloud_top': {'canonical_units': 'Pa'},
 'air_pressure_at_convective_cloud_base': {'canonical_units': 'Pa'},
 'air_pressure_at_convective_cloud_top': {'canonical_units': 'Pa'},
 'air_pressure_at_freezing_level': {'canonical_units': 'Pa'},
 'air_pressure_at_mean_sea_level': {'canonical_units': 'Pa'},
 'air_pressure_at_sea_level': {'canonical_units': 'Pa'},
 'air_pressure_at_top_of_atmosphere_model': {'canonical_units': 'Pa'},
 'air_pseudo_equivalent_potential_temperature': {'canonical_units': 'K'},
 'air_pseudo_equivalent_temperature': {'canonical_units': 'K'},
 'air_temperature': {'canonical_units': 'K'},
 'air_temperature_anomaly': {'canonical_units': 'K'},
 'air_temperature_at_cloud_top': {'canonical_units': 'K'},
 'air_temperature_at_effective_cloud_top_defined_by_infrared_radiation': {'canonical_units': 'K'},
 'air_temperature_lapse_rate': {'canonical_units': 'K m-1'},
 'air_temperature_threshold': {'canonical_units': 'K'},
 'altimeter_range': {'canonical_units': 'm'},
 'altimeter_range_correction_due_to_dry_troposphere': {'canonical_units': 'm'},
 'altimeter_range_correction_due_to_ionosphere': {'canonical_units': 'm'},
 'altimeter_range_correction_due_to_wet_troposphere': {'canonical_units': 'm'},
 'altitude': {'canonical_units': 'm'},
 'altitude_at_top_of_atmosphere_model': {'canonical_units': 'm'},
 'altitude_at_top_of_dry_convection': {'canonical_units': 'm'},
 'ambient_aerosol_particle_diameter': {'canonical_units': 'm'},
 'amplitude_of_global_average_sea_level_change': {'canonical_units': 'm'},
 'angle_of_emergence': {'canonical_units': 'degree'},
 'angle_of_incidence': {'canonical_units': 'degree'},
 'angle_of_rotation_from_east_to_x': {'canonical_units': 'degree'},
 'angle_of_rotation_from_east_to_y': {'canonical_units': 'degree'},
 'angle_of_rotation_from_solar_azimuth_to_platform_azimuth': {'canonical_units': 'degree'},
 'angstrom_exponent_of_ambient_aerosol_in_air': {'canonical_units': '1'},
 'apparent_air_temperature': {'canonical_units': 'K'},
 'apparent_oxygen_utilization': {'canonical_units': 'mol kg-1'},
 'area_fraction': {'canonical_units': '1'},
 'area_fraction_below_surface': {'canonical_units': '1'},
 'area_fraction_of_day_defined_by_solar_zenith_angle': {'canonical_units': '1'},
 'area_fraction_of_night_defined_by_solar_zenith_angle': {'canonical_units': '1'},
 'area_fraction_of_twilight_defined_by_solar_zenith_angle': {'canonical_units': '1'},
 'area_type': {'canonical_units': None},
 'asymmetry_factor_of_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_absolute_vorticity': {'canonical_units': 's-1'},
 'atmosphere_absorption_optical_thickness_due_to_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_black_carbon_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_dust_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_dust_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_particulate_organic_matter_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_particulate_organic_matter_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_sea_salt_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_seasalt_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_seasalt_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_sulfate_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_absorption_optical_thickness_due_to_sulfate_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_boundary_layer_thickness': {'canonical_units': 'm'},
 'atmosphere_cloud_condensed_water_content': {'canonical_units': 'kg m-2'},
 'atmosphere_cloud_ice_content': {'canonical_units': 'kg m-2'},
 'atmosphere_cloud_liquid_water_content': {'canonical_units': 'kg m-2'},
 'atmosphere_content_of_sulfate_aerosol': {'canonical_units': 'kg m-2'},
 'atmosphere_convective_available_potential_energy': {'canonical_units': 'J '
                                                                         'kg-1'},
 'atmosphere_convective_available_potential_energy_wrt_surface': {'canonical_units': 'J '
                                                                                     'kg '
                                                                                     '-1'},
 'atmosphere_convective_cloud_condensed_water_content': {'canonical_units': 'kg '
                                                                            'm-2'},
 'atmosphere_convective_cloud_liquid_water_content': {'canonical_units': 'kg '
                                                                         'm-2'},
 'atmosphere_convective_inhibition': {'canonical_units': 'J kg -1'},
 'atmosphere_convective_inhibition_wrt_surface': {'canonical_units': 'J kg -1'},
 'atmosphere_convective_mass_flux': {'canonical_units': 'kg m-2 s-1'},
 'atmosphere_downdraft_convective_mass_flux': {'canonical_units': 'kg m-2 s-1'},
 'atmosphere_dry_energy_content': {'canonical_units': 'J m-2'},
 'atmosphere_dry_static_energy_content': {'canonical_units': 'J m-2'},
 'atmosphere_eastward_stress_due_to_gravity_wave_drag': {'canonical_units': 'Pa'},
 'atmosphere_energy_content': {'canonical_units': 'J m-2'},
 'atmosphere_enthalpy_content': {'canonical_units': 'J m-2'},
 'atmosphere_heat_diffusivity': {'canonical_units': 'm2 s-1'},
 'atmosphere_helicity': {'canonical_units': 'm2 s-2'},
 'atmosphere_horizontal_streamfunction': {'canonical_units': 'm2 s-1'},
 'atmosphere_horizontal_velocity_potential': {'canonical_units': 'm2 s-1'},
 'atmosphere_hybrid_height_coordinate': {'canonical_units': 'm'},
 'atmosphere_hybrid_sigma_pressure_coordinate': {'canonical_units': '1'},
 'atmosphere_kinetic_energy_content': {'canonical_units': 'J m-2'},
 'atmosphere_layer_thickness_expressed_as_geopotential_height_difference': {'canonical_units': 'm'},
 'atmosphere_level_of_free_convection': {'canonical_units': 'm'},
 'atmosphere_level_of_free_convection_wrt_surface': {'canonical_units': 'm'},
 'atmosphere_lifting_condensation_level': {'canonical_units': 'm'},
 'atmosphere_lifting_condensation_level_wrt_surface': {'canonical_units': 'm'},
 'atmosphere_ln_pressure_coordinate': {'canonical_units': '1'},
 'atmosphere_mass_content_of_acetic_acid': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_aceto_nitrile': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_alkanes': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_alkenes': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_alpha_hexachlorocyclohexane': {'canonical_units': 'kg '
                                                                               'm-2'},
 'atmosphere_mass_content_of_alpha_pinene': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_ammonia': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_ammonium_dry_aerosol': {'canonical_units': 'kg '
                                                                        'm-2'},
 'atmosphere_mass_content_of_ammonium_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                                  'm-2'},
 'atmosphere_mass_content_of_anthropogenic_nmvoc_expressed_as_carbon': {'canonical_units': 'kg '
                                                                                           'm-2'},
 'atmosphere_mass_content_of_aromatic_compounds': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_atomic_bromine': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_atomic_chlorine': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_atomic_nitrogen': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_benzene': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_beta_pinene': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_biogenic_nmvoc_expressed_as_carbon': {'canonical_units': 'kg '
                                                                                      'm-2'},
 'atmosphere_mass_content_of_black_carbon_dry_aerosol': {'canonical_units': 'kg '
                                                                            'm-2'},
 'atmosphere_mass_content_of_bromine_chloride': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_bromine_monoxide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_bromine_nitrate': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_brox_expressed_as_bromine': {'canonical_units': 'kg '
                                                                             'm-2'},
 'atmosphere_mass_content_of_butane': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_carbon_dioxide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_carbon_monoxide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_carbon_tetrachloride': {'canonical_units': 'kg '
                                                                        'm-2'},
 'atmosphere_mass_content_of_cfc11': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_cfc113': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_cfc113a': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_cfc114': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_cfc115': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_cfc12': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_chlorine_dioxide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_chlorine_monoxide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_chlorine_nitrate': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_cloud_condensed_water': {'canonical_units': 'kg '
                                                                         'm-2'},
 'atmosphere_mass_content_of_cloud_ice': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_cloud_liquid_water': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_clox_expressed_as_chlorine': {'canonical_units': 'kg '
                                                                              'm-2'},
 'atmosphere_mass_content_of_convective_cloud_condensed_water': {'canonical_units': 'kg '
                                                                                    'm-2'},
 'atmosphere_mass_content_of_convective_cloud_ice': {'canonical_units': 'kg '
                                                                        'm-2'},
 'atmosphere_mass_content_of_convective_cloud_liquid_water': {'canonical_units': 'kg '
                                                                                 'm-2'},
 'atmosphere_mass_content_of_dichlorine_peroxide': {'canonical_units': 'kg '
                                                                       'm-2'},
 'atmosphere_mass_content_of_dimethyl_sulfide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_dinitrogen_pentoxide': {'canonical_units': 'kg '
                                                                        'm-2'},
 'atmosphere_mass_content_of_dust_dry_aerosol': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_dust_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                              'm-2'},
 'atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                                          'm-2'},
 'atmosphere_mass_content_of_ethane': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_ethanol': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_ethene': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_ethyne': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_formaldehyde': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_formic_acid': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_gaseous_divalent_mercury': {'canonical_units': 'kg '
                                                                            'm-2'},
 'atmosphere_mass_content_of_gaseous_elemental_mercury': {'canonical_units': 'kg '
                                                                             'm-2'},
 'atmosphere_mass_content_of_graupel': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_graupel_and_hail': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hail': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_halon1202': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_halon1211': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_halon1301': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_halon2402': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hcc140a': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hcfc141b': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hcfc142b': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hcfc22': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hexachlorobiphenyl': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hox_expressed_as_hydrogen': {'canonical_units': 'kg '
                                                                             'm-2'},
 'atmosphere_mass_content_of_hydrogen_bromide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hydrogen_chloride': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hydrogen_cyanide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hydrogen_peroxide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hydroperoxyl_radical': {'canonical_units': 'kg '
                                                                        'm-2'},
 'atmosphere_mass_content_of_hydroxyl_radical': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hypobromous_acid': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_hypochlorous_acid': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_inorganic_bromine': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_inorganic_chlorine': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_isoprene': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_limonene': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_liquid_precipitation': {'canonical_units': 'kg '
                                                                        'm-2'},
 'atmosphere_mass_content_of_mercury_dry_aerosol': {'canonical_units': 'kg '
                                                                       'm-2'},
 'atmosphere_mass_content_of_mercury_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                                 'm-2'},
 'atmosphere_mass_content_of_methane': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_methanol': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_methyl_bromide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_methyl_chloride': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_methyl_hydroperoxide': {'canonical_units': 'kg '
                                                                        'm-2'},
 'atmosphere_mass_content_of_methyl_peroxy_radical': {'canonical_units': 'kg '
                                                                         'm-2'},
 'atmosphere_mass_content_of_molecular_hydrogen': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_nitrate_dry_aerosol': {'canonical_units': 'kg '
                                                                       'm-2'},
 'atmosphere_mass_content_of_nitrate_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                                 'm-2'},
 'atmosphere_mass_content_of_nitrate_radical': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_nitric_acid': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_nitric_acid_trihydrate_ambient_aerosol': {'canonical_units': 'kg '
                                                                                          'm-2'},
 'atmosphere_mass_content_of_nitric_acid_trihydrate_ambient_aerosol_particles': {'canonical_units': 'kg '
                                                                                                    'm-2'},
 'atmosphere_mass_content_of_nitrogen_monoxide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_nitrous_acid': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_nitrous_oxide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_nmvoc_expressed_as_carbon': {'canonical_units': 'kg '
                                                                             'm-2'},
 'atmosphere_mass_content_of_nox_expressed_as_nitrogen': {'canonical_units': 'kg '
                                                                             'm-2'},
 'atmosphere_mass_content_of_noy_expressed_as_nitrogen': {'canonical_units': 'kg '
                                                                             'm-2'},
 'atmosphere_mass_content_of_oxygenated_hydrocarbons': {'canonical_units': 'kg '
                                                                           'm-2'},
 'atmosphere_mass_content_of_ozone': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol': {'canonical_units': 'kg '
                                                                                          'm-2'},
 'atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                                                    'm-2'},
 'atmosphere_mass_content_of_peroxy_radicals': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_peroxyacetyl_nitrate': {'canonical_units': 'kg '
                                                                        'm-2'},
 'atmosphere_mass_content_of_peroxynitric_acid': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_primary_particulate_organic_matter_dry_aerosol': {'canonical_units': 'kg '
                                                                                                  'm-2'},
 'atmosphere_mass_content_of_primary_particulate_organic_matter_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                                                            'm-2'},
 'atmosphere_mass_content_of_propane': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_propene': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_radon': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_sea_salt_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                                  'm-2'},
 'atmosphere_mass_content_of_sea_salt_dry_aerosol_particles_expressed_as_cations': {'canonical_units': 'kg '
                                                                                                       'm-2'},
 'atmosphere_mass_content_of_seasalt_dry_aerosol': {'canonical_units': 'kg '
                                                                       'm-2'},
 'atmosphere_mass_content_of_seasalt_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                                 'm-2'},
 'atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol': {'canonical_units': 'kg '
                                                                                                    'm-2'},
 'atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                                                              'm-2'},
 'atmosphere_mass_content_of_snow': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_sulfate': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_sulfate_ambient_aerosol': {'canonical_units': 'kg '
                                                                           'm-2'},
 'atmosphere_mass_content_of_sulfate_ambient_aerosol_particles': {'canonical_units': 'kg '
                                                                                     'm-2'},
 'atmosphere_mass_content_of_sulfate_dry_aerosol': {'canonical_units': 'kg '
                                                                       'm-2'},
 'atmosphere_mass_content_of_sulfate_dry_aerosol_expressed_as_sulfur': {'canonical_units': 'kg '
                                                                                           'm-2'},
 'atmosphere_mass_content_of_sulfate_dry_aerosol_particles': {'canonical_units': 'kg '
                                                                                 'm-2'},
 'atmosphere_mass_content_of_sulfate_dry_aerosol_particles_expressed_as_sulfur': {'canonical_units': 'kg '
                                                                                                     'm-2'},
 'atmosphere_mass_content_of_sulfate_expressed_as_sulfur_dry_aerosol': {'canonical_units': 'kg '
                                                                                           'm-2'},
 'atmosphere_mass_content_of_sulfur_dioxide': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_terpenes': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_toluene': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_volcanic_ash': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_water': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_water_in_ambient_aerosol': {'canonical_units': 'kg '
                                                                            'm-2'},
 'atmosphere_mass_content_of_water_in_ambient_aerosol_particles': {'canonical_units': 'kg '
                                                                                      'm-2'},
 'atmosphere_mass_content_of_water_vapor': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_content_of_xylene': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_of_air_per_unit_area': {'canonical_units': 'kg m-2'},
 'atmosphere_mass_of_carbon_dioxide': {'canonical_units': 'kg'},
 'atmosphere_mass_per_unit_area': {'canonical_units': 'kg m-2'},
 'atmosphere_mole_content_of_carbon_monoxide': {'canonical_units': 'mol m-2'},
 'atmosphere_mole_content_of_methane': {'canonical_units': 'mol m-2'},
 'atmosphere_mole_content_of_nitrogen_dioxide': {'canonical_units': 'mol m-2'},
 'atmosphere_mole_content_of_ozone': {'canonical_units': 'mol m-2'},
 'atmosphere_mole_content_of_water_vapor': {'canonical_units': 'mol m-2'},
 'atmosphere_moles_of_acetic_acid': {'canonical_units': 'mol'},
 'atmosphere_moles_of_aceto_nitrile': {'canonical_units': 'mol'},
 'atmosphere_moles_of_alpha_hexachlorocyclohexane': {'canonical_units': 'mol'},
 'atmosphere_moles_of_alpha_pinene': {'canonical_units': 'mol'},
 'atmosphere_moles_of_ammonia': {'canonical_units': 'mol'},
 'atmosphere_moles_of_anthropogenic_nmvoc_expressed_as_carbon': {'canonical_units': 'mol'},
 'atmosphere_moles_of_atomic_bromine': {'canonical_units': 'mol'},
 'atmosphere_moles_of_atomic_chlorine': {'canonical_units': 'mol'},
 'atmosphere_moles_of_atomic_nitrogen': {'canonical_units': 'mol'},
 'atmosphere_moles_of_benzene': {'canonical_units': 'mol'},
 'atmosphere_moles_of_beta_pinene': {'canonical_units': 'mol'},
 'atmosphere_moles_of_biogenic_nmvoc_expressed_as_carbon': {'canonical_units': 'mol'},
 'atmosphere_moles_of_bromine_chloride': {'canonical_units': 'mol'},
 'atmosphere_moles_of_bromine_monoxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_bromine_nitrate': {'canonical_units': 'mol'},
 'atmosphere_moles_of_brox_expressed_as_bromine': {'canonical_units': 'mol'},
 'atmosphere_moles_of_butane': {'canonical_units': 'mol'},
 'atmosphere_moles_of_carbon_dioxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_carbon_monoxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_carbon_tetrachloride': {'canonical_units': 'mol'},
 'atmosphere_moles_of_cfc11': {'canonical_units': 'mol'},
 'atmosphere_moles_of_cfc113': {'canonical_units': 'mol'},
 'atmosphere_moles_of_cfc113a': {'canonical_units': 'mol'},
 'atmosphere_moles_of_cfc114': {'canonical_units': 'mol'},
 'atmosphere_moles_of_cfc115': {'canonical_units': 'mol'},
 'atmosphere_moles_of_cfc12': {'canonical_units': 'mol'},
 'atmosphere_moles_of_chlorine_dioxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_chlorine_monoxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_chlorine_nitrate': {'canonical_units': 'mol'},
 'atmosphere_moles_of_clox_expressed_as_chlorine': {'canonical_units': 'mol'},
 'atmosphere_moles_of_dichlorine_peroxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_dimethyl_sulfide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_dinitrogen_pentoxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_ethane': {'canonical_units': 'mol'},
 'atmosphere_moles_of_ethanol': {'canonical_units': 'mol'},
 'atmosphere_moles_of_ethene': {'canonical_units': 'mol'},
 'atmosphere_moles_of_ethyne': {'canonical_units': 'mol'},
 'atmosphere_moles_of_formaldehyde': {'canonical_units': 'mol'},
 'atmosphere_moles_of_formic_acid': {'canonical_units': 'mol'},
 'atmosphere_moles_of_gaseous_divalent_mercury': {'canonical_units': 'mol'},
 'atmosphere_moles_of_gaseous_elemental_mercury': {'canonical_units': 'mol'},
 'atmosphere_moles_of_halon1202': {'canonical_units': 'mol'},
 'atmosphere_moles_of_halon1211': {'canonical_units': 'mol'},
 'atmosphere_moles_of_halon1301': {'canonical_units': 'mol'},
 'atmosphere_moles_of_halon2402': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hcc140a': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hcfc141b': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hcfc142b': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hcfc22': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hexachlorobiphenyl': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hox_expressed_as_hydrogen': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hydrogen_bromide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hydrogen_chloride': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hydrogen_cyanide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hydrogen_peroxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hydroperoxyl_radical': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hydroxyl_radical': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hypobromous_acid': {'canonical_units': 'mol'},
 'atmosphere_moles_of_hypochlorous_acid': {'canonical_units': 'mol'},
 'atmosphere_moles_of_inorganic_bromine': {'canonical_units': 'mol'},
 'atmosphere_moles_of_inorganic_chlorine': {'canonical_units': 'mol'},
 'atmosphere_moles_of_isoprene': {'canonical_units': 'mol'},
 'atmosphere_moles_of_limonene': {'canonical_units': 'mol'},
 'atmosphere_moles_of_methane': {'canonical_units': 'mol'},
 'atmosphere_moles_of_methanol': {'canonical_units': 'mol'},
 'atmosphere_moles_of_methyl_bromide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_methyl_chloride': {'canonical_units': 'mol'},
 'atmosphere_moles_of_methyl_hydroperoxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_methyl_peroxy_radical': {'canonical_units': 'mol'},
 'atmosphere_moles_of_molecular_hydrogen': {'canonical_units': 'mol'},
 'atmosphere_moles_of_nitrate_radical': {'canonical_units': 'mol'},
 'atmosphere_moles_of_nitric_acid': {'canonical_units': 'mol'},
 'atmosphere_moles_of_nitric_acid_trihydrate_ambient_aerosol': {'canonical_units': 'mol'},
 'atmosphere_moles_of_nitric_acid_trihydrate_ambient_aerosol_particles': {'canonical_units': 'mol'},
 'atmosphere_moles_of_nitrogen_dioxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_nitrogen_monoxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_nitrous_acid': {'canonical_units': 'mol'},
 'atmosphere_moles_of_nitrous_oxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_nmvoc_expressed_as_carbon': {'canonical_units': 'mol'},
 'atmosphere_moles_of_nox_expressed_as_nitrogen': {'canonical_units': 'mol'},
 'atmosphere_moles_of_noy_expressed_as_nitrogen': {'canonical_units': 'mol'},
 'atmosphere_moles_of_ozone': {'canonical_units': 'mol'},
 'atmosphere_moles_of_peroxyacetyl_nitrate': {'canonical_units': 'mol'},
 'atmosphere_moles_of_peroxynitric_acid': {'canonical_units': 'mol'},
 'atmosphere_moles_of_propane': {'canonical_units': 'mol'},
 'atmosphere_moles_of_propene': {'canonical_units': 'mol'},
 'atmosphere_moles_of_radon': {'canonical_units': 'mol'},
 'atmosphere_moles_of_sulfur_dioxide': {'canonical_units': 'mol'},
 'atmosphere_moles_of_toluene': {'canonical_units': 'mol'},
 'atmosphere_moles_of_water_vapor': {'canonical_units': 'mol'},
 'atmosphere_moles_of_xylene': {'canonical_units': 'mol'},
 'atmosphere_momentum_diffusivity': {'canonical_units': 'm2 s-1'},
 'atmosphere_net_rate_of_absorption_of_longwave_energy': {'canonical_units': 'W '
                                                                             'm-2'},
 'atmosphere_net_rate_of_absorption_of_shortwave_energy': {'canonical_units': 'W '
                                                                              'm-2'},
 'atmosphere_net_upward_convective_mass_flux': {'canonical_units': 'kg m-2 '
                                                                   's-1'},
 'atmosphere_net_upward_deep_convective_mass_flux': {'canonical_units': 'kg '
                                                                        'm-2 '
                                                                        's-1'},
 'atmosphere_net_upward_shallow_convective_mass_flux': {'canonical_units': 'kg '
                                                                           'm-2 '
                                                                           's-1'},
 'atmosphere_northward_stress_due_to_gravity_wave_drag': {'canonical_units': 'Pa'},
 'atmosphere_number_content_of_aerosol_particles': {'canonical_units': 'm-2'},
 'atmosphere_number_content_of_cloud_droplets': {'canonical_units': 'm-2'},
 'atmosphere_number_content_of_ice_crystals': {'canonical_units': 'm-2'},
 'atmosphere_optical_thickness_due_to_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_ammonium_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_black_carbon_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_cloud': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_convective_cloud': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_dust_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_dust_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_dust_dry_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_dust_dry_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_nitrate_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_particulate_organic_matter_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_particulate_organic_matter_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_pm10_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_pm10_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_pm1_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_pm1_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_pm2p5_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_pm2p5_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_sea_salt_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_seasalt_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_seasalt_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_stratiform_cloud': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_sulfate_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_water_in_ambient_aerosol': {'canonical_units': '1'},
 'atmosphere_optical_thickness_due_to_water_in_ambient_aerosol_particles': {'canonical_units': '1'},
 'atmosphere_potential_energy_content': {'canonical_units': 'J m-2'},
 'atmosphere_relative_vorticity': {'canonical_units': 's-1'},
 'atmosphere_sigma_coordinate': {'canonical_units': '1'},
 'atmosphere_sleve_coordinate': {'canonical_units': '1'},
 'atmosphere_so4_content': {'canonical_units': 'kg m-2'},
 'atmosphere_specific_convective_available_potential_energy': {'canonical_units': 'J '
                                                                                  'kg-1'},
 'atmosphere_stability_k_index': {'canonical_units': 'K'},
 'atmosphere_stability_showalter_index': {'canonical_units': 'K'},
 'atmosphere_stability_total_totals_index': {'canonical_units': 'K'},
 'atmosphere_sulfate_content': {'canonical_units': 'kg m-2'},
 'atmosphere_surface_drag_coefficient': {'canonical_units': '1'},
 'atmosphere_surface_drag_coefficient_of_heat': {'canonical_units': '1'},
 'atmosphere_surface_drag_coefficient_of_momentum': {'canonical_units': '1'},
 'atmosphere_transformed_eulerian_mean_meridional_overturning_mass_streamfunction': {'canonical_units': 'kg '
                                                                                                        's-1'},
 'atmosphere_updraft_convective_mass_flux': {'canonical_units': 'kg m-2 s-1'},
 'atmosphere_upward_absolute_vorticity': {'canonical_units': 's-1'},
 'atmosphere_upward_relative_vorticity': {'canonical_units': 's-1'},
 'atmosphere_water_vapor_content': {'canonical_units': 'kg m-2'},
 'atmosphere_x_relative_vorticity': {'canonical_units': 's-1'},
 'atmosphere_y_relative_vorticity': {'canonical_units': 's-1'},
 'attenuated_signal_test_quality_flag': {'canonical_units': '1'},
 'automated_tropical_cyclone_forecasting_system_storm_identifier': {'canonical_units': None},
 'backscattering_ratio': {'canonical_units': '1'},
 'backscattering_ratio_in_air': {'canonical_units': '1'},
 'baroclinic_eastward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'baroclinic_northward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'barometric_altitude': {'canonical_units': 'm'},
 'barotropic_eastward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'barotropic_northward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'barotropic_sea_water_x_velocity': {'canonical_units': 'm s-1'},
 'barotropic_sea_water_y_velocity': {'canonical_units': 'm s-1'},
 'basal_downward_heat_flux_in_sea_ice': {'canonical_units': 'W m-2'},
 'baseflow_amount': {'canonical_units': 'kg m-2'},
 'beam_consistency_indicator_from_multibeam_acoustic_doppler_velocity_profiler_in_sea_water': {'canonical_units': '1'},
 'beaufort_wind_force': {'canonical_units': '1'},
 'bedrock_altitude': {'canonical_units': 'm'},
 'bedrock_altitude_change_due_to_isostatic_adjustment': {'canonical_units': 'm'},
 'biological_taxon_identifier': {'canonical_units': None},
 'biological_taxon_lsid': {'canonical_units': None},
 'biological_taxon_name': {'canonical_units': None},
 'bioluminescent_photon_rate_in_sea_water': {'canonical_units': 's-1 m-3'},
 'biomass_burning_carbon_flux': {'canonical_units': 'kg m-2 s-1'},
 'bolus_eastward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'bolus_northward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'bolus_sea_water_x_velocity': {'canonical_units': 'm s-1'},
 'bolus_sea_water_y_velocity': {'canonical_units': 'm s-1'},
 'bolus_upward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'brightness_temperature': {'canonical_units': 'K'},
 'brightness_temperature_anomaly': {'canonical_units': 'K'},
 'brightness_temperature_at_cloud_top': {'canonical_units': 'K'},
 'brunt_vaisala_frequency_in_air': {'canonical_units': 's-1'},
 'burned_area': {'canonical_units': 'm2'},
 'burned_area_fraction': {'canonical_units': '1'},
 'canopy_albedo': {'canonical_units': '1'},
 'canopy_and_surface_water_amount': {'canonical_units': 'kg m-2'},
 'canopy_height': {'canonical_units': 'm'},
 'canopy_resistance_to_ozone_dry_deposition': {'canonical_units': 'm-1 s'},
 'canopy_snow_amount': {'canonical_units': 'kg m-2'},
 'canopy_temperature': {'canonical_units': 'K'},
 'canopy_throughfall_flux': {'canonical_units': 'kg m-2 s-1'},
 'canopy_water_amount': {'canonical_units': 'kg m-2'},
 'carbon_content_of_forestry_and_agricultural_products': {'canonical_units': 'kg '
                                                                             'm-2'},
 'carbon_content_of_products_of_anthropogenic_land_use_change': {'canonical_units': 'kg '
                                                                                    'm-2'},
 'carbon_mass_content_of_forestry_and_agricultural_products': {'canonical_units': 'kg '
                                                                                  'm-2'},
 'carbon_mass_flux_into_forestry_and_agricultural_products_due_to_anthropogenic_land_use_or_land_cover_change': {'canonical_units': 'kg '
                                                                                                                                    'm-2 '
                                                                                                                                    's-1'},
 'carbon_mass_flux_into_litter_and_soil_due_to_anthropogenic_land_use_or_land_cover_change': {'canonical_units': 'kg '
                                                                                                                 'm-2 '
                                                                                                                 's-1'},
 'carbon_mass_flux_into_soil_and_litter_due_to_anthropogenic_land_use_or_land_cover_change': {'canonical_units': 'kg '
                                                                                                                 'm-2 '
                                                                                                                 's-1'},
 'carbon_mass_flux_into_soil_from_litter': {'canonical_units': 'kg m-2 s-1'},
 'carbon_mass_flux_into_soil_from_vegetation_excluding_litter': {'canonical_units': 'kg '
                                                                                    'm-2 '
                                                                                    's-1'},
 'cell_area': {'canonical_units': 'm2'},
 'cell_thickness': {'canonical_units': 'm'},
 'change_in_atmosphere_energy_content_due_to_change_in_sigma_coordinate_wrt_surface_pressure': {'canonical_units': 'J '
                                                                                                                   'm-2'},
 'change_in_energy_content_of_atmosphere_layer_due_to_change_in_sigma_coordinate_wrt_surface_pressure': {'canonical_units': 'J '
                                                                                                                            'm-2'},
 'change_in_land_ice_amount': {'canonical_units': 'kg m-2'},
 'change_in_land_ice_mass': {'canonical_units': 'kg'},
 'change_over_time_in_amount_of_ice_and_snow_on_land': {'canonical_units': 'kg '
                                                                           'm-2'},
 'change_over_time_in_atmosphere_mass_content_of_water_due_to_advection': {'canonical_units': 'kg '
                                                                                              'm-2'},
 'change_over_time_in_atmosphere_water_content_due_to_advection': {'canonical_units': 'kg '
                                                                                      'm-2'},
 'change_over_time_in_atmospheric_water_content_due_to_advection': {'canonical_units': 'kg '
                                                                                       'm-2'},
 'change_over_time_in_canopy_water_amount': {'canonical_units': 'kg m-2'},
 'change_over_time_in_groundwater_amount': {'canonical_units': 'kg m-2'},
 'change_over_time_in_land_surface_liquid_water_amount': {'canonical_units': 'kg '
                                                                             'm-2'},
 'change_over_time_in_land_water_amount': {'canonical_units': 'kg m-2'},
 'change_over_time_in_mass_content_of_water_in_soil': {'canonical_units': 'kg '
                                                                          'm-2'},
 'change_over_time_in_river_water_amount': {'canonical_units': 'kg m-2'},
 'change_over_time_in_sea_water_absolute_salinity': {'canonical_units': 'g '
                                                                        'kg-1'},
 'change_over_time_in_sea_water_conservative_temperature': {'canonical_units': 'K'},
 'change_over_time_in_sea_water_density': {'canonical_units': 'kg m-3'},
 'change_over_time_in_sea_water_neutral_density': {'canonical_units': 'kg m-3'},
 'change_over_time_in_sea_water_potential_density': {'canonical_units': 'kg '
                                                                        'm-3'},
 'change_over_time_in_sea_water_potential_temperature': {'canonical_units': 'K'},
 'change_over_time_in_sea_water_practical_salinity': {'canonical_units': '1'},
 'change_over_time_in_sea_water_preformed_salinity': {'canonical_units': 'g '
                                                                         'kg-1'},
 'change_over_time_in_sea_water_salinity': {'canonical_units': '1e-3'},
 'change_over_time_in_sea_water_specific_potential_enthalpy': {'canonical_units': 'J '
                                                                                  'kg-1'},
 'change_over_time_in_sea_water_temperature': {'canonical_units': 'K'},
 'change_over_time_in_surface_snow_amount': {'canonical_units': 'kg m-2'},
 'change_over_time_in_thermal_energy_content_of_ice_and_snow_on_land': {'canonical_units': 'J '
                                                                                           'm-2'},
 'change_over_time_in_thermal_energy_content_of_vegetation_and_litter_and_soil': {'canonical_units': 'J '
                                                                                                     'm-2'},
 'charnock_coefficient_for_surface_roughness_length_for_momentum_in_air': {'canonical_units': '1'},
 'chlorophyll_concentration_in_sea_water': {'canonical_units': 'kg m-3'},
 'clear_sky_area_fraction': {'canonical_units': '1'},
 'climatology_test_quality_flag': {'canonical_units': '1'},
 'cloud_albedo': {'canonical_units': '1'},
 'cloud_area_fraction': {'canonical_units': '1'},
 'cloud_area_fraction_in_atmosphere_layer': {'canonical_units': '1'},
 'cloud_base_altitude': {'canonical_units': 'm'},
 'cloud_binary_mask': {'canonical_units': '1'},
 'cloud_condensed_water_content_of_atmosphere_layer': {'canonical_units': 'kg '
                                                                          'm-2'},
 'cloud_ice_content_of_atmosphere_layer': {'canonical_units': 'kg m-2'},
 'cloud_ice_mixing_ratio': {'canonical_units': '1'},
 'cloud_liquid_water_content_of_atmosphere_layer': {'canonical_units': 'kg '
                                                                       'm-2'},
 'cloud_liquid_water_mixing_ratio': {'canonical_units': '1'},
 'cloud_top_altitude': {'canonical_units': 'm'},
 'colony_forming_unit_number_concentration_of_biological_taxon_in_sea_water': {'canonical_units': 'm-3'},
 'compressive_strength_of_sea_ice': {'canonical_units': 'Pa m'},
 'concentration_of_chlorophyll_in_sea_water': {'canonical_units': 'kg m-3'},
 'concentration_of_colored_dissolved_organic_matter_in_sea_water_expressed_as_equivalent_mass_fraction_of_quinine_sulfate_dihydrate': {'canonical_units': '1'},
 'concentration_of_suspended_matter_in_sea_water': {'canonical_units': 'kg '
                                                                       'm-3'},
 'convection_time_fraction': {'canonical_units': '1'},
 'convective_cloud_area_fraction': {'canonical_units': '1'},
 'convective_cloud_area_fraction_in_atmosphere_layer': {'canonical_units': '1'},
 'convective_cloud_base_altitude': {'canonical_units': 'm'},
 'convective_cloud_base_height': {'canonical_units': 'm'},
 'convective_cloud_longwave_emissivity': {'canonical_units': '1'},
 'convective_cloud_top_altitude': {'canonical_units': 'm'},
 'convective_cloud_top_height': {'canonical_units': 'm'},
 'convective_precipitation_amount': {'canonical_units': 'kg m-2'},
 'convective_precipitation_flux': {'canonical_units': 'kg m-2 s-1'},
 'convective_precipitation_rate': {'canonical_units': 'm s-1'},
 'convective_rainfall_amount': {'canonical_units': 'kg m-2'},
 'convective_rainfall_flux': {'canonical_units': 'kg m-2 s-1'},
 'convective_rainfall_rate': {'canonical_units': 'm s-1'},
 'convective_snowfall_amount': {'canonical_units': 'kg m-2'},
 'convective_snowfall_flux': {'canonical_units': 'kg m-2 s-1'},
 'coriolis_parameter': {'canonical_units': 's-1'},
 'correction_for_model_negative_specific_humidity': {'canonical_units': '1'},
 'covariance_over_longitude_of_northward_wind_and_air_temperature': {'canonical_units': 'K '
                                                                                        'm '
                                                                                        's-1'},
 'depth': {'canonical_units': 'm'},
 'depth_at_base_of_unfrozen_ground': {'canonical_units': 'm'},
 'depth_at_maximum_upward_derivative_of_sea_water_potential_temperature': {'canonical_units': 'm'},
 'depth_at_shallowest_isotherm_defined_by_soil_temperature': {'canonical_units': 'm'},
 'depth_at_shallowest_local_minimum_in_vertical_profile_of_mole_concentration_of_dissolved_molecular_oxygen_in_sea_water': {'canonical_units': 'm'},
 'depth_below_geoid': {'canonical_units': 'm'},
 'depth_below_sea_floor': {'canonical_units': 'm'},
 'depth_of_isosurface_of_sea_water_potential_temperature': {'canonical_units': 'm'},
 'dew_point_depression': {'canonical_units': 'K'},
 'dew_point_temperature': {'canonical_units': 'K'},
 'diameter_of_ambient_aerosol_particles': {'canonical_units': 'm'},
 'difference_between_sea_surface_temperature_and_air_temperature': {'canonical_units': 'K'},
 'difference_of_air_pressure_from_model_reference': {'canonical_units': 'Pa'},
 'diffuse_downwelling_shortwave_flux_in_air': {'canonical_units': 'W m-2'},
 'diffuse_downwelling_shortwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                                     'm-2'},
 'dimensionless_exner_function': {'canonical_units': '1'},
 'direct_downwelling_shortwave_flux_in_air': {'canonical_units': 'W m-2'},
 'direction_of_radial_vector_away_from_instrument': {'canonical_units': 'degree'},
 'direction_of_radial_vector_toward_instrument': {'canonical_units': 'degree'},
 'direction_of_sea_ice_displacement': {'canonical_units': 'degrees'},
 'direction_of_sea_ice_velocity': {'canonical_units': 'degree'},
 'direction_of_sea_water_velocity': {'canonical_units': 'degree'},
 'direction_of_swell_wave_velocity': {'canonical_units': 'degree'},
 'direction_of_wind_wave_velocity': {'canonical_units': 'degree'},
 'dissipation_in_atmosphere_boundary_layer': {'canonical_units': 'W m-2'},
 'distance_from_geocenter': {'canonical_units': 'm'},
 'distance_from_sun': {'canonical_units': 'm'},
 'distance_from_tropical_cyclone_center_to_leading_edge_of_displaced_convection': {'canonical_units': 'm'},
 'divergence_of_sea_ice_velocity': {'canonical_units': 's-1'},
 'divergence_of_wind': {'canonical_units': 's-1'},
 'downward_air_velocity': {'canonical_units': 'm s-1'},
 'downward_dry_static_energy_flux_due_to_diffusion': {'canonical_units': 'W '
                                                                         'm-2'},
 'downward_eastward_momentum_flux_in_air': {'canonical_units': 'Pa'},
 'downward_eastward_momentum_flux_in_air_due_to_diffusion': {'canonical_units': 'Pa'},
 'downward_eastward_stress_at_sea_ice_base': {'canonical_units': 'Pa'},
 'downward_heat_flux_at_ground_level_in_snow': {'canonical_units': 'W m-2'},
 'downward_heat_flux_at_ground_level_in_soil': {'canonical_units': 'W m-2'},
 'downward_heat_flux_in_air': {'canonical_units': 'W m-2'},
 'downward_heat_flux_in_floating_ice': {'canonical_units': 'W m-2'},
 'downward_heat_flux_in_sea_ice': {'canonical_units': 'W m-2'},
 'downward_heat_flux_in_soil': {'canonical_units': 'W m-2'},
 'downward_liquid_water_mass_flux_into_groundwater': {'canonical_units': 'kg '
                                                                         'm-2 '
                                                                         's-1'},
 'downward_northward_momentum_flux_in_air': {'canonical_units': 'Pa'},
 'downward_northward_momentum_flux_in_air_due_to_diffusion': {'canonical_units': 'Pa'},
 'downward_northward_stress_at_sea_ice_base': {'canonical_units': 'Pa'},
 'downward_sea_ice_basal_salt_flux': {'canonical_units': 'kg m-2 s-1'},
 'downward_water_vapor_flux_in_air_due_to_diffusion': {'canonical_units': 'kg '
                                                                          'm-2 '
                                                                          's-1'},
 'downward_x_stress_at_sea_ice_base': {'canonical_units': 'Pa'},
 'downward_x_stress_at_sea_water_surface': {'canonical_units': 'Pa'},
 'downward_x_stress_correction_at_sea_water_surface': {'canonical_units': 'Pa'},
 'downward_y_stress_at_sea_ice_base': {'canonical_units': 'Pa'},
 'downward_y_stress_at_sea_water_surface': {'canonical_units': 'Pa'},
 'downward_y_stress_correction_at_sea_water_surface': {'canonical_units': 'Pa'},
 'downwelling_longwave_flux_in_air': {'canonical_units': 'W m-2'},
 'downwelling_longwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                            'm-2'},
 'downwelling_longwave_radiance_in_air': {'canonical_units': 'W m-2 sr-1'},
 'downwelling_photon_flux_in_sea_water': {'canonical_units': 'mol m-2 s-1'},
 'downwelling_photon_flux_per_unit_wavelength_in_sea_water': {'canonical_units': 'mol '
                                                                                 'm-2 '
                                                                                 's-1 '
                                                                                 'm-1'},
 'downwelling_photon_radiance_in_sea_water': {'canonical_units': 'mol m-2 s-1 '
                                                                 'sr-1'},
 'downwelling_photon_radiance_per_unit_wavelength_in_sea_water': {'canonical_units': 'mol '
                                                                                     'm-2 '
                                                                                     's-1 '
                                                                                     'm-1 '
                                                                                     'sr-1'},
 'downwelling_photon_spherical_irradiance_in_sea_water': {'canonical_units': 'mol '
                                                                             'm-2 '
                                                                             's-1'},
 'downwelling_photon_spherical_irradiance_per_unit_wavelength_in_sea_water': {'canonical_units': 'mol '
                                                                                                 'm-2 '
                                                                                                 's-1 '
                                                                                                 'm-1'},
 'downwelling_photosynthetic_photon_flux_in_sea_water': {'canonical_units': 'mol '
                                                                            'm-2 '
                                                                            's-1'},
 'downwelling_photosynthetic_photon_radiance_in_sea_water': {'canonical_units': 'mol '
                                                                                'm-2 '
                                                                                's-1 '
                                                                                'sr-1'},
 'downwelling_photosynthetic_photon_spherical_irradiance_in_sea_water': {'canonical_units': 'mol '
                                                                                            'm-2 '
                                                                                            's-1'},
 'downwelling_photosynthetic_radiance_in_sea_water': {'canonical_units': 'W '
                                                                         'm-2 '
                                                                         'sr-1'},
 'downwelling_photosynthetic_radiative_flux_in_sea_water': {'canonical_units': 'W '
                                                                               'm-2'},
 'downwelling_photosynthetic_spherical_irradiance_in_sea_water': {'canonical_units': 'W '
                                                                                     'm-2'},
 'downwelling_radiance_in_sea_water': {'canonical_units': 'W m-2 sr-1'},
 'downwelling_radiance_per_unit_wavelength_in_air': {'canonical_units': 'W m-2 '
                                                                        'm-1 '
                                                                        'sr-1'},
 'downwelling_radiance_per_unit_wavelength_in_sea_water': {'canonical_units': 'W '
                                                                              'm-2 '
                                                                              'm-1 '
                                                                              'sr-1'},
 'downwelling_radiative_flux_in_sea_water': {'canonical_units': 'W m-2'},
 'downwelling_radiative_flux_per_unit_wavelength_in_air': {'canonical_units': 'W '
                                                                              'm-2 '
                                                                              'm-1'},
 'downwelling_radiative_flux_per_unit_wavelength_in_sea_water': {'canonical_units': 'W '
                                                                                    'm-2 '
                                                                                    'm-1'},
 'downwelling_shortwave_flux_in_air': {'canonical_units': 'W m-2'},
 'downwelling_shortwave_flux_in_air_assuming_clean_clear_sky': {'canonical_units': 'W '
                                                                                   'm-2'},
 'downwelling_shortwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                             'm-2'},
 'downwelling_shortwave_flux_in_air_assuming_clear_sky_and_no_aerosol': {'canonical_units': 'W '
                                                                                            'm-2'},
 'downwelling_shortwave_flux_in_sea_water': {'canonical_units': 'W m-2'},
 'downwelling_shortwave_flux_in_sea_water_at_sea_ice_base': {'canonical_units': 'W '
                                                                                'm-2'},
 'downwelling_shortwave_radiance_in_air': {'canonical_units': 'W m-2 sr-1'},
 'downwelling_spectral_photon_flux_in_sea_water': {'canonical_units': 'mol m-2 '
                                                                      's-1 '
                                                                      'm-1'},
 'downwelling_spectral_photon_radiance_in_sea_water': {'canonical_units': 'mol '
                                                                          'm-2 '
                                                                          's-1 '
                                                                          'm-1 '
                                                                          'sr-1'},
 'downwelling_spectral_photon_spherical_irradiance_in_sea_water': {'canonical_units': 'mol '
                                                                                      'm-2 '
                                                                                      's-1 '
                                                                                      'm-1'},
 'downwelling_spectral_radiance_in_air': {'canonical_units': 'W m-2 m-1 sr-1'},
 'downwelling_spectral_radiance_in_sea_water': {'canonical_units': 'W m-2 m-1 '
                                                                   'sr-1'},
 'downwelling_spectral_radiative_flux_in_air': {'canonical_units': 'W m-2 m-1'},
 'downwelling_spectral_radiative_flux_in_sea_water': {'canonical_units': 'W '
                                                                         'm-2 '
                                                                         'm-1'},
 'downwelling_spectral_spherical_irradiance_in_sea_water': {'canonical_units': 'W '
                                                                               'm-2 '
                                                                               'm-1'},
 'downwelling_spherical_irradiance_in_sea_water': {'canonical_units': 'W m-2'},
 'downwelling_spherical_irradiance_per_unit_wavelength_in_sea_water': {'canonical_units': 'W '
                                                                                          'm-2 '
                                                                                          'm-1'},
 'dry_atmosphere_mole_fraction_of_carbon_dioxide': {'canonical_units': '1'},
 'dry_atmosphere_mole_fraction_of_methane': {'canonical_units': '1'},
 'dry_energy_content_of_atmosphere_layer': {'canonical_units': 'J m-2'},
 'dry_static_energy_content_of_atmosphere_layer': {'canonical_units': 'J m-2'},
 'duration_of_sunshine': {'canonical_units': 's'},
 'dvorak_tropical_cyclone_current_intensity_number': {'canonical_units': '1'},
 'dvorak_tropical_number': {'canonical_units': '1'},
 'dynamic_tropopause_potential_temperature': {'canonical_units': 'K'},
 'eastward_air_velocity_relative_to_sea_water': {'canonical_units': 'm s-1'},
 'eastward_atmosphere_dry_static_energy_transport_across_unit_distance': {'canonical_units': 'W '
                                                                                             'm-1'},
 'eastward_atmosphere_water_transport_across_unit_distance': {'canonical_units': 'kg '
                                                                                 's-1 '
                                                                                 'm-1'},
 'eastward_atmosphere_water_vapor_transport_across_unit_distance': {'canonical_units': 'kg '
                                                                                       'm-1 '
                                                                                       's-1'},
 'eastward_derivative_of_eastward_wind': {'canonical_units': 's-1'},
 'eastward_derivative_of_northward_sea_ice_velocity': {'canonical_units': 's-1'},
 'eastward_derivative_of_northward_wind': {'canonical_units': 's-1'},
 'eastward_derivative_of_wind_from_direction': {'canonical_units': 'degree '
                                                                   'm-1'},
 'eastward_flood_water_velocity': {'canonical_units': 'm s-1'},
 'eastward_friction_velocity_in_air': {'canonical_units': 'm s-1'},
 'eastward_land_ice_velocity': {'canonical_units': 'm s-1'},
 'eastward_mass_flux_of_air': {'canonical_units': 'kg m-2 s-1'},
 'eastward_momentum_flux_correction': {'canonical_units': 'Pa'},
 'eastward_sea_ice_displacement': {'canonical_units': 'm'},
 'eastward_sea_ice_velocity': {'canonical_units': 'm s-1'},
 'eastward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'eastward_sea_water_velocity_assuming_no_tide': {'canonical_units': 'm s-1'},
 'eastward_sea_water_velocity_at_sea_floor': {'canonical_units': 'm s-1'},
 'eastward_sea_water_velocity_due_to_parameterized_mesoscale_eddies': {'canonical_units': 'm '
                                                                                          's-1'},
 'eastward_sea_water_velocity_due_to_tides': {'canonical_units': 'm s-1'},
 'eastward_transformed_eulerian_mean_air_velocity': {'canonical_units': 'm '
                                                                        's-1'},
 'eastward_transformed_eulerian_mean_velocity': {'canonical_units': 'm s-1'},
 'eastward_water_vapor_flux': {'canonical_units': 'kg m-2 s-1'},
 'eastward_water_vapor_flux_in_air': {'canonical_units': 'kg m-2 s-1'},
 'eastward_water_vapor_transport_across_unit_distance_in_atmosphere_layer': {'canonical_units': 'kg '
                                                                                                'm-1 '
                                                                                                's-1'},
 'eastward_wind': {'canonical_units': 'm s-1'},
 'eastward_wind_shear': {'canonical_units': 's-1'},
 'effective_radius_of_cloud_condensed_water_particles_at_cloud_top': {'canonical_units': 'm'},
 'effective_radius_of_cloud_liquid_water_particle': {'canonical_units': 'm'},
 'effective_radius_of_cloud_liquid_water_particle_at_liquid_water_cloud_top': {'canonical_units': 'm'},
 'effective_radius_of_cloud_liquid_water_particles': {'canonical_units': 'm'},
 'effective_radius_of_cloud_liquid_water_particles_at_liquid_water_cloud_top': {'canonical_units': 'm'},
 'effective_radius_of_convective_cloud_ice_particle': {'canonical_units': 'm'},
 'effective_radius_of_convective_cloud_ice_particles': {'canonical_units': 'm'},
 'effective_radius_of_convective_cloud_liquid_water_particle': {'canonical_units': 'm'},
 'effective_radius_of_convective_cloud_liquid_water_particle_at_convective_liquid_water_cloud_top': {'canonical_units': 'm'},
 'effective_radius_of_convective_cloud_liquid_water_particles': {'canonical_units': 'm'},
 'effective_radius_of_convective_cloud_liquid_water_particles_at_convective_liquid_water_cloud_top': {'canonical_units': 'm'},
 'effective_radius_of_convective_cloud_rain_particle': {'canonical_units': 'm'},
 'effective_radius_of_convective_cloud_rain_particles': {'canonical_units': 'm'},
 'effective_radius_of_convective_cloud_snow_particle': {'canonical_units': 'm'},
 'effective_radius_of_convective_cloud_snow_particles': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_graupel_particle': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_graupel_particles': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_ice_particle': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_ice_particles': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_liquid_water_particle': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_liquid_water_particle_at_stratiform_liquid_water_cloud_top': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_liquid_water_particles': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_liquid_water_particles_at_stratiform_liquid_water_cloud_top': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_rain_particle': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_rain_particles': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_snow_particle': {'canonical_units': 'm'},
 'effective_radius_of_stratiform_cloud_snow_particles': {'canonical_units': 'm'},
 'electrical_mobility_diameter_of_ambient_aerosol_particles': {'canonical_units': 'm'},
 'electrical_mobility_particle_diameter': {'canonical_units': 'm'},
 'electromagnetic_wavelength': {'canonical_units': 'm'},
 'enrichment_of_14C_in_carbon_dioxide_in_air_expressed_as_uppercase_delta_14C': {'canonical_units': '1e-3'},
 'enthalpy_content_of_atmosphere_layer': {'canonical_units': 'J m-2'},
 'equilibrium_line_altitude': {'canonical_units': 'm'},
 'equivalent_potential_temperature': {'canonical_units': 'K'},
 'equivalent_pressure_of_atmosphere_ozone_content': {'canonical_units': 'Pa'},
 'equivalent_reflectivity_factor': {'canonical_units': 'dBZ'},
 'equivalent_temperature': {'canonical_units': 'K'},
 'equivalent_thickness_at_stp_of_atmosphere_o3_content': {'canonical_units': 'm'},
 'equivalent_thickness_at_stp_of_atmosphere_ozone_content': {'canonical_units': 'm'},
 'ertel_potential_vorticity': {'canonical_units': 'K m2 kg-1 s-1'},
 'fast_soil_pool_carbon_content': {'canonical_units': 'kg m-2'},
 'fast_soil_pool_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'final_air_pressure_of_lifted_parcel': {'canonical_units': 'Pa'},
 'fire_area': {'canonical_units': 'm2'},
 'fire_radiative_power': {'canonical_units': 'W'},
 'fire_temperature': {'canonical_units': 'K'},
 'flat_line_test_quality_flag': {'canonical_units': '1'},
 'floating_ice_sheet_area_fraction': {'canonical_units': '1'},
 'floating_ice_shelf_area': {'canonical_units': 'm2'},
 'floating_ice_shelf_area_fraction': {'canonical_units': '1'},
 'floating_ice_thickness': {'canonical_units': 'm'},
 'flood_water_duration_above_threshold': {'canonical_units': 's'},
 'flood_water_speed': {'canonical_units': 'm s-1'},
 'flood_water_thickness': {'canonical_units': 'm'},
 'fog_area_fraction': {'canonical_units': '1'},
 'forecast_period': {'canonical_units': 's'},
 'forecast_reference_time': {'canonical_units': 's'},
 'fraction_of_surface_downwelling_photosynthetic_radiative_flux_absorbed_by_vegetation': {'canonical_units': '1'},
 'fraction_of_time_with_sea_ice_area_fraction_above_threshold': {'canonical_units': '1'},
 'fractional_saturation_of_oxygen_in_sea_water': {'canonical_units': '1'},
 'freezing_level_altitude': {'canonical_units': 'm'},
 'freezing_temperature_of_sea_water': {'canonical_units': 'K'},
 'frequency_of_lightning_flashes_per_unit_area': {'canonical_units': 'm-2 s-1'},
 'frozen_water_content_of_soil_layer': {'canonical_units': 'kg m-2'},
 'fugacity_of_carbon_dioxide_in_sea_water': {'canonical_units': 'Pa'},
 'gap_test_quality_flag': {'canonical_units': '1'},
 'geoid_height_above_reference_ellipsoid': {'canonical_units': 'm'},
 'geopotential': {'canonical_units': 'm2 s-2'},
 'geopotential_height': {'canonical_units': 'm'},
 'geopotential_height_anomaly': {'canonical_units': 'm'},
 'geopotential_height_at_cloud_top': {'canonical_units': 'm'},
 'geopotential_height_at_volcanic_ash_cloud_top': {'canonical_units': 'm'},
 'geostrophic_eastward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'geostrophic_eastward_wind': {'canonical_units': 'm s-1'},
 'geostrophic_northward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'geostrophic_northward_wind': {'canonical_units': 'm s-1'},
 'global_average_sea_level_change': {'canonical_units': 'm'},
 'global_average_steric_sea_level_change': {'canonical_units': 'm'},
 'global_average_thermosteric_sea_level_change': {'canonical_units': 'm'},
 'graupel_and_hail_fall_amount': {'canonical_units': 'kg m-2'},
 'graupel_and_hail_fall_flux': {'canonical_units': 'kg m-2 s-1'},
 'graupel_fall_amount': {'canonical_units': 'kg m-2'},
 'graupel_fall_flux': {'canonical_units': 'kg m-2 s-1'},
 'grid_eastward_wind': {'canonical_units': 'm s-1'},
 'grid_latitude': {'canonical_units': 'degree'},
 'grid_longitude': {'canonical_units': 'degree'},
 'grid_northward_wind': {'canonical_units': 'm s-1'},
 'gross_primary_productivity_of_biomass_expressed_as_13C': {'canonical_units': 'kg '
                                                                               'm-2 '
                                                                               's-1'},
 'gross_primary_productivity_of_biomass_expressed_as_14C': {'canonical_units': 'kg '
                                                                               'm-2 '
                                                                               's-1'},
 'gross_primary_productivity_of_biomass_expressed_as_carbon': {'canonical_units': 'kg '
                                                                                  'm-2 '
                                                                                  's-1'},
 'gross_primary_productivity_of_carbon': {'canonical_units': 'kg m-2 s-1'},
 'gross_range_test_quality_flag': {'canonical_units': '1'},
 'gross_rate_of_decrease_in_area_fraction': {'canonical_units': 's-1'},
 'gross_rate_of_increase_in_area_fraction': {'canonical_units': 's-1'},
 'ground_level_altitude': {'canonical_units': 'm'},
 'grounded_ice_sheet_area': {'canonical_units': 'm2'},
 'grounded_ice_sheet_area_fraction': {'canonical_units': '1'},
 'growth_limitation_of_calcareous_phytoplankton_due_to_solar_irradiance': {'canonical_units': '1'},
 'growth_limitation_of_diatoms_due_to_solar_irradiance': {'canonical_units': '1'},
 'growth_limitation_of_diazotrophic_phytoplankton_due_to_solar_irradiance': {'canonical_units': '1'},
 'growth_limitation_of_diazotrophs_due_to_solar_irradiance': {'canonical_units': '1'},
 'growth_limitation_of_miscellaneous_phytoplankton_due_to_solar_irradiance': {'canonical_units': '1'},
 'growth_limitation_of_picophytoplankton_due_to_solar_irradiance': {'canonical_units': '1'},
 'hail_fall_amount': {'canonical_units': 'kg m-2'},
 'hail_fall_flux': {'canonical_units': 'kg m-2 s-1'},
 'halosteric_change_in_mean_sea_level': {'canonical_units': 'm'},
 'halosteric_change_in_sea_surface_height': {'canonical_units': 'm'},
 'harmonic_period': {'canonical_units': 's'},
 'heat_flux_correction': {'canonical_units': 'W m-2'},
 'heat_flux_into_sea_water_due_to_freezing_of_frazil_ice': {'canonical_units': 'W '
                                                                               'm-2'},
 'heat_flux_into_sea_water_due_to_iceberg_thermodynamics': {'canonical_units': 'W '
                                                                               'm-2'},
 'heat_flux_into_sea_water_due_to_newtonian_relaxation': {'canonical_units': 'W '
                                                                             'm-2'},
 'heat_flux_into_sea_water_due_to_sea_ice_thermodynamics': {'canonical_units': 'W '
                                                                               'm-2'},
 'heat_flux_into_sea_water_due_to_snow_thermodynamics': {'canonical_units': 'W '
                                                                            'm-2'},
 'heat_index_of_air_temperature': {'canonical_units': 'K'},
 'height': {'canonical_units': 'm'},
 'height_above_geopotential_datum': {'canonical_units': 'm'},
 'height_above_geopotential_datum_at_top_of_atmosphere_model': {'canonical_units': 'm'},
 'height_above_mean_sea_level': {'canonical_units': 'm'},
 'height_above_reference_ellipsoid': {'canonical_units': 'm'},
 'height_above_sea_floor': {'canonical_units': 'm'},
 'height_at_cloud_top': {'canonical_units': 'm'},
 'height_at_effective_cloud_top_defined_by_infrared_radiation': {'canonical_units': 'm'},
 'heterotrophic_respiration_carbon_flux': {'canonical_units': 'kg m-2 s-1'},
 'high_type_cloud_area_fraction': {'canonical_units': '1'},
 'histogram_of_backscattering_ratio_in_air_over_height_above_reference_ellipsoid': {'canonical_units': '1'},
 'histogram_of_backscattering_ratio_over_height_above_reference_ellipsoid': {'canonical_units': '1'},
 'histogram_of_equivalent_reflectivity_factor_over_height_above_reference_ellipsoid': {'canonical_units': '1'},
 'horizontal_atmosphere_dry_energy_transport': {'canonical_units': 'W m-2'},
 'horizontal_dry_energy_transport_in_atmosphere_layer': {'canonical_units': 'W '
                                                                            'm-2'},
 'humidity_mixing_ratio': {'canonical_units': '1'},
 'ice_cloud_area_fraction': {'canonical_units': '1'},
 'ice_cloud_area_fraction_in_atmosphere_layer': {'canonical_units': '1'},
 'ice_volume_in_frozen_ground_in_excess_of_pore_volume_in_unfrozen_ground_expressed_as_fraction_of_frozen_ground_volume': {'canonical_units': '1'},
 'incoming_water_volume_transport_along_river_channel': {'canonical_units': 'm3 '
                                                                            's-1'},
 'indicative_error_from_multibeam_acoustic_doppler_velocity_profiler_in_sea_water': {'canonical_units': 'm '
                                                                                                        's-1'},
 'institution': {'canonical_units': None},
 'integral_of_air_temperature_deficit_wrt_time': {'canonical_units': 'K s'},
 'integral_of_air_temperature_excess_wrt_time': {'canonical_units': 'K s'},
 'integral_of_product_of_eastward_wind_and_specific_humidity_wrt_height': {'canonical_units': 'm2 '
                                                                                              's-1'},
 'integral_of_product_of_northward_wind_and_specific_humidity_wrt_height': {'canonical_units': 'm2 '
                                                                                               's-1'},
 'integral_of_sea_ice_temperature_wrt_depth_expressed_as_heat_content': {'canonical_units': 'J '
                                                                                            'm-2'},
 'integral_of_sea_water_potential_temperature_wrt_depth_expressed_as_heat_content': {'canonical_units': 'J '
                                                                                                        'm-2'},
 'integral_of_sea_water_practical_salinity_wrt_depth': {'canonical_units': 'm'},
 'integral_of_sea_water_temperature_wrt_depth_in_ocean_layer': {'canonical_units': 'K '
                                                                                   'm'},
 'integral_of_surface_downward_eastward_stress_wrt_time': {'canonical_units': 'Pa '
                                                                              's'},
 'integral_of_surface_downward_latent_heat_flux_wrt_time': {'canonical_units': 'W '
                                                                               's '
                                                                               'm-2'},
 'integral_of_surface_downward_northward_stress_wrt_time': {'canonical_units': 'Pa '
                                                                               's'},
 'integral_of_surface_downward_sensible_heat_flux_wrt_time': {'canonical_units': 'W '
                                                                                 's '
                                                                                 'm-2'},
 'integral_of_surface_downwelling_longwave_flux_in_air_wrt_time': {'canonical_units': 'W '
                                                                                      's '
                                                                                      'm-2'},
 'integral_of_surface_downwelling_shortwave_flux_in_air_wrt_time': {'canonical_units': 'W '
                                                                                       's '
                                                                                       'm-2'},
 'integral_of_surface_net_downward_longwave_flux_wrt_time': {'canonical_units': 'W '
                                                                                's '
                                                                                'm-2'},
 'integral_of_surface_net_downward_shortwave_flux_wrt_time': {'canonical_units': 'W '
                                                                                 's '
                                                                                 'm-2'},
 'integral_of_toa_net_downward_shortwave_flux_wrt_time': {'canonical_units': 'W '
                                                                             's '
                                                                             'm-2'},
 'integral_of_toa_outgoing_longwave_flux_wrt_time': {'canonical_units': 'W s '
                                                                        'm-2'},
 'integral_wrt_depth_of_product_of_conservative_temperature_and_sea_water_density': {'canonical_units': 'kg '
                                                                                                        'degree_C '
                                                                                                        'm-2'},
 'integral_wrt_depth_of_product_of_potential_temperature_and_sea_water_density': {'canonical_units': 'kg '
                                                                                                     'degree_C '
                                                                                                     'm-2'},
 'integral_wrt_depth_of_product_of_salinity_and_sea_water_density': {'canonical_units': '1e-3 '
                                                                                        'kg '
                                                                                        'm-2'},
 'integral_wrt_depth_of_product_of_sea_water_density_and_conservative_temperature': {'canonical_units': 'kg '
                                                                                                        'degree_C '
                                                                                                        'm-2'},
 'integral_wrt_depth_of_product_of_sea_water_density_and_potential_temperature': {'canonical_units': 'kg '
                                                                                                     'degree_C '
                                                                                                     'm-2'},
 'integral_wrt_depth_of_product_of_sea_water_density_and_salinity': {'canonical_units': '1e-3 '
                                                                                        'kg '
                                                                                        'm-2'},
 'integral_wrt_depth_of_sea_ice_temperature_expressed_as_heat_content': {'canonical_units': 'J '
                                                                                            'm-2'},
 'integral_wrt_depth_of_sea_water_potential_temperature_expressed_as_heat_content': {'canonical_units': 'J '
                                                                                                        'm-2'},
 'integral_wrt_depth_of_sea_water_practical_salinity': {'canonical_units': 'm'},
 'integral_wrt_depth_of_sea_water_temperature': {'canonical_units': 'K m'},
 'integral_wrt_depth_of_sea_water_temperature_in_ocean_layer': {'canonical_units': 'K '
                                                                                   'm'},
 'integral_wrt_depth_of_tendency_of_sea_water_alkalinity_expressed_as_mole_equivalent': {'canonical_units': 'mol '
                                                                                                            'm-2 '
                                                                                                            's-1'},
 'integral_wrt_depth_of_tendency_of_sea_water_alkalinity_expressed_as_mole_equivalent_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                                        'm-2 '
                                                                                                                                        's-1'},
 'integral_wrt_height_of_product_of_eastward_wind_and_specific_humidity': {'canonical_units': 'm2 '
                                                                                              's-1'},
 'integral_wrt_height_of_product_of_northward_wind_and_specific_humidity': {'canonical_units': 'm2 '
                                                                                               's-1'},
 'integral_wrt_time_of_air_temperature_deficit': {'canonical_units': 'K s'},
 'integral_wrt_time_of_air_temperature_excess': {'canonical_units': 'K s'},
 'integral_wrt_time_of_mole_stomatal_uptake_of_ozone': {'canonical_units': 'mol '
                                                                           'm-2'},
 'integral_wrt_time_of_radioactivity_concentration_in_air': {'canonical_units': 'Bq '
                                                                                's '
                                                                                'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_101Mo_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_101Tc_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_102Mo_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_102Tc_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_102mTc_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_103Ru_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_103mRh_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_104Tc_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_105Rh_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_105Ru_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_105mRh_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_106Rh_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_106Ru_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_106mRh_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_107Pd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_107Rh_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_107mPd_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_109Pd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_109mAg_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_110mAg_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_111Ag_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_111Pd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_111mAg_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_111mCd_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_111mPd_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_112Ag_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_112Pd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_113Ag_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_113Cd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_113mAg_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_113mCd_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_113mIn_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_115Ag_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_115Cd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_115In_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_115mAg_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_115mCd_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_115mIn_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_116In_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_116mIn_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_117Cd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_117In_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_117mCd_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_117mIn_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_117mSn_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_118Cd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_118In_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_118mIn_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_119In_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_119mIn_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_119mSn_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_11C_in_air': {'canonical_units': 'Bq '
                                                                                       's '
                                                                                       'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_121Sn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_121mSn_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_123Sn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_123mSn_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_124Sb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_124mSb_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_125Sb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_125Sn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_125mTe_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_126Sb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_126Sn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_126mSb_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_127Sb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_127Sn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_127Te_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_127mTe_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_128Sb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_128Sn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_128mSb_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_129I_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_129Sb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_129Te_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_129mTe_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_129mXe_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_130I_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_130Sb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_130Sn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_130mI_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_130mSb_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_131I_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_131Sb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_131Te_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_131mTe_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_131mXe_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_132I_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_132Te_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_133I_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_133Te_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_133Xe_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_133mI_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_133mTe_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_133mXe_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_134Cs_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_134I_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_134Te_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_134mCs_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_134mI_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_134mXe_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_135Cs_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_135I_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_135Xe_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_135mBa_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_135mCs_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_135mXe_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_136Cs_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_137Cs_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_137Xe_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_137mBa_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_138Cs_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_138Xe_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_139Ba_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_13N_in_air': {'canonical_units': 'Bq '
                                                                                       's '
                                                                                       'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_140Ba_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_140La_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_141Ce_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_141La_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_142Ce_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_142La_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_142Pr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_142mPr_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_143Ce_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_143La_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_143Pr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_144Ce_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_144Nd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_144Pr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_144mPr_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_145Pr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_146Ce_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_146Pr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_147Nd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_147Pm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_147Pr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_147Sm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_148Pm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_148Sm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_148mPm_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_149Nd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_149Pm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_149Sm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_150Pm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_151Nd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_151Pm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_151Sm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_152Nd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_152Pm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_152mPm_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_153Sm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_154Eu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_155Eu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_155Sm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_156Eu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_156Sm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_157Eu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_158Eu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_159Eu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_159Gd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_15O_in_air': {'canonical_units': 'Bq '
                                                                                       's '
                                                                                       'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_160Tb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_161Tb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_162Gd_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_162Tb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_162mTb_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_163Tb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_165Dy_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_18F_in_air': {'canonical_units': 'Bq '
                                                                                       's '
                                                                                       'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_206Hg_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_206Tl_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_207Tl_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_207mPb_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_208Tl_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_209Bi_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_209Pb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_209Tl_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_210Bi_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_210Pb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_210Po_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_210Tl_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_211Bi_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_211Pb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_211Po_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_212Bi_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_212Pb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_212Po_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_213Bi_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_213Pb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_213Po_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_214Bi_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_214Pb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_214Po_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_215At_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_215Bi_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_215Po_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_216At_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_216Po_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_217At_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_217Po_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_218At_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_218Po_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_218Rn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_219At_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_219Rn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_220Rn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_221Fr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_221Rn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_222Fr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_222Ra_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_222Rn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_223Fr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_223Ra_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_223Rn_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_224Ra_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_225Ac_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_225Ra_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_226Ac_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_226Ra_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_226Th_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_227Ac_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_227Ra_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_227Th_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_228Ac_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_228Ra_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_228Th_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_229Ac_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_229Ra_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_229Th_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_230Pa_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_230Th_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_230U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_231Pa_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_231Th_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_231U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_232Pa_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_232Th_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_232U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_233Pa_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_233Th_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_233U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_234Pa_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_234Th_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_234U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_234mPa_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_235Np_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_235Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_235U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_236Np_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_236Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_236U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_236mNp_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_237Np_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_237Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_237U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_238Np_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_238Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_238U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_239Np_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_239Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_239U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_240Am_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_240Np_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_240Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_240U_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_240mNp_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_241Am_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_241Cm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_241Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_242Am_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_242Cm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_242Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_242m1Am_in_air': {'canonical_units': 'Bq '
                                                                                           's '
                                                                                           'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_242m2Am_in_air': {'canonical_units': 'Bq '
                                                                                           's '
                                                                                           'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_243Am_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_243Cm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_243Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_244Am_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_244Cm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_244Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_244mAm_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_245Am_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_245Cm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_245Pu_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_246Cm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_247Cm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_248Cm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_249Bk_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_249Cf_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_249Cm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_24Na_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_250Bk_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_250Cf_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_250Cm_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_251Cf_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_252Cf_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_253Cf_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_253Es_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_254Cf_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_254Es_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_254mEs_in_air': {'canonical_units': 'Bq '
                                                                                          's '
                                                                                          'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_255Es_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_3H_in_air': {'canonical_units': 'Bq '
                                                                                      's '
                                                                                      'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_41Ar_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_54Mn_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_58Co_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_60Co_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_72Ga_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_72Zn_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_73Ga_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_75Ge_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_77As_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_77Ge_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_77mGe_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_78As_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_78Ge_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_79Se_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_81Se_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_81mSe_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_82Br_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_82mBr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_83Br_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_83Se_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_83mKr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_83mSe_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_84Br_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_84mBr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_85Kr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_85mKr_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_86Rb_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_86mRb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_87Kr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_87Rb_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_88Kr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_88Rb_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_89Kr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_89Rb_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_89Sr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_90Sr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_90Y_in_air': {'canonical_units': 'Bq '
                                                                                       's '
                                                                                       'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_90mY_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_91Sr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_91Y_in_air': {'canonical_units': 'Bq '
                                                                                       's '
                                                                                       'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_91mY_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_92Sr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_92Y_in_air': {'canonical_units': 'Bq '
                                                                                       's '
                                                                                       'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_93Y_in_air': {'canonical_units': 'Bq '
                                                                                       's '
                                                                                       'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_93Zr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_94Nb_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_94Y_in_air': {'canonical_units': 'Bq '
                                                                                       's '
                                                                                       'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_94mNb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_95Nb_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_95Y_in_air': {'canonical_units': 'Bq '
                                                                                       's '
                                                                                       'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_95Zr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_95mNb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_96Nb_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_97Nb_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_97Zr_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_97mNb_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_98Nb_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_99Mo_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_99Tc_in_air': {'canonical_units': 'Bq '
                                                                                        's '
                                                                                        'm-3'},
 'integral_wrt_time_of_radioactivity_concentration_of_99mTc_in_air': {'canonical_units': 'Bq '
                                                                                         's '
                                                                                         'm-3'},
 'integral_wrt_time_of_surface_downward_eastward_stress': {'canonical_units': 'Pa '
                                                                              's'},
 'integral_wrt_time_of_surface_downward_latent_heat_flux': {'canonical_units': 'W '
                                                                               's '
                                                                               'm-2'},
 'integral_wrt_time_of_surface_downward_northward_stress': {'canonical_units': 'Pa '
                                                                               's'},
 'integral_wrt_time_of_surface_downward_sensible_heat_flux': {'canonical_units': 'W '
                                                                                 's '
                                                                                 'm-2'},
 'integral_wrt_time_of_surface_downwelling_longwave_flux_in_air': {'canonical_units': 'W '
                                                                                      's '
                                                                                      'm-2'},
 'integral_wrt_time_of_surface_downwelling_shortwave_flux_in_air': {'canonical_units': 'W '
                                                                                       's '
                                                                                       'm-2'},
 'integral_wrt_time_of_surface_net_downward_longwave_flux': {'canonical_units': 'W '
                                                                                's '
                                                                                'm-2'},
 'integral_wrt_time_of_surface_net_downward_shortwave_flux': {'canonical_units': 'W '
                                                                                 's '
                                                                                 'm-2'},
 'integral_wrt_time_of_toa_net_downward_shortwave_flux': {'canonical_units': 'W '
                                                                             's '
                                                                             'm-2'},
 'integral_wrt_time_of_toa_outgoing_longwave_flux': {'canonical_units': 'W s '
                                                                        'm-2'},
 'iron_growth_limitation_of_calcareous_phytoplankton': {'canonical_units': '1'},
 'iron_growth_limitation_of_diatoms': {'canonical_units': '1'},
 'iron_growth_limitation_of_diazotrophic_phytoplankton': {'canonical_units': '1'},
 'iron_growth_limitation_of_diazotrophs': {'canonical_units': '1'},
 'iron_growth_limitation_of_miscellaneous_phytoplankton': {'canonical_units': '1'},
 'iron_growth_limitation_of_picophytoplankton': {'canonical_units': '1'},
 'isccp_cloud_area_fraction': {'canonical_units': '1'},
 'isotope_ratio_of_17O_to_16O_in_sea_water_excluding_solutes_and_solids': {'canonical_units': '1'},
 'isotope_ratio_of_18O_to_16O_in_sea_water_excluding_solutes_and_solids': {'canonical_units': '1'},
 'isotropic_longwave_radiance_in_air': {'canonical_units': 'W m-2 sr-1'},
 'isotropic_radiance_per_unit_wavelength_in_air': {'canonical_units': 'W m-2 '
                                                                      'm-1 '
                                                                      'sr-1'},
 'isotropic_shortwave_radiance_in_air': {'canonical_units': 'W m-2 sr-1'},
 'isotropic_spectral_radiance_in_air': {'canonical_units': 'W m-2 m-1 sr-1'},
 'kinetic_energy_content_of_atmosphere_layer': {'canonical_units': 'J m-2'},
 'kinetic_energy_dissipation_in_atmosphere_boundary_layer': {'canonical_units': 'W '
                                                                                'm-2'},
 'lagrangian_tendency_of_air_pressure': {'canonical_units': 'Pa s-1'},
 'lagrangian_tendency_of_atmosphere_sigma_coordinate': {'canonical_units': 's-1'},
 'land_area_fraction': {'canonical_units': '1'},
 'land_binary_mask': {'canonical_units': '1'},
 'land_cover': {'canonical_units': None},
 'land_cover_lccs': {'canonical_units': None},
 'land_ice_area_fraction': {'canonical_units': '1'},
 'land_ice_basal_drag': {'canonical_units': 'Pa'},
 'land_ice_basal_melt_rate': {'canonical_units': 'm s-1'},
 'land_ice_basal_specific_mass_balance_flux': {'canonical_units': 'kg m-2 s-1'},
 'land_ice_basal_temperature': {'canonical_units': 'K'},
 'land_ice_basal_upward_velocity': {'canonical_units': 'm s-1'},
 'land_ice_basal_x_velocity': {'canonical_units': 'm s-1'},
 'land_ice_basal_y_velocity': {'canonical_units': 'm s-1'},
 'land_ice_calving_rate': {'canonical_units': 'm s-1'},
 'land_ice_lwe_basal_melt_rate': {'canonical_units': 'm s-1'},
 'land_ice_lwe_calving_rate': {'canonical_units': 'm s-1'},
 'land_ice_lwe_surface_specific_mass_balance': {'canonical_units': 'm s-1'},
 'land_ice_lwe_surface_specific_mass_balance_rate': {'canonical_units': 'm '
                                                                        's-1'},
 'land_ice_mass': {'canonical_units': 'kg'},
 'land_ice_mass_not_displacing_sea_water': {'canonical_units': 'kg'},
 'land_ice_runoff_flux': {'canonical_units': 'kg m-2 s-1'},
 'land_ice_sigma_coordinate': {'canonical_units': '1'},
 'land_ice_specific_mass_flux_due_to_calving': {'canonical_units': 'kg m-2 '
                                                                   's-1'},
 'land_ice_specific_mass_flux_due_to_calving_and_ice_front_melting': {'canonical_units': 'kg '
                                                                                         'm-2 '
                                                                                         's-1'},
 'land_ice_surface_melt_flux': {'canonical_units': 'kg m-2 s-1'},
 'land_ice_surface_specific_mass_balance': {'canonical_units': 'm s-1'},
 'land_ice_surface_specific_mass_balance_flux': {'canonical_units': 'kg m-2 '
                                                                    's-1'},
 'land_ice_surface_specific_mass_balance_rate': {'canonical_units': 'm s-1'},
 'land_ice_surface_upward_velocity': {'canonical_units': 'm s-1'},
 'land_ice_surface_x_velocity': {'canonical_units': 'm s-1'},
 'land_ice_surface_y_velocity': {'canonical_units': 'm s-1'},
 'land_ice_temperature': {'canonical_units': 'K'},
 'land_ice_thickness': {'canonical_units': 'm'},
 'land_ice_vertical_mean_x_velocity': {'canonical_units': 'm s-1'},
 'land_ice_vertical_mean_y_velocity': {'canonical_units': 'm s-1'},
 'land_ice_x_velocity': {'canonical_units': 'm s-1'},
 'land_ice_y_velocity': {'canonical_units': 'm s-1'},
 'land_surface_liquid_water_amount': {'canonical_units': 'kg m-2'},
 'land_water_amount': {'canonical_units': 'kg m-2'},
 'large_scale_cloud_area_fraction': {'canonical_units': '1'},
 'large_scale_graupel_flux': {'canonical_units': 'kg m-2 s-1'},
 'large_scale_precipitation_amount': {'canonical_units': 'kg m-2'},
 'large_scale_precipitation_flux': {'canonical_units': 'kg m-2 s-1'},
 'large_scale_rainfall_amount': {'canonical_units': 'kg m-2'},
 'large_scale_rainfall_flux': {'canonical_units': 'kg m-2 s-1'},
 'large_scale_rainfall_rate': {'canonical_units': 'm s-1'},
 'large_scale_snowfall_amount': {'canonical_units': 'kg m-2'},
 'large_scale_snowfall_flux': {'canonical_units': 'kg m-2 s-1'},
 'latitude': {'canonical_units': 'degree_north'},
 'leaf_area_index': {'canonical_units': '1'},
 'leaf_carbon_content': {'canonical_units': 'kg m-2'},
 'leaf_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'leaf_mass_content_of_nitrogen': {'canonical_units': 'kg m-2'},
 'lightning_potential_index': {'canonical_units': 'J Kg-1'},
 'lightning_radiant_energy': {'canonical_units': 'J'},
 'liquid_water_cloud_area_fraction': {'canonical_units': '1'},
 'liquid_water_cloud_area_fraction_in_atmosphere_layer': {'canonical_units': '1'},
 'liquid_water_content_of_permafrost_layer': {'canonical_units': 'kg m-2'},
 'liquid_water_content_of_snow_layer': {'canonical_units': 'kg m-2'},
 'liquid_water_content_of_soil_layer': {'canonical_units': 'kg m-2'},
 'liquid_water_content_of_surface_snow': {'canonical_units': 'kg m-2'},
 'liquid_water_mass_flux_into_soil_due_to_surface_snow_melt': {'canonical_units': 'kg '
                                                                                  'm-2 '
                                                                                  's-1'},
 'litter_carbon_content': {'canonical_units': 'kg m-2'},
 'litter_carbon_flux': {'canonical_units': 'kg m-2 s-1'},
 'litter_mass_content_of_13C': {'canonical_units': 'kg m-2'},
 'litter_mass_content_of_14C': {'canonical_units': 'kg m-2'},
 'litter_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'litter_mass_content_of_nitrogen': {'canonical_units': 'kg m-2'},
 'location_test_quality_flag': {'canonical_units': '1'},
 'log10_size_interval_based_number_size_distribution_of_cloud_condensation_nuclei_at_stp_in_air': {'canonical_units': 'm-3'},
 'longitude': {'canonical_units': 'degree_east'},
 'longwave_radiance': {'canonical_units': 'W m-2 sr-1'},
 'low_type_cloud_area_fraction': {'canonical_units': '1'},
 'lwe_convective_precipitation_rate': {'canonical_units': 'm s-1'},
 'lwe_convective_snowfall_rate': {'canonical_units': 'm s-1'},
 'lwe_large_scale_precipitation_rate': {'canonical_units': 'm s-1'},
 'lwe_large_scale_snowfall_rate': {'canonical_units': 'm s-1'},
 'lwe_precipitation_rate': {'canonical_units': 'm s-1'},
 'lwe_snowfall_rate': {'canonical_units': 'm s-1'},
 'lwe_stratiform_precipitation_rate': {'canonical_units': 'm s-1'},
 'lwe_stratiform_snowfall_rate': {'canonical_units': 'm s-1'},
 'lwe_thickness_of_atmosphere_mass_content_of_water_vapor': {'canonical_units': 'm'},
 'lwe_thickness_of_atmosphere_water_vapor_content': {'canonical_units': 'm'},
 'lwe_thickness_of_canopy_water_amount': {'canonical_units': 'm'},
 'lwe_thickness_of_convective_precipitation_amount': {'canonical_units': 'm'},
 'lwe_thickness_of_convective_snowfall_amount': {'canonical_units': 'm'},
 'lwe_thickness_of_frozen_water_content_of_soil_layer': {'canonical_units': 'm'},
 'lwe_thickness_of_large_scale_precipitation_amount': {'canonical_units': 'm'},
 'lwe_thickness_of_large_scale_snowfall_amount': {'canonical_units': 'm'},
 'lwe_thickness_of_moisture_content_of_soil_layer': {'canonical_units': 'm'},
 'lwe_thickness_of_precipitation_amount': {'canonical_units': 'm'},
 'lwe_thickness_of_snowfall_amount': {'canonical_units': 'm'},
 'lwe_thickness_of_soil_moisture_content': {'canonical_units': 'm'},
 'lwe_thickness_of_stratiform_precipitation_amount': {'canonical_units': 'm'},
 'lwe_thickness_of_stratiform_snowfall_amount': {'canonical_units': 'm'},
 'lwe_thickness_of_surface_snow_amount': {'canonical_units': 'm'},
 'lwe_thickness_of_water_evaporation_amount': {'canonical_units': 'm'},
 'lwe_water_evaporation_rate': {'canonical_units': 'm s-1'},
 'magnitude_of_air_velocity_relative_to_sea_water': {'canonical_units': 'm '
                                                                        's-1'},
 'magnitude_of_derivative_of_position_wrt_model_level_number': {'canonical_units': 'm'},
 'magnitude_of_derivative_of_position_wrt_x_coordinate_index': {'canonical_units': 'm'},
 'magnitude_of_derivative_of_position_wrt_y_coordinate_index': {'canonical_units': 'm'},
 'magnitude_of_heat_flux_in_sea_water_due_to_advection': {'canonical_units': 'W '
                                                                             'm-2'},
 'magnitude_of_sea_ice_displacement': {'canonical_units': 'm'},
 'magnitude_of_surface_downward_stress': {'canonical_units': 'Pa'},
 'mass_concentration_of_acetic_acid_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_aceto_nitrile_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_alkanes_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_alkenes_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_alpha_hexachlorocyclohexane_in_air': {'canonical_units': 'kg '
                                                                                 'm-3'},
 'mass_concentration_of_alpha_pinene_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_ammonia_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_ammonium_dry_aerosol_in_air': {'canonical_units': 'kg '
                                                                          'm-3'},
 'mass_concentration_of_ammonium_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                    'm-3'},
 'mass_concentration_of_anthropogenic_nmvoc_expressed_as_carbon_in_air': {'canonical_units': 'kg '
                                                                                             'm-3'},
 'mass_concentration_of_aromatic_compounds_in_air': {'canonical_units': 'kg '
                                                                        'm-3'},
 'mass_concentration_of_atomic_bromine_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_atomic_chlorine_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_atomic_nitrogen_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_benzene_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_beta_pinene_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_biogenic_nmvoc_expressed_as_carbon_in_air': {'canonical_units': 'kg '
                                                                                        'm-3'},
 'mass_concentration_of_biological_taxon_expressed_as_carbon_in_sea_water': {'canonical_units': 'kg '
                                                                                                'm-3'},
 'mass_concentration_of_biological_taxon_expressed_as_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                                                     'm-3'},
 'mass_concentration_of_biological_taxon_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'kg '
                                                                                                  'm-3'},
 'mass_concentration_of_biomass_burning_dry_aerosol_in_air': {'canonical_units': 'kg '
                                                                                 'm-3'},
 'mass_concentration_of_biomass_burning_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                           'm-3'},
 'mass_concentration_of_black_carbon_dry_aerosol_in_air': {'canonical_units': 'kg '
                                                                              'm-3'},
 'mass_concentration_of_bromine_chloride_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_bromine_monoxide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_bromine_nitrate_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_brox_expressed_as_bromine_in_air': {'canonical_units': 'kg '
                                                                               'm-3'},
 'mass_concentration_of_butane_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_calcareous_phytoplankton_expressed_as_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                                                             'm-3'},
 'mass_concentration_of_carbon_dioxide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_carbon_monoxide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_carbon_tetrachloride_in_air': {'canonical_units': 'kg '
                                                                          'm-3'},
 'mass_concentration_of_cfc113_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_cfc113a_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_cfc114_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_cfc115_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_cfc11_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_cfc12_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_chlorine_dioxide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_chlorine_monoxide_in_air': {'canonical_units': 'kg '
                                                                       'm-3'},
 'mass_concentration_of_chlorine_nitrate_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_chlorophyll_a_in_sea_water': {'canonical_units': 'kg '
                                                                         'm-3'},
 'mass_concentration_of_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                       'm-3'},
 'mass_concentration_of_cloud_liquid_water_in_air': {'canonical_units': 'kg '
                                                                        'm-3'},
 'mass_concentration_of_clox_expressed_as_chlorine_in_air': {'canonical_units': 'kg '
                                                                                'm-3'},
 'mass_concentration_of_coarse_mode_ambient_aerosol_in_air': {'canonical_units': 'kg '
                                                                                 'm-3'},
 'mass_concentration_of_coarse_mode_ambient_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                           'm-3'},
 'mass_concentration_of_condensed_water_in_soil': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_diatoms_expressed_as_carbon_in_sea_water': {'canonical_units': 'kg '
                                                                                       'm-3'},
 'mass_concentration_of_diatoms_expressed_as_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                                            'm-3'},
 'mass_concentration_of_diatoms_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'kg '
                                                                                         'm-3'},
 'mass_concentration_of_diazotrophic_phytoplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'kg '
                                                                                                          'm-3'},
 'mass_concentration_of_diazotrophic_phytoplankton_expressed_as_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                                                               'm-3'},
 'mass_concentration_of_diazotrophs_expressed_as_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                                                'm-3'},
 'mass_concentration_of_dichlorine_peroxide_in_air': {'canonical_units': 'kg '
                                                                         'm-3'},
 'mass_concentration_of_dimethyl_sulfide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_dinitrogen_pentoxide_in_air': {'canonical_units': 'kg '
                                                                          'm-3'},
 'mass_concentration_of_drizzle_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_dust_dry_aerosol_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_dust_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                'm-3'},
 'mass_concentration_of_elemental_carbon_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                            'm-3'},
 'mass_concentration_of_ethane_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_ethanol_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_ethene_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_ethyne_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_flagellates_expressed_as_carbon_in_sea_water': {'canonical_units': 'kg '
                                                                                           'm-3'},
 'mass_concentration_of_flagellates_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'kg '
                                                                                             'm-3'},
 'mass_concentration_of_formaldehyde_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_formic_acid_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_gaseous_divalent_mercury_in_air': {'canonical_units': 'kg '
                                                                              'm-3'},
 'mass_concentration_of_gaseous_elemental_mercury_in_air': {'canonical_units': 'kg '
                                                                               'm-3'},
 'mass_concentration_of_halon1202_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_halon1211_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_halon1301_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_halon2402_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_hcc140a_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_hcfc141b_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_hcfc142b_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_hcfc22_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_hexachlorobiphenyl_in_air': {'canonical_units': 'kg '
                                                                        'm-3'},
 'mass_concentration_of_hox_expressed_as_hydrogen_in_air': {'canonical_units': 'kg '
                                                                               'm-3'},
 'mass_concentration_of_hydrogen_bromide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_hydrogen_chloride_in_air': {'canonical_units': 'kg '
                                                                       'm-3'},
 'mass_concentration_of_hydrogen_cyanide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_hydrogen_peroxide_in_air': {'canonical_units': 'kg '
                                                                       'm-3'},
 'mass_concentration_of_hydroperoxyl_radical_in_air': {'canonical_units': 'kg '
                                                                          'm-3'},
 'mass_concentration_of_hydroxyl_radical_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_hypobromous_acid_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_hypochlorous_acid_in_air': {'canonical_units': 'kg '
                                                                       'm-3'},
 'mass_concentration_of_inorganic_bromine_in_air': {'canonical_units': 'kg '
                                                                       'm-3'},
 'mass_concentration_of_inorganic_chlorine_in_air': {'canonical_units': 'kg '
                                                                        'm-3'},
 'mass_concentration_of_inorganic_nitrogen_in_sea_water': {'canonical_units': 'kg '
                                                                              'm-3'},
 'mass_concentration_of_isoprene_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_limonene_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_liquid_water_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_mercury_dry_aerosol_in_air': {'canonical_units': 'kg '
                                                                         'm-3'},
 'mass_concentration_of_mercury_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                   'm-3'},
 'mass_concentration_of_methane_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_methanol_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_methyl_bromide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_methyl_chloride_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_methyl_hydroperoxide_in_air': {'canonical_units': 'kg '
                                                                          'm-3'},
 'mass_concentration_of_methyl_peroxy_radical_in_air': {'canonical_units': 'kg '
                                                                           'm-3'},
 'mass_concentration_of_microphytoplankton_expressed_as_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                                                       'm-3'},
 'mass_concentration_of_miscellaneous_phytoplankton_expressed_as_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                                                                'm-3'},
 'mass_concentration_of_molecular_hydrogen_in_air': {'canonical_units': 'kg '
                                                                        'm-3'},
 'mass_concentration_of_nanophytoplankton_expressed_as_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                                                      'm-3'},
 'mass_concentration_of_nitrate_dry_aerosol_in_air': {'canonical_units': 'kg '
                                                                         'm-3'},
 'mass_concentration_of_nitrate_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                   'm-3'},
 'mass_concentration_of_nitrate_radical_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_nitric_acid_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_nitric_acid_trihydrate_ambient_aerosol_in_air': {'canonical_units': 'kg '
                                                                                            'm-3'},
 'mass_concentration_of_nitric_acid_trihydrate_ambient_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                                      'm-3'},
 'mass_concentration_of_nitrogen_dioxide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_nitrogen_monoxide_in_air': {'canonical_units': 'kg '
                                                                       'm-3'},
 'mass_concentration_of_nitrous_acid_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_nitrous_oxide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_nmvoc_expressed_as_carbon_in_air': {'canonical_units': 'kg '
                                                                               'm-3'},
 'mass_concentration_of_nox_expressed_as_nitrogen_in_air': {'canonical_units': 'kg '
                                                                               'm-3'},
 'mass_concentration_of_noy_expressed_as_nitrogen_in_air': {'canonical_units': 'kg '
                                                                               'm-3'},
 'mass_concentration_of_organic_detritus_expressed_as_carbon_in_sea_water': {'canonical_units': 'kg '
                                                                                                'm-3'},
 'mass_concentration_of_organic_detritus_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'kg '
                                                                                                  'm-3'},
 'mass_concentration_of_oxygen_in_sea_water': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_oxygenated_hydrocarbons_in_air': {'canonical_units': 'kg '
                                                                             'm-3'},
 'mass_concentration_of_ozone_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_particulate_organic_matter_dry_aerosol_in_air': {'canonical_units': 'kg '
                                                                                            'm-3'},
 'mass_concentration_of_particulate_organic_matter_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                                      'm-3'},
 'mass_concentration_of_peroxy_radicals_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_peroxyacetyl_nitrate_in_air': {'canonical_units': 'kg '
                                                                          'm-3'},
 'mass_concentration_of_peroxynitric_acid_in_air': {'canonical_units': 'kg '
                                                                       'm-3'},
 'mass_concentration_of_petroleum_hydrocarbons_in_sea_water': {'canonical_units': 'kg '
                                                                                  'm-3'},
 'mass_concentration_of_phosphate_in_sea_water': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_phytoplankton_expressed_as_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                                                  'm-3'},
 'mass_concentration_of_picophytoplankton_expressed_as_chlorophyll_in_sea_water': {'canonical_units': 'kg '
                                                                                                      'm-3'},
 'mass_concentration_of_pm10_ambient_aerosol_in_air': {'canonical_units': 'kg '
                                                                          'm-3'},
 'mass_concentration_of_pm10_ambient_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                    'm-3'},
 'mass_concentration_of_pm10_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air': {'canonical_units': 'kg '
                                                                                                              'm-3'},
 'mass_concentration_of_pm10_sea_salt_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                         'm-3'},
 'mass_concentration_of_pm1_ambient_aerosol_in_air': {'canonical_units': 'kg '
                                                                         'm-3'},
 'mass_concentration_of_pm1_ambient_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                   'm-3'},
 'mass_concentration_of_pm2p5_ambient_aerosol_in_air': {'canonical_units': 'kg '
                                                                           'm-3'},
 'mass_concentration_of_pm2p5_ambient_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                     'm-3'},
 'mass_concentration_of_pm2p5_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air': {'canonical_units': 'kg '
                                                                                                               'm-3'},
 'mass_concentration_of_pm2p5_sea_salt_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                          'm-3'},
 'mass_concentration_of_primary_particulate_organic_matter_dry_aerosol_in_air': {'canonical_units': 'kg '
                                                                                                    'm-3'},
 'mass_concentration_of_primary_particulate_organic_matter_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                                              'm-3'},
 'mass_concentration_of_propane_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_propene_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_radon_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_rain_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air': {'canonical_units': 'kg '
                                                                                                         'm-3'},
 'mass_concentration_of_sea_salt_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                    'm-3'},
 'mass_concentration_of_seasalt_dry_aerosol_in_air': {'canonical_units': 'kg '
                                                                         'm-3'},
 'mass_concentration_of_seasalt_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                   'm-3'},
 'mass_concentration_of_secondary_particulate_organic_matter_dry_aerosol_in_air': {'canonical_units': 'kg '
                                                                                                      'm-3'},
 'mass_concentration_of_secondary_particulate_organic_matter_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                                                'm-3'},
 'mass_concentration_of_silicate_in_sea_water': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_sulfate_aerosol_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_sulfate_ambient_aerosol_in_air': {'canonical_units': 'kg '
                                                                             'm-3'},
 'mass_concentration_of_sulfate_ambient_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                       'm-3'},
 'mass_concentration_of_sulfate_dry_aerosol_in_air': {'canonical_units': 'kg '
                                                                         'm-3'},
 'mass_concentration_of_sulfate_dry_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                   'm-3'},
 'mass_concentration_of_sulfur_dioxide_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_suspended_matter_in_sea_water': {'canonical_units': 'kg '
                                                                            'm-3'},
 'mass_concentration_of_terpenes_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_toluene_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_volcanic_ash_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_water_in_ambient_aerosol_in_air': {'canonical_units': 'kg '
                                                                              'm-3'},
 'mass_concentration_of_water_in_ambient_aerosol_particles_in_air': {'canonical_units': 'kg '
                                                                                        'm-3'},
 'mass_concentration_of_water_vapor_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_xylene_in_air': {'canonical_units': 'kg m-3'},
 'mass_concentration_of_zooplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'kg '
                                                                                           'm-3'},
 'mass_content_of_13C_in_vegetation_and_litter_and_soil_and_forestry_and_agricultural_products': {'canonical_units': 'kg '
                                                                                                                     'm-2'},
 'mass_content_of_14C_in_vegetation_and_litter_and_soil_and_forestry_and_agricultural_products': {'canonical_units': 'kg '
                                                                                                                     'm-2'},
 'mass_content_of_carbon_in_vegetation_and_litter_and_soil_and_forestry_and_agricultural_products': {'canonical_units': 'kg '
                                                                                                                        'm-2'},
 'mass_content_of_cloud_condensed_water_in_atmosphere_layer': {'canonical_units': 'kg '
                                                                                  'm-2'},
 'mass_content_of_cloud_ice_in_atmosphere_layer': {'canonical_units': 'kg m-2'},
 'mass_content_of_cloud_liquid_water_in_atmosphere_layer': {'canonical_units': 'kg '
                                                                               'm-2'},
 'mass_content_of_nitrogen_in_vegetation_and_litter_and_soil_and_forestry_and_agricultural_products': {'canonical_units': 'kg '
                                                                                                                          'm-2'},
 'mass_content_of_water_in_atmosphere_layer': {'canonical_units': 'kg m-2'},
 'mass_content_of_water_in_soil': {'canonical_units': 'kg m-2'},
 'mass_content_of_water_in_soil_layer': {'canonical_units': 'kg m-2'},
 'mass_content_of_water_in_soil_layer_defined_by_root_depth': {'canonical_units': 'kg '
                                                                                  'm-2'},
 'mass_content_of_water_vapor_containing_17O_in_atmosphere_layer': {'canonical_units': 'kg '
                                                                                       'm-2'},
 'mass_content_of_water_vapor_containing_18O_in_atmosphere_layer': {'canonical_units': 'kg '
                                                                                       'm-2'},
 'mass_content_of_water_vapor_containing_single_2H_in_atmosphere_layer': {'canonical_units': 'kg '
                                                                                             'm-2'},
 'mass_content_of_water_vapor_in_atmosphere_layer': {'canonical_units': 'kg '
                                                                        'm-2'},
 'mass_flux_of_carbon_into_forestry_and_agricultural_products_due_to_crop_harvesting': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'mass_flux_of_carbon_into_litter_from_vegetation': {'canonical_units': 'kg '
                                                                        'm-2 '
                                                                        's-1'},
 'mass_flux_of_carbon_into_litter_from_vegetation_due_to_mortality': {'canonical_units': 'kg '
                                                                                         'm-2 '
                                                                                         's-1'},
 'mass_flux_of_carbon_into_litter_from_vegetation_due_to_senescence': {'canonical_units': 'kg '
                                                                                          'm-2 '
                                                                                          's-1'},
 'mass_flux_of_carbon_into_sea_water_from_rivers': {'canonical_units': 'kg m-2 '
                                                                       's-1'},
 'mass_flux_of_carbon_into_soil_from_vegetation_due_to_mortality': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'mass_flux_of_carbon_into_soil_from_vegetation_due_to_senescence': {'canonical_units': 'kg '
                                                                                        'm-2 '
                                                                                        's-1'},
 'mass_flux_of_carbon_out_of_soil_due_to_leaching_and_runoff': {'canonical_units': 'kg '
                                                                                   'm-2 '
                                                                                   's-1'},
 'mass_flux_of_nitrogen_compounds_expressed_as_nitrogen_into_sea_from_rivers': {'canonical_units': 'kg '
                                                                                                   'm-2 '
                                                                                                   's-1'},
 'mass_flux_of_nitrogen_compounds_expressed_as_nitrogen_out_of_litter_and_soil_due_to_immobilisation_and_remineralization': {'canonical_units': 'kg '
                                                                                                                                                'm-2 '
                                                                                                                                                's-1'},
 'mass_flux_of_nitrogen_compounds_expressed_as_nitrogen_out_of_vegetation_and_litter_and_soil_due_to_leaching_and_runoff': {'canonical_units': 'kg '
                                                                                                                                               'm-2 '
                                                                                                                                               's-1'},
 'mass_fraction_of_acetic_acid_in_air': {'canonical_units': '1'},
 'mass_fraction_of_aceto_nitrile_in_air': {'canonical_units': '1'},
 'mass_fraction_of_alkanes_in_air': {'canonical_units': '1'},
 'mass_fraction_of_alkenes_in_air': {'canonical_units': '1'},
 'mass_fraction_of_alpha_hexachlorocyclohexane_in_air': {'canonical_units': '1'},
 'mass_fraction_of_alpha_pinene_in_air': {'canonical_units': '1'},
 'mass_fraction_of_ammonia_in_air': {'canonical_units': '1'},
 'mass_fraction_of_ammonium_dry_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_ammonium_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_anthropogenic_nmvoc_expressed_as_carbon_in_air': {'canonical_units': '1'},
 'mass_fraction_of_aromatic_compounds_in_air': {'canonical_units': '1'},
 'mass_fraction_of_atomic_bromine_in_air': {'canonical_units': '1'},
 'mass_fraction_of_atomic_chlorine_in_air': {'canonical_units': '1'},
 'mass_fraction_of_atomic_nitrogen_in_air': {'canonical_units': '1'},
 'mass_fraction_of_benzene_in_air': {'canonical_units': '1'},
 'mass_fraction_of_beta_pinene_in_air': {'canonical_units': '1'},
 'mass_fraction_of_biogenic_nmvoc_expressed_as_carbon_in_air': {'canonical_units': '1'},
 'mass_fraction_of_black_carbon_dry_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_bromine_chloride_in_air': {'canonical_units': '1'},
 'mass_fraction_of_bromine_monoxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_bromine_nitrate_in_air': {'canonical_units': '1'},
 'mass_fraction_of_brox_expressed_as_bromine_in_air': {'canonical_units': '1'},
 'mass_fraction_of_butane_in_air': {'canonical_units': '1'},
 'mass_fraction_of_carbon_dioxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_carbon_dioxide_tracer_in_air': {'canonical_units': '1'},
 'mass_fraction_of_carbon_monoxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_carbon_tetrachloride_in_air': {'canonical_units': '1'},
 'mass_fraction_of_cfc113_in_air': {'canonical_units': '1'},
 'mass_fraction_of_cfc113a_in_air': {'canonical_units': '1'},
 'mass_fraction_of_cfc114_in_air': {'canonical_units': '1'},
 'mass_fraction_of_cfc115_in_air': {'canonical_units': '1'},
 'mass_fraction_of_cfc11_in_air': {'canonical_units': '1'},
 'mass_fraction_of_cfc12_in_air': {'canonical_units': '1'},
 'mass_fraction_of_chlorine_dioxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_chlorine_monoxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_chlorine_nitrate_in_air': {'canonical_units': '1'},
 'mass_fraction_of_chlorophyll_a_in_sea_water': {'canonical_units': '1'},
 'mass_fraction_of_clay_in_soil': {'canonical_units': '1'},
 'mass_fraction_of_cloud_condensed_water_in_air': {'canonical_units': '1'},
 'mass_fraction_of_cloud_ice_in_air': {'canonical_units': '1'},
 'mass_fraction_of_cloud_liquid_water_in_air': {'canonical_units': '1'},
 'mass_fraction_of_clox_expressed_as_chlorine_in_air': {'canonical_units': '1'},
 'mass_fraction_of_convective_cloud_condensed_water_in_air': {'canonical_units': '1'},
 'mass_fraction_of_convective_cloud_ice_in_air': {'canonical_units': '1'},
 'mass_fraction_of_convective_cloud_liquid_water_in_air': {'canonical_units': '1'},
 'mass_fraction_of_convective_condensed_water_in_air': {'canonical_units': '1'},
 'mass_fraction_of_dichlorine_peroxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_dimethyl_sulfide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_dinitrogen_pentoxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_dust_dry_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_dust_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_elemental_carbon_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_ethane_in_air': {'canonical_units': '1'},
 'mass_fraction_of_ethanol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_ethene_in_air': {'canonical_units': '1'},
 'mass_fraction_of_ethyne_in_air': {'canonical_units': '1'},
 'mass_fraction_of_formaldehyde_in_air': {'canonical_units': '1'},
 'mass_fraction_of_formic_acid_in_air': {'canonical_units': '1'},
 'mass_fraction_of_frozen_water_in_soil_moisture': {'canonical_units': '1'},
 'mass_fraction_of_gaseous_divalent_mercury_in_air': {'canonical_units': '1'},
 'mass_fraction_of_gaseous_elemental_mercury_in_air': {'canonical_units': '1'},
 'mass_fraction_of_graupel_and_hail_in_air': {'canonical_units': '1'},
 'mass_fraction_of_graupel_in_air': {'canonical_units': '1'},
 'mass_fraction_of_gravel_in_soil': {'canonical_units': '1'},
 'mass_fraction_of_hail_in_air': {'canonical_units': '1'},
 'mass_fraction_of_halon1202_in_air': {'canonical_units': '1'},
 'mass_fraction_of_halon1211_in_air': {'canonical_units': '1'},
 'mass_fraction_of_halon1301_in_air': {'canonical_units': '1'},
 'mass_fraction_of_halon2402_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hcc140a_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hcfc141b_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hcfc142b_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hcfc22_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hexachlorobiphenyl_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hox_expressed_as_hydrogen_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hydrogen_bromide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hydrogen_chloride_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hydrogen_cyanide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hydrogen_peroxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hydroperoxyl_radical_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hydroxyl_radical_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hypobromous_acid_in_air': {'canonical_units': '1'},
 'mass_fraction_of_hypochlorous_acid_in_air': {'canonical_units': '1'},
 'mass_fraction_of_inorganic_bromine_in_air': {'canonical_units': '1'},
 'mass_fraction_of_inorganic_chlorine_in_air': {'canonical_units': '1'},
 'mass_fraction_of_isoprene_in_air': {'canonical_units': '1'},
 'mass_fraction_of_limonene_in_air': {'canonical_units': '1'},
 'mass_fraction_of_liquid_precipitation_in_air': {'canonical_units': '1'},
 'mass_fraction_of_mercury_dry_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_mercury_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_methane_in_air': {'canonical_units': '1'},
 'mass_fraction_of_methanesulfonic_acid_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_methanol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_methyl_bromide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_methyl_chloride_in_air': {'canonical_units': '1'},
 'mass_fraction_of_methyl_hydroperoxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_methyl_peroxy_radical_in_air': {'canonical_units': '1'},
 'mass_fraction_of_molecular_hydrogen_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nitrate_dry_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nitrate_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nitrate_radical_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nitric_acid_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nitric_acid_trihydrate_ambient_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nitric_acid_trihydrate_ambient_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nitrogen_dioxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nitrogen_monoxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nitrous_acid_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nitrous_oxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nmvoc_expressed_as_carbon_in_air': {'canonical_units': '1'},
 'mass_fraction_of_nox_expressed_as_nitrogen_in_air': {'canonical_units': '1'},
 'mass_fraction_of_noy_expressed_as_nitrogen_in_air': {'canonical_units': '1'},
 'mass_fraction_of_o3_in_air': {'canonical_units': '1'},
 'mass_fraction_of_organic_matter_in_soil': {'canonical_units': '1'},
 'mass_fraction_of_oxygenated_hydrocarbons_in_air': {'canonical_units': '1'},
 'mass_fraction_of_ozone_in_air': {'canonical_units': '1'},
 'mass_fraction_of_particulate_organic_matter_dry_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_in_air': {'canonical_units': '1'},
 'mass_fraction_of_particulate_organic_matter_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_peroxy_radicals_in_air': {'canonical_units': '1'},
 'mass_fraction_of_peroxyacetyl_nitrate_in_air': {'canonical_units': '1'},
 'mass_fraction_of_peroxynitric_acid_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_ambient_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_ambient_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_ammonium_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_dust_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_elemental_carbon_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_nitrate_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_particulate_organic_matter_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_primary_particulate_organic_matter_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_sea_salt_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm10_sulfate_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm1_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm1_ambient_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm1_ambient_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm1_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_ambient_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_ambient_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_ammonium_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_dust_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_elemental_carbon_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_nitrate_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_particulate_organic_matter_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_primary_particulate_organic_matter_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_sea_salt_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_pm2p5_sulfate_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_precipitation_in_air': {'canonical_units': '1'},
 'mass_fraction_of_primary_particulate_organic_matter_dry_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_primary_particulate_organic_matter_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_propane_in_air': {'canonical_units': '1'},
 'mass_fraction_of_propene_in_air': {'canonical_units': '1'},
 'mass_fraction_of_radon_in_air': {'canonical_units': '1'},
 'mass_fraction_of_rain_and_drizzle_in_air': {'canonical_units': '1'},
 'mass_fraction_of_rain_in_air': {'canonical_units': '1'},
 'mass_fraction_of_rainfall_falling_onto_surface_snow': {'canonical_units': '1'},
 'mass_fraction_of_sand_in_soil': {'canonical_units': '1'},
 'mass_fraction_of_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air': {'canonical_units': '1'},
 'mass_fraction_of_sea_salt_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_seasalt_dry_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_seasalt_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_secondary_particulate_organic_matter_dry_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_secondary_particulate_organic_matter_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_shallow_convective_cloud_liquid_water_in_air': {'canonical_units': '1'},
 'mass_fraction_of_silt_in_soil': {'canonical_units': '1'},
 'mass_fraction_of_snow_in_air': {'canonical_units': '1'},
 'mass_fraction_of_solid_precipitation_falling_onto_surface_snow': {'canonical_units': '1'},
 'mass_fraction_of_stratiform_cloud_ice_in_air': {'canonical_units': '1'},
 'mass_fraction_of_stratiform_cloud_liquid_water_in_air': {'canonical_units': '1'},
 'mass_fraction_of_sulfate_dry_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_sulfate_dry_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_sulfur_dioxide_in_air': {'canonical_units': '1'},
 'mass_fraction_of_sulfuric_acid_in_air': {'canonical_units': '1'},
 'mass_fraction_of_terpenes_in_air': {'canonical_units': '1'},
 'mass_fraction_of_toluene_in_air': {'canonical_units': '1'},
 'mass_fraction_of_unfrozen_water_in_soil_moisture': {'canonical_units': '1'},
 'mass_fraction_of_water_in_air': {'canonical_units': '1'},
 'mass_fraction_of_water_in_ambient_aerosol_in_air': {'canonical_units': '1'},
 'mass_fraction_of_water_in_ambient_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_water_in_pm10_ambient_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_water_in_pm2p5_ambient_aerosol_particles_in_air': {'canonical_units': '1'},
 'mass_fraction_of_xylene_in_air': {'canonical_units': '1'},
 'maximum_over_coordinate_rotation_of_sea_ice_horizontal_shear_strain_rate': {'canonical_units': 's-1'},
 'maximum_over_coordinate_rotation_of_sea_ice_horizontal_shear_stress': {'canonical_units': 'N '
                                                                                            'm-1'},
 'medium_soil_pool_carbon_content': {'canonical_units': 'kg m-2'},
 'medium_soil_pool_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'medium_type_cloud_area_fraction': {'canonical_units': '1'},
 'minimum_depth_of_aragonite_undersaturation_in_sea_water': {'canonical_units': 'm'},
 'minimum_depth_of_calcite_undersaturation_in_sea_water': {'canonical_units': 'm'},
 'minus_one_times_surface_upwelling_longwave_flux_in_air': {'canonical_units': 'W '
                                                                               'm-2'},
 'minus_one_times_surface_upwelling_shortwave_flux_in_air': {'canonical_units': 'W '
                                                                                'm-2'},
 'minus_one_times_toa_outgoing_shortwave_flux': {'canonical_units': 'W m-2'},
 'minus_one_times_water_flux_into_sea_water_from_rivers': {'canonical_units': 'kg '
                                                                              'm-2 '
                                                                              's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_ammonia_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                   'm-2 '
                                                                                                   's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_ammonia_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                   'm-2 '
                                                                                                   's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_ammonium_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_ammonium_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_deposition': {'canonical_units': 'kg '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_insoluble_dust_dry_aerosol_particles_due_to_deposition': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_nitrogen_compounds_expressed_as_nitrogen_due_to_deposition': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_noy_expressed_as_nitrogen_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_noy_expressed_as_nitrogen_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_ozone_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                 'm-2 '
                                                                                                 's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                            'm-2 '
                                                                                                                                            's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                            'm-2 '
                                                                                                                                            's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_sea_salt_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_sea_salt_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'minus_tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'minus_tendency_of_ocean_mole_content_of_elemental_nitrogen_due_to_denitrification_and_sedimentation': {'canonical_units': 'mol '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'minus_tendency_of_ocean_mole_content_of_inorganic_carbon_due_to_sedimentation': {'canonical_units': 'mol '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'minus_tendency_of_ocean_mole_content_of_iron_due_to_sedimentation': {'canonical_units': 'mol '
                                                                                          'm-2 '
                                                                                          's-1'},
 'minus_tendency_of_ocean_mole_content_of_organic_carbon_due_to_sedimentation': {'canonical_units': 'mol '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'miscellaneous_living_matter_carbon_content': {'canonical_units': 'kg m-2'},
 'miscellaneous_living_matter_mass_content_of_carbon': {'canonical_units': 'kg '
                                                                           'm-2'},
 'miscellaneous_living_matter_mass_content_of_nitrogen': {'canonical_units': 'kg '
                                                                             'm-2'},
 'model_level_number': {'canonical_units': '1'},
 'model_level_number_at_base_of_ocean_mixed_layer_defined_by_sigma_theta': {'canonical_units': '1'},
 'model_level_number_at_convective_cloud_base': {'canonical_units': '1'},
 'model_level_number_at_convective_cloud_top': {'canonical_units': '1'},
 'model_level_number_at_sea_floor': {'canonical_units': '1'},
 'model_level_number_at_top_of_atmosphere_boundary_layer': {'canonical_units': '1'},
 'moisture_content_of_soil_layer': {'canonical_units': 'kg m-2'},
 'moisture_content_of_soil_layer_at_field_capacity': {'canonical_units': 'kg '
                                                                         'm-2'},
 'mole_concentration_of_acetic_acid_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_aceto_nitrile_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_alpha_hexachlorocyclohexane_in_air': {'canonical_units': 'mol '
                                                                                 'm-3'},
 'mole_concentration_of_alpha_pinene_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_ammonia_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_ammonium_in_sea_water': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_anthropogenic_nmvoc_expressed_as_carbon_in_air': {'canonical_units': 'mol '
                                                                                             'm-3'},
 'mole_concentration_of_aragonite_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                         'm-3'},
 'mole_concentration_of_aragonite_expressed_as_carbon_in_sea_water_at_saturation': {'canonical_units': 'mol '
                                                                                                       'm-3'},
 'mole_concentration_of_atomic_bromine_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_atomic_chlorine_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_atomic_nitrogen_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_bacteria_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                        'm-3'},
 'mole_concentration_of_benzene_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_beta_pinene_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_biogenic_nmvoc_expressed_as_carbon_in_air': {'canonical_units': 'mol '
                                                                                        'm-3'},
 'mole_concentration_of_biological_taxon_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                'm-3'},
 'mole_concentration_of_biological_taxon_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                                  'm-3'},
 'mole_concentration_of_bromine_chloride_in_air': {'canonical_units': 'mol '
                                                                      'm-3'},
 'mole_concentration_of_bromine_monoxide_in_air': {'canonical_units': 'mol '
                                                                      'm-3'},
 'mole_concentration_of_bromine_nitrate_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_brox_expressed_as_bromine_in_air': {'canonical_units': 'mol '
                                                                               'm-3'},
 'mole_concentration_of_butane_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_calcareous_phytoplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                        'm-3'},
 'mole_concentration_of_calcite_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                       'm-3'},
 'mole_concentration_of_calcite_expressed_as_carbon_in_sea_water_at_saturation': {'canonical_units': 'mol '
                                                                                                     'm-3'},
 'mole_concentration_of_carbon_dioxide_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_carbon_monoxide_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_carbon_tetrachloride_in_air': {'canonical_units': 'mol '
                                                                          'm-3'},
 'mole_concentration_of_carbonate_abiotic_analogue_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                          'm-3'},
 'mole_concentration_of_carbonate_expressed_as_carbon_at_equilibrium_with_pure_aragonite_in_sea_water': {'canonical_units': 'mol '
                                                                                                                            'm-3'},
 'mole_concentration_of_carbonate_expressed_as_carbon_at_equilibrium_with_pure_calcite_in_sea_water': {'canonical_units': 'mol '
                                                                                                                          'm-3'},
 'mole_concentration_of_carbonate_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                         'm-3'},
 'mole_concentration_of_carbonate_natural_analogue_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                          'm-3'},
 'mole_concentration_of_cfc113_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_cfc113a_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_cfc114_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_cfc115_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_cfc11_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_cfc11_in_sea_water': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_cfc12_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_cfc12_in_sea_water': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_chlorine_dioxide_in_air': {'canonical_units': 'mol '
                                                                      'm-3'},
 'mole_concentration_of_chlorine_monoxide_in_air': {'canonical_units': 'mol '
                                                                       'm-3'},
 'mole_concentration_of_chlorine_nitrate_in_air': {'canonical_units': 'mol '
                                                                      'm-3'},
 'mole_concentration_of_clox_expressed_as_chlorine_in_air': {'canonical_units': 'mol '
                                                                                'm-3'},
 'mole_concentration_of_diatoms_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                       'm-3'},
 'mole_concentration_of_diatoms_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                         'm-3'},
 'mole_concentration_of_diatoms_in_sea_water_expressed_as_nitrogen': {'canonical_units': 'mol '
                                                                                         'm-3'},
 'mole_concentration_of_diazotrophic_phytoplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                          'm-3'},
 'mole_concentration_of_diazotrophs_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                           'm-3'},
 'mole_concentration_of_dichlorine_peroxide_in_air': {'canonical_units': 'mol '
                                                                         'm-3'},
 'mole_concentration_of_dimethyl_sulfide_in_air': {'canonical_units': 'mol '
                                                                      'm-3'},
 'mole_concentration_of_dimethyl_sulfide_in_sea_water': {'canonical_units': 'mol '
                                                                            'm-3'},
 'mole_concentration_of_dinitrogen_pentoxide_in_air': {'canonical_units': 'mol '
                                                                          'm-3'},
 'mole_concentration_of_dissolved_inorganic_13C_in_sea_water': {'canonical_units': 'mol '
                                                                                   'm-3'},
 'mole_concentration_of_dissolved_inorganic_14C_in_sea_water': {'canonical_units': 'mol '
                                                                                   'm-3'},
 'mole_concentration_of_dissolved_inorganic_carbon13_in_sea_water': {'canonical_units': 'mol '
                                                                                        'm-3'},
 'mole_concentration_of_dissolved_inorganic_carbon14_in_sea_water': {'canonical_units': 'mol '
                                                                                        'm-3'},
 'mole_concentration_of_dissolved_inorganic_carbon_abiotic_analogue_in_sea_water': {'canonical_units': 'mol '
                                                                                                       'm-3'},
 'mole_concentration_of_dissolved_inorganic_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                      'm-3'},
 'mole_concentration_of_dissolved_inorganic_carbon_natural_analogue_in_sea_water': {'canonical_units': 'mol '
                                                                                                       'm-3'},
 'mole_concentration_of_dissolved_inorganic_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                        'm-3'},
 'mole_concentration_of_dissolved_inorganic_phosphorus_in_sea_water': {'canonical_units': 'mol '
                                                                                          'm-3'},
 'mole_concentration_of_dissolved_inorganic_silicon_in_sea_water': {'canonical_units': 'mol '
                                                                                       'm-3'},
 'mole_concentration_of_dissolved_iron_in_sea_water': {'canonical_units': 'mol '
                                                                          'm-3'},
 'mole_concentration_of_dissolved_molecular_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                        'm-3'},
 'mole_concentration_of_dissolved_molecular_oxygen_in_sea_water': {'canonical_units': 'mol '
                                                                                      'm-3'},
 'mole_concentration_of_dissolved_molecular_oxygen_in_sea_water_at_saturation': {'canonical_units': 'mol '
                                                                                                    'm-3'},
 'mole_concentration_of_dissolved_molecular_oxygen_in_sea_water_at_shallowest_local_minimum_in_vertical_profile': {'canonical_units': 'mol '
                                                                                                                                      'm-3'},
 'mole_concentration_of_dissolved_organic_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                    'm-3'},
 'mole_concentration_of_dissolved_organic_nitrogen_in_sea_water': {'canonical_units': 'mol/m3'},
 'mole_concentration_of_ethane_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_ethanol_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_ethene_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_ethyne_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_formaldehyde_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_formic_acid_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_gaseous_divalent_mercury_in_air': {'canonical_units': 'mol '
                                                                              'm-3'},
 'mole_concentration_of_gaseous_elemental_mercury_in_air': {'canonical_units': 'mol '
                                                                               'm-3'},
 'mole_concentration_of_halon1202_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_halon1211_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_halon1301_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_halon2402_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_hcc140a_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_hcfc141b_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_hcfc142b_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_hcfc22_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_hexachlorobiphenyl_in_air': {'canonical_units': 'mol '
                                                                        'm-3'},
 'mole_concentration_of_hox_expressed_as_hydrogen_in_air': {'canonical_units': 'mol '
                                                                               'm-3'},
 'mole_concentration_of_hydrogen_bromide_in_air': {'canonical_units': 'mol '
                                                                      'm-3'},
 'mole_concentration_of_hydrogen_chloride_in_air': {'canonical_units': 'mol '
                                                                       'm-3'},
 'mole_concentration_of_hydrogen_cyanide_in_air': {'canonical_units': 'mol '
                                                                      'm-3'},
 'mole_concentration_of_hydrogen_peroxide_in_air': {'canonical_units': 'mol '
                                                                       'm-3'},
 'mole_concentration_of_hydrogen_sulfide_in_sea_water': {'canonical_units': 'mol '
                                                                            'm-3'},
 'mole_concentration_of_hydroperoxyl_radical_in_air': {'canonical_units': 'mol '
                                                                          'm-3'},
 'mole_concentration_of_hydroxyl_radical_in_air': {'canonical_units': 'mol '
                                                                      'm-3'},
 'mole_concentration_of_hypobromous_acid_in_air': {'canonical_units': 'mol '
                                                                      'm-3'},
 'mole_concentration_of_hypochlorous_acid_in_air': {'canonical_units': 'mol '
                                                                       'm-3'},
 'mole_concentration_of_inorganic_bromine_in_air': {'canonical_units': 'mol '
                                                                       'm-3'},
 'mole_concentration_of_inorganic_chlorine_in_air': {'canonical_units': 'mol '
                                                                        'm-3'},
 'mole_concentration_of_isoprene_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_limonene_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_mesozooplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                               'm-3'},
 'mole_concentration_of_mesozooplankton_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                                 'm-3'},
 'mole_concentration_of_mesozooplankton_in_sea_water_expressed_as_nitrogen': {'canonical_units': 'mol '
                                                                                                 'm-3'},
 'mole_concentration_of_methane_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_methanol_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_methyl_bromide_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_methyl_chloride_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_methyl_hydroperoxide_in_air': {'canonical_units': 'mol '
                                                                          'm-3'},
 'mole_concentration_of_methyl_peroxy_radical_in_air': {'canonical_units': 'mol '
                                                                           'm-3'},
 'mole_concentration_of_microzooplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                'm-3'},
 'mole_concentration_of_microzooplankton_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                                  'm-3'},
 'mole_concentration_of_microzooplankton_in_sea_water_expressed_as_nitrogen': {'canonical_units': 'mol '
                                                                                                  'm-3'},
 'mole_concentration_of_miscellaneous_phytoplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                           'm-3'},
 'mole_concentration_of_miscellaneous_zooplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                         'm-3'},
 'mole_concentration_of_molecular_hydrogen_in_air': {'canonical_units': 'mol '
                                                                        'm-3'},
 'mole_concentration_of_nitrate_and_nitrite_in_sea_water': {'canonical_units': 'mol '
                                                                               'm-3'},
 'mole_concentration_of_nitrate_in_sea_water': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_nitrate_radical_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_nitric_acid_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_nitric_acid_trihydrate_ambient_aerosol_in_air': {'canonical_units': 'mol '
                                                                                            'm-3'},
 'mole_concentration_of_nitric_acid_trihydrate_ambient_aerosol_particles_in_air': {'canonical_units': 'mol '
                                                                                                      'm-3'},
 'mole_concentration_of_nitrite_in_sea_water': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_nitrogen_dioxide_in_air': {'canonical_units': 'mol '
                                                                      'm-3'},
 'mole_concentration_of_nitrogen_monoxide_in_air': {'canonical_units': 'mol '
                                                                       'm-3'},
 'mole_concentration_of_nitrous_acid_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_nitrous_oxide_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_nmvoc_expressed_as_carbon_in_air': {'canonical_units': 'mol '
                                                                               'm-3'},
 'mole_concentration_of_nox_expressed_as_nitrogen_in_air': {'canonical_units': 'mol '
                                                                               'm-3'},
 'mole_concentration_of_noy_expressed_as_nitrogen_in_air': {'canonical_units': 'mol '
                                                                               'm-3'},
 'mole_concentration_of_organic_detritus_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                'm-3'},
 'mole_concentration_of_organic_detritus_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                                  'm-3'},
 'mole_concentration_of_organic_detritus_expressed_as_silicon_in_sea_water': {'canonical_units': 'mol '
                                                                                                 'm-3'},
 'mole_concentration_of_organic_detritus_in_sea_water_expressed_as_nitrogen': {'canonical_units': 'mol '
                                                                                                  'm-3'},
 'mole_concentration_of_organic_detritus_in_sea_water_expressed_as_silicon': {'canonical_units': 'mol '
                                                                                                 'm-3'},
 'mole_concentration_of_ozone_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_particulate_matter_expressed_as_silicon_in_sea_water': {'canonical_units': 'mol '
                                                                                                   'm-3'},
 'mole_concentration_of_particulate_organic_matter_expressed_as_iron_in_sea_water': {'canonical_units': 'mol '
                                                                                                        'm-3'},
 'mole_concentration_of_particulate_organic_matter_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                                            'm-3'},
 'mole_concentration_of_particulate_organic_matter_expressed_as_phosphorus_in_sea_water': {'canonical_units': 'mol '
                                                                                                              'm-3'},
 'mole_concentration_of_particulate_organic_matter_expressed_as_silicon_in_sea_water': {'canonical_units': 'mol '
                                                                                                           'm-3'},
 'mole_concentration_of_particulate_organic_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                        'm-3'},
 'mole_concentration_of_peroxyacetyl_nitrate_in_air': {'canonical_units': 'mol '
                                                                          'm-3'},
 'mole_concentration_of_peroxynitric_acid_in_air': {'canonical_units': 'mol '
                                                                       'm-3'},
 'mole_concentration_of_phosphate_in_sea_water': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_phytoplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                             'm-3'},
 'mole_concentration_of_phytoplankton_expressed_as_iron_in_sea_water': {'canonical_units': 'mol '
                                                                                           'm-3'},
 'mole_concentration_of_phytoplankton_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                               'm-3'},
 'mole_concentration_of_phytoplankton_expressed_as_phosphorus_in_sea_water': {'canonical_units': 'mol '
                                                                                                 'm-3'},
 'mole_concentration_of_phytoplankton_expressed_as_silicon_in_sea_water': {'canonical_units': 'mol '
                                                                                              'm-3'},
 'mole_concentration_of_phytoplankton_in_sea_water_expressed_as_nitrogen': {'canonical_units': 'mol '
                                                                                               'm-3'},
 'mole_concentration_of_picophytoplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                 'm-3'},
 'mole_concentration_of_propane_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_propene_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_radon_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_silicate_in_sea_water': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_sulfur_dioxide_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_sulfur_hexafluoride_in_sea_water': {'canonical_units': 'mol '
                                                                               'm-3'},
 'mole_concentration_of_toluene_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_water_vapor_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_xylene_in_air': {'canonical_units': 'mol m-3'},
 'mole_concentration_of_zooplankton_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                           'm-3'},
 'mole_concentration_of_zooplankton_expressed_as_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                             'm-3'},
 'mole_content_of_carbon_monoxide_in_atmosphere_layer': {'canonical_units': 'mol '
                                                                            'm-2'},
 'mole_content_of_methane_in_atmosphere_layer': {'canonical_units': 'mol m-2'},
 'mole_content_of_nitrogen_dioxide_in_atmosphere_layer': {'canonical_units': 'mol '
                                                                             'm-2'},
 'mole_content_of_ozone_in_atmosphere_layer': {'canonical_units': 'mol m-2'},
 'mole_fraction_of_acetaldehyde_in_air': {'canonical_units': '1'},
 'mole_fraction_of_acetic_acid_in_air': {'canonical_units': '1'},
 'mole_fraction_of_aceto_nitrile_in_air': {'canonical_units': '1'},
 'mole_fraction_of_acetone_in_air': {'canonical_units': '1'},
 'mole_fraction_of_aldehydes_in_air': {'canonical_units': '1'},
 'mole_fraction_of_alkanes_in_air': {'canonical_units': '1'},
 'mole_fraction_of_alkenes_in_air': {'canonical_units': '1'},
 'mole_fraction_of_alpha_hexachlorocyclohexane_in_air': {'canonical_units': '1'},
 'mole_fraction_of_alpha_pinene_in_air': {'canonical_units': '1'},
 'mole_fraction_of_ammonia_in_air': {'canonical_units': '1'},
 'mole_fraction_of_anthropogenic_nmvoc_expressed_as_carbon_in_air': {'canonical_units': '1'},
 'mole_fraction_of_artificial_tracer_with_fixed_lifetime_in_air': {'canonical_units': '1'},
 'mole_fraction_of_atomic_bromine_in_air': {'canonical_units': '1'},
 'mole_fraction_of_atomic_chlorine_in_air': {'canonical_units': '1'},
 'mole_fraction_of_atomic_nitrogen_in_air': {'canonical_units': '1'},
 'mole_fraction_of_benzene_in_air': {'canonical_units': '1'},
 'mole_fraction_of_beta_pinene_in_air': {'canonical_units': '1'},
 'mole_fraction_of_biogenic_nmvoc_expressed_as_carbon_in_air': {'canonical_units': '1'},
 'mole_fraction_of_bromine_chloride_in_air': {'canonical_units': '1'},
 'mole_fraction_of_bromine_monoxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_bromine_nitrate_in_air': {'canonical_units': '1'},
 'mole_fraction_of_brox_expressed_as_bromine_in_air': {'canonical_units': '1'},
 'mole_fraction_of_butane_in_air': {'canonical_units': '1'},
 'mole_fraction_of_carbon_dioxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_carbon_monoxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_carbon_tetrachloride_in_air': {'canonical_units': '1'},
 'mole_fraction_of_carbon_tetrafluoride_in_air': {'canonical_units': '1'},
 'mole_fraction_of_carbonyl_fluoride_in_air': {'canonical_units': '1'},
 'mole_fraction_of_carbonyl_sulfide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_cfc113_in_air': {'canonical_units': '1'},
 'mole_fraction_of_cfc113a_in_air': {'canonical_units': '1'},
 'mole_fraction_of_cfc114_in_air': {'canonical_units': '1'},
 'mole_fraction_of_cfc115_in_air': {'canonical_units': '1'},
 'mole_fraction_of_cfc11_in_air': {'canonical_units': '1'},
 'mole_fraction_of_cfc12_in_air': {'canonical_units': '1'},
 'mole_fraction_of_chlorine dioxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_chlorine monoxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_chlorine_dioxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_chlorine_monoxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_chlorine_nitrate_in_air': {'canonical_units': '1'},
 'mole_fraction_of_chloroform_in_air': {'canonical_units': '1'},
 'mole_fraction_of_clox_expressed_as_chlorine_in_air': {'canonical_units': '1'},
 'mole_fraction_of_dichlorine peroxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_dichlorine_in_air': {'canonical_units': '1'},
 'mole_fraction_of_dichlorine_peroxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_dichloromethane_in_air': {'canonical_units': '1'},
 'mole_fraction_of_dimethyl_sulfide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_dinitrogen_pentoxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_ethane_in_air': {'canonical_units': '1'},
 'mole_fraction_of_ethanol_in_air': {'canonical_units': '1'},
 'mole_fraction_of_ethene_in_air': {'canonical_units': '1'},
 'mole_fraction_of_ethyne_in_air': {'canonical_units': '1'},
 'mole_fraction_of_formaldehyde_in_air': {'canonical_units': '1'},
 'mole_fraction_of_formic_acid_in_air': {'canonical_units': '1'},
 'mole_fraction_of_gaseous_divalent_mercury_in_air': {'canonical_units': '1'},
 'mole_fraction_of_gaseous_elemental_mercury_in_air': {'canonical_units': '1'},
 'mole_fraction_of_glyoxal_in_air': {'canonical_units': '1'},
 'mole_fraction_of_halon1202_in_air': {'canonical_units': '1'},
 'mole_fraction_of_halon1211_in_air': {'canonical_units': '1'},
 'mole_fraction_of_halon1301_in_air': {'canonical_units': '1'},
 'mole_fraction_of_halon2402_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hcc140a_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hcfc124_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hcfc141b_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hcfc142b_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hcfc22_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hexachlorobiphenyl_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc125_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc134a_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc143a_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc152a_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc227ea_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc236fa_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc23_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc245fa_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc32_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc365mfc_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hfc4310mee_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hox_expressed_as_hydrogen_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hydrogen_bromide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hydrogen_chloride_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hydrogen_cyanide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hydrogen_peroxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hydrogen_sulfide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hydroperoxyl_radical_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hydroxyl_radical_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hypobromous_acid_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hypochlorous acid_in_air': {'canonical_units': '1'},
 'mole_fraction_of_hypochlorous_acid_in_air': {'canonical_units': '1'},
 'mole_fraction_of_inorganic_bromine_in_air': {'canonical_units': '1'},
 'mole_fraction_of_inorganic_chlorine_in_air': {'canonical_units': '1'},
 'mole_fraction_of_isoprene_in_air': {'canonical_units': '1'},
 'mole_fraction_of_limonene_in_air': {'canonical_units': '1'},
 'mole_fraction_of_methane_in_air': {'canonical_units': '1'},
 'mole_fraction_of_methanol_in_air': {'canonical_units': '1'},
 'mole_fraction_of_methlyglyoxal_in_air': {'canonical_units': '1'},
 'mole_fraction_of_methyl_bromide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_methyl_chloride_in_air': {'canonical_units': '1'},
 'mole_fraction_of_methyl_hydroperoxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_methyl_peroxy_radical_in_air': {'canonical_units': '1'},
 'mole_fraction_of_methylglyoxal_in_air': {'canonical_units': '1'},
 'mole_fraction_of_molecular_hydrogen_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nitrate_radical_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nitric_acid_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nitric_acid_trihydrate_ambient_aerosol_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nitric_acid_trihydrate_ambient_aerosol_particles_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nitrogen_dioxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nitrogen_monoxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nitrogen_trifluoride_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nitrous_acid_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nitrous_oxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nmvoc_expressed_as_carbon_in_air': {'canonical_units': '1'},
 'mole_fraction_of_nox_expressed_as_nitrogen_in_air': {'canonical_units': '1'},
 'mole_fraction_of_noy_expressed_as_nitrogen_in_air': {'canonical_units': '1'},
 'mole_fraction_of_o3_in_air': {'canonical_units': '1'},
 'mole_fraction_of_organic_nitrates_in_air': {'canonical_units': '1'},
 'mole_fraction_of_ox_in_air': {'canonical_units': '1'},
 'mole_fraction_of_ozone_in_air': {'canonical_units': '1'},
 'mole_fraction_of_perchloroethene_in_air': {'canonical_units': '1'},
 'mole_fraction_of_peroxyacetyl_nitrate_in_air': {'canonical_units': '1'},
 'mole_fraction_of_peroxynitric_acid_in_air': {'canonical_units': '1'},
 'mole_fraction_of_pfc116_in_air': {'canonical_units': '1'},
 'mole_fraction_of_pfc218_in_air': {'canonical_units': '1'},
 'mole_fraction_of_pfc318_in_air': {'canonical_units': '1'},
 'mole_fraction_of_propane_in_air': {'canonical_units': '1'},
 'mole_fraction_of_propene_in_air': {'canonical_units': '1'},
 'mole_fraction_of_radon_in_air': {'canonical_units': '1'},
 'mole_fraction_of_sulfur_dioxide_in_air': {'canonical_units': '1'},
 'mole_fraction_of_sulfur_hexafluoride_in_air': {'canonical_units': '1'},
 'mole_fraction_of_sulfuryl_fluoride_in_air': {'canonical_units': '1'},
 'mole_fraction_of_toluene_in_air': {'canonical_units': '1'},
 'mole_fraction_of_total_inorganic_bromine_in_air': {'canonical_units': '1'},
 'mole_fraction_of_total_reactive_nitrogen_in_air': {'canonical_units': '1'},
 'mole_fraction_of_water_vapor_in_air': {'canonical_units': '1'},
 'mole_fraction_of_xylene_in_air': {'canonical_units': '1'},
 'mole_ratio_of_nitrate_to_phosphate_in_sea_water': {'canonical_units': '1'},
 'moles_of_carbon_monoxide_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_carbon_tetrachloride_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_cfc113_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_cfc114_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_cfc115_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_cfc11_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_cfc11_per_unit_mass_in_sea_water': {'canonical_units': 'mol kg-1'},
 'moles_of_cfc12_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_dissolved_inorganic_carbon_per_unit_mass_in_sea_water': {'canonical_units': 'mol '
                                                                                       'kg-1'},
 'moles_of_halon1202_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_halon1211_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_halon1301_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_halon2402_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_hcc140a_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_hcfc22_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_methane_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_methyl_bromide_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_methyl_chloride_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_molecular_hydrogen_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_nitrate_and_nitrite_per_unit_mass_in_sea_water': {'canonical_units': 'mol '
                                                                                'kg-1'},
 'moles_of_nitrate_per_unit_mass_in_sea_water': {'canonical_units': 'mol kg-1'},
 'moles_of_nitrite_per_unit_mass_in_sea_water': {'canonical_units': 'mol kg-1'},
 'moles_of_nitrous_oxide_in_atmosphere': {'canonical_units': 'mol'},
 'moles_of_oxygen_per_unit_mass_in_sea_water': {'canonical_units': 'mol kg-1'},
 'moles_of_phosphate_per_unit_mass_in_sea_water': {'canonical_units': 'mol '
                                                                      'kg-1'},
 'moles_of_silicate_per_unit_mass_in_sea_water': {'canonical_units': 'mol '
                                                                     'kg-1'},
 'moles_per_unit_mass_of_cfc11_in_sea_water': {'canonical_units': 'mol kg-1'},
 'multi_variate_test_quality_flag': {'canonical_units': '1'},
 'neighbor_test_quality_flag': {'canonical_units': '1'},
 'net_downward_longwave_flux_in_air': {'canonical_units': 'W m-2'},
 'net_downward_longwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                             'm-2'},
 'net_downward_radiative_flux_at_top_of_atmosphere_model': {'canonical_units': 'W '
                                                                               'm-2'},
 'net_downward_shortwave_flux_at_sea_water_surface': {'canonical_units': 'W '
                                                                         'm-2'},
 'net_downward_shortwave_flux_in_air': {'canonical_units': 'W m-2'},
 'net_downward_shortwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                              'm-2'},
 'net_primary_mole_productivity_of_biomass_expressed_as_carbon_by_calcareous_phytoplankton': {'canonical_units': 'mol '
                                                                                                                 'm-2 '
                                                                                                                 's-1'},
 'net_primary_mole_productivity_of_biomass_expressed_as_carbon_by_diatoms': {'canonical_units': 'mol '
                                                                                                'm-2 '
                                                                                                's-1'},
 'net_primary_mole_productivity_of_biomass_expressed_as_carbon_by_diazotrophic_phytoplankton': {'canonical_units': 'mol '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'net_primary_mole_productivity_of_biomass_expressed_as_carbon_by_diazotrophs': {'canonical_units': 'mol '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'net_primary_mole_productivity_of_biomass_expressed_as_carbon_by_miscellaneous_phytoplankton': {'canonical_units': 'mol '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'net_primary_mole_productivity_of_biomass_expressed_as_carbon_by_phytoplankton': {'canonical_units': 'mol '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'net_primary_mole_productivity_of_biomass_expressed_as_carbon_by_picophytoplankton': {'canonical_units': 'mol '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'net_primary_mole_productivity_of_biomass_expressed_as_carbon_due_to_nitrate_utilization': {'canonical_units': 'mol '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'net_primary_mole_productivity_of_carbon_by_calcareous_phytoplankton': {'canonical_units': 'mol '
                                                                                            'm-2 '
                                                                                            's-1'},
 'net_primary_mole_productivity_of_carbon_by_diatoms': {'canonical_units': 'mol '
                                                                           'm-2 '
                                                                           's-1'},
 'net_primary_mole_productivity_of_carbon_by_diazotrophs': {'canonical_units': 'mol '
                                                                               'm-2 '
                                                                               's-1'},
 'net_primary_mole_productivity_of_carbon_by_miscellaneous_phytoplankton': {'canonical_units': 'mol '
                                                                                               'm-2 '
                                                                                               's-1'},
 'net_primary_mole_productivity_of_carbon_by_phytoplankton': {'canonical_units': 'mol '
                                                                                 'm-2 '
                                                                                 's-1'},
 'net_primary_mole_productivity_of_carbon_by_picophytoplankton': {'canonical_units': 'mol '
                                                                                     'm-2 '
                                                                                     's-1'},
 'net_primary_mole_productivity_of_carbon_due_to_nitrate_utilization': {'canonical_units': 'mol '
                                                                                           'm-2 '
                                                                                           's-1'},
 'net_primary_production_of_biomass_expressed_as_carbon_per_unit_volume_in_sea_water': {'canonical_units': 'kg '
                                                                                                           'm-3 '
                                                                                                           's-1'},
 'net_primary_productivity_of_biomass_expressed_as_carbon': {'canonical_units': 'kg '
                                                                                'm-2 '
                                                                                's-1'},
 'net_primary_productivity_of_biomass_expressed_as_carbon_accumulated_in_leaves': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'net_primary_productivity_of_biomass_expressed_as_carbon_accumulated_in_miscellaneous_living_matter': {'canonical_units': 'kg '
                                                                                                                           'm-2 '
                                                                                                                           's-1'},
 'net_primary_productivity_of_biomass_expressed_as_carbon_accumulated_in_roots': {'canonical_units': 'kg '
                                                                                                     'm-2 '
                                                                                                     's-1'},
 'net_primary_productivity_of_biomass_expressed_as_carbon_accumulated_in_stems': {'canonical_units': 'kg '
                                                                                                     'm-2 '
                                                                                                     's-1'},
 'net_primary_productivity_of_biomass_expressed_as_carbon_accumulated_in_wood': {'canonical_units': 'kg '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'net_primary_productivity_of_carbon': {'canonical_units': 'kg m-2 s-1'},
 'net_primary_productivity_of_carbon_accumulated_in_leaves': {'canonical_units': 'kg '
                                                                                 'm-2 '
                                                                                 's-1'},
 'net_primary_productivity_of_carbon_accumulated_in_roots': {'canonical_units': 'kg '
                                                                                'm-2 '
                                                                                's-1'},
 'net_primary_productivity_of_carbon_accumulated_in_wood': {'canonical_units': 'kg '
                                                                               'm-2 '
                                                                               's-1'},
 'net_rate_of_absorption_of_longwave_energy_in_atmosphere_layer': {'canonical_units': 'W '
                                                                                      'm-2'},
 'net_rate_of_absorption_of_shortwave_energy_in_atmosphere_layer': {'canonical_units': 'W '
                                                                                       'm-2'},
 'net_rate_of_absorption_of_shortwave_energy_in_ocean_layer': {'canonical_units': 'W '
                                                                                  'm-2'},
 'net_upward_longwave_flux_in_air': {'canonical_units': 'W m-2'},
 'net_upward_longwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                           'm-2'},
 'net_upward_shortwave_flux_in_air': {'canonical_units': 'W m-2'},
 'net_upward_shortwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                            'm-2'},
 'nitrogen_growth_limitation_of_calcareous_phytoplankton': {'canonical_units': '1'},
 'nitrogen_growth_limitation_of_diatoms': {'canonical_units': '1'},
 'nitrogen_growth_limitation_of_diazotrophic_phytoplankton': {'canonical_units': '1'},
 'nitrogen_growth_limitation_of_diazotrophs': {'canonical_units': '1'},
 'nitrogen_growth_limitation_of_miscellaneous_phytoplankton': {'canonical_units': '1'},
 'nitrogen_growth_limitation_of_picophytoplankton': {'canonical_units': '1'},
 'nitrogen_mass_content_of_forestry_and_agricultural_products': {'canonical_units': 'kg '
                                                                                    'm-2'},
 'nitrogen_mass_flux_into_forestry_and_agricultural_products_due_to_anthropogenic_land_use_or_land_cover_change': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'nitrogen_mass_flux_into_litter_from_vegetation': {'canonical_units': 'kg m-2 '
                                                                       's-1'},
 'nitrogen_mass_flux_into_soil_from_litter': {'canonical_units': 'kg m-2 s-1'},
 'nitrogen_mass_flux_into_soil_from_vegetation_excluding_litter': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'non_tidal_elevation_of_sea_surface_height': {'canonical_units': 'm'},
 'normalized_difference_vegetation_index': {'canonical_units': '1'},
 'northward_air_velocity_relative_to_sea_water': {'canonical_units': 'm s-1'},
 'northward_atmosphere_dry_static_energy_transport_across_unit_distance': {'canonical_units': 'W '
                                                                                              'm-1'},
 'northward_atmosphere_heat_transport': {'canonical_units': 'W'},
 'northward_atmosphere_water_transport_across_unit_distance': {'canonical_units': 'kg '
                                                                                  'm-1 '
                                                                                  's-1'},
 'northward_atmosphere_water_vapor_transport_across_unit_distance': {'canonical_units': 'kg '
                                                                                        'm-1 '
                                                                                        's-1'},
 'northward_derivative_of_eastward_sea_ice_velocity': {'canonical_units': 's-1'},
 'northward_derivative_of_eastward_wind': {'canonical_units': 's-1'},
 'northward_derivative_of_northward_wind': {'canonical_units': 's-1'},
 'northward_derivative_of_wind_from_direction': {'canonical_units': 'degree '
                                                                    'm-1'},
 'northward_eliassen_palm_flux': {'canonical_units': 'm3 s-2'},
 'northward_eliassen_palm_flux_in_air': {'canonical_units': 'm3 s-2'},
 'northward_flood_water_velocity': {'canonical_units': 'm s-1'},
 'northward_friction_velocity_in_air': {'canonical_units': 'm s-1'},
 'northward_heat_flux_due_to_eddy_advection': {'canonical_units': 'W m-2'},
 'northward_heat_flux_in_air_due_to_eddy_advection': {'canonical_units': 'W '
                                                                         'm-2'},
 'northward_land_ice_velocity': {'canonical_units': 'm s-1'},
 'northward_mass_flux_of_air': {'canonical_units': 'kg m-2 s-1'},
 'northward_momentum_flux_correction': {'canonical_units': 'Pa'},
 'northward_northward_derivative_of_geopotential': {'canonical_units': 's-2'},
 'northward_ocean_freshwater_transport': {'canonical_units': 'kg s-1'},
 'northward_ocean_freshwater_transport_due_to_bolus_advection': {'canonical_units': 'kg '
                                                                                    's-1'},
 'northward_ocean_freshwater_transport_due_to_diffusion': {'canonical_units': 'kg '
                                                                              's-1'},
 'northward_ocean_freshwater_transport_due_to_gyre': {'canonical_units': 'kg '
                                                                         's-1'},
 'northward_ocean_freshwater_transport_due_to_overturning': {'canonical_units': 'kg '
                                                                                's-1'},
 'northward_ocean_freshwater_transport_due_to_parameterized_eddy_advection': {'canonical_units': 'kg '
                                                                                                 's-1'},
 'northward_ocean_heat_transport': {'canonical_units': 'W'},
 'northward_ocean_heat_transport_due_to_bolus_advection': {'canonical_units': 'W'},
 'northward_ocean_heat_transport_due_to_diffusion': {'canonical_units': 'W'},
 'northward_ocean_heat_transport_due_to_gyre': {'canonical_units': 'W'},
 'northward_ocean_heat_transport_due_to_overturning': {'canonical_units': 'W'},
 'northward_ocean_heat_transport_due_to_parameterized_eddy_advection': {'canonical_units': 'W'},
 'northward_ocean_heat_transport_due_to_parameterized_mesoscale_eddy_advection': {'canonical_units': 'W'},
 'northward_ocean_heat_transport_due_to_parameterized_mesoscale_eddy_diffusion': {'canonical_units': 'W'},
 'northward_ocean_heat_transport_due_to_parameterized_submesoscale_eddy_advection': {'canonical_units': 'W'},
 'northward_ocean_salt_transport': {'canonical_units': 'kg s-1'},
 'northward_ocean_salt_transport_due_to_bolus_advection': {'canonical_units': 'kg '
                                                                              's-1'},
 'northward_ocean_salt_transport_due_to_diffusion': {'canonical_units': 'kg '
                                                                        's-1'},
 'northward_ocean_salt_transport_due_to_gyre': {'canonical_units': 'kg s-1'},
 'northward_ocean_salt_transport_due_to_overturning': {'canonical_units': 'kg '
                                                                          's-1'},
 'northward_ocean_salt_transport_due_to_parameterized_eddy_advection': {'canonical_units': 'kg '
                                                                                           's-1'},
 'northward_sea_ice_displacement': {'canonical_units': 'm'},
 'northward_sea_ice_velocity': {'canonical_units': 'm s-1'},
 'northward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'northward_sea_water_velocity_assuming_no_tide': {'canonical_units': 'm s-1'},
 'northward_sea_water_velocity_at_sea_floor': {'canonical_units': 'm s-1'},
 'northward_sea_water_velocity_due_to_parameterized_mesoscale_eddies': {'canonical_units': 'm '
                                                                                           's-1'},
 'northward_sea_water_velocity_due_to_tides': {'canonical_units': 'm s-1'},
 'northward_transformed_eulerian_mean_air_velocity': {'canonical_units': 'm '
                                                                         's-1'},
 'northward_transformed_eulerian_mean_velocity': {'canonical_units': 'm s-1'},
 'northward_upward_derivative_of_geopotential': {'canonical_units': 's-2'},
 'northward_water_vapor_flux': {'canonical_units': 'kg m-2 s-1'},
 'northward_water_vapor_flux_in_air': {'canonical_units': 'kg m-2 s-1'},
 'northward_water_vapor_transport_across_unit_distance_in_atmosphere_layer': {'canonical_units': 'kg '
                                                                                                 'm-1 '
                                                                                                 's-1'},
 'northward_westward_derivative_of_geopotential': {'canonical_units': 's-2'},
 'northward_wind': {'canonical_units': 'm s-1'},
 'northward_wind_shear': {'canonical_units': 's-1'},
 'nudging_increment_in_mass_content_of_water_in_soil': {'canonical_units': 'kg '
                                                                           'm-2'},
 'nudging_increment_in_snow_and_ice_amount_on_land': {'canonical_units': 'kg '
                                                                         'm-2'},
 'number_concentration_of_aerosol_particles_at_stp_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_ambient_aerosol_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_ambient_aerosol_particles_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_biological_taxon_in_sea_water': {'canonical_units': 'm-3'},
 'number_concentration_of_cloud_condensation_nuclei_at_stp_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_cloud_liquid_water_particles_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_cloud_liquid_water_particles_in_air_at_liquid_water_cloud_top': {'canonical_units': 'm-3'},
 'number_concentration_of_coarse_mode_ambient_aerosol_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_coarse_mode_ambient_aerosol_particles_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_convective_cloud_liquid_water_particle_at_convective_liquid_water_cloud_top': {'canonical_units': 'm-3'},
 'number_concentration_of_convective_cloud_liquid_water_particles_at_convective_liquid_water_cloud_top': {'canonical_units': 'm-3'},
 'number_concentration_of_ice_crystals_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_ice_crystals_in_air_at_ice_cloud_top': {'canonical_units': 'm-3'},
 'number_concentration_of_nucleation_mode_ambient_aerosol_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_nucleation_mode_ambient_aerosol_particles_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_ozone_molecules_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_pm10_aerosol_particles_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_pm2p5_aerosol_particles_in_air': {'canonical_units': 'm-3'},
 'number_concentration_of_stratiform_cloud_liquid_water_particle_at_stratiform_liquid_water_cloud_top': {'canonical_units': 'm-3'},
 'number_concentration_of_stratiform_cloud_liquid_water_particles_at_stratiform_liquid_water_cloud_top': {'canonical_units': 'm-3'},
 'number_of_days_with_air_temperature_above_threshold': {'canonical_units': '1'},
 'number_of_days_with_air_temperature_below_threshold': {'canonical_units': '1'},
 'number_of_days_with_lwe_thickness_of_precipitation_amount_above_threshold': {'canonical_units': '1'},
 'number_of_days_with_surface_temperature_below_threshold': {'canonical_units': '1'},
 'number_of_days_with_wind_speed_above_threshold': {'canonical_units': '1'},
 'number_of_icebergs_per_unit_area': {'canonical_units': 'm-2'},
 'number_of_missing_observations': {'canonical_units': '1'},
 'number_of_observations': {'canonical_units': '1'},
 'ocean_barotropic_mass_streamfunction': {'canonical_units': 'kg s-1'},
 'ocean_barotropic_streamfunction': {'canonical_units': 'm3 s-1'},
 'ocean_double_sigma_coordinate': {'canonical_units': '1'},
 'ocean_heat_x_transport': {'canonical_units': 'W'},
 'ocean_heat_x_transport_due_to_bolus_advection': {'canonical_units': 'W'},
 'ocean_heat_x_transport_due_to_diffusion': {'canonical_units': 'W'},
 'ocean_heat_x_transport_due_to_parameterized_eddy_advection': {'canonical_units': 'W'},
 'ocean_heat_y_transport': {'canonical_units': 'W'},
 'ocean_heat_y_transport_due_to_bolus_advection': {'canonical_units': 'W'},
 'ocean_heat_y_transport_due_to_diffusion': {'canonical_units': 'W'},
 'ocean_heat_y_transport_due_to_parameterized_eddy_advection': {'canonical_units': 'W'},
 'ocean_integral_of_sea_water_temperature_wrt_depth': {'canonical_units': 'K '
                                                                          'm'},
 'ocean_integral_wrt_depth_of_sea_water_temperature': {'canonical_units': 'K '
                                                                          'm'},
 'ocean_isopycnal_layer_thickness_diffusivity': {'canonical_units': 'm2 s-1'},
 'ocean_kinetic_energy_dissipation_per_unit_area_due_to_vertical_friction': {'canonical_units': 'W '
                                                                                                'm-2'},
 'ocean_kinetic_energy_dissipation_per_unit_area_due_to_xy_friction': {'canonical_units': 'W '
                                                                                          'm-2'},
 'ocean_mass_content_of_dissolved_inorganic_carbon': {'canonical_units': 'kg '
                                                                         'm-2'},
 'ocean_mass_content_of_dissolved_organic_carbon': {'canonical_units': 'kg '
                                                                       'm-2'},
 'ocean_mass_content_of_particulate_organic_matter_expressed_as_carbon': {'canonical_units': 'kg '
                                                                                             'm-2'},
 'ocean_mass_x_transport': {'canonical_units': 'kg s-1'},
 'ocean_mass_x_transport_due_to_advection': {'canonical_units': 'kg s-1'},
 'ocean_mass_x_transport_due_to_advection_and_bolus_advection': {'canonical_units': 'kg '
                                                                                    's-1'},
 'ocean_mass_x_transport_due_to_advection_and_parameterized_eddy_advection': {'canonical_units': 'kg '
                                                                                                 's-1'},
 'ocean_mass_y_transport': {'canonical_units': 'kg s-1'},
 'ocean_mass_y_transport_due_to_advection': {'canonical_units': 'kg s-1'},
 'ocean_mass_y_transport_due_to_advection_and_bolus_advection': {'canonical_units': 'kg '
                                                                                    's-1'},
 'ocean_mass_y_transport_due_to_advection_and_parameterized_eddy_advection': {'canonical_units': 'kg '
                                                                                                 's-1'},
 'ocean_meridional_overturning_mass_streamfunction': {'canonical_units': 'kg '
                                                                         's-1'},
 'ocean_meridional_overturning_mass_streamfunction_due_to_bolus_advection': {'canonical_units': 'kg '
                                                                                                's-1'},
 'ocean_meridional_overturning_mass_streamfunction_due_to_parameterized_eddy_advection': {'canonical_units': 'kg '
                                                                                                             's-1'},
 'ocean_meridional_overturning_mass_streamfunction_due_to_parameterized_mesoscale_eddy_advection': {'canonical_units': 'kg '
                                                                                                                       's-1'},
 'ocean_meridional_overturning_mass_streamfunction_due_to_parameterized_submesoscale_eddy_advection': {'canonical_units': 'kg '
                                                                                                                          's-1'},
 'ocean_meridional_overturning_streamfunction': {'canonical_units': 'm3 s-1'},
 'ocean_mixed_layer_thickness': {'canonical_units': 'm'},
 'ocean_mixed_layer_thickness_defined_by_mixing_scheme': {'canonical_units': 'm'},
 'ocean_mixed_layer_thickness_defined_by_sigma_t': {'canonical_units': 'm'},
 'ocean_mixed_layer_thickness_defined_by_sigma_theta': {'canonical_units': 'm'},
 'ocean_mixed_layer_thickness_defined_by_temperature': {'canonical_units': 'm'},
 'ocean_mixed_layer_thickness_defined_by_vertical_tracer_diffusivity': {'canonical_units': 'm'},
 'ocean_mixed_layer_thickness_defined_by_vertical_tracer_diffusivity_deficit': {'canonical_units': 'm'},
 'ocean_mixed_layer_thickness_defined_by_vertical_tracer_diffusivity_threshold': {'canonical_units': 'm'},
 'ocean_momentum_xy_biharmonic_diffusivity': {'canonical_units': 'm4 s-1'},
 'ocean_momentum_xy_laplacian_diffusivity': {'canonical_units': 'm2 s-1'},
 'ocean_montgomery_potential': {'canonical_units': 'm2 s-2'},
 'ocean_relative_vorticity': {'canonical_units': 's-1'},
 'ocean_rigid_lid_pressure': {'canonical_units': 'Pa'},
 'ocean_rigid_lid_pressure_expressed_as_sea_surface_height_above_geoid': {'canonical_units': 'm'},
 'ocean_s_coordinate': {'canonical_units': '1'},
 'ocean_s_coordinate_g1': {'canonical_units': '1'},
 'ocean_s_coordinate_g2': {'canonical_units': '1'},
 'ocean_salt_x_transport': {'canonical_units': '1e-3 kg s-1'},
 'ocean_salt_y_transport': {'canonical_units': '1e-3 kg s-1'},
 'ocean_sigma_coordinate': {'canonical_units': '1'},
 'ocean_sigma_z_coordinate': {'canonical_units': '1'},
 'ocean_tracer_biharmonic_diffusivity_due_to_parameterized_mesoscale_eddy_advection': {'canonical_units': 'm4 '
                                                                                                          's-1'},
 'ocean_tracer_bolus_biharmonic_diffusivity': {'canonical_units': 'm4 s-1'},
 'ocean_tracer_bolus_laplacian_diffusivity': {'canonical_units': 'm2 s-1'},
 'ocean_tracer_diffusivity_due_to_parameterized_mesoscale_eddy_advection': {'canonical_units': 'm2 '
                                                                                               's-1'},
 'ocean_tracer_epineutral_biharmonic_diffusivity': {'canonical_units': 'm4 '
                                                                       's-1'},
 'ocean_tracer_epineutral_laplacian_diffusivity': {'canonical_units': 'm2 s-1'},
 'ocean_tracer_laplacian_diffusivity_due_to_parameterized_mesoscale_eddy_advection': {'canonical_units': 'm2 '
                                                                                                         's-1'},
 'ocean_tracer_xy_biharmonic_diffusivity': {'canonical_units': 'm4 s-1'},
 'ocean_tracer_xy_laplacian_diffusivity': {'canonical_units': 'm2 s-1'},
 'ocean_vertical_diffusivity': {'canonical_units': 'm2 s-1'},
 'ocean_vertical_heat_diffusivity': {'canonical_units': 'm2 s-1'},
 'ocean_vertical_momentum_diffusivity': {'canonical_units': 'm2 s-1'},
 'ocean_vertical_momentum_diffusivity_due_to_background': {'canonical_units': 'm2 '
                                                                              's-1'},
 'ocean_vertical_momentum_diffusivity_due_to_convection': {'canonical_units': 'm2 '
                                                                              's-1'},
 'ocean_vertical_momentum_diffusivity_due_to_form_drag': {'canonical_units': 'm2 '
                                                                             's-1'},
 'ocean_vertical_momentum_diffusivity_due_to_tides': {'canonical_units': 'm2 '
                                                                         's-1'},
 'ocean_vertical_salt_diffusivity': {'canonical_units': 'm2 s-1'},
 'ocean_vertical_tracer_diffusivity': {'canonical_units': 'm2 s-1'},
 'ocean_vertical_tracer_diffusivity_due_to_background': {'canonical_units': 'm2 '
                                                                            's-1'},
 'ocean_vertical_tracer_diffusivity_due_to_convection': {'canonical_units': 'm2 '
                                                                            's-1'},
 'ocean_vertical_tracer_diffusivity_due_to_tides': {'canonical_units': 'm2 '
                                                                       's-1'},
 'ocean_vertical_tracer_diffusivity_due_to_wind_mixing': {'canonical_units': 'm2 '
                                                                             's-1'},
 'ocean_volume': {'canonical_units': 'm3'},
 'ocean_volume_fraction': {'canonical_units': '1'},
 'ocean_volume_transport_across_line': {'canonical_units': 'm3 s-1'},
 'ocean_volume_x_transport': {'canonical_units': 'm3 s-1'},
 'ocean_volume_y_transport': {'canonical_units': 'm3 s-1'},
 'ocean_y_overturning_mass_streamfunction': {'canonical_units': 'kg s-1'},
 'ocean_y_overturning_mass_streamfunction_due_to_bolus_advection': {'canonical_units': 'kg '
                                                                                       's-1'},
 'ocean_y_overturning_mass_streamfunction_due_to_parameterized_eddy_advection': {'canonical_units': 'kg '
                                                                                                    's-1'},
 'ocean_y_overturning_mass_streamfunction_due_to_parameterized_mesoscale_eddy_advection': {'canonical_units': 'kg '
                                                                                                              's-1'},
 'ocean_y_overturning_mass_streamfunction_due_to_parameterized_submesoscale_eddy_advection': {'canonical_units': 'kg '
                                                                                                                 's-1'},
 'omega': {'canonical_units': 'Pa s-1'},
 'omnidirectional_photosynthetic_spherical_irradiance_in_sea_water': {'canonical_units': 'W '
                                                                                         'm-2'},
 'omnidirectional_spectral_spherical_irradiance_in_sea_water': {'canonical_units': 'W '
                                                                                   'm-3'},
 'omnidirectional_spherical_irradiance_per_unit_wavelength_in_sea_water': {'canonical_units': 'W '
                                                                                              'm-3'},
 'optical_thickness_of_atmosphere_layer_due_to_aerosol': {'canonical_units': '1'},
 'optical_thickness_of_atmosphere_layer_due_to_ambient_aerosol': {'canonical_units': '1'},
 'optical_thickness_of_atmosphere_layer_due_to_ambient_aerosol_particles': {'canonical_units': '1'},
 'original_air_pressure_of_lifted_parcel': {'canonical_units': 'Pa'},
 'outgoing_water_volume_transport_along_river_channel': {'canonical_units': 'm3 '
                                                                            's-1'},
 'partial_pressure_of_carbon_dioxide_in_sea_water': {'canonical_units': 'Pa'},
 'partial_pressure_of_methane_in_sea_water': {'canonical_units': 'Pa'},
 'permafrost_active_layer_thickness': {'canonical_units': 'm'},
 'permafrost_area_fraction': {'canonical_units': '1'},
 'permafrost_layer_thickness': {'canonical_units': 'm'},
 'phase_of_global_average_sea_level_change': {'canonical_units': 'degree'},
 'photolysis_rate_of_molecular_oxygen': {'canonical_units': 's-1'},
 'photolysis_rate_of_nitrogen_dioxide': {'canonical_units': 's-1'},
 'photolysis_rate_of_ozone': {'canonical_units': 's-1'},
 'photolysis_rate_of_ozone_to_1D_oxygen_atom': {'canonical_units': 's-1'},
 'planetary_albedo': {'canonical_units': '1'},
 'plant_respiration_carbon_flux': {'canonical_units': 'kg m-2 s-1'},
 'platform_azimuth_angle': {'canonical_units': 'degree'},
 'platform_course': {'canonical_units': 'degree'},
 'platform_heave': {'canonical_units': 'm'},
 'platform_heave_down': {'canonical_units': 'm'},
 'platform_heave_rate': {'canonical_units': 'm s-1'},
 'platform_heave_rate_down': {'canonical_units': 'm s-1'},
 'platform_heave_rate_up': {'canonical_units': 'm s-1'},
 'platform_heave_up': {'canonical_units': 'm'},
 'platform_id': {'canonical_units': None},
 'platform_name': {'canonical_units': None},
 'platform_orientation': {'canonical_units': 'degree'},
 'platform_pitch': {'canonical_units': 'degree'},
 'platform_pitch_angle': {'canonical_units': 'degree'},
 'platform_pitch_fore_down': {'canonical_units': 'degree'},
 'platform_pitch_fore_up': {'canonical_units': 'degree'},
 'platform_pitch_rate': {'canonical_units': 'degree s-1'},
 'platform_pitch_rate_fore_down': {'canonical_units': 'degree s-1'},
 'platform_pitch_rate_fore_up': {'canonical_units': 'degree s-1'},
 'platform_roll': {'canonical_units': 'degree'},
 'platform_roll_angle': {'canonical_units': 'degree'},
 'platform_roll_rate': {'canonical_units': 'degree s-1'},
 'platform_roll_rate_starboard_down': {'canonical_units': 'degree s-1'},
 'platform_roll_rate_starboard_up': {'canonical_units': 'degree s-1'},
 'platform_roll_starboard_down': {'canonical_units': 'degree'},
 'platform_roll_starboard_up': {'canonical_units': 'degree'},
 'platform_speed_wrt_air': {'canonical_units': 'm s-1'},
 'platform_speed_wrt_ground': {'canonical_units': 'm s-1'},
 'platform_speed_wrt_sea_water': {'canonical_units': 'm s-1'},
 'platform_surge': {'canonical_units': 'm'},
 'platform_surge_aft': {'canonical_units': 'm'},
 'platform_surge_fore': {'canonical_units': 'm'},
 'platform_surge_rate': {'canonical_units': 'm s-1'},
 'platform_surge_rate_aft': {'canonical_units': 'm s-1'},
 'platform_surge_rate_fore': {'canonical_units': 'm s-1'},
 'platform_sway': {'canonical_units': 'm'},
 'platform_sway_port': {'canonical_units': 'm'},
 'platform_sway_rate': {'canonical_units': 'm s-1'},
 'platform_sway_rate_port': {'canonical_units': 'm s-1'},
 'platform_sway_rate_starboard': {'canonical_units': 'm s-1'},
 'platform_sway_starboard': {'canonical_units': 'm'},
 'platform_view_angle': {'canonical_units': 'degree'},
 'platform_yaw': {'canonical_units': 'degree'},
 'platform_yaw_angle': {'canonical_units': 'degree'},
 'platform_yaw_fore_port': {'canonical_units': 'degree'},
 'platform_yaw_fore_starboard': {'canonical_units': 'degree'},
 'platform_yaw_rate': {'canonical_units': 'degree s-1'},
 'platform_yaw_rate_fore_port': {'canonical_units': 'degree s-1'},
 'platform_yaw_rate_fore_starboard': {'canonical_units': 'degree s-1'},
 'platform_zenith_angle': {'canonical_units': 'degree'},
 'potential_energy_content_of_atmosphere_layer': {'canonical_units': 'J m-2'},
 'potential_vorticity_of_atmosphere_layer': {'canonical_units': 'Pa-1 s-1'},
 'potential_vorticity_of_ocean_layer': {'canonical_units': 'm-1 s-1'},
 'precipitation_amount': {'canonical_units': 'kg m-2'},
 'precipitation_flux': {'canonical_units': 'kg m-2 s-1'},
 'precipitation_flux_containing_17O': {'canonical_units': 'kg m-2 s-1'},
 'precipitation_flux_containing_18O': {'canonical_units': 'kg m-2 s-1'},
 'precipitation_flux_containing_single_2H': {'canonical_units': 'kg m-2 s-1'},
 'precipitation_flux_onto_canopy': {'canonical_units': 'kg m-2 s-1'},
 'precipitation_flux_onto_canopy_where_land': {'canonical_units': 'kg m-2 s-1'},
 'predominant_precipitation_type_at_surface': {'canonical_units': None},
 'pressure_at_effective_cloud_top_defined_by_infrared_radiation': {'canonical_units': 'Pa'},
 'probability_distribution_of_wind_from_direction_over_time': {'canonical_units': '1'},
 'product_of_air_temperature_and_omega': {'canonical_units': 'K Pa s-1'},
 'product_of_air_temperature_and_specific_humidity': {'canonical_units': 'K'},
 'product_of_eastward_sea_water_velocity_and_salinity': {'canonical_units': 'm '
                                                                            's-1'},
 'product_of_eastward_sea_water_velocity_and_temperature': {'canonical_units': 'K '
                                                                               'm '
                                                                               's-1'},
 'product_of_eastward_wind_and_air_temperature': {'canonical_units': 'K m s-1'},
 'product_of_eastward_wind_and_geopotential_height': {'canonical_units': 'm2 '
                                                                         's-1'},
 'product_of_eastward_wind_and_lagrangian_tendency_of_air_pressure': {'canonical_units': 'Pa '
                                                                                         'm '
                                                                                         's-2'},
 'product_of_eastward_wind_and_northward_wind': {'canonical_units': 'm2 s-2'},
 'product_of_eastward_wind_and_omega': {'canonical_units': 'Pa m s-2'},
 'product_of_eastward_wind_and_specific_humidity': {'canonical_units': 'm s-1'},
 'product_of_eastward_wind_and_upward_air_velocity': {'canonical_units': 'm2 '
                                                                         's-2'},
 'product_of_geopotential_height_and_omega': {'canonical_units': 'Pa m s-1'},
 'product_of_lagrangian_tendency_of_air_pressure_and_air_temperature': {'canonical_units': 'K '
                                                                                           'Pa '
                                                                                           's-1'},
 'product_of_lagrangian_tendency_of_air_pressure_and_geopotential_height': {'canonical_units': 'Pa '
                                                                                               'm '
                                                                                               's-1'},
 'product_of_lagrangian_tendency_of_air_pressure_and_specific_humidity': {'canonical_units': 'Pa '
                                                                                             's-1'},
 'product_of_northward_sea_water_velocity_and_salinity': {'canonical_units': 'm '
                                                                             's-1'},
 'product_of_northward_sea_water_velocity_and_temperature': {'canonical_units': 'K '
                                                                                'm '
                                                                                's-1'},
 'product_of_northward_wind_and_air_temperature': {'canonical_units': 'K m '
                                                                      's-1'},
 'product_of_northward_wind_and_geopotential_height': {'canonical_units': 'm2 '
                                                                          's-1'},
 'product_of_northward_wind_and_lagrangian_tendency_of_air_pressure': {'canonical_units': 'Pa '
                                                                                          'm '
                                                                                          's-2'},
 'product_of_northward_wind_and_omega': {'canonical_units': 'Pa m s-2'},
 'product_of_northward_wind_and_specific_humdity': {'canonical_units': 'm s-1'},
 'product_of_northward_wind_and_specific_humidity': {'canonical_units': 'm '
                                                                        's-1'},
 'product_of_northward_wind_and_upward_air_velocity': {'canonical_units': 'm2 '
                                                                          's-2'},
 'product_of_omega_and_air_temperature': {'canonical_units': 'K Pa s-1'},
 'product_of_omega_and_specific_humidity': {'canonical_units': 'Pa s-1'},
 'product_of_specific_humidity_and_omega': {'canonical_units': 'Pa s-1'},
 'product_of_upward_air_velocity_and_air_temperature': {'canonical_units': 'K '
                                                                           'm '
                                                                           's-1'},
 'product_of_upward_air_velocity_and_specific_humidity': {'canonical_units': 'm '
                                                                             's-1'},
 'projection_x_angular_coordinate': {'canonical_units': 'radian'},
 'projection_x_coordinate': {'canonical_units': 'm'},
 'projection_y_angular_coordinate': {'canonical_units': 'radian'},
 'projection_y_coordinate': {'canonical_units': 'm'},
 'proportion_of_acceptable_signal_returns_from_acoustic_instrument_in_sea_water': {'canonical_units': '1'},
 'pseudo_equivalent_potential_temperature': {'canonical_units': 'K'},
 'pseudo_equivalent_temperature': {'canonical_units': 'K'},
 'quality_flag': {'canonical_units': '1'},
 'radial_sea_water_velocity_away_from_instrument': {'canonical_units': 'm s-1'},
 'radial_sea_water_velocity_toward_instrument': {'canonical_units': 'm s-1'},
 'radial_velocity_of_scatterers_away_from_instrument': {'canonical_units': 'm '
                                                                           's-1'},
 'radial_velocity_of_scatterers_toward_instrument': {'canonical_units': 'm '
                                                                        's-1'},
 'radiation_frequency': {'canonical_units': 's-1'},
 'radiation_wavelength': {'canonical_units': 'm'},
 'radioactivity_concentration_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_101Mo_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_101Tc_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_102Mo_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_102Tc_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_102mTc_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_103Ru_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_103mRh_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_104Tc_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_105Rh_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_105Ru_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_105mRh_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_106Rh_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_106Ru_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_106mRh_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_107Pd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_107Rh_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_107mPd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_109Pd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_109mAg_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_110mAg_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_111Ag_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_111Pd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_111mAg_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_111mCd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_111mPd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_112Ag_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_112Pd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_113Ag_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_113Cd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_113mAg_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_113mCd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_113mIn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_115Ag_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_115Cd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_115In_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_115mAg_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_115mCd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_115mIn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_116In_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_116mIn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_117Cd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_117In_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_117mCd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_117mIn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_117mSn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_118Cd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_118In_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_118mIn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_119In_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_119mIn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_119mSn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_11C_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_121Sn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_121mSn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_123Sn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_123mSn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_124Sb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_124mSb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_125Sb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_125Sn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_125mTe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_126Sb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_126Sn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_126mSb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_127Sb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_127Sn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_127Te_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_127mTe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_128Sb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_128Sn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_128mSb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_129I_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_129Sb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_129Te_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_129mTe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_129mXe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_130I_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_130Sb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_130Sn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_130mI_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_130mSb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_131I_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_131Sb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_131Te_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_131mTe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_131mXe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_132I_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_132Te_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_133I_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_133Te_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_133Xe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_133mI_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_133mTe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_133mXe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_134Cs_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_134I_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_134Te_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_134mCs_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_134mI_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_134mXe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_135Cs_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_135I_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_135Xe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_135mBa_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_135mCs_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_135mXe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_136Cs_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_137Cs_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_137Xe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_137mBa_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_138Cs_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_138Xe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_139Ba_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_13N_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_140Ba_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_140La_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_141Ce_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_141La_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_142Ce_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_142La_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_142Pr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_142mPr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_143Ce_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_143La_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_143Pr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_144Ce_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_144Nd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_144Pr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_144mPr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_145Pr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_146Ce_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_146Pr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_147Nd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_147Pm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_147Pr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_147Sm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_148Pm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_148Sm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_148mPm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_149Nd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_149Pm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_149Sm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_150Pm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_151Nd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_151Pm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_151Sm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_152Nd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_152Pm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_152mPm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_153Sm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_154Eu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_155Eu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_155Sm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_156Eu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_156Sm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_157Eu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_158Eu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_159Eu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_159Gd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_15O_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_160Tb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_161Tb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_162Gd_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_162Tb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_162mTb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_163Tb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_165Dy_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_18F_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_206Hg_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_206Tl_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_207Tl_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_207mPb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_208Tl_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_209Bi_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_209Pb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_209Tl_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_210Bi_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_210Pb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_210Po_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_210Tl_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_211Bi_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_211Pb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_211Po_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_212Bi_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_212Pb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_212Po_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_213Bi_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_213Pb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_213Po_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_214Bi_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_214Pb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_214Po_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_215At_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_215Bi_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_215Po_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_216At_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_216Po_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_217At_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_217Po_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_218At_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_218Po_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_218Rn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_219At_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_219Rn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_220Rn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_221Fr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_221Rn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_222Fr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_222Ra_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_222Rn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_223Fr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_223Ra_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_223Rn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_224Ra_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_225Ac_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_225Ra_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_226Ac_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_226Ra_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_226Th_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_227Ac_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_227Ra_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_227Th_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_228Ac_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_228Ra_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_228Th_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_229Ac_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_229Ra_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_229Th_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_230Pa_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_230Th_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_230U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_231Pa_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_231Th_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_231U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_232Pa_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_232Th_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_232U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_233Pa_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_233Th_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_233U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_234Pa_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_234Th_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_234U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_234mPa_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_235Np_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_235Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_235U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_236Np_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_236Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_236U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_236mNp_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_237Np_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_237Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_237U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_238Np_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_238Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_238U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_239Np_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_239Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_239U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_240Am_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_240Np_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_240Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_240U_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_240mNp_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_241Am_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_241Cm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_241Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_242Am_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_242Cm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_242Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_242m1Am_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_242m2Am_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_243Am_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_243Cm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_243Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_244Am_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_244Cm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_244Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_244mAm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_245Am_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_245Cm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_245Pu_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_246Cm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_247Cm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_248Cm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_249Bk_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_249Cf_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_249Cm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_24Na_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_250Bk_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_250Cf_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_250Cm_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_251Cf_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_252Cf_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_253Cf_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_253Es_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_254Cf_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_254Es_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_254mEs_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_255Es_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_3H_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_41Ar_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_54Mn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_58Co_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_60Co_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_72Ga_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_72Zn_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_73Ga_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_75Ge_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_77As_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_77Ge_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_77mGe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_78As_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_78Ge_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_79Se_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_81Se_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_81mSe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_82Br_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_82mBr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_83Br_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_83Se_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_83mKr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_83mSe_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_84Br_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_84mBr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_85Kr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_85mKr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_86Rb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_86mRb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_87Kr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_87Rb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_88Kr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_88Rb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_89Kr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_89Rb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_89Sr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_90Sr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_90Y_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_90mY_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_91Sr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_91Y_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_91mY_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_92Sr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_92Y_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_93Y_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_93Zr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_94Nb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_94Y_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_94mNb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_95Nb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_95Y_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_95Zr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_95mNb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_96Nb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_97Nb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_97Zr_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_97mNb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_98Nb_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_99Mo_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_99Tc_in_air': {'canonical_units': 'Bq m-3'},
 'radioactivity_concentration_of_99mTc_in_air': {'canonical_units': 'Bq m-3'},
 'radius_of_tropical_cyclone_central_dense_overcast_region': {'canonical_units': 'm'},
 'radius_of_tropical_cyclone_eye': {'canonical_units': 'm'},
 'radius_of_tropical_cyclone_maximum_sustained_wind_speed': {'canonical_units': 'm'},
 'rainfall_amount': {'canonical_units': 'kg m-2'},
 'rainfall_flux': {'canonical_units': 'kg m-2 s-1'},
 'rainfall_rate': {'canonical_units': 'm s-1'},
 'rate_of_ hydroxyl_radical_destruction_due_to_reaction_with_nmvoc': {'canonical_units': 's-1'},
 'rate_of_change_test_quality_flag': {'canonical_units': '1'},
 'rate_of_hydroxyl_radical_destruction_due_to_reaction_with_nmvoc': {'canonical_units': 's-1'},
 'ratio_of_ice_volume_in_frozen_ground_to_pore_volume_in_unfrozen_ground': {'canonical_units': '1'},
 'ratio_of_sea_water_potential_temperature_anomaly_to_relaxation_timescale': {'canonical_units': 'K '
                                                                                                 's-1'},
 'ratio_of_sea_water_practical_salinity_anomaly_to_relaxation_timescale': {'canonical_units': 's-1'},
 'ratio_of_x_derivative_of_ocean_rigid_lid_pressure_to_sea_surface_density': {'canonical_units': 'm '
                                                                                                 's-2'},
 'ratio_of_y_derivative_of_ocean_rigid_lid_pressure_to_sea_surface_density': {'canonical_units': 'm '
                                                                                                 's-2'},
 'realization': {'canonical_units': '1'},
 'reference_air_pressure_for_atmosphere_vertical_coordinate': {'canonical_units': 'Pa'},
 'reference_epoch': {'canonical_units': 's'},
 'reference_pressure': {'canonical_units': 'Pa'},
 'reference_sea_water_density_for_boussinesq_approximation': {'canonical_units': 'kg '
                                                                                 'm-3'},
 'region': {'canonical_units': None},
 'relative_humidity': {'canonical_units': '1'},
 'relative_humidity_for_aerosol_particle_size_selection': {'canonical_units': '1'},
 'relative_platform_azimuth_angle': {'canonical_units': 'degree'},
 'relative_sensor_azimuth_angle': {'canonical_units': 'degree'},
 'richardson_number_in_sea_water': {'canonical_units': '1'},
 'river_water_volume_transport_into_cell': {'canonical_units': 'm3 s-1'},
 'river_water_volume_transport_out_of_cell': {'canonical_units': 'm3 s-1'},
 'root_carbon_content': {'canonical_units': 'kg m-2'},
 'root_depth': {'canonical_units': 'm'},
 'root_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'root_mass_content_of_nitrogen': {'canonical_units': 'kg m-2'},
 'runoff_amount': {'canonical_units': 'kg m-2'},
 'runoff_amount_excluding_baseflow': {'canonical_units': 'kg m-2'},
 'runoff_flux': {'canonical_units': 'kg m-2 s-1'},
 'salt_flux_into_sea_water_due_to_sea_ice_thermodynamics': {'canonical_units': 'kg '
                                                                               'm-2 '
                                                                               's-1'},
 'salt_flux_into_sea_water_from_rivers': {'canonical_units': 'kg m-2 s-1'},
 'scattering_angle': {'canonical_units': 'rad'},
 'scene_type_of_dvorak_tropical_cyclone_cloud_region': {'canonical_units': '1'},
 'scene_type_of_dvorak_tropical_cyclone_eye_region': {'canonical_units': '1'},
 'sea_area': {'canonical_units': 'm2'},
 'sea_area_fraction': {'canonical_units': '1'},
 'sea_binary_mask': {'canonical_units': '1'},
 'sea_floor_depth': {'canonical_units': 'm'},
 'sea_floor_depth_below_geoid': {'canonical_units': 'm'},
 'sea_floor_depth_below_geopotential_datum': {'canonical_units': 'm'},
 'sea_floor_depth_below_mean_sea_level': {'canonical_units': 'm'},
 'sea_floor_depth_below_reference_ellipsoid': {'canonical_units': 'm'},
 'sea_floor_depth_below_sea_level': {'canonical_units': 'm'},
 'sea_floor_depth_below_sea_surface': {'canonical_units': 'm'},
 'sea_floor_sediment_grain_size': {'canonical_units': 'm'},
 'sea_ice_albedo': {'canonical_units': '1'},
 'sea_ice_amount': {'canonical_units': 'kg m-2'},
 'sea_ice_and_surface_snow_amount': {'canonical_units': 'kg m-2'},
 'sea_ice_area': {'canonical_units': 'm2'},
 'sea_ice_area_fraction': {'canonical_units': '1'},
 'sea_ice_area_transport_across_line': {'canonical_units': 'm2 s-1'},
 'sea_ice_average_normal_horizontal_stress': {'canonical_units': 'N m-1'},
 'sea_ice_basal_drag_coefficient_for_momentum_in_sea_water': {'canonical_units': '1'},
 'sea_ice_basal_temperature': {'canonical_units': 'K'},
 'sea_ice_classification': {'canonical_units': None},
 'sea_ice_displacement': {'canonical_units': 'm'},
 'sea_ice_draft': {'canonical_units': 'm'},
 'sea_ice_extent': {'canonical_units': 'm2'},
 'sea_ice_floe_diameter': {'canonical_units': 'm'},
 'sea_ice_freeboard': {'canonical_units': 'm'},
 'sea_ice_mass': {'canonical_units': 'kg'},
 'sea_ice_mass_content_of_salt': {'canonical_units': 'kg m-2'},
 'sea_ice_melt_pond_thickness': {'canonical_units': 'm'},
 'sea_ice_salinity': {'canonical_units': '1e-3'},
 'sea_ice_speed': {'canonical_units': 'm s-1'},
 'sea_ice_surface_temperature': {'canonical_units': 'K'},
 'sea_ice_temperature': {'canonical_units': 'K'},
 'sea_ice_temperature_expressed_as_heat_content': {'canonical_units': 'J m-2'},
 'sea_ice_thickness': {'canonical_units': 'm'},
 'sea_ice_transport_across_line': {'canonical_units': 'kg s-1'},
 'sea_ice_volume': {'canonical_units': 'm3'},
 'sea_ice_x_displacement': {'canonical_units': 'm'},
 'sea_ice_x_force_per_unit_area_due_to_coriolis_effect': {'canonical_units': 'N '
                                                                             'm-2'},
 'sea_ice_x_force_per_unit_area_due_to_sea_surface_tilt': {'canonical_units': 'N '
                                                                              'm-2'},
 'sea_ice_x_internal_stress': {'canonical_units': 'N m-2'},
 'sea_ice_x_transport': {'canonical_units': 'kg s-1'},
 'sea_ice_x_velocity': {'canonical_units': 'm s-1'},
 'sea_ice_y_displacement': {'canonical_units': 'm'},
 'sea_ice_y_force_per_unit_area_due_to_coriolis_effect': {'canonical_units': 'N '
                                                                             'm-2'},
 'sea_ice_y_force_per_unit_area_due_to_sea_surface_tilt': {'canonical_units': 'N '
                                                                              'm-2'},
 'sea_ice_y_internal_stress': {'canonical_units': 'N m-2'},
 'sea_ice_y_transport': {'canonical_units': 'kg s-1'},
 'sea_ice_y_velocity': {'canonical_units': 'm s-1'},
 'sea_surface_density': {'canonical_units': 'kg m-3'},
 'sea_surface_downward_eastward_stress_due_to_dissipation_of_sea_surface_waves': {'canonical_units': 'Pa'},
 'sea_surface_downward_northward_stress_due_to_dissipation_of_sea_surface_waves': {'canonical_units': 'Pa'},
 'sea_surface_elevation': {'canonical_units': 'm'},
 'sea_surface_elevation_anomaly': {'canonical_units': 'm'},
 'sea_surface_foundation_temperature': {'canonical_units': 'K'},
 'sea_surface_height': {'canonical_units': 'm'},
 'sea_surface_height_above_geoid': {'canonical_units': 'm'},
 'sea_surface_height_above_geopotential_datum': {'canonical_units': 'm'},
 'sea_surface_height_above_mean_sea_level': {'canonical_units': 'm'},
 'sea_surface_height_above_reference_ellipsoid': {'canonical_units': 'm'},
 'sea_surface_height_above_sea_level': {'canonical_units': 'm'},
 'sea_surface_height_amplitude_due_to_earth_tide': {'canonical_units': 'm'},
 'sea_surface_height_amplitude_due_to_equilibrium_ocean_tide': {'canonical_units': 'm'},
 'sea_surface_height_amplitude_due_to_geocentric_ocean_tide': {'canonical_units': 'm'},
 'sea_surface_height_amplitude_due_to_non_equilibrium_ocean_tide': {'canonical_units': 'm'},
 'sea_surface_height_amplitude_due_to_pole_tide': {'canonical_units': 'm'},
 'sea_surface_height_bias_due_to_sea_surface_roughness': {'canonical_units': 'm'},
 'sea_surface_height_correction_due_to_air_pressure_and_wind_at_high_frequency': {'canonical_units': 'm'},
 'sea_surface_height_correction_due_to_air_pressure_at_low_frequency': {'canonical_units': 'm'},
 'sea_surface_mean_square_crosswave_slope': {'canonical_units': '1'},
 'sea_surface_mean_square_upwave_slope': {'canonical_units': '1'},
 'sea_surface_mean_square_upwave_slope_direction': {'canonical_units': 'degree'},
 'sea_surface_primary_swell_wave_directional_spread': {'canonical_units': 'degree'},
 'sea_surface_primary_swell_wave_energy_at_variance_spectral_density_maximum': {'canonical_units': 'm2 '
                                                                                                   's'},
 'sea_surface_primary_swell_wave_from_direction': {'canonical_units': 'degree'},
 'sea_surface_primary_swell_wave_from_direction_at_variance_spectral_density_maximum': {'canonical_units': 'degree'},
 'sea_surface_primary_swell_wave_mean_period': {'canonical_units': 's'},
 'sea_surface_primary_swell_wave_period_at_variance_spectral_density_maximum': {'canonical_units': 's'},
 'sea_surface_primary_swell_wave_significant_height': {'canonical_units': 'm'},
 'sea_surface_salinity': {'canonical_units': '1e-3'},
 'sea_surface_secondary_swell_wave_directional_spread': {'canonical_units': 'degree'},
 'sea_surface_secondary_swell_wave_energy_at_variance_spectral_density_maximum': {'canonical_units': 'm2 '
                                                                                                     's'},
 'sea_surface_secondary_swell_wave_from_direction': {'canonical_units': 'degree'},
 'sea_surface_secondary_swell_wave_from_direction_at_variance_spectral_density_maximum': {'canonical_units': 'degree'},
 'sea_surface_secondary_swell_wave_mean_period': {'canonical_units': 's'},
 'sea_surface_secondary_swell_wave_period_at_variance_spectral_density_maximum': {'canonical_units': 's'},
 'sea_surface_secondary_swell_wave_significant_height': {'canonical_units': 'm'},
 'sea_surface_skin_temperature': {'canonical_units': 'K'},
 'sea_surface_subskin_temperature': {'canonical_units': 'K'},
 'sea_surface_swell_wave_directional_spread': {'canonical_units': 'degree'},
 'sea_surface_swell_wave_from_direction': {'canonical_units': 'degree'},
 'sea_surface_swell_wave_from_direction_at_variance_spectral_density_maximum': {'canonical_units': 'degree'},
 'sea_surface_swell_wave_mean_period': {'canonical_units': 's'},
 'sea_surface_swell_wave_mean_period_from_variance_spectral_density_first_frequency_moment': {'canonical_units': 's'},
 'sea_surface_swell_wave_mean_period_from_variance_spectral_density_inverse_frequency_moment': {'canonical_units': 's'},
 'sea_surface_swell_wave_mean_period_from_variance_spectral_density_second_frequency_moment': {'canonical_units': 's'},
 'sea_surface_swell_wave_period': {'canonical_units': 's'},
 'sea_surface_swell_wave_period_at_variance_spectral_density_maximum': {'canonical_units': 's'},
 'sea_surface_swell_wave_significant_height': {'canonical_units': 'm'},
 'sea_surface_swell_wave_to_direction': {'canonical_units': 'degree'},
 'sea_surface_swell_wave_zero_upcrossing_period': {'canonical_units': 's'},
 'sea_surface_temperature': {'canonical_units': 'K'},
 'sea_surface_tertiary_swell_wave_directional_spread': {'canonical_units': 'degree'},
 'sea_surface_tertiary_swell_wave_energy_at_variance_spectral_density_maximum': {'canonical_units': 'm2 '
                                                                                                    's'},
 'sea_surface_tertiary_swell_wave_from_direction': {'canonical_units': 'degree'},
 'sea_surface_tertiary_swell_wave_from_direction_at_variance_spectral_density_maximum': {'canonical_units': 'degree'},
 'sea_surface_tertiary_swell_wave_mean_period': {'canonical_units': 's'},
 'sea_surface_tertiary_swell_wave_period_at_variance_spectral_density_maximum': {'canonical_units': 's'},
 'sea_surface_tertiary_swell_wave_significant_height': {'canonical_units': 'm'},
 'sea_surface_wave_directional_spread': {'canonical_units': 'degree'},
 'sea_surface_wave_directional_spread_at_variance_spectral_density_maximum': {'canonical_units': 'degree'},
 'sea_surface_wave_directional_variance_spectral_density': {'canonical_units': 'm2 '
                                                                               's '
                                                                               'rad-1'},
 'sea_surface_wave_energy_at_variance_spectral_density_maximum': {'canonical_units': 'm2 '
                                                                                     's'},
 'sea_surface_wave_frequency': {'canonical_units': 's-1'},
 'sea_surface_wave_from_direction': {'canonical_units': 'degree'},
 'sea_surface_wave_from_direction_at_variance_spectral_density_maximum': {'canonical_units': 'degree'},
 'sea_surface_wave_maximum_crest_height': {'canonical_units': 'm'},
 'sea_surface_wave_maximum_height': {'canonical_units': 'm'},
 'sea_surface_wave_maximum_period': {'canonical_units': 's'},
 'sea_surface_wave_maximum_steepness': {'canonical_units': '1'},
 'sea_surface_wave_maximum_trough_depth': {'canonical_units': 'm'},
 'sea_surface_wave_mean_height': {'canonical_units': 'm'},
 'sea_surface_wave_mean_height_of_highest_tenth': {'canonical_units': 'm'},
 'sea_surface_wave_mean_period': {'canonical_units': 's'},
 'sea_surface_wave_mean_period_from_variance_spectral_density_first_frequency_moment': {'canonical_units': 's'},
 'sea_surface_wave_mean_period_from_variance_spectral_density_inverse_frequency_moment': {'canonical_units': 's'},
 'sea_surface_wave_mean_period_from_variance_spectral_density_second_frequency_moment': {'canonical_units': 's'},
 'sea_surface_wave_mean_period_of_highest_tenth': {'canonical_units': 's'},
 'sea_surface_wave_mean_square_slope': {'canonical_units': '1'},
 'sea_surface_wave_mean_square_x_slope': {'canonical_units': '1'},
 'sea_surface_wave_mean_square_y_slope': {'canonical_units': '1'},
 'sea_surface_wave_mean_wavenumber_from_variance_spectral_density_first_wavenumber_moment': {'canonical_units': 'm-1'},
 'sea_surface_wave_period_at_variance_spectral_density_maximum': {'canonical_units': 's'},
 'sea_surface_wave_period_of_highest_wave': {'canonical_units': 's'},
 'sea_surface_wave_significant_height': {'canonical_units': 'm'},
 'sea_surface_wave_significant_period': {'canonical_units': 's'},
 'sea_surface_wave_stokes_drift_eastward_velocity': {'canonical_units': 'm '
                                                                        's-1'},
 'sea_surface_wave_stokes_drift_northward_velocity': {'canonical_units': 'm '
                                                                         's-1'},
 'sea_surface_wave_stokes_drift_speed': {'canonical_units': 'm s-1'},
 'sea_surface_wave_stokes_drift_to_direction': {'canonical_units': 'degree'},
 'sea_surface_wave_stokes_drift_x_velocity': {'canonical_units': 'm s-1'},
 'sea_surface_wave_stokes_drift_y_velocity': {'canonical_units': 'm s-1'},
 'sea_surface_wave_to_direction': {'canonical_units': 'degree'},
 'sea_surface_wave_variance_spectral_density': {'canonical_units': 'm2 s'},
 'sea_surface_wave_xx_radiation_stress': {'canonical_units': 'Pa'},
 'sea_surface_wave_xy_radiation_stress': {'canonical_units': 'Pa'},
 'sea_surface_wave_yy_radiation_stress': {'canonical_units': 'Pa'},
 'sea_surface_wave_zero_upcrossing_period': {'canonical_units': 's'},
 'sea_surface_wind_wave_directional_spread': {'canonical_units': 'degree'},
 'sea_surface_wind_wave_energy_at_variance_spectral_density_maximum': {'canonical_units': 'm2 '
                                                                                          's'},
 'sea_surface_wind_wave_from_direction': {'canonical_units': 'degree'},
 'sea_surface_wind_wave_from_direction_at_variance_spectral_density_maximum': {'canonical_units': 'degree'},
 'sea_surface_wind_wave_mean_period': {'canonical_units': 's'},
 'sea_surface_wind_wave_mean_period_from_variance_spectral_density_first_frequency_moment': {'canonical_units': 's'},
 'sea_surface_wind_wave_mean_period_from_variance_spectral_density_inverse_frequency_moment': {'canonical_units': 's'},
 'sea_surface_wind_wave_mean_period_from_variance_spectral_density_second_frequency_moment': {'canonical_units': 's'},
 'sea_surface_wind_wave_period': {'canonical_units': 's'},
 'sea_surface_wind_wave_period_at_variance_spectral_density_maximum': {'canonical_units': 's'},
 'sea_surface_wind_wave_significant_height': {'canonical_units': 'm'},
 'sea_surface_wind_wave_to_direction': {'canonical_units': 'degree'},
 'sea_surface_wind_wave_zero_upcrossing_period': {'canonical_units': 's'},
 'sea_water_absolute_salinity': {'canonical_units': 'g kg-1'},
 'sea_water_added_conservative_temperature': {'canonical_units': 'degree_C'},
 'sea_water_added_potential_temperature': {'canonical_units': 'degree_C'},
 'sea_water_age_since_surface_contact': {'canonical_units': 'year'},
 'sea_water_alkalinity_expressed_as_mole_equivalent': {'canonical_units': 'mol '
                                                                          'm-3'},
 'sea_water_alkalinity_natural_analogue_expressed_as_mole_equivalent': {'canonical_units': 'mol '
                                                                                           'm-3'},
 'sea_water_conservative_temperature': {'canonical_units': 'K'},
 'sea_water_cox_salinity': {'canonical_units': '1e-3'},
 'sea_water_density': {'canonical_units': 'kg m-3'},
 'sea_water_electrical_conductivity': {'canonical_units': 'S m-1'},
 'sea_water_from_direction': {'canonical_units': 'degree'},
 'sea_water_knudsen_salinity': {'canonical_units': '1e-3'},
 'sea_water_mass': {'canonical_units': 'kg'},
 'sea_water_mass_per_unit_area': {'canonical_units': 'kg m-2'},
 'sea_water_mass_per_unit_area_expressed_as_thickness': {'canonical_units': 'm'},
 'sea_water_neutral_density': {'canonical_units': 'kg m-3'},
 'sea_water_ph_abiotic_analogue_reported_on_total_scale': {'canonical_units': '1'},
 'sea_water_ph_natural_analogue_reported_on_total_scale': {'canonical_units': '1'},
 'sea_water_ph_reported_on_total_scale': {'canonical_units': '1'},
 'sea_water_potential_density': {'canonical_units': 'kg m-3'},
 'sea_water_potential_temperature': {'canonical_units': 'K'},
 'sea_water_potential_temperature_at_sea_floor': {'canonical_units': 'K'},
 'sea_water_potential_temperature_expressed_as_heat_content': {'canonical_units': 'J '
                                                                                  'm-2'},
 'sea_water_practical_salinity': {'canonical_units': '1'},
 'sea_water_practical_salinity_at_sea_floor': {'canonical_units': '1'},
 'sea_water_preformed_salinity': {'canonical_units': 'g kg-1'},
 'sea_water_pressure': {'canonical_units': 'dbar'},
 'sea_water_pressure_at_sea_floor': {'canonical_units': 'dbar'},
 'sea_water_pressure_at_sea_water_surface': {'canonical_units': 'dbar'},
 'sea_water_pressure_due_to_sea_water': {'canonical_units': 'dbar'},
 'sea_water_redistributed_conservative_temperature': {'canonical_units': 'degree_C'},
 'sea_water_redistributed_potential_temperature': {'canonical_units': 'degree_C'},
 'sea_water_reference_salinity': {'canonical_units': 'g kg-1'},
 'sea_water_salinity': {'canonical_units': '1e-3'},
 'sea_water_salinity_at_sea_floor': {'canonical_units': '1e-3'},
 'sea_water_sigma_t': {'canonical_units': 'kg m-3'},
 'sea_water_sigma_t_difference': {'canonical_units': 'kg m-3'},
 'sea_water_sigma_theta': {'canonical_units': 'kg m-3'},
 'sea_water_sigma_theta_difference': {'canonical_units': 'kg m-3'},
 'sea_water_specific_potential_enthalpy': {'canonical_units': 'J kg-1'},
 'sea_water_speed': {'canonical_units': 'm s-1'},
 'sea_water_speed_at_sea_floor': {'canonical_units': 'm s-1'},
 'sea_water_speed_due_to_tides': {'canonical_units': 'm s-1'},
 'sea_water_temperature': {'canonical_units': 'K'},
 'sea_water_temperature_anomaly': {'canonical_units': 'K'},
 'sea_water_temperature_at_sea_floor': {'canonical_units': 'K'},
 'sea_water_temperature_difference': {'canonical_units': 'K'},
 'sea_water_to_direction': {'canonical_units': 'degree'},
 'sea_water_transport_across_line': {'canonical_units': 'kg s-1'},
 'sea_water_turbidity': {'canonical_units': '1'},
 'sea_water_velocity_from_direction': {'canonical_units': 'degree'},
 'sea_water_velocity_to_direction': {'canonical_units': 'degree'},
 'sea_water_velocity_to_direction_at_sea_floor': {'canonical_units': 'degree'},
 'sea_water_velocity_to_direction_due_to_tides': {'canonical_units': 'degree'},
 'sea_water_volume': {'canonical_units': 'm3'},
 'sea_water_x_velocity': {'canonical_units': 'm s-1'},
 'sea_water_x_velocity_due_to_parameterized_mesoscale_eddies': {'canonical_units': 'm '
                                                                                   's-1'},
 'sea_water_y_velocity': {'canonical_units': 'm s-1'},
 'sea_water_y_velocity_due_to_parameterized_mesoscale_eddies': {'canonical_units': 'm '
                                                                                   's-1'},
 'secchi_depth_of_sea_water': {'canonical_units': 'm'},
 'sensor_azimuth_angle': {'canonical_units': 'degree'},
 'sensor_band_central_radiation_frequency': {'canonical_units': 's-1'},
 'sensor_band_central_radiation_wavelength': {'canonical_units': 'm'},
 'sensor_band_central_radiation_wavenumber': {'canonical_units': 'm-1'},
 'sensor_band_identifier': {'canonical_units': None},
 'sensor_view_angle': {'canonical_units': 'degree'},
 'sensor_zenith_angle': {'canonical_units': 'degree'},
 'shallow_convection_time_fraction': {'canonical_units': '1'},
 'shallow_convective_cloud_base_altitude': {'canonical_units': 'm'},
 'shallow_convective_cloud_top_altitude': {'canonical_units': 'm'},
 'shallow_convective_precipitation_flux': {'canonical_units': 'kg m-2 s-1'},
 'shortwave_radiance': {'canonical_units': 'W m-2 sr-1'},
 'signal_intensity_from_multibeam_acoustic_doppler_velocity_sensor_in_sea_water': {'canonical_units': '1'},
 'significant_height_of_swell_waves': {'canonical_units': 'm'},
 'significant_height_of_wind_and_swell_waves': {'canonical_units': 'm'},
 'significant_height_of_wind_waves': {'canonical_units': 'm'},
 'single_scattering_albedo_in_air_due_to_ambient_aerosol_particles': {'canonical_units': '1'},
 'sinking_mole_flux_of_aragonite_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                        'm-2 '
                                                                                        's-1'},
 'sinking_mole_flux_of_calcite_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                      'm-2 '
                                                                                      's-1'},
 'sinking_mole_flux_of_particulate_iron_in_sea_water': {'canonical_units': 'mol '
                                                                           'm-2 '
                                                                           's-1'},
 'sinking_mole_flux_of_particulate_organic_matter_expressed_as_carbon_in_sea_water': {'canonical_units': 'mol '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'sinking_mole_flux_of_particulate_organic_nitrogen_in_sea_water': {'canonical_units': 'mol '
                                                                                       'm-2 '
                                                                                       's-1'},
 'sinking_mole_flux_of_particulate_organic_phosphorus_in_sea_water': {'canonical_units': 'mol '
                                                                                         'm-2 '
                                                                                         's-1'},
 'sinking_mole_flux_of_particulate_silicon_in_sea_water': {'canonical_units': 'mol '
                                                                              'm-2 '
                                                                              's-1'},
 'slow_soil_pool_carbon_content': {'canonical_units': 'kg m-2'},
 'slow_soil_pool_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'snow_area_fraction_viewable_from_above': {'canonical_units': '1'},
 'snow_density': {'canonical_units': 'kg m-3'},
 'snow_grain_size': {'canonical_units': 'm'},
 'snow_soot_content': {'canonical_units': 'kg m-2'},
 'snow_temperature': {'canonical_units': 'K'},
 'snow_thermal_energy_content': {'canonical_units': 'J m-2'},
 'snow_transport_across_line_due_to_sea_ice_dynamics': {'canonical_units': 'kg '
                                                                           's-1'},
 'snowfall_amount': {'canonical_units': 'kg m-2'},
 'snowfall_flux': {'canonical_units': 'kg m-2 s-1'},
 'soil_albedo': {'canonical_units': '1'},
 'soil_carbon_content': {'canonical_units': 'kg m-2'},
 'soil_frozen_water_content': {'canonical_units': 'kg m-2'},
 'soil_hydraulic_conductivity_at_saturation': {'canonical_units': 'm s-1'},
 'soil_mass_content_of_13C': {'canonical_units': 'kg m-2'},
 'soil_mass_content_of_14C': {'canonical_units': 'kg m-2'},
 'soil_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'soil_mass_content_of_inorganic_ammonium_expressed_as_nitrogen': {'canonical_units': 'kg '
                                                                                      'm-2'},
 'soil_mass_content_of_inorganic_nitrate_expressed_as_nitrogen': {'canonical_units': 'kg '
                                                                                     'm-2'},
 'soil_mass_content_of_inorganic_nitrogen_expressed_as_nitrogen': {'canonical_units': 'kg '
                                                                                      'm-2'},
 'soil_mass_content_of_nitrogen': {'canonical_units': 'kg m-2'},
 'soil_moisture_content': {'canonical_units': 'kg m-2'},
 'soil_moisture_content_at_field_capacity': {'canonical_units': 'kg m-2'},
 'soil_pool': {'canonical_units': None},
 'soil_pool_carbon_decay_rate': {'canonical_units': 's-1'},
 'soil_porosity': {'canonical_units': '1'},
 'soil_respiration_carbon_flux': {'canonical_units': 'kg m-2 s-1'},
 'soil_suction_at_saturation': {'canonical_units': 'Pa'},
 'soil_temperature': {'canonical_units': 'K'},
 'soil_thermal_capacity': {'canonical_units': 'J kg-1 K-1'},
 'soil_thermal_conductivity': {'canonical_units': 'W m-1 K-1'},
 'soil_type': {'canonical_units': None},
 'soil_water_ph': {'canonical_units': '1'},
 'solar_azimuth_angle': {'canonical_units': 'degree'},
 'solar_elevation_angle': {'canonical_units': 'degree'},
 'solar_irradiance': {'canonical_units': 'W m-2'},
 'solar_irradiance_per_unit_wavelength': {'canonical_units': 'W m-2 m-1'},
 'solar_zenith_angle': {'canonical_units': 'degree'},
 'solid_earth_subsurface_temperature': {'canonical_units': 'K'},
 'solid_precipitation_flux': {'canonical_units': 'kg m-2 s-1'},
 'solid_precipitation_flux_containing_17O': {'canonical_units': 'kg m-2 s-1'},
 'solid_precipitation_flux_containing_18O': {'canonical_units': 'kg m-2 s-1'},
 'solid_precipitation_flux_containing_single_2H': {'canonical_units': 'kg m-2 '
                                                                      's-1'},
 'soot_content_of_surface_snow': {'canonical_units': 'kg m-2'},
 'sound_frequency': {'canonical_units': 's-1'},
 'sound_intensity_in_air': {'canonical_units': 'W m-2'},
 'sound_intensity_in_water': {'canonical_units': 'W m-2'},
 'sound_intensity_level_in_air': {'canonical_units': 'dB'},
 'sound_intensity_level_in_water': {'canonical_units': 'dB'},
 'sound_pressure_in_air': {'canonical_units': 'Pa'},
 'sound_pressure_in_water': {'canonical_units': 'Pa'},
 'sound_pressure_level_in_air': {'canonical_units': 'dB'},
 'sound_pressure_level_in_water': {'canonical_units': 'dB'},
 'source': {'canonical_units': None},
 'specific_convective_available_potential_energy': {'canonical_units': 'J '
                                                                       'kg-1'},
 'specific_dry_energy_of_air': {'canonical_units': 'm2 s-2'},
 'specific_gravitational_potential_energy': {'canonical_units': 'J kg-1'},
 'specific_heat_capacity_of_frozen_ground': {'canonical_units': 'J kg-1 K-1'},
 'specific_heat_capacity_of_sea_water': {'canonical_units': 'J kg-1 K-1'},
 'specific_humidity': {'canonical_units': '1'},
 'specific_kinetic_energy_of_air': {'canonical_units': 'm2 s-2'},
 'specific_kinetic_energy_of_sea_water': {'canonical_units': 'm2 s-2'},
 'specific_potential_energy': {'canonical_units': 'J kg-1'},
 'specific_turbulent_kinetic_energy_dissipation_in_sea_water': {'canonical_units': 'W '
                                                                                   'kg-1'},
 'specific_turbulent_kinetic_energy_of_sea_water': {'canonical_units': 'm2 '
                                                                       's-2'},
 'spectral_radiance': {'canonical_units': 'W m-2 m-1 sr-1'},
 'speed_of_sound_in_air': {'canonical_units': 'm s-1'},
 'speed_of_sound_in_sea_water': {'canonical_units': 'm s-1'},
 'spell_length_of_days_with_air_temperature_above_threshold': {'canonical_units': 'day'},
 'spell_length_of_days_with_air_temperature_below_threshold': {'canonical_units': 'day'},
 'spell_length_of_days_with_lwe_thickness_of_precipitation_amount_above_threshold': {'canonical_units': 'day'},
 'spell_length_of_days_with_lwe_thickness_of_precipitation_amount_below_threshold': {'canonical_units': 'day'},
 'spike_test_quality_flag': {'canonical_units': '1'},
 'square_of_air_temperature': {'canonical_units': 'K2'},
 'square_of_brunt_vaisala_frequency_in_air': {'canonical_units': 's-2'},
 'square_of_brunt_vaisala_frequency_in_sea_water': {'canonical_units': 's-2'},
 'square_of_eastward_wind': {'canonical_units': 'm2 s-2'},
 'square_of_geopotential_height': {'canonical_units': 'm2'},
 'square_of_lagrangian_tendency_of_air_pressure': {'canonical_units': 'Pa2 '
                                                                      's-2'},
 'square_of_northward_wind': {'canonical_units': 'm2 s-2'},
 'square_of_ocean_mixed_layer_thickness_defined_by_sigma_t': {'canonical_units': 'm2'},
 'square_of_sea_surface_height_above_geoid': {'canonical_units': 'm2'},
 'square_of_sea_surface_salinity': {'canonical_units': '1e-6'},
 'square_of_sea_surface_temperature': {'canonical_units': 'K2'},
 'square_of_upward_air_velocity': {'canonical_units': 'm2 s-2'},
 'square_of_upward_ocean_mass_transport': {'canonical_units': 'kg2 s-2'},
 'station_description': {'canonical_units': None},
 'station_wmo_id': {'canonical_units': None},
 'status_flag': {'canonical_units': '1'},
 'stem_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'stem_mass_content_of_nitrogen': {'canonical_units': 'kg m-2'},
 'steric_change_in_mean_sea_level': {'canonical_units': 'm'},
 'steric_change_in_sea_surface_height': {'canonical_units': 'm'},
 'storm_motion_speed': {'canonical_units': 'm s-1'},
 'stratiform_cloud_area_fraction': {'canonical_units': '1'},
 'stratiform_cloud_area_fraction_in_atmosphere_layer': {'canonical_units': '1'},
 'stratiform_cloud_longwave_emissivity': {'canonical_units': '1'},
 'stratiform_graupel_fall_amount': {'canonical_units': 'kg m-2'},
 'stratiform_graupel_flux': {'canonical_units': 'kg m-2 s-1'},
 'stratiform_precipitation_amount': {'canonical_units': 'kg m-2'},
 'stratiform_precipitation_flux': {'canonical_units': 'kg m-2 s-1'},
 'stratiform_rainfall_amount': {'canonical_units': 'kg m-2'},
 'stratiform_rainfall_flux': {'canonical_units': 'kg m-2 s-1'},
 'stratiform_rainfall_rate': {'canonical_units': 'm s-1'},
 'stratiform_snowfall_amount': {'canonical_units': 'kg m-2'},
 'stratiform_snowfall_flux': {'canonical_units': 'kg m-2 s-1'},
 'stratosphere_mole_content_of_nitrogen_dioxide': {'canonical_units': 'mol '
                                                                      'm-2'},
 'stratosphere_optical_thickness_due_to_ambient_aerosol_particles': {'canonical_units': '1'},
 'stratosphere_optical_thickness_due_to_sulfate_ambient_aerosol_particles': {'canonical_units': '1'},
 'stratosphere_optical_thickness_due_to_volcanic_ambient_aerosol_particles': {'canonical_units': '1'},
 'subsurface_litter_carbon_content': {'canonical_units': 'kg m-2'},
 'subsurface_litter_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'subsurface_litter_mass_content_of_nitrogen': {'canonical_units': 'kg m-2'},
 'subsurface_runoff_amount': {'canonical_units': 'kg m-2'},
 'subsurface_runoff_flux': {'canonical_units': 'kg m-2 s-1'},
 'sunglint_angle': {'canonical_units': 'rad'},
 'sunlit_binary_mask': {'canonical_units': '1'},
 'surface_air_pressure': {'canonical_units': 'Pa'},
 'surface_albedo': {'canonical_units': '1'},
 'surface_albedo_assuming_deep_snow': {'canonical_units': '1'},
 'surface_albedo_assuming_no_snow': {'canonical_units': '1'},
 'surface_altitude': {'canonical_units': 'm'},
 'surface_backwards_scattering_coefficient_of_radar_wave': {'canonical_units': '1'},
 'surface_bidirectional_reflectance': {'canonical_units': '1'},
 'surface_brightness_temperature': {'canonical_units': 'K'},
 'surface_carbon_dioxide_abiotic_analogue_partial_pressure_difference_between_sea_water_and_air': {'canonical_units': 'Pa'},
 'surface_carbon_dioxide_mole_flux': {'canonical_units': 'mol m-2 s-1'},
 'surface_carbon_dioxide_natural_analogue_partial_pressure_difference_between_sea_water_and_air': {'canonical_units': 'Pa'},
 'surface_carbon_dioxide_partial_pressure_difference_between_air_and_sea_water': {'canonical_units': 'Pa'},
 'surface_carbon_dioxide_partial_pressure_difference_between_sea_water_and_air': {'canonical_units': 'Pa'},
 'surface_cover': {'canonical_units': None},
 'surface_diffuse_downwelling_photosynthetic_radiative_flux_in_air': {'canonical_units': 'W '
                                                                                         'm-2'},
 'surface_diffuse_downwelling_shortwave_flux_in_air': {'canonical_units': 'W '
                                                                          'm-2'},
 'surface_diffuse_downwelling_shortwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                                             'm-2'},
 'surface_diffuse_shortwave_hemispherical_reflectance': {'canonical_units': '1'},
 'surface_direct_along_beam_shortwave_flux_in_air': {'canonical_units': 'W '
                                                                        'm-2'},
 'surface_direct_downwelling_shortwave_flux_in_air': {'canonical_units': 'W '
                                                                         'm-2'},
 'surface_direct_shortwave_hemispherical_reflectance': {'canonical_units': '1'},
 'surface_downward_eastward_stress': {'canonical_units': 'Pa'},
 'surface_downward_eastward_stress_due_to_boundary_layer_mixing': {'canonical_units': 'Pa'},
 'surface_downward_eastward_stress_due_to_ocean_viscous_dissipation': {'canonical_units': 'Pa'},
 'surface_downward_eastward_stress_due_to_sea_surface_waves': {'canonical_units': 'Pa'},
 'surface_downward_heat_flux_in_air': {'canonical_units': 'W m-2'},
 'surface_downward_heat_flux_in_sea_ice': {'canonical_units': 'W m-2'},
 'surface_downward_heat_flux_in_sea_water': {'canonical_units': 'W m-2'},
 'surface_downward_heat_flux_in_snow': {'canonical_units': 'W m-2'},
 'surface_downward_latent_heat_flux': {'canonical_units': 'W m-2'},
 'surface_downward_mass_flux_of_13C_dioxide_abiotic_analogue_expressed_as_13C': {'canonical_units': 'kg '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'surface_downward_mass_flux_of_14C_dioxide_abiotic_analogue_expressed_as_carbon': {'canonical_units': 'kg '
                                                                                                       'm-2 '
                                                                                                       's-1'},
 'surface_downward_mass_flux_of_ammonia': {'canonical_units': 'kg m-2 s-1'},
 'surface_downward_mass_flux_of_carbon13_dioxide_abiotic_analogue_expressed_as_carbon13': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'surface_downward_mass_flux_of_carbon14_dioxide_abiotic_analogue_expressed_as_carbon': {'canonical_units': 'kg '
                                                                                                            'm-2 '
                                                                                                            's-1'},
 'surface_downward_mass_flux_of_carbon_dioxide_abiotic_analogue_expressed_as_carbon': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'surface_downward_mass_flux_of_carbon_dioxide_expressed_as_carbon': {'canonical_units': 'kg '
                                                                                         'm-2 '
                                                                                         's-1'},
 'surface_downward_mass_flux_of_carbon_dioxide_natural_analogue_expressed_as_carbon': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'surface_downward_mass_flux_of_methane_due_to_wetland_biological_consumption': {'canonical_units': 'kg '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'surface_downward_mass_flux_of_water_due_to_irrigation': {'canonical_units': 'kg '
                                                                              'm-2 '
                                                                              's-1'},
 'surface_downward_mole_flux_of_carbon_dioxide': {'canonical_units': 'mol m-2 '
                                                                     's-1'},
 'surface_downward_mole_flux_of_cfc11': {'canonical_units': 'mol m-2 s-1'},
 'surface_downward_mole_flux_of_cfc12': {'canonical_units': 'mol m-2 s-1'},
 'surface_downward_mole_flux_of_molecular_oxygen': {'canonical_units': 'mol '
                                                                       'm-2 '
                                                                       's-1'},
 'surface_downward_mole_flux_of_sulfur_hexafluoride': {'canonical_units': 'mol '
                                                                          'm-2 '
                                                                          's-1'},
 'surface_downward_northward_stress': {'canonical_units': 'Pa'},
 'surface_downward_northward_stress_due_to_boundary_layer_mixing': {'canonical_units': 'Pa'},
 'surface_downward_northward_stress_due_to_ocean_viscous_dissipation': {'canonical_units': 'Pa'},
 'surface_downward_northward_stress_due_to_sea_surface_waves': {'canonical_units': 'Pa'},
 'surface_downward_sensible_heat_flux': {'canonical_units': 'W m-2'},
 'surface_downward_water_flux': {'canonical_units': 'kg m-2 s-1'},
 'surface_downward_x_stress': {'canonical_units': 'Pa'},
 'surface_downward_x_stress_correction': {'canonical_units': 'Pa'},
 'surface_downward_y_stress': {'canonical_units': 'Pa'},
 'surface_downward_y_stress_correction': {'canonical_units': 'Pa'},
 'surface_downwelling_longwave_flux': {'canonical_units': 'W m-2'},
 'surface_downwelling_longwave_flux_in_air': {'canonical_units': 'W m-2'},
 'surface_downwelling_longwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                                    'm-2'},
 'surface_downwelling_longwave_flux_in_air_due_to_volcanic_ambient_aerosol_particles': {'canonical_units': 'W '
                                                                                                           'm-2'},
 'surface_downwelling_photon_flux_in_sea_water': {'canonical_units': 'mol m-2 '
                                                                     's-1'},
 'surface_downwelling_photon_flux_per_unit_wavelength_in_sea_water': {'canonical_units': 'mol '
                                                                                         'm-2 '
                                                                                         's-1 '
                                                                                         'm-1'},
 'surface_downwelling_photon_radiance_in_sea_water': {'canonical_units': 'mol '
                                                                         'm-2 '
                                                                         's-1 '
                                                                         'sr-1'},
 'surface_downwelling_photon_radiance_per_unit_wavelength_in_sea_water': {'canonical_units': 'mol '
                                                                                             'm-2 '
                                                                                             's-1 '
                                                                                             'm-1 '
                                                                                             'sr-1'},
 'surface_downwelling_photon_spherical_irradiance_in_sea_water': {'canonical_units': 'mol '
                                                                                     'm-2 '
                                                                                     's-1'},
 'surface_downwelling_photon_spherical_irradiance_per_unit_wavelength_in_sea_water': {'canonical_units': 'mol '
                                                                                                         'm-2 '
                                                                                                         's-1 '
                                                                                                         'm-1'},
 'surface_downwelling_photosynthetic_photon_flux_in_air': {'canonical_units': 'mol '
                                                                              'm-2 '
                                                                              's-1'},
 'surface_downwelling_photosynthetic_photon_flux_in_sea_water': {'canonical_units': 'mol '
                                                                                    'm-2 '
                                                                                    's-1'},
 'surface_downwelling_photosynthetic_photon_radiance_in_sea_water': {'canonical_units': 'mol '
                                                                                        'm-2 '
                                                                                        's-1 '
                                                                                        'sr-1'},
 'surface_downwelling_photosynthetic_photon_spherical_irradiance_in_sea_water': {'canonical_units': 'mol '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'surface_downwelling_photosynthetic_radiance_in_sea_water': {'canonical_units': 'W '
                                                                                 'm-2 '
                                                                                 'sr-1'},
 'surface_downwelling_photosynthetic_radiative_flux_in_air': {'canonical_units': 'W '
                                                                                 'm-2'},
 'surface_downwelling_photosynthetic_radiative_flux_in_sea_water': {'canonical_units': 'W '
                                                                                       'm-2'},
 'surface_downwelling_photosynthetic_spherical_irradiance_in_sea_water': {'canonical_units': 'W '
                                                                                             'm-2'},
 'surface_downwelling_radiance_in_sea_water': {'canonical_units': 'W m-2 sr-1'},
 'surface_downwelling_radiance_per_unit_wavelength_in_sea_water': {'canonical_units': 'W '
                                                                                      'm-2 '
                                                                                      'm-1 '
                                                                                      'sr-1'},
 'surface_downwelling_radiative_flux_in_sea_water': {'canonical_units': 'W '
                                                                        'm-2'},
 'surface_downwelling_radiative_flux_per_unit_wavelength_in_air': {'canonical_units': 'W '
                                                                                      'm-2 '
                                                                                      'm-1'},
 'surface_downwelling_radiative_flux_per_unit_wavelength_in_sea_water': {'canonical_units': 'W '
                                                                                            'm-2 '
                                                                                            'm-1'},
 'surface_downwelling_shortwave_flux': {'canonical_units': 'W m-2'},
 'surface_downwelling_shortwave_flux_assuming_clear_sky': {'canonical_units': 'W '
                                                                              'm-2'},
 'surface_downwelling_shortwave_flux_in_air': {'canonical_units': 'W m-2'},
 'surface_downwelling_shortwave_flux_in_air_assuming_clean_clear_sky': {'canonical_units': 'W '
                                                                                           'm-2'},
 'surface_downwelling_shortwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                                     'm-2'},
 'surface_downwelling_shortwave_flux_in_air_assuming_clear_sky_and_no_aerosol': {'canonical_units': 'W '
                                                                                                    'm-2'},
 'surface_downwelling_shortwave_flux_in_air_due_to_volcanic_ambient_aerosol_particles': {'canonical_units': 'W '
                                                                                                            'm-2'},
 'surface_downwelling_spectral_photon_flux_in_sea_water': {'canonical_units': 'mol '
                                                                              'm-2 '
                                                                              's-1 '
                                                                              'm-1'},
 'surface_downwelling_spectral_photon_radiance_in_sea_water': {'canonical_units': 'mol '
                                                                                  'm-2 '
                                                                                  's-1 '
                                                                                  'm-1 '
                                                                                  'sr-1'},
 'surface_downwelling_spectral_photon_spherical_irradiance_in_sea_water': {'canonical_units': 'mol '
                                                                                              'm-2 '
                                                                                              's-1 '
                                                                                              'm-1'},
 'surface_downwelling_spectral_radiance_in_sea_water': {'canonical_units': 'W '
                                                                           'm-2 '
                                                                           'm-1 '
                                                                           'sr-1'},
 'surface_downwelling_spectral_radiative_flux_in_air': {'canonical_units': 'W '
                                                                           'm-2 '
                                                                           'm-1'},
 'surface_downwelling_spectral_radiative_flux_in_sea_water': {'canonical_units': 'W '
                                                                                 'm-2 '
                                                                                 'm-1'},
 'surface_downwelling_spectral_spherical_irradiance_in_sea_water': {'canonical_units': 'W '
                                                                                       'm-2 '
                                                                                       'm-1'},
 'surface_downwelling_spherical_irradiance_in_sea_water': {'canonical_units': 'W '
                                                                              'm-2'},
 'surface_downwelling_spherical_irradiance_per_unit_wavelength_in_sea_water': {'canonical_units': 'W '
                                                                                                  'm-2 '
                                                                                                  'm-1'},
 'surface_drag_coefficient_for_heat_in_air': {'canonical_units': '1'},
 'surface_drag_coefficient_for_momentum_in_air': {'canonical_units': '1'},
 'surface_drag_coefficient_in_air': {'canonical_units': '1'},
 'surface_eastward_geostrophic_sea_water_velocity': {'canonical_units': 'm '
                                                                        's-1'},
 'surface_eastward_geostrophic_sea_water_velocity_assuming_sea_level_for_geoid': {'canonical_units': 'm '
                                                                                                     's-1'},
 'surface_eastward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'surface_frozen_carbon_dioxide_amount': {'canonical_units': 'kg m-2'},
 'surface_geopotential': {'canonical_units': 'm2 s-2'},
 'surface_geostrophic_eastward_sea_water_velocity': {'canonical_units': 'm '
                                                                        's-1'},
 'surface_geostrophic_eastward_sea_water_velocity_assuming_mean_sea_level_for_geoid': {'canonical_units': 'm '
                                                                                                          's-1'},
 'surface_geostrophic_eastward_sea_water_velocity_assuming_sea_level_for_geoid': {'canonical_units': 'm '
                                                                                                     's-1'},
 'surface_geostrophic_northward_sea_water_velocity': {'canonical_units': 'm '
                                                                         's-1'},
 'surface_geostrophic_northward_sea_water_velocity_assuming_mean_sea_level_for_geoid': {'canonical_units': 'm '
                                                                                                           's-1'},
 'surface_geostrophic_northward_sea_water_velocity_assuming_sea_level_for_geoid': {'canonical_units': 'm '
                                                                                                      's-1'},
 'surface_geostrophic_sea_water_x_velocity': {'canonical_units': 'm s-1'},
 'surface_geostrophic_sea_water_x_velocity_assuming_mean_sea_level_for_geoid': {'canonical_units': 'm '
                                                                                                   's-1'},
 'surface_geostrophic_sea_water_x_velocity_assuming_sea_level_for_geoid': {'canonical_units': 'm '
                                                                                              's-1'},
 'surface_geostrophic_sea_water_y_velocity': {'canonical_units': 'm s-1'},
 'surface_geostrophic_sea_water_y_velocity_assuming_mean_sea_level_for_geoid': {'canonical_units': 'm '
                                                                                                   's-1'},
 'surface_geostrophic_sea_water_y_velocity_assuming_sea_level_for_geoid': {'canonical_units': 'm '
                                                                                              's-1'},
 'surface_height_above_geopotential_datum': {'canonical_units': 'm'},
 'surface_litter_carbon_content': {'canonical_units': 'kg m-2'},
 'surface_litter_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'surface_litter_mass_content_of_nitrogen': {'canonical_units': 'kg m-2'},
 'surface_longwave_emissivity': {'canonical_units': '1'},
 'surface_microwave_emissivity': {'canonical_units': '1'},
 'surface_molecular_oxygen_partial_pressure_difference_between_sea_water_and_air': {'canonical_units': 'Pa'},
 'surface_net_downward_longwave_dust_ambient_aerosol_particles_direct_radiative_effect': {'canonical_units': 'W '
                                                                                                             'm-2'},
 'surface_net_downward_longwave_dust_ambient_aerosol_particles_direct_radiative_effect_assuming_clear_sky': {'canonical_units': 'W '
                                                                                                                                'm-2'},
 'surface_net_downward_longwave_flux': {'canonical_units': 'W m-2'},
 'surface_net_downward_longwave_flux_assuming_clear_sky': {'canonical_units': 'W '
                                                                              'm-2'},
 'surface_net_downward_mass_flux_of_ammonia_due_to_bidirectional_surface_exchange': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'surface_net_downward_mass_flux_of_carbon_dioxide_expressed_as_13C_due_to_all_land_processes': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'surface_net_downward_mass_flux_of_carbon_dioxide_expressed_as_14C_due_to_all_land_processes': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'surface_net_downward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_all_land_processes': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'surface_net_downward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_all_land_processes_excluding_anthropogenic_land_use_change': {'canonical_units': 'kg '
                                                                                                                                                               'm-2 '
                                                                                                                                                               's-1'},
 'surface_net_downward_radiative_flux': {'canonical_units': 'W m-2'},
 'surface_net_downward_radiative_flux_where_land': {'canonical_units': 'W m-2'},
 'surface_net_downward_shortwave_dust_ambient_aerosol_particles_direct_radiative_effect': {'canonical_units': 'W '
                                                                                                              'm-2'},
 'surface_net_downward_shortwave_dust_ambient_aerosol_particles_direct_radiative_effect_assuming_clear_sky': {'canonical_units': 'W '
                                                                                                                                 'm-2'},
 'surface_net_downward_shortwave_flux': {'canonical_units': 'W m-2'},
 'surface_net_downward_shortwave_flux_assuming_clear_sky': {'canonical_units': 'W '
                                                                               'm-2'},
 'surface_net_upward_longwave_flux': {'canonical_units': 'W m-2'},
 'surface_net_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_anthropogenic_land_use_change': {'canonical_units': 'kg '
                                                                                                                                              'm-2 '
                                                                                                                                              's-1'},
 'surface_net_upward_mass_flux_of_methane_due_to_emission_from_wetland_biological_processes': {'canonical_units': 'kg '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'surface_net_upward_radiative_flux': {'canonical_units': 'W m-2'},
 'surface_net_upward_shortwave_flux': {'canonical_units': 'W m-2'},
 'surface_northward_geostrophic_sea_water_velocity': {'canonical_units': 'm '
                                                                         's-1'},
 'surface_northward_geostrophic_sea_water_velocity_assuming_sea_level_for_geoid': {'canonical_units': 'm '
                                                                                                      's-1'},
 'surface_northward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'surface_partial_pressure_of_carbon_dioxide_abiotic_analogue_in_sea_water': {'canonical_units': 'Pa'},
 'surface_partial_pressure_of_carbon_dioxide_in_air': {'canonical_units': 'Pa'},
 'surface_partial_pressure_of_carbon_dioxide_in_sea_water': {'canonical_units': 'Pa'},
 'surface_partial_pressure_of_carbon_dioxide_natural_analogue_in_sea_water': {'canonical_units': 'Pa'},
 'surface_radioactivity_content': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_101Mo': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_101Tc': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_102Mo': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_102Tc': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_102mTc': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_103Ru': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_103mRh': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_104Tc': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_105Rh': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_105Ru': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_105mRh': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_106Rh': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_106Ru': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_106mRh': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_107Pd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_107Rh': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_107mPd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_109Pd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_109mAg': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_110mAg': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_111Ag': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_111Pd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_111mAg': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_111mCd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_111mPd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_112Ag': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_112Pd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_113Ag': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_113Cd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_113mAg': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_113mCd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_113mIn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_115Ag': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_115Cd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_115In': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_115mAg': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_115mCd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_115mIn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_116In': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_116mIn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_117Cd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_117In': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_117mCd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_117mIn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_117mSn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_118Cd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_118In': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_118mIn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_119In': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_119mIn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_119mSn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_11C': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_121Sn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_121mSn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_123Sn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_123mSn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_124Sb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_124mSb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_125Sb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_125Sn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_125mTe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_126Sb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_126Sn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_126mSb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_127Sb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_127Sn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_127Te': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_127mTe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_128Sb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_128Sn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_128mSb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_129I': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_129Sb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_129Te': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_129mTe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_129mXe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_130I': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_130Sb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_130Sn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_130mI': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_130mSb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_131I': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_131Sb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_131Te': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_131mTe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_131mXe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_132I': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_132Te': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_133I': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_133Te': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_133Xe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_133mI': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_133mTe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_133mXe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_134Cs': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_134I': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_134Te': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_134mCs': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_134mI': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_134mXe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_135Cs': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_135I': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_135Xe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_135mBa': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_135mCs': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_135mXe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_136Cs': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_137Cs': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_137Xe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_137mBa': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_138Cs': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_138Xe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_139Ba': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_13N': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_140Ba': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_140La': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_141Ce': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_141La': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_142Ce': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_142La': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_142Pr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_142mPr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_143Ce': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_143La': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_143Pr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_144Ce': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_144Nd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_144Pr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_144mPr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_145Pr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_146Ce': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_146Pr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_147Nd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_147Pm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_147Pr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_147Sm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_148Pm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_148Sm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_148mPm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_149Nd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_149Pm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_149Sm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_150Pm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_151Nd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_151Pm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_151Sm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_152Nd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_152Pm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_152mPm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_153Sm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_154Eu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_155Eu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_155Sm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_156Eu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_156Sm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_157Eu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_158Eu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_159Eu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_159Gd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_15O': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_160Tb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_161Tb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_162Gd': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_162Tb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_162mTb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_163Tb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_165Dy': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_18F': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_206Hg': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_206Tl': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_207Tl': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_207mPb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_208Tl': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_209Bi': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_209Pb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_209Tl': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_210Bi': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_210Pb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_210Po': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_210Tl': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_211Bi': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_211Pb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_211Po': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_212Bi': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_212Pb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_212Po': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_213Bi': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_213Pb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_213Po': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_214Bi': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_214Pb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_214Po': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_215At': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_215Bi': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_215Po': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_216At': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_216Po': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_217At': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_217Po': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_218At': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_218Po': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_218Rn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_219At': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_219Rn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_220Rn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_221Fr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_221Rn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_222Fr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_222Ra': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_222Rn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_223Fr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_223Ra': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_223Rn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_224Ra': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_225Ac': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_225Ra': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_226Ac': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_226Ra': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_226Th': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_227Ac': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_227Ra': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_227Th': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_228Ac': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_228Ra': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_228Th': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_229Ac': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_229Ra': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_229Th': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_230Pa': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_230Th': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_230U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_231Pa': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_231Th': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_231U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_232Pa': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_232Th': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_232U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_233Pa': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_233Th': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_233U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_234Pa': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_234Th': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_234U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_234mPa': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_235Np': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_235Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_235U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_236Np': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_236Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_236U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_236mNp': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_237Np': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_237Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_237U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_238Np': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_238Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_238U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_239Np': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_239Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_239U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_240Am': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_240Np': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_240Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_240U': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_240mNp': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_241Am': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_241Cm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_241Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_242Am': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_242Cm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_242Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_242m1Am': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_242m2Am': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_243Am': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_243Cm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_243Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_244Am': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_244Cm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_244Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_244mAm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_245Am': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_245Cm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_245Pu': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_246Cm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_247Cm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_248Cm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_249Bk': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_249Cf': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_249Cm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_24Na': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_250Bk': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_250Cf': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_250Cm': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_251Cf': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_252Cf': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_253Cf': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_253Es': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_254Cf': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_254Es': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_254mEs': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_255Es': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_3H': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_41Ar': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_54Mn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_58Co': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_60Co': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_72Ga': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_72Zn': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_73Ga': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_75Ge': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_77As': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_77Ge': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_77mGe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_78As': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_78Ge': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_79Se': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_81Se': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_81mSe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_82Br': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_82mBr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_83Br': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_83Se': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_83mKr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_83mSe': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_84Br': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_84mBr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_85Kr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_85mKr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_86Rb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_86mRb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_87Kr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_87Rb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_88Kr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_88Rb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_89Kr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_89Rb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_89Sr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_90Sr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_90Y': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_90mY': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_91Sr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_91Y': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_91mY': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_92Sr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_92Y': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_93Y': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_93Zr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_94Nb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_94Y': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_94mNb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_95Nb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_95Y': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_95Zr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_95mNb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_96Nb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_97Nb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_97Zr': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_97mNb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_98Nb': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_99Mo': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_99Tc': {'canonical_units': 'Bq m-2'},
 'surface_radioactivity_content_of_99mTc': {'canonical_units': 'Bq m-2'},
 'surface_ratio_of_upwelling_radiance_emerging_from_sea_water_to_downwelling_radiative_flux_in_air': {'canonical_units': 'sr-1'},
 'surface_roughness_length': {'canonical_units': 'm'},
 'surface_roughness_length_for_heat_in_air': {'canonical_units': 'm'},
 'surface_roughness_length_for_humidity_in_air': {'canonical_units': 'm'},
 'surface_roughness_length_for_momentum_in_air': {'canonical_units': 'm'},
 'surface_runoff_amount': {'canonical_units': 'kg m-2'},
 'surface_runoff_flux': {'canonical_units': 'kg m-2 s-1'},
 'surface_snow_amount': {'canonical_units': 'kg m-2'},
 'surface_snow_and_ice_melt_flux': {'canonical_units': 'kg m-2 s-1'},
 'surface_snow_and_ice_melt_heat_flux': {'canonical_units': 'W m-2'},
 'surface_snow_and_ice_refreezing_flux': {'canonical_units': 'kg m-2 s-1'},
 'surface_snow_and_ice_sublimation_flux': {'canonical_units': 'kg m-2 s-1'},
 'surface_snow_area_fraction': {'canonical_units': '1'},
 'surface_snow_binary_mask': {'canonical_units': '1'},
 'surface_snow_density': {'canonical_units': 'kg m-3'},
 'surface_snow_melt_amount': {'canonical_units': 'kg m-2'},
 'surface_snow_melt_and_sublimation_heat_flux': {'canonical_units': 'W m-2'},
 'surface_snow_melt_flux': {'canonical_units': 'kg m-2 s-1'},
 'surface_snow_melt_heat_flux': {'canonical_units': 'W m-2'},
 'surface_snow_sublimation_amount': {'canonical_units': 'kg m-2'},
 'surface_snow_sublimation_heat_flux': {'canonical_units': 'W m-2'},
 'surface_snow_thickness': {'canonical_units': 'm'},
 'surface_snow_thickness_where_sea_ice': {'canonical_units': 'm'},
 'surface_specific_humidity': {'canonical_units': '1'},
 'surface_temperature': {'canonical_units': 'K'},
 'surface_temperature_anomaly': {'canonical_units': 'K'},
 'surface_temperature_where_land': {'canonical_units': 'K'},
 'surface_temperature_where_open_sea': {'canonical_units': 'K'},
 'surface_temperature_where_snow': {'canonical_units': 'K'},
 'surface_upward_carbon_mass_flux_due_to_plant_respiration_for_biomass_growth': {'canonical_units': 'kg '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'surface_upward_carbon_mass_flux_due_to_plant_respiration_for_biomass_maintenance': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'surface_upward_eastward_stress_due_to_sea_surface_waves': {'canonical_units': 'Pa'},
 'surface_upward_heat_flux_due_to_anthropogenic_energy_consumption': {'canonical_units': 'W '
                                                                                         'm-2'},
 'surface_upward_heat_flux_in_air': {'canonical_units': 'W m-2'},
 'surface_upward_latent_heat_flux': {'canonical_units': 'W m-2'},
 'surface_upward_latent_heat_flux_due_to_sublimation': {'canonical_units': 'W '
                                                                           'm-2'},
 'surface_upward_mass_flux_of_ammonia': {'canonical_units': 'kg m-2 s-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_13C_due_to_heterotrophic_respiration': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_13C_due_to_plant_respiration': {'canonical_units': 'kg '
                                                                                                             'm-2 '
                                                                                                             's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_14C_due_to_heterotrophic_respiration': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_14C_due_to_plant_respiration': {'canonical_units': 'kg '
                                                                                                             'm-2 '
                                                                                                             's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_anthropogenic_land_use_or_land_cover_change': {'canonical_units': 'kg '
                                                                                                                                          'm-2 '
                                                                                                                                          's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_anthropogenic_land_use_or_land_cover_change_excluding_forestry_and_agricultural_products': {'canonical_units': 'kg '
                                                                                                                                                                                       'm-2 '
                                                                                                                                                                                       's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_crop_harvesting': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_fires': {'canonical_units': 'kg '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_fires_excluding_anthropogenic_land_use_change': {'canonical_units': 'kg '
                                                                                                                                                          'm-2 '
                                                                                                                                                          's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_grazing': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_litter_in_fires': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_natural_fires': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_natural_sources': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_vegetation_in_fires': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_heterotrophic_respiration': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_plant_respiration': {'canonical_units': 'kg '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_plant_respiration_for_biomass_growth': {'canonical_units': 'kg '
                                                                                                                                   'm-2 '
                                                                                                                                   's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_plant_respiration_for_biomass_maintenance': {'canonical_units': 'kg '
                                                                                                                                        'm-2 '
                                                                                                                                        's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_plant_respiration_in_leaves': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_plant_respiration_in_miscellaneous_living_matter': {'canonical_units': 'kg '
                                                                                                                                               'm-2 '
                                                                                                                                               's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_plant_respiration_in_roots': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_plant_respiration_in_stems': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'surface_upward_mass_flux_of_carbon_dioxide_expressed_as_carbon_due_to_respiration_in_soil': {'canonical_units': 'kg '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'surface_upward_mass_flux_of_carbon_due_to_heterotrophic_respiration_in_litter': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'surface_upward_mass_flux_of_carbon_due_to_heterotrophic_respiration_in_soil': {'canonical_units': 'kg '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'surface_upward_mass_flux_of_methane_due_to_emission_from_wetland_biological_production': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'surface_upward_mass_flux_of_nitrogen_compounds_expressed_as_nitrogen': {'canonical_units': 'kg '
                                                                                             'm-2 '
                                                                                             's-1'},
 'surface_upward_mass_flux_of_nitrogen_compounds_expressed_as_nitrogen_due_to_all_land_processes_excluding_fires': {'canonical_units': 'kg '
                                                                                                                                       'm-2 '
                                                                                                                                       's-1'},
 'surface_upward_mass_flux_of_nitrogen_compounds_expressed_as_nitrogen_due_to_emission_from_fires': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'surface_upward_mass_flux_of_nitrogen_compounds_expressed_as_nitrogen_out_of_vegetation_and_litter_and_soil': {'canonical_units': 'kg '
                                                                                                                                   'm-2 '
                                                                                                                                   's-1'},
 'surface_upward_mass_flux_of_nitrous_oxide_expressed_as_nitrogen_out_of_vegetation_and_litter_and_soil': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'surface_upward_mass_flux_of_nox_expressed_as_nitrogen_out_of_vegetation_and_litter_and_soil': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'surface_upward_mole_flux_of_carbon_dioxide': {'canonical_units': 'mol m-2 '
                                                                   's-1'},
 'surface_upward_mole_flux_of_dimethyl_sulfide': {'canonical_units': 'mol m-2 '
                                                                     's-1'},
 'surface_upward_northward_stress_due_to_sea_surface_waves': {'canonical_units': 'Pa'},
 'surface_upward_sensible_heat_flux': {'canonical_units': 'W m-2'},
 'surface_upward_sensible_heat_flux_where_sea': {'canonical_units': 'W m-2'},
 'surface_upward_water_flux': {'canonical_units': 'kg m-2 s-1'},
 'surface_upward_water_vapor_flux_in_air': {'canonical_units': 'kg m-2 s-1'},
 'surface_upwelling_longwave_flux': {'canonical_units': 'W m-2'},
 'surface_upwelling_longwave_flux_assuming_clear_sky': {'canonical_units': 'W '
                                                                           'm-2'},
 'surface_upwelling_longwave_flux_in_air': {'canonical_units': 'W m-2'},
 'surface_upwelling_longwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                                  'm-2'},
 'surface_upwelling_photosynthetic_photon_flux_in_air': {'canonical_units': 'mol '
                                                                            'm-2 '
                                                                            's-1'},
 'surface_upwelling_radiance_in_air': {'canonical_units': 'W m-2 sr-1'},
 'surface_upwelling_radiance_in_air_emerging_from_sea_water': {'canonical_units': 'W '
                                                                                  'm-2 '
                                                                                  'sr-1'},
 'surface_upwelling_radiance_in_air_reflected_by_sea_water': {'canonical_units': 'W '
                                                                                 'm-2 '
                                                                                 'sr-1'},
 'surface_upwelling_radiance_in_sea_water': {'canonical_units': 'W m-2 sr-1'},
 'surface_upwelling_radiance_per_unit_wavelength_in_air': {'canonical_units': 'W '
                                                                              'm-2 '
                                                                              'm-1 '
                                                                              'sr-1'},
 'surface_upwelling_radiance_per_unit_wavelength_in_air_emerging_from_sea_water': {'canonical_units': 'W '
                                                                                                      'm-2 '
                                                                                                      'm-1 '
                                                                                                      'sr-1'},
 'surface_upwelling_radiance_per_unit_wavelength_in_air_reflected_by_sea_water': {'canonical_units': 'W '
                                                                                                     'm-2 '
                                                                                                     'm-1 '
                                                                                                     'sr-1'},
 'surface_upwelling_radiance_per_unit_wavelength_in_sea_water': {'canonical_units': 'W '
                                                                                    'm-2 '
                                                                                    'm-1 '
                                                                                    'sr-1'},
 'surface_upwelling_radiative_flux_per_unit_wavelength_in_air': {'canonical_units': 'W '
                                                                                    'm-2 '
                                                                                    'm-1'},
 'surface_upwelling_radiative_flux_per_unit_wavelength_in_sea_water': {'canonical_units': 'W '
                                                                                          'm-2 '
                                                                                          'm-1'},
 'surface_upwelling_shortwave_flux': {'canonical_units': 'W m-2'},
 'surface_upwelling_shortwave_flux_assuming_clear_sky': {'canonical_units': 'W '
                                                                            'm-2'},
 'surface_upwelling_shortwave_flux_in_air': {'canonical_units': 'W m-2'},
 'surface_upwelling_shortwave_flux_in_air_assuming_clean_clear_sky': {'canonical_units': 'W '
                                                                                         'm-2'},
 'surface_upwelling_shortwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                                   'm-2'},
 'surface_upwelling_shortwave_flux_in_air_assuming_clear_sky_and_no_aerosol': {'canonical_units': 'W '
                                                                                                  'm-2'},
 'surface_upwelling_spectral_radiance_in_air': {'canonical_units': 'W m-2 m-1 '
                                                                   'sr-1'},
 'surface_upwelling_spectral_radiance_in_air_emerging_from_sea_water': {'canonical_units': 'W '
                                                                                           'm-2 '
                                                                                           'm-1 '
                                                                                           'sr-1'},
 'surface_upwelling_spectral_radiance_in_air_reflected_by_sea_water': {'canonical_units': 'W '
                                                                                          'm-2 '
                                                                                          'm-1 '
                                                                                          'sr-1'},
 'surface_upwelling_spectral_radiance_in_sea_water': {'canonical_units': 'W '
                                                                         'm-2 '
                                                                         'm-1 '
                                                                         'sr-1'},
 'surface_upwelling_spectral_radiative_flux_in_air': {'canonical_units': 'W '
                                                                         'm-2 '
                                                                         'm-1'},
 'surface_upwelling_spectral_radiative_flux_in_sea_water': {'canonical_units': 'W '
                                                                               'm-2 '
                                                                               'm-1'},
 'surface_water_amount': {'canonical_units': 'kg m-2'},
 'surface_water_evaporation_flux': {'canonical_units': 'kg m-2 s-1'},
 'swell_wave_period': {'canonical_units': 's'},
 'syntax_test_quality_flag': {'canonical_units': '1'},
 'temperature_at_base_of_ice_sheet_model': {'canonical_units': 'K'},
 'temperature_at_top_of_ice_sheet_model': {'canonical_units': 'K'},
 'temperature_difference_between_ambient_air_and_air_lifted_adiabatically': {'canonical_units': 'K'},
 'temperature_difference_between_ambient_air_and_air_lifted_adiabatically_from_the_surface': {'canonical_units': 'K'},
 'temperature_flux_due_to_evaporation_expressed_as_heat_flux_out_of_sea_water': {'canonical_units': 'W '
                                                                                                    'm-2'},
 'temperature_flux_due_to_rainfall_expressed_as_heat_flux_into_sea_water': {'canonical_units': 'W '
                                                                                               'm-2'},
 'temperature_flux_due_to_runoff_expressed_as_heat_flux_into_sea_water': {'canonical_units': 'W '
                                                                                             'm-2'},
 'temperature_in_ground': {'canonical_units': 'K'},
 'temperature_in_surface_snow': {'canonical_units': 'K'},
 'temperature_of_analysis_of_sea_water': {'canonical_units': 'K'},
 'temperature_of_sensor_for_oxygen_in_sea_water': {'canonical_units': 'K'},
 'tendency_of_air_density': {'canonical_units': 'kg m-3 s-1'},
 'tendency_of_air_pressure': {'canonical_units': 'Pa s-1'},
 'tendency_of_air_temperature': {'canonical_units': 'K s-1'},
 'tendency_of_air_temperature_due_to_advection': {'canonical_units': 'K s-1'},
 'tendency_of_air_temperature_due_to_boundary_layer_mixing': {'canonical_units': 'K '
                                                                                 's-1'},
 'tendency_of_air_temperature_due_to_convection': {'canonical_units': 'K s-1'},
 'tendency_of_air_temperature_due_to_diabatic_processes': {'canonical_units': 'K '
                                                                              's-1'},
 'tendency_of_air_temperature_due_to_diffusion': {'canonical_units': 'K s-1'},
 'tendency_of_air_temperature_due_to_dissipation_of_nonorographic_gravity_waves': {'canonical_units': 'K '
                                                                                                      's-1'},
 'tendency_of_air_temperature_due_to_dissipation_of_orographic_gravity_waves': {'canonical_units': 'K '
                                                                                                   's-1'},
 'tendency_of_air_temperature_due_to_dry_convection': {'canonical_units': 'K '
                                                                          's-1'},
 'tendency_of_air_temperature_due_to_large_scale_precipitation': {'canonical_units': 'K '
                                                                                     's-1'},
 'tendency_of_air_temperature_due_to_longwave_heating': {'canonical_units': 'K '
                                                                            's-1'},
 'tendency_of_air_temperature_due_to_longwave_heating_assuming_clear_sky': {'canonical_units': 'K '
                                                                                               's-1'},
 'tendency_of_air_temperature_due_to_longwave_heating_from_volcanic_ambient_aerosol_particles': {'canonical_units': 'K '
                                                                                                                    's-1'},
 'tendency_of_air_temperature_due_to_model_physics': {'canonical_units': 'K '
                                                                         's-1'},
 'tendency_of_air_temperature_due_to_moist_convection': {'canonical_units': 'K '
                                                                            's-1'},
 'tendency_of_air_temperature_due_to_radiative_heating': {'canonical_units': 'K '
                                                                             's-1'},
 'tendency_of_air_temperature_due_to_shortwave_heating': {'canonical_units': 'K '
                                                                             's-1'},
 'tendency_of_air_temperature_due_to_shortwave_heating_assuming_clear_sky': {'canonical_units': 'K '
                                                                                                's-1'},
 'tendency_of_air_temperature_due_to_shortwave_heating_from_volcanic_ambient_aerosol_particles': {'canonical_units': 'K '
                                                                                                                     's-1'},
 'tendency_of_air_temperature_due_to_stratiform_cloud_and_precipitation': {'canonical_units': 'K '
                                                                                              's-1'},
 'tendency_of_air_temperature_due_to_stratiform_cloud_and_precipitation_and_boundary_layer_mixing': {'canonical_units': 'K '
                                                                                                                        's-1'},
 'tendency_of_air_temperature_due_to_stratiform_precipitation': {'canonical_units': 'K '
                                                                                    's-1'},
 'tendency_of_air_temperature_due_to_turbulence': {'canonical_units': 'K s-1'},
 'tendency_of_atmosphere_dry_energy_content': {'canonical_units': 'W m-2'},
 'tendency_of_atmosphere_enthalpy_content_due_to_advection': {'canonical_units': 'W '
                                                                                 'm-2'},
 'tendency_of_atmosphere_kinetic_energy_content_due_to_advection': {'canonical_units': 'W '
                                                                                       'm-2'},
 'tendency_of_atmosphere_mass_content_of_acetaldehyde_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_acetaldehyde_due_to_emission': {'canonical_units': 'kg '
                                                                                            'm-2 '
                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_acetaldehyde_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_acetic_acid_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                 'm-2 '
                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_acetic_acid_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                 'm-2 '
                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_aceto_nitrile_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                   'm-2 '
                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_acetone_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_alcohols_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_alcohols_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_alcohols_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_alcohols_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_alcohols_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_alcohols_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                   'm-2 '
                                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_alcohols_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_alcohols_due_to_emission_from_solvent_production_and_use': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_alcohols_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_aldehydes_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                               'm-2 '
                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_aldehydes_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                               'm-2 '
                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_alkanes_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_alkenes_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_alpha_hexachlorocyclohexane_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                 'm-2 '
                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_alpha_hexachlorocyclohexane_due_to_emission': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_alpha_hexachlorocyclohexane_due_to_re_emission': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_alpha_hexachlorocyclohexane_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                 'm-2 '
                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_alpha_pinene_due_to_emission': {'canonical_units': 'kg '
                                                                                            'm-2 '
                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                             'm-2 '
                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonia_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                             'm-2 '
                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonium_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonium_dry_aerosol_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonium_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_ammonium_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_aromatic_compounds_due_to_emission': {'canonical_units': 'kg '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_benzene_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_benzene_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_benzene_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_benzene_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_benzene_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_benzene_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_benzene_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_benzene_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_benzene_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_benzene_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_beta_pinene_due_to_emission': {'canonical_units': 'kg '
                                                                                           'm-2 '
                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_biogenic_nmvoc_expressed_as_carbon_due_to_emission': {'canonical_units': 'kg '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_emission': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                                        'm-2 '
                                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                                'm-2 '
                                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                                 'm-2 '
                                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                                   'm-2 '
                                                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                         'm-2 '
                                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                                          'm-2 '
                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_black_carbon_dry_aerosol_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_butane_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_dioxide_due_to_emission': {'canonical_units': 'kg '
                                                                                              'm-2 '
                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_dioxide_expressed_as_carbon_due_to_anthropogenic_emission': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_forestry_and_agricultural_products': {'canonical_units': 'kg '
                                                                                                                                                          'm-2 '
                                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_dioxide_expressed_as_carbon_due_to_emission_from_fossil_fuel_combustion': {'canonical_units': 'kg '
                                                                                                                                              'm-2 '
                                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                     'm-2 '
                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission': {'canonical_units': 'kg '
                                                                                               'm-2 '
                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                       'm-2 '
                                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                 'm-2 '
                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                        'm-2 '
                                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                          'm-2 '
                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_solvent_production_and_use': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_monoxide_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_carbon_tetrachloride_due_to_emission': {'canonical_units': 'kg '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_cfc113_due_to_emission': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_cfc113a_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_cfc114_due_to_emission': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_cfc115_due_to_emission': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_cfc11_due_to_emission': {'canonical_units': 'kg '
                                                                                     'm-2 '
                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_cfc12_due_to_emission': {'canonical_units': 'kg '
                                                                                     'm-2 '
                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_chlorinated_hydrocarbons_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_chlorinated_hydrocarbons_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_chlorinated_hydrocarbons_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                         'm-2 '
                                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_chlorinated_hydrocarbons_due_to_emission_from_solvent_production_and_use': {'canonical_units': 'kg '
                                                                                                                                        'm-2 '
                                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_chlorinated_hydrocarbons_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                                          'm-2 '
                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_dimethyl_sulfide_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_dimethyl_sulfide_due_to_emission': {'canonical_units': 'kg '
                                                                                                'm-2 '
                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_dimethyl_sulfide_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_dimethyl_sulfide_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_dimethyl_sulfide_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_due_to_emission': {'canonical_units': 'kg '
                                                                                                'm-2 '
                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                            'm-2 '
                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_deposition': {'canonical_units': 'kg '
                                                                                                            'm-2 '
                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                                                      'm-2 '
                                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                                              'm-2 '
                                                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                                        'm-2 '
                                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                                               'm-2 '
                                                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                                                          'm-2 '
                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                                                              'm-2 '
                                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                                                 'm-2 '
                                                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                                       'm-2 '
                                                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                                                        'm-2 '
                                                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                                    'm-2 '
                                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_esters_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_esters_due_to_emission_from_solvent_production_and_use': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_esters_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_ethane_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_ethanol_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_ethene_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_ethers_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_ethers_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_ethers_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_ethers_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_ethers_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_ethers_due_to_emission_from_solvent_production_and_use': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_ethers_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_ethyne_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_emission': {'canonical_units': 'kg '
                                                                                            'm-2 '
                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                    'm-2 '
                                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                     'm-2 '
                                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                       'm-2 '
                                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                             'm-2 '
                                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_formaldehyde_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_formic_acid_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                 'm-2 '
                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_formic_acid_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                 'm-2 '
                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_gaseous_divalent_mercury_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_gaseous_divalent_mercury_due_to_emission': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_gaseous_divalent_mercury_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_gaseous_elemental_mercury_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_gaseous_elemental_mercury_due_to_emission': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_gaseous_elemental_mercury_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_halon1202_due_to_emission': {'canonical_units': 'kg '
                                                                                         'm-2 '
                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_halon1211_due_to_emission': {'canonical_units': 'kg '
                                                                                         'm-2 '
                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_halon1301_due_to_emission': {'canonical_units': 'kg '
                                                                                         'm-2 '
                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_halon2402_due_to_emission': {'canonical_units': 'kg '
                                                                                         'm-2 '
                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_hcc140a_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_hcfc141b_due_to_emission': {'canonical_units': 'kg '
                                                                                        'm-2 '
                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_hcfc142b_due_to_emission': {'canonical_units': 'kg '
                                                                                        'm-2 '
                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_hcfc22_due_to_emission': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_hexachlorobiphenyl_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_hexachlorobiphenyl_due_to_emission': {'canonical_units': 'kg '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_hexachlorobiphenyl_due_to_re_emission': {'canonical_units': 'kg '
                                                                                                     'm-2 '
                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_hexachlorobiphenyl_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_hydrogen_cyanide_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_hydrogen_cyanide_due_to_emission': {'canonical_units': 'kg '
                                                                                                'm-2 '
                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_hydrogen_peroxide_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                       'm-2 '
                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_hydrogen_peroxide_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                       'm-2 '
                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_insoluble_dust_dry_aerosol_particles_due_to_deposition': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_isoprene_due_to_emission': {'canonical_units': 'kg '
                                                                                        'm-2 '
                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_isoprene_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_isoprene_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_ketones_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_ketones_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_ketones_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_ketones_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_ketones_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_ketones_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_ketones_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_ketones_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_ketones_due_to_emission_from_solvent_production_and_use': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_ketones_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_limonene_due_to_emission': {'canonical_units': 'kg '
                                                                                        'm-2 '
                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_mercury_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_mercury_dry_aerosol_due_to_emission': {'canonical_units': 'kg '
                                                                                                   'm-2 '
                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_mercury_dry_aerosol_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_mercury_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_mercury_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                             'm-2 '
                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_mercury_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_methane_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_methanesulfonic_acid_dry_aerosol_particles_due_to_net_chemical_production': {'canonical_units': 'kg '
                                                                                                                                         'm-2 '
                                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_methanesulfonic_acid_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_methanesulfonic_acid_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_methanol_due_to_emission': {'canonical_units': 'kg '
                                                                                        'm-2 '
                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_methyl_bromide_due_to_emission': {'canonical_units': 'kg '
                                                                                              'm-2 '
                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_methyl_chloride_due_to_emission': {'canonical_units': 'kg '
                                                                                               'm-2 '
                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_molecular_hydrogen_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_molecular_hydrogen_due_to_emission': {'canonical_units': 'kg '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_molecular_hydrogen_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_molecular_hydrogen_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                   'm-2 '
                                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_monoterpenes_due_to_emission': {'canonical_units': 'kg '
                                                                                            'm-2 '
                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrate_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrate_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrate_dry_aerosol_particles_due_to_net_chemical_production': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrate_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_nitric_acid_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                 'm-2 '
                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_nitric_acid_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                 'm-2 '
                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_compounds_expressed_as_nitrogen_due_to_anthropogenic_emission': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_compounds_expressed_as_nitrogen_due_to_anthropogenic_land_use_or_land_cover_change': {'canonical_units': 'kg '
                                                                                                                                                           'm-2 '
                                                                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_compounds_expressed_as_nitrogen_due_to_deposition': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_compounds_expressed_as_nitrogen_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_compounds_expressed_as_nitrogen_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_dioxide_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_dioxide_due_to_emission': {'canonical_units': 'kg '
                                                                                                'm-2 '
                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_dioxide_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_dioxide_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_due_to_deposition': {'canonical_units': 'kg '
                                                                                          'm-2 '
                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                              'm-2 '
                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                              'm-2 '
                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission': {'canonical_units': 'kg '
                                                                                                 'm-2 '
                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                         'm-2 '
                                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                          'm-2 '
                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                            'm-2 '
                                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrogen_monoxide_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                                   'm-2 '
                                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrous_acid_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrous_acid_due_to_emission': {'canonical_units': 'kg '
                                                                                            'm-2 '
                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrous_acid_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrous_oxide_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                   'm-2 '
                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_nitrous_oxide_due_to_emission': {'canonical_units': 'kg '
                                                                                             'm-2 '
                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission': {'canonical_units': 'kg '
                                                                                     'm-2 '
                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                             'm-2 '
                                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                       'm-2 '
                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                             'm-2 '
                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_solvent_production_and_use': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_nmvoc_expressed_as_carbon_due_to_emission': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_due_to_emission': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                                               'm-2 '
                                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                                                  'm-2 '
                                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                                          'm-2 '
                                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                                    'm-2 '
                                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                                           'm-2 '
                                                                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                                                          'm-2 '
                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                                             'm-2 '
                                                                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                                   'm-2 '
                                                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_soil': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_nox_expressed_as_nitrogen_monoxide_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                                                    'm-2 '
                                                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_noy_expressed_as_nitrogen_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_noy_expressed_as_nitrogen_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_acids_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_acids_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                             'm-2 '
                                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_acids_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                     'm-2 '
                                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_acids_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_acids_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_acids_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                        'm-2 '
                                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_acids_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_acids_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_nitrates_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_nitrates_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_peroxides_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                       'm-2 '
                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_organic_peroxides_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                       'm-2 '
                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_oxidized_nitrogen_compounds_expressed_as_nitrogen_due_to_deposition': {'canonical_units': 'kg '
                                                                                                                                   'm-2 '
                                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_oxidized_nitrogen_compounds_expressed_as_nitrogen_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                       'm-2 '
                                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_oxidized_nitrogen_compounds_expressed_as_nitrogen_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                       'm-2 '
                                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_ozone_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                           'm-2 '
                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_ozone_due_to_dry_deposition_into_stomata': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                                    'm-2 '
                                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_due_to_net_chemical_production_and_emission': {'canonical_units': 'kg '
                                                                                                                                                  'm-2 '
                                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_due_to_net_production_and_emission': {'canonical_units': 'kg '
                                                                                                                                         'm-2 '
                                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_expressed_as_carbon_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                                                                          'm-2 '
                                                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_expressed_as_carbon_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                                                                  'm-2 '
                                                                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_expressed_as_carbon_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                                                            'm-2 '
                                                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_expressed_as_carbon_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                                                                   'm-2 '
                                                                                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_expressed_as_carbon_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                                                                              'm-2 '
                                                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_expressed_as_carbon_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                                                                                  'm-2 '
                                                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_expressed_as_carbon_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                                                                     'm-2 '
                                                                                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_expressed_as_carbon_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                                                           'm-2 '
                                                                                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_expressed_as_carbon_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                                                                            'm-2 '
                                                                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                                              'm-2 '
                                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_due_to_net_chemical_production_and_emission': {'canonical_units': 'kg '
                                                                                                                                                            'm-2 '
                                                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                                                            'm-2 '
                                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                                          'm-2 '
                                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_emission': {'canonical_units': 'kg '
                                                                                                                                                    'm-2 '
                                                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                                                                                    'm-2 '
                                                                                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                                                                            'm-2 '
                                                                                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                                                                      'm-2 '
                                                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                                                                             'm-2 '
                                                                                                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                                                                                        'm-2 '
                                                                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                                                                                            'm-2 '
                                                                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                                                                               'm-2 '
                                                                                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                                                                                     'm-2 '
                                                                                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                                                                                      'm-2 '
                                                                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                                          'm-2 '
                                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_pentane_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_pentane_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_pentane_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_pentane_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_pentane_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_pentane_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_pentane_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_pentane_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_pentane_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_peroxyacetyl_nitrate_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_peroxynitric_acid_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                       'm-2 '
                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_dust_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_dust_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_dust_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_sea_salt_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_sea_salt_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_sea_salt_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_seasalt_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_seasalt_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_pm10_seasalt_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                 'm-2 '
                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                 'm-2 '
                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_dust_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_dust_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_dust_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_sea_salt_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_sea_salt_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_sea_salt_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_seasalt_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_seasalt_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_pm2p5_seasalt_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_primary_particulate_organic_matter_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                    'm-2 '
                                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_primary_particulate_organic_matter_dry_aerosol_due_to_emission': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_primary_particulate_organic_matter_dry_aerosol_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                    'm-2 '
                                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_primary_particulate_organic_matter_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                              'm-2 '
                                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_primary_particulate_organic_matter_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                                                        'm-2 '
                                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_primary_particulate_organic_matter_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                              'm-2 '
                                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_propane_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_propene_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_radon_due_to_emission': {'canonical_units': 'kg '
                                                                                     'm-2 '
                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_reduced_nitrogen_compounds_expressed_as_nitrogen_due_to_deposition': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_reduced_nitrogen_compounds_expressed_as_nitrogen_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_reduced_nitrogen_compounds_expressed_as_nitrogen_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_sea_salt_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_sea_salt_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_sea_salt_dry_aerosol_particles_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                            'm-2 '
                                                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_sea_salt_dry_aerosol_particles_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                                          'm-2 '
                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_sea_salt_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_seasalt_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_seasalt_dry_aerosol_due_to_emission': {'canonical_units': 'kg '
                                                                                                   'm-2 '
                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_seasalt_dry_aerosol_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                 'm-2 '
                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_seasalt_dry_aerosol_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_seasalt_dry_aerosol_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_seasalt_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_seasalt_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                             'm-2 '
                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_seasalt_dry_aerosol_particles_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                           'm-2 '
                                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_seasalt_dry_aerosol_particles_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_seasalt_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol_due_to_net_chemical_production': {'canonical_units': 'kg '
                                                                                                                                               'm-2 '
                                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol_due_to_net_production': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                                'm-2 '
                                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                                                          'm-2 '
                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol_particles_due_to_net_chemical_production': {'canonical_units': 'kg '
                                                                                                                                                         'm-2 '
                                                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                                'm-2 '
                                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_sesquiterpenes_due_to_emission': {'canonical_units': 'kg '
                                                                                              'm-2 '
                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_due_to_emission': {'canonical_units': 'kg '
                                                                                                   'm-2 '
                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_expressed_as_sulfur_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                             'm-2 '
                                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_expressed_as_sulfur_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                                     'm-2 '
                                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_expressed_as_sulfur_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                                                   'm-2 '
                                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_expressed_as_sulfur_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                             'm-2 '
                                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_due_to_aqueous_phase_net_chemical_production': {'canonical_units': 'kg '
                                                                                                                                          'm-2 '
                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_due_to_emission': {'canonical_units': 'kg '
                                                                                                             'm-2 '
                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_due_to_gaseous_phase_net_chemical_production': {'canonical_units': 'kg '
                                                                                                                                          'm-2 '
                                                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_expressed_as_sulfur_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                                       'm-2 '
                                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_expressed_as_sulfur_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                                               'm-2 '
                                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_expressed_as_sulfur_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                                                             'm-2 '
                                                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_dry_aerosol_particles_expressed_as_sulfur_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                                       'm-2 '
                                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_expressed_as_sulfur_dry_aerosol_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                                             'm-2 '
                                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_expressed_as_sulfur_dry_aerosol_due_to_gravitational_settling': {'canonical_units': 'kg '
                                                                                                                                     'm-2 '
                                                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_expressed_as_sulfur_dry_aerosol_due_to_turbulent_deposition': {'canonical_units': 'kg '
                                                                                                                                   'm-2 '
                                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfate_expressed_as_sulfur_dry_aerosol_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                                             'm-2 '
                                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_dry_deposition': {'canonical_units': 'kg '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_emission': {'canonical_units': 'kg '
                                                                                              'm-2 '
                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                      'm-2 '
                                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                       'm-2 '
                                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                         'm-2 '
                                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_sulfur_dioxide_due_to_wet_deposition': {'canonical_units': 'kg '
                                                                                                    'm-2 '
                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_terpenes_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_terpenes_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                    'm-2 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                         'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                                'm-2 '
                                                                                                                                's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_solvent_production_and_use': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_toluene_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                         'm-2 '
                                                                                                                         's-1'},
 'tendency_of_atmosphere_mass_content_of_trimethylbenzene_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                                        'm-2 '
                                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_water_due_to_advection': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_water_vapor': {'canonical_units': 'kg '
                                                                           'm-2 '
                                                                           's-1'},
 'tendency_of_atmosphere_mass_content_of_water_vapor_due_to_advection': {'canonical_units': 'kg '
                                                                                            'm-2 '
                                                                                            's-1'},
 'tendency_of_atmosphere_mass_content_of_water_vapor_due_to_convection': {'canonical_units': 'kg '
                                                                                             'm-2 '
                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_water_vapor_due_to_deep_convection': {'canonical_units': 'kg '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_atmosphere_mass_content_of_water_vapor_due_to_shallow_convection': {'canonical_units': 'kg '
                                                                                                     'm-2 '
                                                                                                     's-1'},
 'tendency_of_atmosphere_mass_content_of_water_vapor_due_to_sublimation_of_surface_ice': {'canonical_units': 'kg '
                                                                                                             'm-2 '
                                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_water_vapor_due_to_sublimation_of_surface_snow': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_water_vapor_due_to_sublimation_of_surface_snow_and_ice': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_water_vapor_due_to_turbulence': {'canonical_units': 'kg '
                                                                                             'm-2 '
                                                                                             's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_agricultural_production': {'canonical_units': 'kg '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_agricultural_waste_burning': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_energy_production_and_distribution': {'canonical_units': 'kg '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_forest_fires': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_industrial_processes_and_combustion': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_land_transport': {'canonical_units': 'kg '
                                                                                                          'm-2 '
                                                                                                          's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_maritime_transport': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_residential_and_commercial_combustion': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_savanna_and_grassland_fires': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_solvent_production_and_use': {'canonical_units': 'kg '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_atmosphere_mass_content_of_xylene_due_to_emission_from_waste_treatment_and_disposal': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_atmosphere_mass_per_unit_area': {'canonical_units': 'kg m-2 s-1'},
 'tendency_of_atmosphere_mass_per_unit_area_due_to_advection': {'canonical_units': 'kg '
                                                                                   'm-2 '
                                                                                   's-1'},
 'tendency_of_atmosphere_mole_concentration_of_carbon_monoxide_due_to_chemical_destruction': {'canonical_units': 'mol '
                                                                                                                 'm-3 '
                                                                                                                 's-1'},
 'tendency_of_atmosphere_mole_concentration_of_methane_due_to_chemical_destruction': {'canonical_units': 'mol '
                                                                                                         'm-3 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_mole_concentration_of_nitrous_oxide_due_to_chemical_destruction': {'canonical_units': 'mol '
                                                                                                               'm-3 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_mole_concentration_of_ozone_due_to_chemical_destruction': {'canonical_units': 'mol '
                                                                                                       'm-3 '
                                                                                                       's-1'},
 'tendency_of_atmosphere_mole_concentration_of_ozone_due_to_chemical_production': {'canonical_units': 'mol '
                                                                                                      'm-3 '
                                                                                                      's-1'},
 'tendency_of_atmosphere_moles_of_acetic_acid': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_aceto_nitrile': {'canonical_units': 'mol '
                                                                      's-1'},
 'tendency_of_atmosphere_moles_of_alpha_hexachlorocyclohexane': {'canonical_units': 'mol '
                                                                                    's-1'},
 'tendency_of_atmosphere_moles_of_alpha_pinene': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_ammonia': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_anthropogenic_nmvoc_expressed_as_carbon': {'canonical_units': 'mol '
                                                                                                's-1'},
 'tendency_of_atmosphere_moles_of_atomic_bromine': {'canonical_units': 'mol '
                                                                       's-1'},
 'tendency_of_atmosphere_moles_of_atomic_chlorine': {'canonical_units': 'mol '
                                                                        's-1'},
 'tendency_of_atmosphere_moles_of_atomic_nitrogen': {'canonical_units': 'mol '
                                                                        's-1'},
 'tendency_of_atmosphere_moles_of_benzene': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_beta_pinene': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_biogenic_nmvoc_expressed_as_carbon': {'canonical_units': 'mol '
                                                                                           's-1'},
 'tendency_of_atmosphere_moles_of_bromine_chloride': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_bromine_monoxide': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_bromine_nitrate': {'canonical_units': 'mol '
                                                                        's-1'},
 'tendency_of_atmosphere_moles_of_brox_expressed_as_bromine': {'canonical_units': 'mol '
                                                                                  's-1'},
 'tendency_of_atmosphere_moles_of_butane': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_carbon_dioxide': {'canonical_units': 'mol '
                                                                       's-1'},
 'tendency_of_atmosphere_moles_of_carbon_monoxide': {'canonical_units': 'mol '
                                                                        's-1'},
 'tendency_of_atmosphere_moles_of_carbon_tetrachloride': {'canonical_units': 'mol '
                                                                             's-1'},
 'tendency_of_atmosphere_moles_of_cfc11': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_cfc113': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_cfc113a': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_cfc114': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_cfc115': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_cfc12': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_chlorine_dioxide': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_chlorine_monoxide': {'canonical_units': 'mol '
                                                                          's-1'},
 'tendency_of_atmosphere_moles_of_chlorine_nitrate': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_clox_expressed_as_chlorine': {'canonical_units': 'mol '
                                                                                   's-1'},
 'tendency_of_atmosphere_moles_of_dichlorine_peroxide': {'canonical_units': 'mol '
                                                                            's-1'},
 'tendency_of_atmosphere_moles_of_dimethyl_sulfide': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_dinitrogen_pentoxide': {'canonical_units': 'mol '
                                                                             's-1'},
 'tendency_of_atmosphere_moles_of_ethane': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_ethanol': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_ethene': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_ethyne': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_formaldehyde': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_formic_acid': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_gaseous_divalent_mercury': {'canonical_units': 'mol '
                                                                                 's-1'},
 'tendency_of_atmosphere_moles_of_gaseous_elemental_mercury': {'canonical_units': 'mol '
                                                                                  's-1'},
 'tendency_of_atmosphere_moles_of_halon1202': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_halon1211': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_halon1301': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_halon2402': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_hcc140a': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_hcfc141b': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_hcfc142b': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_hcfc22': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_hexachlorobiphenyl': {'canonical_units': 'mol '
                                                                           's-1'},
 'tendency_of_atmosphere_moles_of_hox_expressed_as_hydrogen': {'canonical_units': 'mol '
                                                                                  's-1'},
 'tendency_of_atmosphere_moles_of_hydrogen_bromide': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_hydrogen_chloride': {'canonical_units': 'mol '
                                                                          's-1'},
 'tendency_of_atmosphere_moles_of_hydrogen_cyanide': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_hydrogen_peroxide': {'canonical_units': 'mol '
                                                                          's-1'},
 'tendency_of_atmosphere_moles_of_hydroperoxyl_radical': {'canonical_units': 'mol '
                                                                             's-1'},
 'tendency_of_atmosphere_moles_of_hydroxyl_radical': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_hypobromous_acid': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_hypochlorous_acid': {'canonical_units': 'mol '
                                                                          's-1'},
 'tendency_of_atmosphere_moles_of_inorganic_bromine': {'canonical_units': 'mol '
                                                                          's-1'},
 'tendency_of_atmosphere_moles_of_inorganic_chlorine': {'canonical_units': 'mol '
                                                                           's-1'},
 'tendency_of_atmosphere_moles_of_isoprene': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_limonene': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_methane': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_methanol': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_methyl_bromide': {'canonical_units': 'mol '
                                                                       's-1'},
 'tendency_of_atmosphere_moles_of_methyl_chloride': {'canonical_units': 'mol '
                                                                        's-1'},
 'tendency_of_atmosphere_moles_of_methyl_hydroperoxide': {'canonical_units': 'mol '
                                                                             's-1'},
 'tendency_of_atmosphere_moles_of_methyl_peroxy_radical': {'canonical_units': 'mol '
                                                                              's-1'},
 'tendency_of_atmosphere_moles_of_molecular_hydrogen': {'canonical_units': 'mol '
                                                                           's-1'},
 'tendency_of_atmosphere_moles_of_nitrate_radical': {'canonical_units': 'mol '
                                                                        's-1'},
 'tendency_of_atmosphere_moles_of_nitric_acid': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_nitric_acid_trihydrate_ambient_aerosol': {'canonical_units': 'mol '
                                                                                               's-1'},
 'tendency_of_atmosphere_moles_of_nitric_acid_trihydrate_ambient_aerosol_particles': {'canonical_units': 'mol '
                                                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_nitrogen_dioxide': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_atmosphere_moles_of_nitrogen_monoxide': {'canonical_units': 'mol '
                                                                          's-1'},
 'tendency_of_atmosphere_moles_of_nitrous_acid': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_nitrous_oxide': {'canonical_units': 'mol '
                                                                      's-1'},
 'tendency_of_atmosphere_moles_of_nmvoc_expressed_as_carbon': {'canonical_units': 'mol '
                                                                                  's-1'},
 'tendency_of_atmosphere_moles_of_nox_expressed_as_nitrogen': {'canonical_units': 'mol '
                                                                                  's-1'},
 'tendency_of_atmosphere_moles_of_noy_expressed_as_nitrogen': {'canonical_units': 'mol '
                                                                                  's-1'},
 'tendency_of_atmosphere_moles_of_ozone': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_peroxyacetyl_nitrate': {'canonical_units': 'mol '
                                                                             's-1'},
 'tendency_of_atmosphere_moles_of_peroxynitric_acid': {'canonical_units': 'mol '
                                                                          's-1'},
 'tendency_of_atmosphere_moles_of_propane': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_propene': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_radon': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_sulfate_dry_aerosol': {'canonical_units': 'mol '
                                                                            's-1'},
 'tendency_of_atmosphere_moles_of_sulfate_dry_aerosol_particles': {'canonical_units': 'mol '
                                                                                      's-1'},
 'tendency_of_atmosphere_moles_of_sulfur_dioxide': {'canonical_units': 'mol '
                                                                       's-1'},
 'tendency_of_atmosphere_moles_of_toluene': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_water_vapor': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_moles_of_xylene': {'canonical_units': 'mol s-1'},
 'tendency_of_atmosphere_number_content_of_aerosol_particles_due_to_dry_deposition': {'canonical_units': 'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_number_content_of_aerosol_particles_due_to_gravitational_settling': {'canonical_units': 'm-2 '
                                                                                                                 's-1'},
 'tendency_of_atmosphere_number_content_of_aerosol_particles_due_to_turbulent_deposition': {'canonical_units': 'm-2 '
                                                                                                               's-1'},
 'tendency_of_atmosphere_number_content_of_aerosol_particles_due_to_turbulent_depostion': {'canonical_units': 'm-2 '
                                                                                                              's-1'},
 'tendency_of_atmosphere_number_content_of_aerosol_particles_due_to_wet_deposition': {'canonical_units': 'm-2 '
                                                                                                         's-1'},
 'tendency_of_atmosphere_of_mole_concentration_of_carbon_monoxide_due_to_chemical_destruction': {'canonical_units': 'mol '
                                                                                                                    'm-3 '
                                                                                                                    's-1'},
 'tendency_of_atmosphere_potential_energy_content_due_to_advection': {'canonical_units': 'W '
                                                                                         'm-2'},
 'tendency_of_atmosphere_water_content_due_to_advection': {'canonical_units': 'kg '
                                                                              'm-2 '
                                                                              's-1'},
 'tendency_of_atmosphere_water_vapor_content': {'canonical_units': 'kg m-2 '
                                                                   's-1'},
 'tendency_of_atmosphere_water_vapor_content_due_to_advection': {'canonical_units': 'kg '
                                                                                    'm-2 '
                                                                                    's-1'},
 'tendency_of_atmosphere_water_vapor_content_due_to_convection': {'canonical_units': 'kg '
                                                                                     'm-2 '
                                                                                     's-1'},
 'tendency_of_atmosphere_water_vapor_content_due_to_deep_convection': {'canonical_units': 'kg '
                                                                                          'm-2 '
                                                                                          's-1'},
 'tendency_of_atmosphere_water_vapor_content_due_to_shallow_convection': {'canonical_units': 'kg '
                                                                                             'm-2 '
                                                                                             's-1'},
 'tendency_of_atmosphere_water_vapor_content_due_to_turbulence': {'canonical_units': 'kg '
                                                                                     'm-2 '
                                                                                     's-1'},
 'tendency_of_bedrock_altitude': {'canonical_units': 'm s-1'},
 'tendency_of_canopy_water_amount_due_to_evaporation_of_intercepted_precipitation': {'canonical_units': 'kg '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_change_in_land_ice_amount': {'canonical_units': 'kg m-2 s-1'},
 'tendency_of_dry_energy_content_of_atmosphere_layer': {'canonical_units': 'W '
                                                                           'm-2'},
 'tendency_of_dry_static_energy_content_of_atmosphere_layer': {'canonical_units': 'W '
                                                                                  'm-2'},
 'tendency_of_eastward_wind': {'canonical_units': 'm s-2'},
 'tendency_of_eastward_wind_due_to_advection': {'canonical_units': 'm s-2'},
 'tendency_of_eastward_wind_due_to_advection_by_northward_transformed_eulerian_mean_air_velocity': {'canonical_units': 'm '
                                                                                                                       's-2'},
 'tendency_of_eastward_wind_due_to_advection_by_upward_transformed_eulerian_mean_air_velocity': {'canonical_units': 'm '
                                                                                                                    's-2'},
 'tendency_of_eastward_wind_due_to_convection': {'canonical_units': 'm s-2'},
 'tendency_of_eastward_wind_due_to_diffusion': {'canonical_units': 'm s-2'},
 'tendency_of_eastward_wind_due_to_eliassen_palm_flux_divergence': {'canonical_units': 'm '
                                                                                       's-2'},
 'tendency_of_eastward_wind_due_to_gravity_wave_drag': {'canonical_units': 'm '
                                                                           's-2'},
 'tendency_of_eastward_wind_due_to_nonorographic_gravity_wave_drag': {'canonical_units': 'm '
                                                                                         's-2'},
 'tendency_of_eastward_wind_due_to_numerical_artefacts': {'canonical_units': 'm '
                                                                             's-2'},
 'tendency_of_eastward_wind_due_to_orographic_gravity_wave_drag': {'canonical_units': 'm '
                                                                                      's-2'},
 'tendency_of_enthalpy_content_of_atmosphere_layer_due_to_advection': {'canonical_units': 'W '
                                                                                          'm-2'},
 'tendency_of_global_average_sea_level_change': {'canonical_units': 'm year-1'},
 'tendency_of_kinetic_energy_content_of_atmosphere_layer_due_to_advection': {'canonical_units': 'W '
                                                                                                'm-2'},
 'tendency_of_land_ice_mass': {'canonical_units': 'kg s-1'},
 'tendency_of_land_ice_mass_due_to_basal_mass_balance': {'canonical_units': 'kg '
                                                                            's-1'},
 'tendency_of_land_ice_mass_due_to_calving': {'canonical_units': 'kg s-1'},
 'tendency_of_land_ice_mass_due_to_surface_mass_balance': {'canonical_units': 'kg '
                                                                              's-1'},
 'tendency_of_land_ice_thickness': {'canonical_units': 'm s-1'},
 'tendency_of_mass_concentration_of_black_carbon_dry_aerosol_in_air_due_to_emission_from_aviation': {'canonical_units': 'kg '
                                                                                                                        'm-3 '
                                                                                                                        's-1'},
 'tendency_of_mass_concentration_of_elemental_carbon_dry_aerosol_particles_in_air_due_to_emission_from_aviation': {'canonical_units': 'kg '
                                                                                                                                      'm-3 '
                                                                                                                                      's-1'},
 'tendency_of_mass_concentration_of_nitrogen_dioxide_in_air_due_to_emission_from_aviation': {'canonical_units': 'kg '
                                                                                                                'm-3 '
                                                                                                                's-1'},
 'tendency_of_mass_concentration_of_nitrogen_monoxide_in_air_due_to_emission_from_aviation': {'canonical_units': 'kg '
                                                                                                                 'm-3 '
                                                                                                                 's-1'},
 'tendency_of_mass_concentration_of_nox_expressed_as_nitrogen_monoxide_in_air_due_to_emission_from_aviation': {'canonical_units': 'kg '
                                                                                                                                  'm-3 '
                                                                                                                                  's-1'},
 'tendency_of_mass_content_of_water_vapor_in_atmosphere_layer': {'canonical_units': 'kg '
                                                                                    'm-2 '
                                                                                    's-1'},
 'tendency_of_mass_content_of_water_vapor_in_atmosphere_layer_due_to_convection': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_mass_content_of_water_vapor_in_atmosphere_layer_due_to_deep_convection': {'canonical_units': 'kg '
                                                                                                           'm-2 '
                                                                                                           's-1'},
 'tendency_of_mass_content_of_water_vapor_in_atmosphere_layer_due_to_shallow_convection': {'canonical_units': 'kg '
                                                                                                              'm-2 '
                                                                                                              's-1'},
 'tendency_of_mass_content_of_water_vapor_in_atmosphere_layer_due_to_turbulence': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_mass_fraction_of_cloud_condensed_water_in_air': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_cloud_condensed_water_in_air_due_to_advection': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_cloud_ice_in_air': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_cloud_ice_in_air_due_to_advection': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_cloud_ice_in_air_due_to_diffusion': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_cloud_liquid_water_in_air': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_cloud_liquid_water_in_air_due_to_advection': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_cloud_liquid_water_in_air_due_to_diffusion': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_convective_cloud_ice_in_air': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_convective_cloud_liquid_water_in_air': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_condensed_water_in_air': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_condensed_water_in_air_due_to_advection': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_condensed_water_in_air_due_to_autoconversion_to_rain': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_condensed_water_in_air_due_to_autoconversion_to_snow': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_condensed_water_in_air_due_to_boundary_layer_mixing': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_condensed_water_in_air_due_to_cloud_microphysics': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_condensed_water_in_air_due_to_condensation_and_evaporation': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_condensed_water_in_air_due_to_icefall': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_accretion_to_snow': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_advection': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_aggregation': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_bergeron_findeisen_process_from_cloud_liquid': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_boundary_layer_mixing': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_cloud_microphysics': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_convective_detrainment': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_deposition_and_sublimation': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_evaporation_of_melting_ice': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_heterogeneous_nucleation_from_cloud_liquid': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_heterogeneous_nucleation_from_cloud_liquid_water': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_heterogeneous_nucleation_from_water_vapor': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_homogeneous_nucleation': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_icefall': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_melting_to_cloud_liquid': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_melting_to_cloud_liquid_water': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_melting_to_rain': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_riming_from_cloud_liquid': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_riming_from_cloud_liquid_water': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_ice_in_air_due_to_riming_from_rain': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_accretion_to_rain': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_accretion_to_snow': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_advection': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_autoconversion': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_bergeron_findeisen_process_to_cloud_ice': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_boundary_layer_mixing': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_cloud_microphysics': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_condensation_and_evaporation': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_condensation_and_evaporation_from_boundary_layer_mixing': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_condensation_and_evaporation_from_convection': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_condensation_and_evaporation_from_longwave_heating': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_condensation_and_evaporation_from_pressure_change': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_condensation_and_evaporation_from_shortwave_heating': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_condensation_and_evaporation_from_turbulence': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_convective_detrainment': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_heterogeneous_nucleation': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_homogeneous_nucleation': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_melting_from_cloud_ice': {'canonical_units': 's-1'},
 'tendency_of_mass_fraction_of_stratiform_cloud_liquid_water_in_air_due_to_riming': {'canonical_units': 's-1'},
 'tendency_of_middle_atmosphere_moles_of_carbon_monoxide': {'canonical_units': 'mol '
                                                                               's-1'},
 'tendency_of_middle_atmosphere_moles_of_hcc140a': {'canonical_units': 'mol '
                                                                       's-1'},
 'tendency_of_middle_atmosphere_moles_of_methane': {'canonical_units': 'mol '
                                                                       's-1'},
 'tendency_of_middle_atmosphere_moles_of_methyl_bromide': {'canonical_units': 'mol '
                                                                              's-1'},
 'tendency_of_middle_atmosphere_moles_of_methyl_chloride': {'canonical_units': 'mol '
                                                                               's-1'},
 'tendency_of_middle_atmosphere_moles_of_molecular_hydrogen': {'canonical_units': 'mol '
                                                                                  's-1'},
 'tendency_of_mole_concentration_of_aragonite_expressed_as_carbon_in_sea_water_due_to_biological_production': {'canonical_units': 'mol '
                                                                                                                                  'm-3 '
                                                                                                                                  's-1'},
 'tendency_of_mole_concentration_of_aragonite_expressed_as_carbon_in_sea_water_due_to_dissolution': {'canonical_units': 'mol '
                                                                                                                        'm-3 '
                                                                                                                        's-1'},
 'tendency_of_mole_concentration_of_calcite_expressed_as_carbon_in_sea_water_due_to_biological_production': {'canonical_units': 'mol '
                                                                                                                                'm-3 '
                                                                                                                                's-1'},
 'tendency_of_mole_concentration_of_calcite_expressed_as_carbon_in_sea_water_due_to_dissolution': {'canonical_units': 'mol '
                                                                                                                      'm-3 '
                                                                                                                      's-1'},
 'tendency_of_mole_concentration_of_dissolved_inorganic_carbon_in_sea_water_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                              'm-3 '
                                                                                                                              's-1'},
 'tendency_of_mole_concentration_of_dissolved_inorganic_iron_in_sea_water_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                            'm-3 '
                                                                                                                            's-1'},
 'tendency_of_mole_concentration_of_dissolved_inorganic_nitrogen_in_sea_water_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                                'm-3 '
                                                                                                                                's-1'},
 'tendency_of_mole_concentration_of_dissolved_inorganic_phosphate_in_sea_water_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                                 'm-3 '
                                                                                                                                 's-1'},
 'tendency_of_mole_concentration_of_dissolved_inorganic_phosphorus_in_sea_water_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                                  'm-3 '
                                                                                                                                  's-1'},
 'tendency_of_mole_concentration_of_dissolved_inorganic_silicate_in_sea_water_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                                'm-3 '
                                                                                                                                's-1'},
 'tendency_of_mole_concentration_of_dissolved_inorganic_silicon_in_sea_water_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                               'm-3 '
                                                                                                                               's-1'},
 'tendency_of_mole_concentration_of_dissolved_iron_in_sea_water_due_to_dissolution_from_inorganic_particles': {'canonical_units': 'mol '
                                                                                                                                  'm-3 '
                                                                                                                                  's-1'},
 'tendency_of_mole_concentration_of_dissolved_iron_in_sea_water_due_to_grazing_of_phytoplankton': {'canonical_units': 'mol '
                                                                                                                      'm-3 '
                                                                                                                      's-1'},
 'tendency_of_mole_concentration_of_dissolved_iron_in_sea_water_due_to_scavenging_by_inorganic_particles': {'canonical_units': 'mol '
                                                                                                                               'm-3 '
                                                                                                                               's-1'},
 'tendency_of_mole_concentration_of_iron_in_sea_water_due_to_biological_production': {'canonical_units': 'mol '
                                                                                                         'm-3 '
                                                                                                         's-1'},
 'tendency_of_mole_concentration_of_ox_in_air_due_to_chemical_and_photolytic_production': {'canonical_units': 'mol '
                                                                                                              'm-3 '
                                                                                                              's-1'},
 'tendency_of_mole_concentration_of_ox_in_air_due_to_chemical_destruction': {'canonical_units': 'mol '
                                                                                                'm-3 '
                                                                                                's-1'},
 'tendency_of_mole_concentration_of_particulate_organic_matter_expressed_as_carbon_in_sea_water_due_to_grazing_of_phytoplankton': {'canonical_units': 'mol '
                                                                                                                                                      'm-3 '
                                                                                                                                                      's-1'},
 'tendency_of_mole_concentration_of_particulate_organic_matter_expressed_as_carbon_in_sea_water_due_to_net_primary_production': {'canonical_units': 'mol '
                                                                                                                                                    'm-3 '
                                                                                                                                                    's-1'},
 'tendency_of_mole_concentration_of_particulate_organic_matter_expressed_as_carbon_in_sea_water_due_to_net_primary_production_by_calcareous_phytoplankton': {'canonical_units': 'mol '
                                                                                                                                                                                'm-3 '
                                                                                                                                                                                's-1'},
 'tendency_of_mole_concentration_of_particulate_organic_matter_expressed_as_carbon_in_sea_water_due_to_net_primary_production_by_diatoms': {'canonical_units': 'mol '
                                                                                                                                                               'm-3 '
                                                                                                                                                               's-1'},
 'tendency_of_mole_concentration_of_particulate_organic_matter_expressed_as_carbon_in_sea_water_due_to_net_primary_production_by_diazotrophic_phytoplankton': {'canonical_units': 'mol '
                                                                                                                                                                                  'm-3 '
                                                                                                                                                                                  's-1'},
 'tendency_of_mole_concentration_of_particulate_organic_matter_expressed_as_carbon_in_sea_water_due_to_net_primary_production_by_diazotrophs': {'canonical_units': 'mol '
                                                                                                                                                                   'm-3 '
                                                                                                                                                                   's-1'},
 'tendency_of_mole_concentration_of_particulate_organic_matter_expressed_as_carbon_in_sea_water_due_to_net_primary_production_by_miscellaneous_phytoplankton': {'canonical_units': 'mol '
                                                                                                                                                                                   'm-3 '
                                                                                                                                                                                   's-1'},
 'tendency_of_mole_concentration_of_particulate_organic_matter_expressed_as_carbon_in_sea_water_due_to_net_primary_production_by_picophytoplankton': {'canonical_units': 'mol '
                                                                                                                                                                         'm-3 '
                                                                                                                                                                         's-1'},
 'tendency_of_mole_concentration_of_particulate_organic_matter_expressed_as_carbon_in_sea_water_due_to_nitrate_utilization': {'canonical_units': 'mol '
                                                                                                                                                 'm-3 '
                                                                                                                                                 's-1'},
 'tendency_of_mole_concentration_of_particulate_organic_matter_expressed_as_carbon_in_sea_water_due_to_remineralization': {'canonical_units': 'mol '
                                                                                                                                              'm-3 '
                                                                                                                                              's-1'},
 'tendency_of_mole_concentration_of_silicon_in_sea_water_due_to_biological_production': {'canonical_units': 'mol '
                                                                                                            'm-3 '
                                                                                                            's-1'},
 'tendency_of_moles_of_carbon_monoxide_in_atmosphere': {'canonical_units': 'mol '
                                                                           's-1'},
 'tendency_of_moles_of_carbon_monoxide_in_middle_atmosphere': {'canonical_units': 'mol '
                                                                                  's-1'},
 'tendency_of_moles_of_carbon_monoxide_in_troposphere': {'canonical_units': 'mol '
                                                                            's-1'},
 'tendency_of_moles_of_carbon_tetrachloride_in_atmosphere': {'canonical_units': 'mol '
                                                                                's-1'},
 'tendency_of_moles_of_cfc113_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_cfc114_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_cfc115_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_cfc11_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_cfc12_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_halon1202_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_halon1211_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_halon1301_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_halon2402_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_hcc140a_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_hcc140a_in_middle_atmosphere': {'canonical_units': 'mol '
                                                                          's-1'},
 'tendency_of_moles_of_hcc140a_in_troposphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_hcfc22_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_hcfc22_in_troposphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_methane_in_atmosphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_methane_in_middle_atmosphere': {'canonical_units': 'mol '
                                                                          's-1'},
 'tendency_of_moles_of_methane_in_troposphere': {'canonical_units': 'mol s-1'},
 'tendency_of_moles_of_methyl_bromide_in_atmosphere': {'canonical_units': 'mol '
                                                                          's-1'},
 'tendency_of_moles_of_methyl_bromide_in_middle_atmosphere': {'canonical_units': 'mol '
                                                                                 's-1'},
 'tendency_of_moles_of_methyl_bromide_in_troposphere': {'canonical_units': 'mol '
                                                                           's-1'},
 'tendency_of_moles_of_methyl_chloride_in_atmosphere': {'canonical_units': 'mol '
                                                                           's-1'},
 'tendency_of_moles_of_methyl_chloride_in_middle_atmosphere': {'canonical_units': 'mol '
                                                                                  's-1'},
 'tendency_of_moles_of_methyl_chloride_in_troposphere': {'canonical_units': 'mol '
                                                                            's-1'},
 'tendency_of_moles_of_molecular_hydrogen_in_atmosphere': {'canonical_units': 'mol '
                                                                              's-1'},
 'tendency_of_moles_of_molecular_hydrogen_in_middle_atmosphere': {'canonical_units': 'mol '
                                                                                     's-1'},
 'tendency_of_moles_of_molecular_hydrogen_in_troposphere': {'canonical_units': 'mol '
                                                                               's-1'},
 'tendency_of_moles_of_nitrous_oxide_in_atmosphere': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_northward_wind': {'canonical_units': 'm s-2'},
 'tendency_of_northward_wind_due_to_advection': {'canonical_units': 'm s-2'},
 'tendency_of_northward_wind_due_to_convection': {'canonical_units': 'm s-2'},
 'tendency_of_northward_wind_due_to_diffusion': {'canonical_units': 'm s-2'},
 'tendency_of_northward_wind_due_to_gravity_wave_drag': {'canonical_units': 'm '
                                                                            's-2'},
 'tendency_of_northward_wind_due_to_nonorographic_gravity_wave_drag': {'canonical_units': 'm '
                                                                                          's-2'},
 'tendency_of_northward_wind_due_to_orographic_gravity_wave_drag': {'canonical_units': 'm '
                                                                                       's-2'},
 'tendency_of_ocean_barotropic_streamfunction': {'canonical_units': 'm3 s-2'},
 'tendency_of_ocean_eddy_kinetic_energy_content_due_to_bolus_transport': {'canonical_units': 'W '
                                                                                             'm-2'},
 'tendency_of_ocean_eddy_kinetic_energy_content_due_to_parameterized_eddy_advection': {'canonical_units': 'W '
                                                                                                          'm-2'},
 'tendency_of_ocean_mole_content_of_aragonite_expressed_as_carbon_due_to_biological_production': {'canonical_units': 'mol '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'tendency_of_ocean_mole_content_of_calcite_expressed_as_carbon_due_to_biological_production': {'canonical_units': 'mol '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_ocean_mole_content_of_carbon_due_to_runoff_and_sediment_dissolution': {'canonical_units': 'mol '
                                                                                                        'm-2 '
                                                                                                        's-1'},
 'tendency_of_ocean_mole_content_of_carbon_due_to_sedimentation': {'canonical_units': 'mol '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_ocean_mole_content_of_dissolved_inorganic_carbon': {'canonical_units': 'mol '
                                                                                     'm-2 '
                                                                                     's-1'},
 'tendency_of_ocean_mole_content_of_dissolved_inorganic_carbon_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                 'm-2 '
                                                                                                                 's-1'},
 'tendency_of_ocean_mole_content_of_dissolved_inorganic_iron': {'canonical_units': 'mol '
                                                                                   'm-2 '
                                                                                   's-1'},
 'tendency_of_ocean_mole_content_of_dissolved_inorganic_iron_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                               'm-2 '
                                                                                                               's-1'},
 'tendency_of_ocean_mole_content_of_dissolved_inorganic_nitrogen': {'canonical_units': 'mol '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_ocean_mole_content_of_dissolved_inorganic_nitrogen_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                   'm-2 '
                                                                                                                   's-1'},
 'tendency_of_ocean_mole_content_of_dissolved_inorganic_phosphorus': {'canonical_units': 'mol '
                                                                                         'm-2 '
                                                                                         's-1'},
 'tendency_of_ocean_mole_content_of_dissolved_inorganic_phosphorus_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'tendency_of_ocean_mole_content_of_dissolved_inorganic_silicon': {'canonical_units': 'mol '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_ocean_mole_content_of_dissolved_inorganic_silicon_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'tendency_of_ocean_mole_content_of_elemental_nitrogen_due_to_denitrification_and_sedimentation': {'canonical_units': 'mol '
                                                                                                                      'm-2 '
                                                                                                                      's-1'},
 'tendency_of_ocean_mole_content_of_elemental_nitrogen_due_to_deposition_and_fixation_and_runoff': {'canonical_units': 'mol '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_ocean_mole_content_of_elemental_nitrogen_due_to_fixation': {'canonical_units': 'mol '
                                                                                             'm-2 '
                                                                                             's-1'},
 'tendency_of_ocean_mole_content_of_inorganic_carbon': {'canonical_units': 'mol '
                                                                           'm-2 '
                                                                           's-1'},
 'tendency_of_ocean_mole_content_of_inorganic_carbon_due_to_runoff_and_sediment_dissolution': {'canonical_units': 'mol '
                                                                                                                  'm-2 '
                                                                                                                  's-1'},
 'tendency_of_ocean_mole_content_of_inorganic_carbon_due_to_sedimentation': {'canonical_units': 'mol '
                                                                                                'm-2 '
                                                                                                's-1'},
 'tendency_of_ocean_mole_content_of_iron_due_to_biological_production': {'canonical_units': 'mol '
                                                                                            'm-2 '
                                                                                            's-1'},
 'tendency_of_ocean_mole_content_of_iron_due_to_deposition_and_runoff_and_sediment_dissolution': {'canonical_units': 'mol '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'tendency_of_ocean_mole_content_of_iron_due_to_sedimentation': {'canonical_units': 'mol '
                                                                                    'm-2 '
                                                                                    's-1'},
 'tendency_of_ocean_mole_content_of_nitrogen_due_to_biological_production': {'canonical_units': 'mol '
                                                                                                'm-2 '
                                                                                                's-1'},
 'tendency_of_ocean_mole_content_of_organic_carbon_due_to_runoff_and_sediment_dissolution': {'canonical_units': 'mol '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'tendency_of_ocean_mole_content_of_organic_carbon_due_to_sedimentation': {'canonical_units': 'mol '
                                                                                              'm-2 '
                                                                                              's-1'},
 'tendency_of_ocean_mole_content_of_oxidized_nitrogen_compounds_expressed_as_nitrogen_due_to_deposition': {'canonical_units': 'mol '
                                                                                                                              'm-2 '
                                                                                                                              's-1'},
 'tendency_of_ocean_mole_content_of_oxidized_nitrogen_compounds_expressed_as_nitrogen_due_to_dry_deposition': {'canonical_units': 'mol '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_ocean_mole_content_of_oxidized_nitrogen_compounds_expressed_as_nitrogen_due_to_wet_deposition': {'canonical_units': 'mol '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_ocean_mole_content_of_phosphorus_due_to_biological_production': {'canonical_units': 'mol '
                                                                                                  'm-2 '
                                                                                                  's-1'},
 'tendency_of_ocean_mole_content_of_reduced_nitrogen_compounds_expressed_as_nitrogen_due_to_deposition': {'canonical_units': 'mol '
                                                                                                                             'm-2 '
                                                                                                                             's-1'},
 'tendency_of_ocean_mole_content_of_reduced_nitrogen_compounds_expressed_as_nitrogen_due_to_dry_deposition': {'canonical_units': 'mol '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_ocean_mole_content_of_reduced_nitrogen_compounds_expressed_as_nitrogen_due_to_wet_deposition': {'canonical_units': 'mol '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_ocean_mole_content_of_silicon_due_to_biological_production': {'canonical_units': 'mol '
                                                                                               'm-2 '
                                                                                               's-1'},
 'tendency_of_ocean_potential_energy_content': {'canonical_units': 'W m-2'},
 'tendency_of_ocean_potential_energy_content_due_to_background': {'canonical_units': 'W '
                                                                                     'm-2'},
 'tendency_of_ocean_potential_energy_content_due_to_tides': {'canonical_units': 'W '
                                                                                'm-2'},
 'tendency_of_potential_energy_content_of_atmosphere_layer_due_to_advection': {'canonical_units': 'W '
                                                                                                  'm-2'},
 'tendency_of_potential_energy_content_of_ocean_layer_due_to_convection': {'canonical_units': 'W '
                                                                                              'm-2'},
 'tendency_of_potential_energy_content_of_ocean_layer_due_to_diffusion': {'canonical_units': 'W '
                                                                                             'm-2'},
 'tendency_of_sea_ice_amount_due_to_basal_melting': {'canonical_units': 'kg '
                                                                        'm-2 '
                                                                        's-1'},
 'tendency_of_sea_ice_amount_due_to_congelation_ice_accumulation': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'tendency_of_sea_ice_amount_due_to_conversion_of_snow_to_sea_ice': {'canonical_units': 'kg '
                                                                                        'm-2 '
                                                                                        's-1'},
 'tendency_of_sea_ice_amount_due_to_frazil_ice_accumulation_in_leads': {'canonical_units': 'kg '
                                                                                           'm-2 '
                                                                                           's-1'},
 'tendency_of_sea_ice_amount_due_to_lateral_growth_of_ice_floes': {'canonical_units': 'kg '
                                                                                      'm-2 '
                                                                                      's-1'},
 'tendency_of_sea_ice_amount_due_to_lateral_melting': {'canonical_units': 'kg '
                                                                          'm-2 '
                                                                          's-1'},
 'tendency_of_sea_ice_amount_due_to_sea_ice_dynamics': {'canonical_units': 'kg '
                                                                           'm-2 '
                                                                           's-1'},
 'tendency_of_sea_ice_amount_due_to_sea_ice_thermodynamics': {'canonical_units': 'kg '
                                                                                 'm-2 '
                                                                                 's-1'},
 'tendency_of_sea_ice_amount_due_to_snow_conversion': {'canonical_units': 'kg '
                                                                          'm-2 '
                                                                          's-1'},
 'tendency_of_sea_ice_amount_due_to_surface_melting': {'canonical_units': 'kg '
                                                                          'm-2 '
                                                                          's-1'},
 'tendency_of_sea_ice_area_fraction_due_to_dynamics': {'canonical_units': 's-1'},
 'tendency_of_sea_ice_area_fraction_due_to_ridging': {'canonical_units': 's-1'},
 'tendency_of_sea_ice_area_fraction_due_to_thermodynamics': {'canonical_units': 's-1'},
 'tendency_of_sea_ice_thickness_due_to_dynamics': {'canonical_units': 'm s-1'},
 'tendency_of_sea_ice_thickness_due_to_thermodynamics': {'canonical_units': 'm '
                                                                            's-1'},
 'tendency_of_sea_surface_height_above_mean_sea_level': {'canonical_units': 'm '
                                                                            'year-1'},
 'tendency_of_sea_surface_height_above_sea_level': {'canonical_units': 'm '
                                                                       'year-1'},
 'tendency_of_sea_water_alkalinity_expressed_as_mole_equivalent_due_to_biological_processes': {'canonical_units': 'mol '
                                                                                                                  'm-3 '
                                                                                                                  's-1'},
 'tendency_of_sea_water_conservative_temperature_expressed_as_heat_content': {'canonical_units': 'W '
                                                                                                 'm-2'},
 'tendency_of_sea_water_conservative_temperature_expressed_as_heat_content_due_to_parameterized_dianeutral_mixing': {'canonical_units': 'W '
                                                                                                                                        'm-2'},
 'tendency_of_sea_water_conservative_temperature_expressed_as_heat_content_due_to_parameterized_eddy_advection': {'canonical_units': 'W '
                                                                                                                                     'm-2'},
 'tendency_of_sea_water_conservative_temperature_expressed_as_heat_content_due_to_parameterized_eddy_dianeutral_mixing': {'canonical_units': 'W '
                                                                                                                                             'm-2'},
 'tendency_of_sea_water_conservative_temperature_expressed_as_heat_content_due_to_parameterized_mesoscale_eddy_advection': {'canonical_units': 'W '
                                                                                                                                               'm-2'},
 'tendency_of_sea_water_conservative_temperature_expressed_as_heat_content_due_to_parameterized_mesoscale_eddy_diffusion': {'canonical_units': 'W '
                                                                                                                                               'm-2'},
 'tendency_of_sea_water_conservative_temperature_expressed_as_heat_content_due_to_parameterized_submesoscale_eddy_advection': {'canonical_units': 'W '
                                                                                                                                                  'm-2'},
 'tendency_of_sea_water_conservative_temperature_expressed_as_heat_content_due_to_residual_mean_advection': {'canonical_units': 'W '
                                                                                                                                'm-2'},
 'tendency_of_sea_water_potential_temperature_expressed_as_heat_content': {'canonical_units': 'W '
                                                                                              'm-2'},
 'tendency_of_sea_water_potential_temperature_expressed_as_heat_content_due_to_parameterized_dianeutral_mixing': {'canonical_units': 'W '
                                                                                                                                     'm-2'},
 'tendency_of_sea_water_potential_temperature_expressed_as_heat_content_due_to_parameterized_eddy_advection': {'canonical_units': 'W '
                                                                                                                                  'm-2'},
 'tendency_of_sea_water_potential_temperature_expressed_as_heat_content_due_to_parameterized_eddy_dianeutral_mixing': {'canonical_units': 'W '
                                                                                                                                          'm-2'},
 'tendency_of_sea_water_potential_temperature_expressed_as_heat_content_due_to_parameterized_mesoscale_eddy_advection': {'canonical_units': 'W '
                                                                                                                                            'm-2'},
 'tendency_of_sea_water_potential_temperature_expressed_as_heat_content_due_to_parameterized_mesoscale_eddy_diffusion': {'canonical_units': 'W '
                                                                                                                                            'm-2'},
 'tendency_of_sea_water_potential_temperature_expressed_as_heat_content_due_to_parameterized_submesoscale_eddy_advection': {'canonical_units': 'W '
                                                                                                                                               'm-2'},
 'tendency_of_sea_water_potential_temperature_expressed_as_heat_content_due_to_residual_mean_advection': {'canonical_units': 'W '
                                                                                                                             'm-2'},
 'tendency_of_sea_water_salinity': {'canonical_units': '1e-3 s-1'},
 'tendency_of_sea_water_salinity_due_to_advection': {'canonical_units': '1e-3 '
                                                                        's-1'},
 'tendency_of_sea_water_salinity_due_to_bolus_advection': {'canonical_units': '1e-3 '
                                                                              's-1'},
 'tendency_of_sea_water_salinity_due_to_horizontal_mixing': {'canonical_units': '1e-3 '
                                                                                's-1'},
 'tendency_of_sea_water_salinity_due_to_parameterized_eddy_advection': {'canonical_units': '1e-3 '
                                                                                           's-1'},
 'tendency_of_sea_water_salinity_due_to_sea_ice_thermodynamics': {'canonical_units': '1e-3 '
                                                                                     's-1'},
 'tendency_of_sea_water_salinity_due_to_vertical_mixing': {'canonical_units': '1e-3 '
                                                                              's-1'},
 'tendency_of_sea_water_salinity_expressed_as_salt_content': {'canonical_units': 'kg '
                                                                                 'm-2 '
                                                                                 's-1'},
 'tendency_of_sea_water_salinity_expressed_as_salt_content_due_to_parameterized_dianeutral_mixing': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_sea_water_salinity_expressed_as_salt_content_due_to_parameterized_eddy_advection': {'canonical_units': 'kg '
                                                                                                                     'm-2 '
                                                                                                                     's-1'},
 'tendency_of_sea_water_salinity_expressed_as_salt_content_due_to_parameterized_eddy_dianeutral_mixing': {'canonical_units': 'kg '
                                                                                                                             'm-2 '
                                                                                                                             's-1'},
 'tendency_of_sea_water_salinity_expressed_as_salt_content_due_to_parameterized_mesoscale_eddy_advection': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_sea_water_salinity_expressed_as_salt_content_due_to_parameterized_mesoscale_eddy_diffusion': {'canonical_units': 'kg '
                                                                                                                               'm-2 '
                                                                                                                               's-1'},
 'tendency_of_sea_water_salinity_expressed_as_salt_content_due_to_parameterized_submesoscale_eddy_advection': {'canonical_units': 'kg '
                                                                                                                                  'm-2 '
                                                                                                                                  's-1'},
 'tendency_of_sea_water_salinity_expressed_as_salt_content_due_to_residual_mean_advection': {'canonical_units': 'kg '
                                                                                                                'm-2 '
                                                                                                                's-1'},
 'tendency_of_sea_water_temperature': {'canonical_units': 'K s-1'},
 'tendency_of_sea_water_temperature_due_to_advection': {'canonical_units': 'K '
                                                                           's-1'},
 'tendency_of_sea_water_temperature_due_to_bolus_advection': {'canonical_units': 'K '
                                                                                 's-1'},
 'tendency_of_sea_water_temperature_due_to_horizontal_mixing': {'canonical_units': 'K '
                                                                                   's-1'},
 'tendency_of_sea_water_temperature_due_to_parameterized_eddy_advection': {'canonical_units': 'K '
                                                                                              's-1'},
 'tendency_of_sea_water_temperature_due_to_vertical_mixing': {'canonical_units': 'K '
                                                                                 's-1'},
 'tendency_of_soil_and_vegetation_mass_content_of_nitrogen_compounds_expressed_as_nitrogen_due_to_fixation': {'canonical_units': 'kg '
                                                                                                                                 'm-2 '
                                                                                                                                 's-1'},
 'tendency_of_soil_mass_content_of_nitrogen_compounds_expressed_as_nitrogen_due_to_fertilization': {'canonical_units': 'kg '
                                                                                                                       'm-2 '
                                                                                                                       's-1'},
 'tendency_of_specific_humidity': {'canonical_units': 's-1'},
 'tendency_of_specific_humidity_due_to_advection': {'canonical_units': 's-1'},
 'tendency_of_specific_humidity_due_to_boundary_layer_mixing': {'canonical_units': 's-1'},
 'tendency_of_specific_humidity_due_to_convection': {'canonical_units': 's-1'},
 'tendency_of_specific_humidity_due_to_diffusion': {'canonical_units': 's-1'},
 'tendency_of_specific_humidity_due_to_large_scale_precipitation': {'canonical_units': 's-1'},
 'tendency_of_specific_humidity_due_to_model_physics': {'canonical_units': 's-1'},
 'tendency_of_specific_humidity_due_to_stratiform_cloud_and_precipitation': {'canonical_units': 's-1'},
 'tendency_of_specific_humidity_due_to_stratiform_cloud_and_precipitation_and_boundary_layer_mixing': {'canonical_units': 's-1'},
 'tendency_of_specific_humidity_due_to_stratiform_precipitation': {'canonical_units': 's-1'},
 'tendency_of_surface_air_pressure': {'canonical_units': 'Pa s-1'},
 'tendency_of_surface_snow_amount': {'canonical_units': 'kg m-2 s-1'},
 'tendency_of_surface_snow_amount_due_to_conversion_of_snow_to_sea_ice': {'canonical_units': 'kg '
                                                                                             'm-2 '
                                                                                             's-1'},
 'tendency_of_surface_snow_amount_due_to_drifting_into_sea': {'canonical_units': 'kg '
                                                                                 'm-2 '
                                                                                 's-1'},
 'tendency_of_surface_snow_amount_due_to_sea_ice_dynamics': {'canonical_units': 'kg '
                                                                                'm-2 '
                                                                                's-1'},
 'tendency_of_thermal_energy_content_of_surface_snow_due_to_rainfall_temperature_excess_above_freezing': {'canonical_units': 'W '
                                                                                                                             'm-2'},
 'tendency_of_troposphere_moles_of_carbon_monoxide': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_troposphere_moles_of_hcc140a': {'canonical_units': 'mol s-1'},
 'tendency_of_troposphere_moles_of_hcfc22': {'canonical_units': 'mol s-1'},
 'tendency_of_troposphere_moles_of_methane': {'canonical_units': 'mol s-1'},
 'tendency_of_troposphere_moles_of_methyl_bromide': {'canonical_units': 'mol '
                                                                        's-1'},
 'tendency_of_troposphere_moles_of_methyl_chloride': {'canonical_units': 'mol '
                                                                         's-1'},
 'tendency_of_troposphere_moles_of_molecular_hydrogen': {'canonical_units': 'mol '
                                                                            's-1'},
 'tendency_of_upward_air_velocity': {'canonical_units': 'm s-2'},
 'tendency_of_upward_air_velocity_due_to_advection': {'canonical_units': 'm '
                                                                         's-2'},
 'tendency_of_vegetation_mass_content_of_nitrogen_compounds_expressed_as_nitrogen_due_to_fixation': {'canonical_units': 'kg '
                                                                                                                        'm-2 '
                                                                                                                        's-1'},
 'tendency_of_water_vapor_content_of_atmosphere_layer': {'canonical_units': 'kg '
                                                                            'm-2 '
                                                                            's-1'},
 'tendency_of_water_vapor_content_of_atmosphere_layer_due_to_convection': {'canonical_units': 'kg '
                                                                                              'm-2 '
                                                                                              's-1'},
 'tendency_of_water_vapor_content_of_atmosphere_layer_due_to_deep_convection': {'canonical_units': 'kg '
                                                                                                   'm-2 '
                                                                                                   's-1'},
 'tendency_of_water_vapor_content_of_atmosphere_layer_due_to_shallow_convection': {'canonical_units': 'kg '
                                                                                                      'm-2 '
                                                                                                      's-1'},
 'tendency_of_water_vapor_content_of_atmosphere_layer_due_to_turbulence': {'canonical_units': 'kg '
                                                                                              'm-2 '
                                                                                              's-1'},
 'tendency_of_wind_speed_due_to_convection': {'canonical_units': 'm s-2'},
 'tendency_of_wind_speed_due_to_gravity_wave_drag': {'canonical_units': 'm '
                                                                        's-2'},
 'thermal_conductivity_of_frozen_ground': {'canonical_units': 'W m-1 K-1'},
 'thermal_energy_content_of_surface_snow': {'canonical_units': 'J m-2'},
 'thermodynamic_phase_of_cloud_water_particles_at_cloud_top': {'canonical_units': None},
 'thermosteric_change_in_mean_sea_level': {'canonical_units': 'm'},
 'thermosteric_change_in_sea_surface_height': {'canonical_units': 'm'},
 'thickness_of_convective_rainfall_amount': {'canonical_units': 'm'},
 'thickness_of_convective_snowfall_amount': {'canonical_units': 'm'},
 'thickness_of_ice_on_sea_ice_melt_pond': {'canonical_units': 'm'},
 'thickness_of_large_scale_rainfall_amount': {'canonical_units': 'm'},
 'thickness_of_large_scale_snowfall_amount': {'canonical_units': 'm'},
 'thickness_of_liquid_water_cloud': {'canonical_units': 'm'},
 'thickness_of_rainfall_amount': {'canonical_units': 'm'},
 'thickness_of_snowfall_amount': {'canonical_units': 'm'},
 'thickness_of_stratiform_rainfall_amount': {'canonical_units': 'm'},
 'thickness_of_stratiform_snowfall_amount': {'canonical_units': 'm'},
 'thunderstorm_probability': {'canonical_units': '1'},
 'tidal_sea_surface_height_above_lowest_astronomical_tide': {'canonical_units': 'm'},
 'tidal_sea_surface_height_above_mean_higher_high_water': {'canonical_units': 'm'},
 'tidal_sea_surface_height_above_mean_low_water_springs': {'canonical_units': 'm'},
 'tidal_sea_surface_height_above_mean_lower_low_water': {'canonical_units': 'm'},
 'tidal_sea_surface_height_above_mean_sea_level': {'canonical_units': 'm'},
 'time': {'canonical_units': 's'},
 'time_of_maximum_flood_depth': {'canonical_units': 's'},
 'time_sample_difference_due_to_collocation': {'canonical_units': 's'},
 'time_when_flood_water_falls_below_threshold': {'canonical_units': 's'},
 'time_when_flood_water_rises_above_threshold': {'canonical_units': 's'},
 'to_direction_of_air_velocity_relative_to_sea_water': {'canonical_units': 'degree'},
 'to_direction_of_surface_downward_stress': {'canonical_units': 'degree'},
 'toa_adjusted_longwave_forcing': {'canonical_units': 'W m-2'},
 'toa_adjusted_radiative_forcing': {'canonical_units': 'W m-2'},
 'toa_adjusted_shortwave_forcing': {'canonical_units': 'W m-2'},
 'toa_bidirectional_reflectance': {'canonical_units': '1'},
 'toa_brightness_temperature': {'canonical_units': 'K'},
 'toa_brightness_temperature_assuming_clear_sky': {'canonical_units': 'K'},
 'toa_brightness_temperature_bias_at_standard_scene_due_to_intercalibration': {'canonical_units': 'K'},
 'toa_brightness_temperature_of_standard_scene': {'canonical_units': 'K'},
 'toa_cloud_radiative_effect': {'canonical_units': 'W m-2'},
 'toa_incoming_shortwave_flux': {'canonical_units': 'W m-2'},
 'toa_instantaneous_longwave_forcing': {'canonical_units': 'W m-2'},
 'toa_instantaneous_radiative_forcing': {'canonical_units': 'W m-2'},
 'toa_instantaneous_shortwave_forcing': {'canonical_units': 'W m-2'},
 'toa_longwave_cloud_radiative_effect': {'canonical_units': 'W m-2'},
 'toa_longwave_dust_ambient_aerosol_particles_direct_radiative_effect_assuming_clear_sky': {'canonical_units': 'W '
                                                                                                               'm-2'},
 'toa_net_downward_longwave_flux': {'canonical_units': 'W m-2'},
 'toa_net_downward_longwave_flux_assuming_clear_sky': {'canonical_units': 'W '
                                                                          'm-2'},
 'toa_net_downward_radiative_flux': {'canonical_units': 'W m-2'},
 'toa_net_downward_shortwave_flux': {'canonical_units': 'W m-2'},
 'toa_net_downward_shortwave_flux_assuming_clear_sky': {'canonical_units': 'W '
                                                                           'm-2'},
 'toa_net_upward_longwave_flux': {'canonical_units': 'W m-2'},
 'toa_net_upward_longwave_flux_assuming_clear_sky': {'canonical_units': 'W '
                                                                        'm-2'},
 'toa_net_upward_shortwave_flux': {'canonical_units': 'W m-2'},
 'toa_outgoing_longwave_flux': {'canonical_units': 'W m-2'},
 'toa_outgoing_longwave_flux_assuming_clear_sky': {'canonical_units': 'W m-2'},
 'toa_outgoing_longwave_flux_due_to_volcanic_ambient_aerosol_particles_assuming_clear_sky': {'canonical_units': 'W '
                                                                                                                'm-2'},
 'toa_outgoing_radiance_per_unit_wavelength': {'canonical_units': 'W m-2 sr-1 '
                                                                  'm-1'},
 'toa_outgoing_radiance_per_unit_wavelength_due_to_solar_induced_fluorescence': {'canonical_units': 'W '
                                                                                                    'm-2 '
                                                                                                    'sr-1 '
                                                                                                    'm-1'},
 'toa_outgoing_radiance_per_unit_wavenumber': {'canonical_units': 'W m-2 sr-1 '
                                                                  '(m-1)-1'},
 'toa_outgoing_radiance_per_unit_wavenumber_mean_within_collocation_scene': {'canonical_units': 'W '
                                                                                                'm-2 '
                                                                                                'sr-1 '
                                                                                                '(m-1)-1'},
 'toa_outgoing_radiance_per_unit_wavenumber_mean_within_collocation_target': {'canonical_units': 'W '
                                                                                                 'm-2 '
                                                                                                 'sr-1 '
                                                                                                 '(m-1)-1'},
 'toa_outgoing_radiance_per_unit_wavenumber_stdev_within_collocation_scene': {'canonical_units': 'W '
                                                                                                 'm-2 '
                                                                                                 'sr-1 '
                                                                                                 '(m-1)-1'},
 'toa_outgoing_radiance_per_unit_wavenumber_stdev_within_collocation_target': {'canonical_units': 'W '
                                                                                                  'm-2 '
                                                                                                  'sr-1 '
                                                                                                  '(m-1)-1'},
 'toa_outgoing_shortwave_flux': {'canonical_units': 'W m-2'},
 'toa_outgoing_shortwave_flux_assuming_clean_clear_sky': {'canonical_units': 'W '
                                                                             'm-2'},
 'toa_outgoing_shortwave_flux_assuming_clear_sky': {'canonical_units': 'W m-2'},
 'toa_outgoing_shortwave_flux_assuming_clear_sky_and_no_aerosol': {'canonical_units': 'W '
                                                                                      'm-2'},
 'toa_outgoing_shortwave_flux_assuming_no_aerosol': {'canonical_units': 'W '
                                                                        'm-2'},
 'toa_outgoing_shortwave_flux_due_to_volcanic_ambient_aerosol_particles_assuming_clear_sky': {'canonical_units': 'W '
                                                                                                                 'm-2'},
 'toa_shortwave_cloud_radiative_effect': {'canonical_units': 'W m-2'},
 'tracer_lifetime': {'canonical_units': 's'},
 'transpiration_amount': {'canonical_units': 'kg m-2'},
 'transpiration_flux': {'canonical_units': 'kg m-2 s-1'},
 'tropical_cyclone_eye_brightness_temperature': {'canonical_units': 'K'},
 'tropical_cyclone_maximum_sustained_wind_speed': {'canonical_units': 'm s-1'},
 'tropopause_adjusted_longwave_forcing': {'canonical_units': 'W m-2'},
 'tropopause_adjusted_radiative_forcing': {'canonical_units': 'W m-2'},
 'tropopause_adjusted_shortwave_forcing': {'canonical_units': 'W m-2'},
 'tropopause_air_pressure': {'canonical_units': 'Pa'},
 'tropopause_air_temperature': {'canonical_units': 'K'},
 'tropopause_altitude': {'canonical_units': 'm'},
 'tropopause_downwelling_longwave_flux': {'canonical_units': 'W m-2'},
 'tropopause_instantaneous_longwave_forcing': {'canonical_units': 'W m-2'},
 'tropopause_instantaneous_radiative_forcing': {'canonical_units': 'W m-2'},
 'tropopause_instantaneous_shortwave_forcing': {'canonical_units': 'W m-2'},
 'tropopause_net_downward_longwave_flux': {'canonical_units': 'W m-2'},
 'tropopause_net_downward_shortwave_flux': {'canonical_units': 'W m-2'},
 'tropopause_upwelling_shortwave_flux': {'canonical_units': 'W m-2'},
 'troposphere_mole_content_of_bromine_monoxide': {'canonical_units': 'mol m-2'},
 'troposphere_mole_content_of_formaldehyde': {'canonical_units': 'mol m-2'},
 'troposphere_mole_content_of_glyoxal': {'canonical_units': 'mol m-2'},
 'troposphere_mole_content_of_iodine_monoxide': {'canonical_units': 'mol m-2'},
 'troposphere_mole_content_of_nitrogen_dioxide': {'canonical_units': 'mol m-2'},
 'troposphere_mole_content_of_ozone': {'canonical_units': 'mol m-2'},
 'troposphere_mole_content_of_sulfur_dioxide': {'canonical_units': 'mol m-2'},
 'turbulent_mixing_length_of_sea_water': {'canonical_units': 'm'},
 'ultraviolet_index': {'canonical_units': '1'},
 'ultraviolet_index_assuming_clear_sky': {'canonical_units': '1'},
 'ultraviolet_index_assuming_overcast_sky': {'canonical_units': '1'},
 'upward_air_velocity': {'canonical_units': 'm s-1'},
 'upward_air_velocity_expressed_as_tendency_of_sigma': {'canonical_units': 's-1'},
 'upward_derivative_of_eastward_wind': {'canonical_units': 's-1'},
 'upward_derivative_of_northward_wind': {'canonical_units': 's-1'},
 'upward_derivative_of_wind_from_direction': {'canonical_units': 'degree m-1'},
 'upward_dry_static_energy_flux_due_to_diffusion': {'canonical_units': 'W m-2'},
 'upward_eastward_momentum_flux_in_air_due_to_nonorographic_eastward_gravity_waves': {'canonical_units': 'Pa'},
 'upward_eastward_momentum_flux_in_air_due_to_nonorographic_westward_gravity_waves': {'canonical_units': 'Pa'},
 'upward_eastward_momentum_flux_in_air_due_to_orographic_gravity_waves': {'canonical_units': 'Pa'},
 'upward_eastward_stress_at_sea_ice_base': {'canonical_units': 'Pa'},
 'upward_eliassen_palm_flux': {'canonical_units': 'm3 s-2'},
 'upward_eliassen_palm_flux_in_air': {'canonical_units': 'm3 s-2'},
 'upward_flux_of_eastward_momentum_due_to_nonorographic_eastward_gravity_waves': {'canonical_units': 'Pa'},
 'upward_flux_of_eastward_momentum_due_to_nonorographic_westward_gravity_waves': {'canonical_units': 'Pa'},
 'upward_flux_of_eastward_momentum_due_to_orographic_gravity_waves': {'canonical_units': 'Pa'},
 'upward_geothermal_heat_flux_at_ground_level_in_land_ice': {'canonical_units': 'W '
                                                                                'm-2'},
 'upward_geothermal_heat_flux_at_sea_floor': {'canonical_units': 'W m-2'},
 'upward_heat_flux_at_ground_level_in_snow': {'canonical_units': 'W m-2'},
 'upward_heat_flux_at_ground_level_in_soil': {'canonical_units': 'W m-2'},
 'upward_heat_flux_in_air': {'canonical_units': 'W m-2'},
 'upward_heat_flux_in_sea_water_due_to_convection': {'canonical_units': 'W '
                                                                        'm-2'},
 'upward_latent_heat_flux_in_air': {'canonical_units': 'W m-2'},
 'upward_mass_flux_of_air': {'canonical_units': 'kg m-2 s-1'},
 'upward_northward_stress_at_sea_ice_base': {'canonical_units': 'Pa'},
 'upward_ocean_mass_transport': {'canonical_units': 'kg s-1'},
 'upward_sea_ice_basal_heat_flux': {'canonical_units': 'W m-2'},
 'upward_sea_water_velocity': {'canonical_units': 'm s-1'},
 'upward_sea_water_velocity_due_to_parameterized_mesoscale_eddies': {'canonical_units': 'm '
                                                                                        's-1'},
 'upward_sensible_heat_flux_in_air': {'canonical_units': 'W m-2'},
 'upward_transformed_eulerian_mean_air_velocity': {'canonical_units': 'm s-1'},
 'upward_upward_derivative_of_geopotential': {'canonical_units': 's-2'},
 'upward_water_vapor_flux_in_air': {'canonical_units': 'kg m-2 s-1'},
 'upward_water_vapor_flux_in_air_due_to_diffusion': {'canonical_units': 'kg '
                                                                        'm-2 '
                                                                        's-1'},
 'upward_x_stress_at_sea_ice_base': {'canonical_units': 'Pa'},
 'upward_y_stress_at_sea_ice_base': {'canonical_units': 'Pa'},
 'upwelling_longwave_flux_in_air': {'canonical_units': 'W m-2'},
 'upwelling_longwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                          'm-2'},
 'upwelling_longwave_radiance_in_air': {'canonical_units': 'W m-2 sr-1'},
 'upwelling_radiance_per_unit_wavelength_in_air': {'canonical_units': 'W m-2 '
                                                                      'm-1 '
                                                                      'sr-1'},
 'upwelling_radiative_flux_per_unit_wavelength_in_air': {'canonical_units': 'W '
                                                                            'm-2 '
                                                                            'm-1'},
 'upwelling_radiative_flux_per_unit_wavelength_in_sea_water': {'canonical_units': 'W '
                                                                                  'm-2 '
                                                                                  'm-1'},
 'upwelling_shortwave_flux_in_air': {'canonical_units': 'W m-2'},
 'upwelling_shortwave_flux_in_air_assuming_clean_clear_sky': {'canonical_units': 'W '
                                                                                 'm-2'},
 'upwelling_shortwave_flux_in_air_assuming_clear_sky': {'canonical_units': 'W '
                                                                           'm-2'},
 'upwelling_shortwave_flux_in_air_assuming_clear_sky_and_no_aerosol': {'canonical_units': 'W '
                                                                                          'm-2'},
 'upwelling_shortwave_radiance_in_air': {'canonical_units': 'W m-2 sr-1'},
 'upwelling_spectral_radiance_in_air': {'canonical_units': 'W m-2 m-1 sr-1'},
 'upwelling_spectral_radiative_flux_in_air': {'canonical_units': 'W m-2 m-1'},
 'upwelling_spectral_radiative_flux_in_sea_water': {'canonical_units': 'W m-2 '
                                                                       'm-1'},
 'vegetation_area_fraction': {'canonical_units': '1'},
 'vegetation_carbon_content': {'canonical_units': 'kg m-2'},
 'vegetation_mass_content_of_13C': {'canonical_units': 'kg m-2'},
 'vegetation_mass_content_of_14C': {'canonical_units': 'kg m-2'},
 'vegetation_mass_content_of_nitrogen': {'canonical_units': 'kg m-2'},
 'vertical_air_velocity_expressed_as_tendency_of_pressure': {'canonical_units': 'Pa '
                                                                                's-1'},
 'vertical_air_velocity_expressed_as_tendency_of_sigma': {'canonical_units': 's-1'},
 'vertical_component_of_ocean_xy_tracer_diffusivity': {'canonical_units': 'm2 '
                                                                          's-1'},
 'vertical_navigation_clearance_above_waterway_surface': {'canonical_units': 'm'},
 'virtual_salt_flux_correction': {'canonical_units': 'kg m-2 s-1'},
 'virtual_salt_flux_into_sea_water': {'canonical_units': 'kg m-2 s-1'},
 'virtual_salt_flux_into_sea_water_due_to_evaporation': {'canonical_units': 'kg '
                                                                            'm-2 '
                                                                            's-1'},
 'virtual_salt_flux_into_sea_water_due_to_newtonian_relaxation': {'canonical_units': 'kg '
                                                                                     'm-2 '
                                                                                     's-1'},
 'virtual_salt_flux_into_sea_water_due_to_rainfall': {'canonical_units': 'kg '
                                                                         'm-2 '
                                                                         's-1'},
 'virtual_salt_flux_into_sea_water_due_to_sea_ice_thermodynamics': {'canonical_units': 'kg '
                                                                                       'm-2 '
                                                                                       's-1'},
 'virtual_salt_flux_into_sea_water_from_rivers': {'canonical_units': 'kg m-2 '
                                                                     's-1'},
 'virtual_temperature': {'canonical_units': 'K'},
 'visibility_in_air': {'canonical_units': 'm'},
 'volume_absorption_coefficient_in_air_due_to_dried_aerosol_particles': {'canonical_units': 'm-1'},
 'volume_absorption_coefficient_of_radiative_flux_in_sea_water': {'canonical_units': 'm-1'},
 'volume_absorption_coefficient_of_radiative_flux_in_sea_water_due_to_dissolved_organic_matter': {'canonical_units': 'm-1'},
 'volume_attenuated_backwards_scattering_function_in_air': {'canonical_units': 'm-1 '
                                                                               'sr-1'},
 'volume_attenuated_backwards_scattering_function_in_air_assuming_no_aerosol_or_cloud': {'canonical_units': 'm-1 '
                                                                                                            'sr-1'},
 'volume_attenuation_coefficient_of_downwelling_radiative_flux_in_sea_water': {'canonical_units': 'm-1'},
 'volume_backwards_scattering_coefficient_in_air_due_to_dried_aerosol_particles': {'canonical_units': 'm-1'},
 'volume_backwards_scattering_coefficient_of_radiative_flux_in_sea_water': {'canonical_units': 'm-1'},
 'volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water': {'canonical_units': 'm-1'},
 'volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water_corrected_for_pure_water_attenuance': {'canonical_units': 'm-1'},
 'volume_extinction_coefficient_in_air_due_to_ambient_aerosol': {'canonical_units': 'm-1'},
 'volume_extinction_coefficient_in_air_due_to_ambient_aerosol_particles': {'canonical_units': 'm-1'},
 'volume_extinction_coefficient_in_air_due_to_cloud_particles': {'canonical_units': 'm-1'},
 'volume_fraction_of_clay_in_soil': {'canonical_units': '1'},
 'volume_fraction_of_condensed_water_in_soil': {'canonical_units': '1'},
 'volume_fraction_of_condensed_water_in_soil_at_critical_point': {'canonical_units': '1'},
 'volume_fraction_of_condensed_water_in_soil_at_field_capacity': {'canonical_units': '1'},
 'volume_fraction_of_condensed_water_in_soil_at_wilting_point': {'canonical_units': '1'},
 'volume_fraction_of_condensed_water_in_soil_pores': {'canonical_units': '1'},
 'volume_fraction_of_frozen_water_in_soil': {'canonical_units': '1'},
 'volume_fraction_of_oxygen_in_sea_water': {'canonical_units': '1'},
 'volume_fraction_of_sand_in_soil': {'canonical_units': '1'},
 'volume_fraction_of_silt_in_soil': {'canonical_units': '1'},
 'volume_fraction_of_water_in_soil': {'canonical_units': '1'},
 'volume_fraction_of_water_in_soil_at_critical_point': {'canonical_units': '1'},
 'volume_fraction_of_water_in_soil_at_field_capacity': {'canonical_units': '1'},
 'volume_fraction_of_water_in_soil_at_wilting_point': {'canonical_units': '1'},
 'volume_mixing_ratio_of_oxygen_at_stp_in_sea_water': {'canonical_units': '1'},
 'volume_scattering_coefficient_in_air_due_to_ambient_aerosol_particles': {'canonical_units': 'm-1'},
 'volume_scattering_coefficient_in_air_due_to_dried_aerosol_particles': {'canonical_units': 'm-1'},
 'volume_scattering_coefficient_of_radiative_flux_in_air_due_to_ambient_aerosol_particles': {'canonical_units': 'm-1'},
 'volume_scattering_coefficient_of_radiative_flux_in_air_due_to_dried_aerosol_particles': {'canonical_units': 'm-1'},
 'volume_scattering_coefficient_of_radiative_flux_in_sea_water': {'canonical_units': 'm-1'},
 'volume_scattering_function_of_radiative_flux_in_air_due_to_ambient_aerosol_particles': {'canonical_units': 'm-1 '
                                                                                                             'sr-1'},
 'volume_scattering_function_of_radiative_flux_in_sea_water': {'canonical_units': 'm-1 '
                                                                                  'sr-1'},
 'water_content_of_atmosphere_layer': {'canonical_units': 'kg m-2'},
 'water_evaporation_amount': {'canonical_units': 'kg m-2'},
 'water_evaporation_amount_from_canopy': {'canonical_units': 'kg m-2'},
 'water_evaporation_amount_from_canopy_where_land': {'canonical_units': 'kg '
                                                                        'm-2'},
 'water_evaporation_flux': {'canonical_units': 'kg m-2 s-1'},
 'water_evaporation_flux_from_canopy': {'canonical_units': 'kg m-2 s-1'},
 'water_evaporation_flux_from_canopy_where_land': {'canonical_units': 'kg m-2 '
                                                                      's-1'},
 'water_evaporation_flux_from_soil': {'canonical_units': 'kg m-2 s-1'},
 'water_evaporation_flux_where_sea_ice': {'canonical_units': 'kg m-2 s-1'},
 'water_evapotranspiration_flux': {'canonical_units': 'kg m-2 s-1'},
 'water_flux_correction': {'canonical_units': 'kg m-2 s-1'},
 'water_flux_into_ocean': {'canonical_units': 'kg m-2 s-1'},
 'water_flux_into_ocean_from_rivers': {'canonical_units': 'kg m-2 s-1'},
 'water_flux_into_sea_water': {'canonical_units': 'kg m-2 s-1'},
 'water_flux_into_sea_water_due_to_sea_ice_thermodynamics': {'canonical_units': 'kg '
                                                                                'm-2 '
                                                                                's-1'},
 'water_flux_into_sea_water_due_to_surface_drainage': {'canonical_units': 'kg '
                                                                          'm-2 '
                                                                          's-1'},
 'water_flux_into_sea_water_from_icebergs': {'canonical_units': 'kg m-2 s-1'},
 'water_flux_into_sea_water_from_land_ice': {'canonical_units': 'kg m-2 s-1'},
 'water_flux_into_sea_water_from_rivers': {'canonical_units': 'kg m-2 s-1'},
 'water_flux_into_sea_water_from_rivers_and_surface_downward_water_flux': {'canonical_units': 'kg '
                                                                                              'm-2 '
                                                                                              's-1'},
 'water_flux_into_sea_water_without_flux_correction': {'canonical_units': 'kg '
                                                                          'm-2 '
                                                                          's-1'},
 'water_flux_out_of_sea_ice_and_sea_water': {'canonical_units': 'kg m-2 s-1'},
 'water_flux_out_of_sea_water': {'canonical_units': 'kg m-2 s-1'},
 'water_flux_out_of_sea_water_due_to_newtonian_relaxation': {'canonical_units': 'kg '
                                                                                'm-2 '
                                                                                's-1'},
 'water_flux_out_of_sea_water_due_to_sea_ice_thermodynamics': {'canonical_units': 'kg '
                                                                                  'm-2 '
                                                                                  's-1'},
 'water_potential_evaporation_amount': {'canonical_units': 'kg m-2'},
 'water_potential_evaporation_flux': {'canonical_units': 'kg m-2 s-1'},
 'water_sublimation_flux': {'canonical_units': 'kg m-2 s-1'},
 'water_surface_height_above_reference_datum': {'canonical_units': 'm'},
 'water_surface_reference_datum_altitude': {'canonical_units': 'm'},
 'water_table_depth': {'canonical_units': 'm'},
 'water_vapor_content_of_atmosphere_layer': {'canonical_units': 'kg m-2'},
 'water_vapor_partial_pressure_in_air': {'canonical_units': 'Pa'},
 'water_vapor_pressure': {'canonical_units': 'Pa'},
 'water_vapor_saturation_deficit': {'canonical_units': 'Pa'},
 'water_vapor_saturation_deficit_in_air': {'canonical_units': 'Pa'},
 'water_volume_transport_in_river_channel': {'canonical_units': 'm3 s-1'},
 'water_volume_transport_into_ocean_from_rivers': {'canonical_units': 'm3 s-1'},
 'water_volume_transport_into_sea_water_from_rivers': {'canonical_units': 'm3 '
                                                                          's-1'},
 'wave_frequency': {'canonical_units': 's-1'},
 'westward_upward_derivative_of_geopotential': {'canonical_units': 's-2'},
 'westward_westward_derivative_of_geopotential': {'canonical_units': 's-2'},
 'wet_bulb_potential_temperature': {'canonical_units': 'K'},
 'wet_bulb_temperature': {'canonical_units': 'K'},
 'wind_chill_of_air_temperature': {'canonical_units': 'K'},
 'wind_from_direction': {'canonical_units': 'degree'},
 'wind_gust_from_direction': {'canonical_units': 'degree'},
 'wind_mixing_energy_flux_into_ocean': {'canonical_units': 'W m-2'},
 'wind_mixing_energy_flux_into_sea_water': {'canonical_units': 'W m-2'},
 'wind_speed': {'canonical_units': 'm s-1'},
 'wind_speed_of_gust': {'canonical_units': 'm s-1'},
 'wind_speed_shear': {'canonical_units': 's-1'},
 'wind_to_direction': {'canonical_units': 'degree'},
 'wind_wave_period': {'canonical_units': 's'},
 'wood_carbon_content': {'canonical_units': 'kg m-2'},
 'wood_debris_carbon_content': {'canonical_units': 'kg m-2'},
 'wood_debris_mass_content_of_carbon': {'canonical_units': 'kg m-2'},
 'wood_debris_mass_content_of_nitrogen': {'canonical_units': 'kg m-2'},
 'x_derivative_of_ocean_rigid_lid_pressure': {'canonical_units': 'Pa m-1'},
 'x_heat_flux_in_sea_water_due_to_advection': {'canonical_units': 'W m-2'},
 'x_sea_water_velocity': {'canonical_units': 'm s-1'},
 'x_wind': {'canonical_units': 'm s-1'},
 'x_wind_gust': {'canonical_units': 'm s-1'},
 'y_derivative_of_ocean_rigid_lid_pressure': {'canonical_units': 'Pa m-1'},
 'y_heat_flux_in_sea_water_due_to_advection': {'canonical_units': 'W m-2'},
 'y_sea_water_velocity': {'canonical_units': 'm s-1'},
 'y_wind': {'canonical_units': 'm s-1'},
 'y_wind_gust': {'canonical_units': 'm s-1'},
 'zenith_angle': {'canonical_units': 'degree'}}