# Generated by Django 3.2.11 on 2023-02-14 18:32

from django.db import migrations, models
from django.core import management
import django.db.models.deletion
import taggit.managers


def import_all_images(*args, **kwargs):
    management.call_command("import_cloudinary_images")


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("taggit", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="CloudinaryImage",
            fields=[
                (
                    "public_id",
                    models.CharField(max_length=250, primary_key=True, serialize=False),
                ),
                ("url", models.URLField(blank=True, max_length=1000, null=True)),
                (
                    "upload_type",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                (
                    "resource_type",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                ("version", models.PositiveIntegerField(blank=True, null=True)),
                ("width", models.PositiveIntegerField(blank=True, null=True)),
                ("height", models.PositiveIntegerField(blank=True, null=True)),
                ("created_at", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "verbose_name": "Cloudinary Image",
                "verbose_name_plural": "Cloudinary Images",
                "ordering": ["-created_at"],
            },
        ),
        migrations.CreateModel(
            name="TaggedCloudinaryImage",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "content_object",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wagtailcloudinary.cloudinaryimage",
                    ),
                ),
                (
                    "tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="wagtailcloudinary_taggedcloudinaryimage_items",
                        to="taggit.tag",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="cloudinaryimage",
            name="tags",
            field=taggit.managers.TaggableManager(
                blank=True,
                help_text=None,
                through="wagtailcloudinary.TaggedCloudinaryImage",
                to="taggit.Tag",
                verbose_name="tags",
            ),
        ),
        migrations.RunPython(import_all_images, migrations.RunPython.noop),
    ]
