<p align="center">
<img width=75% src="/gridstatus-header.png" alt="gridstatus logo" />
</p>

<p align="center">
    <a href="https://github.com/kmax12/gridstatus/actions?query=branch%3Amain+workflow%3ATests" target="_blank">
        <img src="https://github.com/kmax12/gridstatus/workflows/Tests/badge.svg?branch=main" alt="Tests" />
    </a>
    <a href="https://codecov.io/gh/kmax12/gridstatus" target="_blank">
        <img src="https://codecov.io/gh/kmax12/gridstatus/branch/main/graph/badge.svg" alt="Code Coverage"//>
    </a>
    <a href="https://badge.fury.io/py/gridstatus" target="_blank">
        <img src="https://badge.fury.io/py/gridstatus.svg?maxAge=2592000" alt="PyPI version">
    </a>
</p>

`gridstatus` is a Python library that provides a uniform API for accessing electricity supply, demand, and pricing data for the major Independent System Operators (ISOs) in the United States. It currently supports data from CAISO, SPP, ISONE, MISO, Ercot, NYISO, and PJM.


## GridStatus.io

To preview some the data this library provide access to, visit [GridStatus.io](https://www.gridstatus.io/).

## Community

* Need Help? Post a [GitHub issue](https://github.com/kmax12/gridstatus/issues) 
* Want to chat? Join our [Slack](https://join.slack.com/t/gridstatus/shared_invite/zt-1jk6vlzt2-Lzz4pdpjkJYVUJkynOiIvQ)
* Want to stay updated? Follow us on Twitter [@grid_status](https://twitter.com/grid_status)
* Want to contribute? Read our [Contributing Guide](CONTRIBUTING.md)

## Installation

`gridstatus` supports python 3.8+. Install with pip

```
python -m pip install gridstatus
```

Upgrade using the following command

```
python -m pip install --upgrade gridstatus
```

## Documentation and Examples

To learn more, visit the [documentation](https://docs.gridstatus.io/) and view [example notebooks](https://docs.gridstatus.io/en/latest/Examples/index.html).

## Get Help

We'd love to answer any usage or data access questions! Please let us know by posting a GitHub issue.
