from pathlib import Path
from erdpy.accounts import Address
from erdpy.validators.core import prepare_transaction_data_for_stake

TESTDATA_FOLDER = Path(__file__).parent.joinpath("testdata")


def test_prepare_transaction_data_for_stake():
    node_operator_address = Address("erd1qyu5wthldzr8wx5c9ucg8kjagg0jfs53s8nr3zpz3hypefsdd8ssycr6th")
    validators_file_path = TESTDATA_FOLDER / "validators.json"
    data, gas_limit = prepare_transaction_data_for_stake(node_operator_address, validators_file_path, node_operator_address)
    
    assert data == "stake@03@E7BEAA95B3877F47348DF4DD1CB578A4F7CABF7A20BFEEFE5CDD263878FF132B765E04FEF6F40C93512B666C47ED7719B8902F6C922C04247989B7137E837CC81A62E54712471C97A2DDAB75AA9C2F58F813ED4C0FA722BDE0AB718BFF382208@604882237A9845F508AD03877B5AAB90569683EEB51FAFCBBEB87440BA359992B3C0B837A8757C25BE18132549404F88@78689FD4B1E2E434D567FE01E61598A42717D83124308266BD09CCC15D2339DD318C019914B86AC29ADBAE5DD8A02D0307425E9BD85A296E94943708C72F8C670F0B7C50A890A5719088DBD9F1D062CAD9ACFFA06DF834106EEBE1A4257EF00D@EC54A009695AF56C3585EF623387B67B6DF1974B0B3C9138EB64BDE6EB33978AE9851112B20C99BF63588E8E949E4388@7188B234A8BF834F2E6258012AA09A2AB93178FFAB9C789480275F61FE02CD1B9A58DDC63B79A73ABEA9E2B7AC5CAC0B0D4324EFF50ACA2F0EC946B9AE6797511FA3CE461B57E77129CBA8AB3B51147695D4CE889CBE67905F6586B4E4F22491@C6C637DE17DB5F89A2FA1D1D935CB60C0E5E8958D3BFC47F903F774DD97398C8FE22093E113865EE98C3AFDD1DE62694@0139472EFF6886771A982F3083DA5D421F24C29181E63888228DC81CA60D69E1"
    assert gas_limit == 16464500
