# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['robonomicsinterface']

package_data = \
{'': ['*']}

install_requires = \
['substrate-interface>=1.0.2,<2.0.0']

setup_kwargs = {
    'name': 'robonomics-interface',
    'version': '0.1.2.post1',
    'description': 'Robonomics wrapper over https://github.com/polkascan/py-substrate-interface created to facilitate programming with Robonomics',
    'long_description': '# robonomics-interface\nThis is a simple wrapper over https://github.com/polkascan/py-substrate-interface used to facilitate writing code for applications using Robonomics.\n\nRobonomics project: https://robonomics.network/\n\nRobonomics parachain dapp: https://parachain.robonomics.network/\n_______\n# Installation \n```bash\npip3 install robonomics-interface\n```\n# Usage\n*More info may be found in docstrings in the source code*\n```python\nimport robonomicsinterface as RI\n```\n## Initialization\n```python\ninterface = RI.RobonomicsInterface()\n```\nBy default, you will only be able to fetch Chainstate info from Frontier parachain.\nYou can specify another **node address** (e.g. local), **seed** (more on that [later](#extrinsics)) and custom **registry types**. \n\n\n## Simple case: fetch Chainstate\nHere, no need to pass any arguments, by\n```python\ninterface = RI.RobonomicsInterface()\n```\nyou will be able to read any Chainstate info from the Frontier parachain:\n```python\nnum_dt = interface.custom_chainstate("DigitalTwin", "Total")\n```\nyou can also specify an argument for the query. Several arguments should be put in a list.\n\nThere is a dedicated function to obtain **Datalog**:\n```python\nrecord = interface.fetch_datalog(<ss58_address>:str)\n```\nThis will give you the latest datalog record of the specified account with its timestamp. You may pass an index argument to fetch specific record. If you create an interface with a provided seed, you\'ll be able to fetch self-datalog calling `fetch_datalog` with no arguments (or just the `index` argument). \n\n## Extrinsics\n**Providing seed** (any raw or mnemonic) while initializing **will let you create and submit extrinsics**:\n```python\ninterface = RI.RobonmicsInterface(seed:str = <seed>)\nhash = interface.custom_extrinsic("DigitalTwin", "create")\n```\nhash is the transaction hash of the succeeded extrinsic. You can also specify arguments for the extrinsic as a dictionary.\n\nThere are dedicated functions for recording datalog and sending launch commands:\n```python\ninterface.record_datalaog("Hello, Robonomics")\ninterface.send_launch(<ss58_address>:str, True)\n```\nCurrent nonce definition amd manual nonce setting is also possible.\n\nThis is an evolving package, it may have errors and lack of functionality, fixes are coming.\nFeel free to open issues when faced a problem.\n',
    'author': 'Pavel Tarasov',
    'author_email': 'p040399@outlook.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Multi-Agent-io/robonomics-interface',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>3.6,<4.0',
}


setup(**setup_kwargs)
