import os
import pytest

import pandas as pd
import numpy as np

from astrocabtools.mrs_subviz.src.io.miri_cube_load import get_miri_cube_data
from astrocabtools.mrs_subviz.src.utils.ellipse_xy_transformations import transform_xy_ellipse
from astrocabtools.mrs_subviz.src.utils.rectangle_xy_transformations import transform_xy_rectangle
from astrocabtools.mrs_subviz.src.utils.aperture_operations import background_subtraction

DATA = os.path.join(os.path.dirname(__file__), 'templates')
FVALUES_SUB_RECTANGLE = [-0.00011184333135317571, -0.0019326840743033237, -0.0029986190088769375, -0.0027461333215450558, -0.0028841166954343836, -0.0029131501488803436, -0.002868255922615625, -0.0028298815812105665, -0.004123332602633127, -0.006427779628835751, -0.006788140142068021, -0.006616270366878375, -0.006648338637240699, -0.007814882577786309, -0.013703485625602453, -0.015368134643171244, -0.014823092547055005, -0.01720828688860345, -0.01770970207987952, -0.01858010066321571, -0.022343132594690892, 0.008436534324558691, 0.04590654134982888, 0.05316507156410514, 0.05558128355871275, 0.05399232982053887, 0.05006271260413663, 0.04917767265514592, 0.043636983688363315, 0.045940670167972375, 0.04627599474523411, 0.04679531791541128, 0.046306510767507976, 0.03935150478190588, 0.040412089788151875, 0.03666074333408849, 0.03360677533917886, 0.034943914147238485, 0.03591000590154965, 0.03620054316923379, 0.035041900355346, 0.03444373306854565, 0.0350176029176125, 0.03532165208948965, 0.03494207966926937, 0.03420270059473021, 0.03662449187365101, 0.03693974853960953, 0.0370964341632025, 0.0395794515559646, 0.040468725355134315, 0.03915941901133162, 0.0364283924836033, 0.03472478148335113, 0.03341382138760962, 0.035313770325903805, 0.03798126420814814, 0.03983499342489246, 0.0397369831656555, 0.037634204462388625, 0.037628117528518884, 0.039060346267261875, 0.03799483336903934, 0.03668588160724083, 0.03526444356100833, 0.03607363644752491, 0.036226628176596117, 0.03699462045505341, 0.03701807791405126, 0.03777550813590258, 0.036339515429621515, 0.03692418777810117, 0.037101186048329855, 0.03720024417714488, 0.036921726620911643, 0.03895879889329487, 0.03887038347940225, 0.037084105424654276, 0.037061722724561486, 0.03898936762711912, 0.039083327159605406, 0.03822787334954603, 0.03610230044856995, 0.03646786392193345, 0.03794248223775219, 0.03845808903303723, 0.036719853908921976, 0.03656963245551829, 0.03536631617262824, 0.03472689383238419, 0.03411860467461076, 0.03741647956056702, 0.035518406146161786, 0.03606142728366002, 0.03375653024686549, 0.0348496843305897, 0.03446969257730577, 0.036838285548149274, 0.03408118332776577, 0.03182943308015273, 0.03361531911397015, 0.03371737374266779, 0.03613535721681316, 0.03628567440016538, 0.034536292575127615, 0.03537208632425525, 0.03540503403755206, 0.03524543751583624, 0.03480383815340609, 0.035114699942784294, 0.03597040262319478, 0.035390790626614696, 0.035133349499831976, 0.0353639706941427, 0.037779959208086474, 0.03587476494675758, 0.03691228169926598, 0.03621398945833768, 0.03618746476758355, 0.03590371436394646, 0.03687399511288302, 0.03917207459980523, 0.038056137685293596, 0.0371331012994553, 0.0380269033287001, 0.03779339885546625, 0.03701469004285274, 0.03735358520760736, 0.03729215722023439, 0.03937617561326074, 0.038872925047411085, 0.03919089134685056, 0.039546875076016286, 0.04081540681251905, 0.040093865875113266, 0.04033938216750352, 0.039671265082667356, 0.03887627519140126, 0.03730280695488207, 0.03753105572219216, 0.03719597944235141, 0.03631150984676008, 0.035621688990468414, 0.03767406317865196, 0.038069642659204136, 0.0363204755998546, 0.03729612286185125, 0.036598120445563806, 0.034599073576120354, 0.03380326804918966, 0.03517207822591309, 0.03517334504746461, 0.035887953894886575, 0.03523046007619602, 0.036855587790322476, 0.03755017689820757, 0.03779296416010459, 0.04106666436212654, 0.03790662974206482, 0.03683955191318939, 0.037144937217214145, 0.03707827268208018, 0.03783034973810622, 0.03608069187559031, 0.03447170202815896, 0.03562352696356923, 0.03574725826402965, 0.034647236634663174, 0.03564139464248177, 0.03507000205513578, 0.03633437718288835, 0.038221086862667425, 0.03616862648577418, 0.034974179822461454, 0.03539774571737424, 0.036524786788673956, 0.039100021187956135, 0.03921482171125213, 0.03816488916013533, 0.037525726015472924, 0.037741223421836695, 0.037332130495576085, 0.03782164189880172, 0.038005843189360115, 0.03700802944439808, 0.03631964410448037, 0.036177210161174984, 0.03772208758497238, 0.03748309859875454, 0.03872240961252876, 0.036490904074241555, 0.036881471763292824, 0.03508110589193611, 0.03524112722223092, 0.03594960624892403, 0.034745752301465115, 0.03673647452623317, 0.034892957654479924, 0.033288925836691706, 0.0356717570042681, 0.034657619418186965, 0.03597292247325965, 0.03685998985425718, 0.03625382507155754, 0.03579497168655197, 0.03527737829368276, 0.03542886710746624, 0.03595919552883761, 0.037346454044172576, 0.038170247899730565, 0.036802197226134564, 0.035619808245286246, 0.03337853122178229, 0.03540341364172375, 0.03659019132879172, 0.036098289836671765, 0.03489005795901235, 0.03488884136764112, 0.03348175114047386, 0.03415154366117086, 0.034784426652735505, 0.034106823925300664, 0.03641345108632521, 0.03626617585675923, 0.03652919847952909, 0.0356495832004842, 0.03544491126003402, 0.03639360819382865, 0.03741311375358734, 0.03465874413020492, 0.03617330570232012, 0.03628167246103053, 0.03951173431604328, 0.038973739458904005, 0.04063969883017232, 0.03605346941005862, 0.03819678076180899, 0.037626975708921984, 0.03624893323652809, 0.03513085280201194, 0.0371242287855975, 0.03736766006974028, 0.037685732335175706, 0.03704548021924431, 0.03646169796923485, 0.03790540915439694, 0.038233714953461485, 0.03670241547767411, 0.03521507053305785, 0.03583641108678125, 0.03627469759888945, 0.0349106803944182, 0.03406141909964224, 0.036019973808827, 0.03592416029131534, 0.03797947043776221, 0.03751619067580367, 0.03578277910315888, 0.037399295032674466, 0.03761587830454648, 0.03933077907104809, 0.0380619475806299, 0.03753111585343678, 0.04011713859205137, 0.038237020434717814, 0.036202499530397, 0.03636168851634516, 0.036770589790525145, 0.03708050438011134, 0.03657598281450419, 0.035585479297451206, 0.03618258016938053, 0.037967625508377796, 0.036728154434643875, 0.037048235696813966, 0.03586125810427956, 0.03776413400576312, 0.037887039444061535, 0.03841264968852953, 0.038324556959856496, 0.03752985593069069, 0.039367208927659936, 0.040612004612439856, 0.03855946673756632, 0.03779931675407548, 0.03884635044350811, 0.03853942327580276, 0.03740654231277476, 0.037245174261960994, 0.0374856380185902, 0.037542459144211615, 0.03895452221572472, 0.039071106070678784, 0.037298529786835725, 0.03932650562530644, 0.040285282231797684, 0.03721968482386685, 0.03887643619650642, 0.03768624236006059, 0.03894042949073668, 0.038995026058824094, 0.03828795594836115, 0.03792667508382342, 0.036527350078567174, 0.03749178356292305, 0.03897593107842537, 0.03824021453802229, 0.03750242738133622, 0.0376705832419123, 0.03784317174411995, 0.03859936348693412, 0.0377122683779601, 0.039532185037131296, 0.03792802034923703, 0.03620345740174626, 0.037112356199755905, 0.03985824163860303, 0.037947751011022386, 0.038344807235018416, 0.038247318404085864, 0.03846259942819751, 0.038717667095482605, 0.04104670711150481, 0.04101980252796144, 0.04349985724784383, 0.03846295497713516, 0.03855788019647538, 0.039390849559640076, 0.038794578188263415, 0.03880385706085837, 0.039188341327449715, 0.039200376825873136, 0.039507995414993044, 0.03966450771461837, 0.039728649611544924, 0.03919868856969806, 0.03962442812704135, 0.04064430535473926, 0.038896068906583633, 0.039241431147573905, 0.041454286880562394, 0.03946440027434093, 0.040508539986635346, 0.03819803085974419, 0.037640937848041914, 0.037094157123180115, 0.03940318615132911, 0.039594109514986764, 0.03877522514468982, 0.03691531329183265, 0.03691966846893499, 0.03835662985254748, 0.03982452795988555, 0.0403092897251123, 0.03843799886165325, 0.038700847167346696, 0.03789882674825505, 0.03821267453943749, 0.03843157862907824, 0.03850708676361251, 0.03913316558937555, 0.038932075882858484, 0.039531048331078567, 0.039282380623626094, 0.03864110156375669, 0.04001656454872839, 0.037643104021895954, 0.03810780972351767, 0.03934756736164399, 0.03617232618546287, 0.03968453096208992, 0.03798482166368799, 0.0367591688659992, 0.03834916464362319, 0.03841524210618705, 0.03747996504475973, 0.03622337028918515, 0.03840220782564885, 0.038644127793543565, 0.04180141349863613, 0.038970468239921466, 0.036152881719932195, 0.0377188019067163, 0.03677996944473182, 0.03393110598774661, 0.034358562568046494, 0.036549008276825015, 0.03695894037103763, 0.03772075561062896, 0.03801078374416024, 0.035516621174150984, 0.041614456384662504, 0.04023667547949521, 0.039866880561620216, 0.04139177701292153, 0.0392597923856907, 0.03907794535033439, 0.039293024416284336, 0.039316258993688596, 0.03896794673372232, 0.03913983069778086, 0.03764356490805676, 0.03750059592437463, 0.03832446679840176, 0.036809317106742456, 0.039454473731674336, 0.03905482292926582, 0.03959632135822465, 0.040589772639767194, 0.03810445598010766, 0.041187732627527535, 0.039062013932728554, 0.03792668838798349, 0.03887590396139991, 0.03898322839904887, 0.040374543628653156, 0.03927395757799418, 0.03802243488969598, 0.039130246764130336, 0.03910381996486091, 0.039978303600386664, 0.039818793007999856, 0.03854157301930053, 0.03925444778795317, 0.03892784685634457, 0.038974932272511864, 0.03746592391427095, 0.03701970267595911, 0.038916685782515725, 0.03956192743984607, 0.040466366876802676, 0.040043968216486744, 0.04000625393394654, 0.04096999689779521, 0.03988304158125461, 0.04169858675560857, 0.041351272671916475, 0.04179378908813966, 0.044911528099142464, 0.04378329408442663, 0.04203293696760867, 0.04128367462783712, 0.04127063164689916, 0.039055898288173685, 0.039608841542213516, 0.04058873725098297, 0.03851482812547745, 0.03769484568703997, 0.0401893211029786, 0.039973112790329, 0.039907680970164824, 0.04547027051568836, 0.051075307050672536, 0.0556671186148006, 0.06231453001171958, 0.06739236056577935, 0.07026293717231905, 0.0732936381110917, 0.07174186920843555, 0.06695595176454405, 0.05745635489553859, 0.04889122911508624, 0.04488606651559944, 0.04077755099344878, 0.03948006350506393, 0.0380888205623023, 0.03783637896243221, 0.03874829266665808, 0.03829978892281652, 0.03922004978564886, 0.03893851487940744, 0.03786837272588249, 0.039005344166721856, 0.0410589052314934, 0.03879668282565381, 0.038119420973175194, 0.03637851618744835, 0.03739731536329122, 0.03678896663326714, 0.03751140892698508, 0.03823646156959677, 0.037509154848588466, 0.03568687431350641, 0.038260064480476336, 0.03792256460286772, 0.03798406526205912, 0.036037890395544864, 0.03595171565401542, 0.03580524499273105, 0.037763679447980994, 0.038791873167523375, 0.03997624347183895, 0.03880787181741012, 0.040542837115934705, 0.039018228414149383, 0.03888741411828939, 0.04061043958249774, 0.04127466494157214, 0.03877624635876066, 0.04053974164256448, 0.03927531274177218, 0.04014296408716686, 0.03906855307765392, 0.03631902304694225, 0.03856513866657786, 0.03918708794827487, 0.03434939404455897, 0.03619888255945454, 0.038294357000192125, 0.038038428272386224, 0.039627520322188706, 0.0405043106549713, 0.03821963320064095, 0.036807613722337054, 0.036829152086690214, 0.038449116578403594, 0.03780406670266254, 0.04104586942158549, 0.04023903971412958, 0.037090667885191275, 0.037784424047574816, 0.040932346165437034, 0.03673358746674085, 0.03775484223787892, 0.03854426371321938, 0.037510510163796446, 0.038044729596887164, 0.04150595457005095, 0.037916608650542666, 0.03700275265630602, 0.03852243627633643, 0.039794044298887846, 0.03893178292353815, 0.036876787061592003, 0.03884928512420144, 0.03962245811291394, 0.03984515646094994, 0.038729925424731915, 0.0405244515853693, 0.0401014593696761, 0.04123910837032231, 0.0414793472563212, 0.039079145008382735, 0.03980706689775411, 0.040260478275210926, 0.0391182957438468, 0.03796263384219435, 0.038819826373914124, 0.038795572220872154, 0.03850446328421349, 0.0401692042249326, 0.038305897244595974, 0.04013389112289456, 0.039887158614496335, 0.03933465052065577, 0.03954470935186992, 0.04087219911405443, 0.039823036185694605, 0.039724504072772726, 0.0381880295867431, 0.03802661681712141, 0.037994993227338916, 0.03793981429947953, 0.036813618829698996, 0.036442469935371175, 0.038851713766871465, 0.038901248071135125, 0.03843146927777784, 0.04020818160279406, 0.038637359422344045, 0.03803621252068923, 0.038311090859138044, 0.03703385333296104, 0.03757048695179406, 0.03728530476153388, 0.03726058726374494, 0.039236020989933784, 0.03686533958713571, 0.03756493951768834, 0.03817653497549581, 0.037078600817503846, 0.0387430512089143, 0.039131678737636594, 0.037156635501157595, 0.03587007070391535, 0.03952860118746082, 0.03683854823815809, 0.036289824322223774, 0.034429042616860764, 0.03490211602278617, 0.037109251079529226, 0.037604647228119584, 0.03665290835278512, 0.03581314009654048, 0.03583069067888685, 0.03654891921519787, 0.03601247636376986, 0.037360368727885535, 0.03645433878489038, 0.03629860827367287, 0.036988212607055274, 0.03718556971586011, 0.03793013207165713, 0.037987470208523666, 0.03903385190662412, 0.03858021577759785, 0.038639676677699394, 0.04094599792452924, 0.039178618371679796, 0.0394738482688958, 0.03872512159075263, 0.04021233704449882, 0.03907514263317237, 0.04052463123093146, 0.040781489740840046, 0.037205279744164585, 0.03836079929488857, 0.037989957112397624, 0.03865435434716556, 0.038745092162610004, 0.03721502325753451, 0.03505349676469492, 0.035680535711272984, 0.036028298219699745, 0.03364367726795402, 0.033952177442647155, 0.03495816137477921, 0.035248120193653365, 0.03738472302251743, 0.0356875972915109, 0.03533857051226903, 0.037036811722574295, 0.03733169102726147, 0.03685734752169033, 0.03789253862241794, 0.03730706678333055, 0.03697696864345251, 0.03822772373918558, 0.041178246159271445, 0.03727475203409955, 0.03880629793880437, 0.036148007223908596, 0.037552759266910166, 0.0359640253777266, 0.03524685458865581, 0.03542667362841351, 0.03597260924823546, 0.03704476413882947, 0.03470784017231526, 0.03757050152036395, 0.03833115665151732, 0.038587064625409756, 0.038364575546856086, 0.03844911661982037, 0.03802082248191983, 0.03883089961792177, 0.03738985619021035, 0.03712746327142073, 0.040553782032469454, 0.04192070796522855, 0.04216855676924569, 0.04411751667651419, 0.04322559573798611, 0.0442396813814494, 0.044180511608214235, 0.046389013921103464, 0.04137235198524547, 0.04173593106918033, 0.03983747446417743, 0.03652779304005828, 0.03957218858110631, 0.038285868290829514, 0.03793477222371204, 0.038725451993232934, 0.04074369243691395, 0.03841595028447427, 0.036095851619046784, 0.038115253211945005, 0.036137821049786883, 0.03535209075043037, 0.03638672670459567, 0.03580717212992289, 0.03569219799858532, 0.03610080620116943, 0.03660707674448513, 0.03754063205955921, 0.03674020917752638, 0.036991178248649045, 0.037297289030722366, 0.0368635934159101, 0.03714787663177377, 0.03680525443254712, 0.03602063120464928, 0.03819126722636024, 0.04067942799844053, 0.0389799471019706, 0.038210611183077905, 0.038687210919042744, 0.03736233973942872, 0.03819915571126979, 0.03861830391908501, 0.03463858529436263, 0.03546121804046176, 0.03681881700630908, 0.03361088318472297, 0.036442206369282915, 0.03605823745704623, 0.03494258698989401, 0.033452720573118974, 0.03464099841047451, 0.03568831255351865, 0.03609675006699582, 0.03476438273322738, 0.03567742609392274, 0.0337492753202429, 0.035397839089588226, 0.034154400815248065, 0.03450356962750398, 0.0345864853120495, 0.03576362243393015, 0.0346648595298782, 0.03585021308789284, 0.03962653004971696, 0.03574418238853462, 0.03436227693008764, 0.03499469127904484, 0.03443097577230203, 0.03429482296182393, 0.036182612937134595, 0.03526895424421893, 0.03392827381308523, 0.03522095392282033, 0.03469739566812337, 0.033726304035637256, 0.0325560187063961, 0.03434151853626108, 0.03677069058116739, 0.03703634119252659, 0.035890615324853964, 0.034267911183093414, 0.03453176007150906, 0.03643603174193821, 0.035909914049930935, 0.03549804093812593, 0.037014491545563896, 0.036066411138823876, 0.03783103893217486, 0.035932769893757016, 0.036475355932969494, 0.03353948395976741, 0.03425210364696574, 0.03339804508479255, 0.0322001279905227, 0.03323499272118255, 0.03267150401593838, 0.03405279568939103, 0.03435283222112247, 0.036476809995775974, 0.03624911647932759, 0.035850597936100806, 0.040421891286283096, 0.03385632574111058, 0.036573119365680196, 0.03564041701539315, 0.03696767159531003, 0.03468083328125121, 0.03720631254952268, 0.03661645420826863, 0.03679238969663985, 0.03543148750121179, 0.03567505692888079, 0.03598112993332987, 0.03610174892029214, 0.0356486688317431, 0.03484419317675154, 0.033595406861987476, 0.0349630341741424, 0.036939533474779324, 0.035435160685728107, 0.03699623238208531, 0.03535159255536807, 0.03626097628297688, 0.03641726217649102, 0.03691069051755386, 0.035428829724222954, 0.03417193138470376, 0.0362425807057417, 0.03823115980079886, 0.03964832672330923, 0.038227261632748435, 0.03714989434688325, 0.042080109767195034, 0.041225478261100304, 0.04121223455035421, 0.040573459401557654, 0.04111915800997393, 0.04429492368099375, 0.043853972198506036, 0.04101425724255928, 0.042005625417140716, 0.04720267482135794, 0.046566368410918865, 0.045716626917002165, 0.04481202350828896, 0.050401900865125054, 0.06794355017845442, 0.06865721645287812, 0.06938277713398443, 0.07030586438058453, 0.07165682232977785, 0.07001780850250625, 0.07278258752988714, 0.07399671575549022, 0.07429805464096405, 0.07683708112274731, 0.07314920876344878, 0.07897079385489869, 0.07519123912102353, 0.07214570739304942, 0.0414561545468949, 0.05524266235488587]
BKG_MEAN_RECTANGLE = [1.2427036817019524e-05, 0.00021474267492259153, 0.00033317988987521525, 0.0003051259246161173, 0.0003204574106038204, 0.00032368334987559373, 0.00031869510251284725, 0.00031443128680117406, 0.00045814806695923635, 0.0007141977365373056, 0.0007542377935631135, 0.000735141151875375, 0.0007387042930267443, 0.000868320286420701, 0.001522609513955828, 0.001707570515907916, 0.0016470102830061116, 0.0019120318765114945, 0.001967744675542169, 0.00206445562924619, 0.002482570288298988, 0.0030819868771332086, 0.0033237216080360087, 0.0036040477974782254, 0.003684864231892592, 0.0036324708999897087, 0.0036653605220216844, 0.003732417972798619, 0.004212024073599774, 0.004235705333015447, 0.004189689877114959, 0.004311656173417787, 0.004371490818071302, 0.004926787094784642, 0.0049597591972402695, 0.0052339139583603205, 0.005239627893759946, 0.0053730669560851105, 0.005410837857673065, 0.005444207074300698, 0.005467056247154083, 0.005472249113709823, 0.005482563357094807, 0.005461674012911178, 0.005461473696175264, 0.00547475191960653, 0.005467706083705093, 0.00548935979067805, 0.005510552844008937, 0.005509544194062838, 0.005507565110658489, 0.005537261461233963, 0.005511266311736958, 0.005528927196138535, 0.005491028899846153, 0.005490217715951596, 0.00554200537294035, 0.005506665455632719, 0.005503953793323249, 0.005543781870354147, 0.0054921052301900265, 0.005508169211515794, 0.005511378975468323, 0.0055223035574548185, 0.005539283196986726, 0.005506561204899678, 0.005555965767287932, 0.00552981009673773, 0.005538649646753272, 0.005510076603056342, 0.005529194159361419, 0.005549525082179137, 0.005508855037682462, 0.005514408210272892, 0.005526036562019009, 0.00554918666025419, 0.005603672407833963, 0.005614719411504276, 0.005640733086174866, 0.005584736803189997, 0.005594736696009048, 0.0056281744423046405, 0.005655700347406617, 0.0056107137438927285, 0.00562591757865128, 0.005579234031581222, 0.0056011964970003845, 0.005611979648915641, 0.005628368549847075, 0.005680760385758481, 0.005692965735405307, 0.0056799520288095175, 0.0056580528497571, 0.005614082740980654, 0.005653115648414041, 0.005639961509240195, 0.005654532672967792, 0.005655590026093978, 0.005694038958274475, 0.005710652640188602, 0.005736422615236651, 0.0057336014184324715, 0.0057549278838128805, 0.005743906008500209, 0.005721359195549523, 0.005735067609703018, 0.005705861292604834, 0.005710022060965892, 0.005737355603557576, 0.005726766038581517, 0.005734282661859805, 0.005795494405974994, 0.00573080673004405, 0.005763118728152219, 0.005737503530732405, 0.005761404460873982, 0.005773446514358555, 0.0057203645657151496, 0.005787183926780082, 0.005789061173318262, 0.005808517031194202, 0.005744289607491437, 0.005792804460817489, 0.0058277567590154225, 0.005823167630641175, 0.005851616374225666, 0.005818489509754762, 0.005837593233410279, 0.005846436363340521, 0.005811798840988937, 0.005846033591931208, 0.005837153923123112, 0.00583693947665331, 0.005837512838221218, 0.005833073287766464, 0.005885588502415304, 0.005898190512675904, 0.00588156536082703, 0.005874822666695639, 0.005861284103583917, 0.005871652404335528, 0.00591284374111743, 0.005867946541164233, 0.005869900353366183, 0.005878998487973977, 0.005925258677525701, 0.005918598174414243, 0.005907871265244201, 0.005940812025053858, 0.005941752403503286, 0.005907991823719321, 0.005914584204039001, 0.005932841743809939, 0.005946949166551435, 0.005921812135608956, 0.0059376519597143535, 0.005954685206583237, 0.005953052985278091, 0.00599231473070616, 0.006000812200050923, 0.006000713598730543, 0.0059981596885114175, 0.005966219690165559, 0.005987342468697322, 0.005992538115434756, 0.005976659526628736, 0.00600709975227109, 0.006022689630542466, 0.006020240438023131, 0.006026826332546211, 0.006037360595207798, 0.006049482275580458, 0.006012241649235906, 0.006047547417373923, 0.006059937771363623, 0.006032046523415169, 0.0060669340713625525, 0.006040321520572442, 0.00606704760652349, 0.0060331813263998346, 0.006056630553666644, 0.0060712950131332245, 0.006091691228821218, 0.006032397899269884, 0.006135127480089471, 0.006104834210713729, 0.006093401422424912, 0.00606230603162446, 0.006090918486856058, 0.006090195115235951, 0.006148376780663376, 0.0061166071335033104, 0.006159250510004577, 0.006148303359966472, 0.006137912746183404, 0.006187700722852152, 0.006206353953195187, 0.006165772221458849, 0.006185352077708245, 0.006150445718632001, 0.006169969124312404, 0.006176888095503821, 0.006168785932019792, 0.006147391734946179, 0.00617238233389345, 0.006187230886837976, 0.006212501788872753, 0.006207434009515277, 0.006200818398573932, 0.006200981831608026, 0.0062029095060463545, 0.006188726968621208, 0.006242347140745403, 0.00620547827116285, 0.006220248158928631, 0.006255764375498231, 0.006240491202176466, 0.006269344127399041, 0.006301491268542218, 0.006282018745336951, 0.006241540884646422, 0.006243850971164044, 0.006263420940261977, 0.006238295966341513, 0.006239644393881602, 0.006247434253583369, 0.0062483775229823235, 0.0062859392914822645, 0.006301564312242745, 0.006330356412614831, 0.006334769198882189, 0.006285345375273206, 0.006282041033672803, 0.006285570880480883, 0.00628880744695166, 0.006257436783592247, 0.006292573016686461, 0.0062953805798733236, 0.006330385707121336, 0.006343407536403589, 0.0063437406283922354, 0.006282890075494115, 0.006338714904908142, 0.006351996768805771, 0.0063753593451406085, 0.006380567347316627, 0.0063433892726324935, 0.006356097774858712, 0.006363417927183382, 0.006374904310175271, 0.00634772743977936, 0.00638664122546963, 0.006415034814031747, 0.006440456762783819, 0.006399652231229525, 0.006423703754186935, 0.0063783418345640325, 0.00645253849971304, 0.006408066755593424, 0.006393794539338398, 0.006393390135213695, 0.006379342714409644, 0.006444804835543791, 0.006459244138076673, 0.006437450478277754, 0.0064812172515566376, 0.006488068818917242, 0.006462930420405084, 0.006418625212841056, 0.006438595848485977, 0.006463834249967538, 0.006440259342782919, 0.006428301927638274, 0.00648439367946399, 0.006472016407672821, 0.00652713012160691, 0.0065541416963760335, 0.00650575465598674, 0.006472228074571851, 0.006534552557866982, 0.006517814786579334, 0.006522541910830592, 0.006545223306338638, 0.0065594871826372666, 0.006511991082989203, 0.006530055038118137, 0.006552372727304213, 0.006540213935146302, 0.006519658184299451, 0.006553370952979044, 0.0065920643632040015, 0.0066116467942263345, 0.006562709519474427, 0.006532252458279798, 0.006531479752904946, 0.0065430632201311685, 0.006540489924020642, 0.006585043737603495, 0.006619874361627042, 0.006570587910103387, 0.006609269240309641, 0.006657264256476412, 0.006633872270139546, 0.006632755571314089, 0.006632224745615241, 0.006654372851690595, 0.0066780287623488714, 0.0066692893062896535, 0.006657418792886564, 0.006668166178463566, 0.006632081378441323, 0.006658286634690171, 0.006669522150834915, 0.006664724146978407, 0.0067156666727072765, 0.006692862946720609, 0.006737286307871078, 0.006723443858026506, 0.006687713425925907, 0.006729475377254177, 0.006726786029760382, 0.00670555428395664, 0.006705530547231733, 0.006715098078827341, 0.006714917021802767, 0.00675382384187861, 0.006766817359934962, 0.006734388134389525, 0.00680806140572901, 0.0067926804185499835, 0.006774877498174023, 0.006773525591472315, 0.0067578019468761096, 0.006798863592533127, 0.006825034071172555, 0.006807310364494336, 0.0067695915910147885, 0.006766278271976974, 0.006794950933478671, 0.006814169061290039, 0.0067867596627264265, 0.006810469012412232, 0.006790339346459037, 0.00683103404026166, 0.0068144253765796475, 0.00678943217059285, 0.0068126047894884485, 0.006805359836706911, 0.006826661975032123, 0.0068751716713590745, 0.006924262981045813, 0.006895658506047461, 0.0068735673305124565, 0.006860574607949836, 0.006861871175410261, 0.006866645897881412, 0.006884725969751309, 0.006876011076570576, 0.006897943830377312, 0.006909373668327127, 0.006899773268323979, 0.006887299822018475, 0.006909253250142286, 0.006911177378516777, 0.007009738937503188, 0.00694721171106258, 0.006958486632997327, 0.006943251518445816, 0.006897590975835229, 0.006896362002743818, 0.006899489495372287, 0.006897649671202398, 0.0068737005251954236, 0.006929382329903496, 0.006967322921356904, 0.006957354485880095, 0.007015519838666622, 0.006998357573616478, 0.006981658285274197, 0.006982322663599008, 0.006937444712517625, 0.006945008623879773, 0.006920006470559742, 0.006942363123736987, 0.00694393366133292, 0.0069654570488026845, 0.006978735248366437, 0.007055520089732135, 0.0069753159825355696, 0.0070013521028289005, 0.007051033387204625, 0.006969516551017332, 0.007016096353044791, 0.007091260174191617, 0.007026644730239296, 0.007022644585649893, 0.007042302810703657, 0.007036842381124502, 0.007042493763969613, 0.006998966804662303, 0.007047212372063907, 0.00702508725266661, 0.007067141482194558, 0.0070546021158853, 0.007057365118051132, 0.007058464722986822, 0.007083047811203213, 0.007064760995173778, 0.007046876295405843, 0.007054370761945773, 0.007065203148614831, 0.007066251445714636, 0.007118680662725411, 0.007156064527964163, 0.007115381834638251, 0.0071237337212606226, 0.007186006771267466, 0.007216097904110164, 0.0071984205316496, 0.007137828644119456, 0.0071294020027500545, 0.007132209063619334, 0.007153748698257209, 0.007097020481989017, 0.007169035642545642, 0.007177288397144575, 0.007230774474691735, 0.0072193804000063285, 0.00728444188731645, 0.007271679469409071, 0.0072069515473354735, 0.007156654141948384, 0.007169067443578285, 0.0072242790998244075, 0.007176180716450393, 0.007167634417602836, 0.0072230504978786384, 0.007241827430419358, 0.007291537458198696, 0.007287470736411208, 0.007283900010771496, 0.007296107006596553, 0.0072564517656666305, 0.007244284491388512, 0.007256063212133168, 0.007287778295656109, 0.0072250893841848554, 0.007278138334895897, 0.007269092330256879, 0.0073061913465147866, 0.007351690819372417, 0.007350249346917615, 0.007379577538811768, 0.007402732217668601, 0.007410873696743743, 0.0074565060508385884, 0.007390709145715306, 0.0074433614480785455, 0.007388255999236135, 0.007376059617682691, 0.007375586416992136, 0.007313281457945414, 0.0073702781903837635, 0.007358939544782985, 0.007380601763048584, 0.007369423644019565, 0.0073643729110387714, 0.007330217466170645, 0.007379539324227287, 0.007375178670296487, 0.007326425670232802, 0.0073922239255995075, 0.007392610258688956, 0.007398914678889527, 0.007398888701958873, 0.007345799441298555, 0.007381023034226097, 0.007368398182140071, 0.007402724642017694, 0.007411238296188514, 0.007377124408319082, 0.007445944475649337, 0.007506951995567801, 0.007395774099277905, 0.007429778367040761, 0.007414054284495345, 0.007453652363258041, 0.007468839820212782, 0.007440554102262059, 0.007473785386684598, 0.007471794406572006, 0.0074936635705919056, 0.00750308630256517, 0.007501207367507242, 0.007484795241981582, 0.007482043911404121, 0.007454669489420008, 0.007458335002446266, 0.007455955573412153, 0.007437076035277698, 0.007449663377707091, 0.007488973860405259, 0.00748607661788154, 0.007509785597433441, 0.007538897844108398, 0.007498725546153337, 0.007561301939734602, 0.007523008475816218, 0.0075392710875051665, 0.007524583064010849, 0.007485874659712101, 0.007478817075162743, 0.007489744648721965, 0.007477210635130832, 0.007510142814376252, 0.007470997761269007, 0.007496212403264442, 0.007548585770383558, 0.007585717212435053, 0.0076433169969047435, 0.0076670315423954865, 0.007572452422961183, 0.007569372202499661, 0.007600074310204579, 0.007576634968349361, 0.00759028193505465, 0.00758747472018287, 0.007618609022432334, 0.007650327583964495, 0.007684022592826533, 0.007635712252257037, 0.00763441557224583, 0.007644820255350311, 0.007693064339383858, 0.007668953263558829, 0.007656029729132436, 0.007630058404848604, 0.007638922859757331, 0.0075934538653606425, 0.007608604942849723, 0.007592160966288325, 0.007659034711345624, 0.007639998590277554, 0.007632298222448604, 0.0077253494830229275, 0.00774734307952456, 0.007771324776679889, 0.007726302477640198, 0.007717700284367305, 0.007765968796496113, 0.007720700007294219, 0.007694287913889391, 0.007625121259945713, 0.007632883632993243, 0.007655941874096412, 0.007677833015829028, 0.007701009562840046, 0.007793641619581531, 0.007805616213256844, 0.007844367769670601, 0.007833026768723585, 0.00781486831746098, 0.007781603654396139, 0.00780575219488455, 0.007774932343858937, 0.007745625987973617, 0.007767395269453391, 0.007721037435752512, 0.007728201584515934, 0.007782679546234976, 0.007780011885262127, 0.007818546163854417, 0.00783882493782434, 0.007887521098564509, 0.007847430524653292, 0.007813106903376176, 0.00781361518250137, 0.007837237137326071, 0.0077856168808195575, 0.007800418643584181, 0.0077960830781920645, 0.0077952133223810486, 0.007816383730252984, 0.007843620736783132, 0.00783191583496423, 0.00780950516931289, 0.007815994907869227, 0.00786825979068541, 0.007988386785134466, 0.007904633834074951, 0.007896980807572616, 0.007889204427944512, 0.007868915361676726, 0.007909552337289363, 0.0078029023191341145, 0.007820964641200648, 0.007880959554183055, 0.00784462967854484, 0.007826648264969148, 0.007930799528103405, 0.00790251416644459, 0.007937087377455191, 0.007914924096407346, 0.007896398064679771, 0.007910096948693542, 0.007928464253668187, 0.007928667777856667, 0.00792675570369176, 0.007917799464310253, 0.007939632392893274, 0.007955644242695148, 0.008020756017073251, 0.008022382235026725, 0.007955785240691992, 0.007952067298360265, 0.008070407609778795, 0.008002567916293963, 0.007977490063339907, 0.007945118873815148, 0.008007453351868402, 0.007999398666721695, 0.007962887489632826, 0.007959250722409994, 0.007954095052240153, 0.008005688161381369, 0.007966603496646735, 0.007965724598437343, 0.00800100370701891, 0.008064897448533438, 0.008034379296245201, 0.008049968729498843, 0.008056217929595285, 0.008072212858560147, 0.008029763544251743, 0.008045178284269892, 0.008020378911347091, 0.008035021115697536, 0.008059172704639387, 0.008085419213273323, 0.008081604782061241, 0.008100038357048043, 0.008087142668743412, 0.008037942995541912, 0.008085185910015611, 0.008137908597082081, 0.008134383768867121, 0.008151811333542088, 0.008083831558424903, 0.008086144333412823, 0.008067876299888045, 0.00810352782593604, 0.00806357261862714, 0.008093580329352446, 0.008100293769333633, 0.008145598213693643, 0.00811074465409786, 0.008185141320704756, 0.008145193695302174, 0.008160507047920344, 0.007922146787394661, 0.008043565461967387, 0.008133652872128727, 0.008144102476432089, 0.008123284824081539, 0.00810985439553843, 0.008160123413262346, 0.008151278066923251, 0.008151070342456284, 0.008220756218247995, 0.00825382615430913, 0.008234157337334704, 0.008232695786113206, 0.00827383251357065, 0.008289212560308625, 0.008254158962225418, 0.008204702554809455, 0.008208347970878412, 0.008213772936718343, 0.008229823466237225, 0.00819385326632145, 0.008189002365271432, 0.008226361597982384, 0.008242967162867145, 0.008237595537323674, 0.008267842700754225, 0.008262424549793184, 0.008210734839382798, 0.008251993124298983, 0.008241650061482437, 0.008333004100621377, 0.008305127143378893, 0.008299937267318013, 0.008328409015915498, 0.00825423888273789, 0.00826577977600172, 0.00827733212911859, 0.008255801274680319, 0.00828860343555383, 0.008341912881680446, 0.008376578579415149, 0.008345436566802271, 0.008400462947302735, 0.008378854359044454, 0.00829232947151314, 0.008358042476303921, 0.008373563247534709, 0.008293910908671496, 0.00832745215431687, 0.008329123041928716, 0.008326288996244864, 0.00829236145601076, 0.008318336693631237, 0.00837154838065287, 0.008375728846458718, 0.008366586439164565, 0.008443088355201694, 0.008453957955175003, 0.008427523645270685, 0.008394665842155053, 0.008403526788204942, 0.00845776802694514, 0.008389075457535795, 0.008395656291653081, 0.008380603485505816, 0.008418650145292942, 0.008425204372075832, 0.008419838414571808, 0.00838967697636099, 0.008418276736135584, 0.008438847747051843, 0.008461814480216785, 0.008468427893789562, 0.008499247543695417, 0.008524901055550834, 0.008480884769537376, 0.008460284358641445, 0.00832540853560359, 0.008305952550485933, 0.008731627985808663, 0.008496291697849321, 0.008417557676289572, 0.008427307787594816, 0.008432414511010851, 0.008437645027188563, 0.008519842390072993, 0.008519652371904206, 0.008521871277984578, 0.008531871595953163, 0.008532568392883976, 0.008518815971417187, 0.008469502647694381, 0.008499704350966177, 0.008494425149568927, 0.0084199666003008, 0.00847985938750195, 0.008512756875854167, 0.008436362610118028, 0.008465064889258174, 0.008487660075301318, 0.008790325295083255, 0.008307625905099892, 0.008699759575757878, 0.008538925510990602, 0.008565432586846554, 0.00853468340214369, 0.008519013289269187, 0.008551165843070509, 0.008525779192936189, 0.008516848605469172, 0.00852309500190196, 0.00852438750576885, 0.008535042796985678, 0.008536286196460253, 0.008551670097254218, 0.008594962915684847, 0.008651802264296684, 0.008611665200160797, 0.008643904793437279, 0.008664843423504487, 0.008682765961458663, 0.008614124659131599, 0.008630016482575845, 0.008604395610229021, 0.008651153176664272, 0.008594968457019911, 0.008605341009283349, 0.008634082685936397, 0.00860896004377125, 0.008428296064459388, 0.008430601158267019, 0.008492188368619532, 0.008437280057404148, 0.008566913894800429, 0.00859819837730488, 0.008602642032046007, 0.008343822341710555, 0.008315486844357184, 0.008335437985047142, 0.008200211848378283, 0.00813242099323231, 0.007980840926013477, 0.00794800552507529, 0.007987163704647205, 0.00796989784413149, 0.007147217989280534, 0.005088284489321897, 0.005277951983420761, 0.005260961679188934, 0.005182999648440042, 0.005149151677897839, 0.005209661274769658, 0.005196777672477388, 0.0052462314608860946, 0.005159448685147632, 0.005103864577519512, 0.005002043361733512, 0.004459467633120807, 0.00455924455122772, 0.004326497091730501, 0.0038101572380420897, 0.002366907447821624]

FVALUES_SUB_ELLIPSE = [-3.904068757023842e-05, -0.0006746340099490347, -0.0010467154943558325, -0.0009585813631937871, -0.00100674664694137, -0.0010168812340584999, -0.0010012101927894068, -0.0009878150206733536, -0.0014393146014155015, -0.002243718362316058, -0.0023695079113176523, -0.0023095140420832166, -0.0023207079801480616, -0.002727908632782259, -0.004783418863329555, -0.005364490988262842, -0.005174235405478846, -0.006006825296678018, -0.00618185221682371, -0.006485678638501924, -0.007799224579740395, 0.0004104993156293611, 0.010521071172897788, 0.020619518109558158, 0.021298651023799433, 0.020703777832914848, 0.019769269159993677, 0.019691909518206124, 0.0175708174538381, 0.01802732278492403, 0.01809408684192885, 0.018245158940543814, 0.018242991087414954, 0.015371163247608293, 0.016201507953524496, 0.014891128147517078, 0.013426224373805445, 0.014321299211047155, 0.014683428052643194, 0.014824413542029083, 0.014622124870060996, 0.014059578955535161, 0.014498210694136, 0.014607081330632918, 0.014587533886424624, 0.014407600386290693, 0.015126394715295362, 0.014730762548236062, 0.01514759229853999, 0.015795657834439324, 0.016225779503831087, 0.0159481656853915, 0.014616827073996124, 0.014294439129771037, 0.01434409177629535, 0.014372346363951526, 0.01578780394940312, 0.016350735701276556, 0.016501542080705978, 0.015442688701867192, 0.014799588052540402, 0.015932562452716497, 0.015317685468843888, 0.01524990165174608, 0.014289682266833272, 0.014787210418010448, 0.014591042387453595, 0.014961225702543275, 0.015135640214801835, 0.01493807238348311, 0.014621036382774105, 0.014609257950754646, 0.01514043875064857, 0.01525457270716881, 0.01497552927147628, 0.01630739703917172, 0.01592840112690355, 0.015362141357033586, 0.015222784822142888, 0.015449812183285564, 0.016543945621878792, 0.01517804837082708, 0.015024013618567728, 0.015013759342196668, 0.015216776329716845, 0.015485955207545709, 0.014914555998170074, 0.014870953425238975, 0.014202508791180238, 0.013881254479940531, 0.013790762925699307, 0.014376254893122869, 0.015015299772492396, 0.014196507231722576, 0.012669171433617149, 0.014266886658495972, 0.014167216686476854, 0.01603756644880317, 0.013960825653327874, 0.013067018066798233, 0.013593232512693624, 0.01352600192071814, 0.014601903892142769, 0.01465317698102761, 0.013887382041407513, 0.014719853831192481, 0.014617635949694167, 0.014617880605029623, 0.014132017266671834, 0.014276502339443633, 0.014569643317431491, 0.014523899167405638, 0.014562040162213127, 0.014818950687892279, 0.015468749045151883, 0.015229593467918377, 0.01516347931947952, 0.01446985463535842, 0.01473216509512483, 0.014413163522206694, 0.014652627154816095, 0.015451561773717735, 0.015306663695783526, 0.014957783654784097, 0.015252397355704345, 0.015378254983546953, 0.014906339612635915, 0.01518506028313988, 0.015303730573550653, 0.015640252269637955, 0.015253396954295256, 0.0161113338475595, 0.016405924218567916, 0.016397931177150018, 0.016472551691767395, 0.017300504994645603, 0.016284804512216068, 0.016096645955703186, 0.01509717151725969, 0.015301078201827325, 0.014840259691598072, 0.0148109812437527, 0.014295774885566822, 0.015115244851690825, 0.015449643611016452, 0.014396643698510833, 0.014996433337272658, 0.014446829083471249, 0.013912687742479956, 0.01387861017093132, 0.014318415010012794, 0.014793448020434398, 0.014796813462561793, 0.014646227137569006, 0.01503094788128704, 0.015411239041031252, 0.01601313404042512, 0.017292968693780754, 0.015294371875740138, 0.015281467819956318, 0.015361946504517929, 0.01528684773034861, 0.015329785583993463, 0.014809529190748856, 0.01386293263118248, 0.014157373927014032, 0.01431311400655266, 0.013772337115138231, 0.013823722053508923, 0.014123875957779836, 0.014409694313132253, 0.015484725929824132, 0.01487147898863811, 0.014693843016180978, 0.014629231395206815, 0.015297161230309036, 0.016187811473609807, 0.01620612088780532, 0.016101492076776205, 0.015503649489376974, 0.015392118770200164, 0.015663501324897265, 0.015176675345971571, 0.015558502074701611, 0.014907374752214674, 0.015003555906472066, 0.014597698899993863, 0.015006847825134166, 0.014720146495920686, 0.015428217203480032, 0.014344395395532845, 0.01479692716368515, 0.014359325748626115, 0.014373244769608905, 0.014637325239648575, 0.01412469315863707, 0.014633916042050103, 0.014359984345892095, 0.013851264189224291, 0.014368568413340804, 0.014201745465626598, 0.014772743500762062, 0.014753491047275122, 0.014879535406721708, 0.014498897554598031, 0.014662325584853864, 0.01440622377371088, 0.014744173283868203, 0.015552318457119945, 0.015088128113737883, 0.014630744406742315, 0.014297041988282598, 0.01386667975988757, 0.014065386357245805, 0.0145739224106296, 0.01475127250105774, 0.014289667888762625, 0.014132730334664494, 0.013532625688448294, 0.013841313929040273, 0.014364017562695456, 0.01393624490144051, 0.014764936850378538, 0.014874279634797961, 0.014939304302817237, 0.014588188566792348, 0.014605862218499344, 0.014760261996016908, 0.015443090049668779, 0.0142740845339903, 0.015013334542205551, 0.014716647408937314, 0.01614398734944271, 0.01622328447592961, 0.015902783431936827, 0.014894414768644875, 0.01517800436610028, 0.015290329999088175, 0.014680954252484068, 0.014013982185959496, 0.014685473151670465, 0.014466036468733491, 0.014877056517791493, 0.014422407803505344, 0.014300484622815631, 0.015111423412929061, 0.015155240245865325, 0.014888558712941539, 0.014223725258533482, 0.014726595371754372, 0.01500354846068587, 0.014190593753431721, 0.014065209231697417, 0.014676058648320812, 0.015161069070017946, 0.015169867783697031, 0.015549547225187511, 0.014655882863471581, 0.01563598942715924, 0.015630894988196267, 0.016401428192727687, 0.015833030024446183, 0.015198289668793129, 0.01646915649109684, 0.016023902366442928, 0.015046917647863173, 0.015034482429007193, 0.014891510610833714, 0.015114865536675702, 0.014999431529299164, 0.01422387091177382, 0.014410649457139258, 0.015154898388324275, 0.014531366259731188, 0.01469987715375315, 0.014148957754002742, 0.01532478755808846, 0.015429159719798871, 0.01564847444590145, 0.01567615736569522, 0.01512442163977053, 0.01598250932084171, 0.016018065027883884, 0.015625143062421305, 0.014843949187967016, 0.015412644560031125, 0.015428805762465699, 0.015119113536681932, 0.015709373574537024, 0.015125847293590417, 0.01518995725336899, 0.015796419570278122, 0.016404410087919732, 0.015565614559339469, 0.016160695305443052, 0.01630635053684246, 0.015147294055004694, 0.01620455520050164, 0.015503923055770863, 0.015508183299178004, 0.01550774106073079, 0.015729819155097708, 0.014969913514267904, 0.014672907265430291, 0.015014993916807991, 0.014995885661671312, 0.01484422815196797, 0.015026307885388637, 0.01511720211325001, 0.014908333574469926, 0.015196824454463076, 0.015081924371009265, 0.015339685267368997, 0.015059289967053108, 0.014999589393682223, 0.01480584413153527, 0.015745825775765044, 0.015030929893185354, 0.015011652320201598, 0.01533559558932162, 0.015755133637701365, 0.01555452184902947, 0.016380304111025458, 0.016281718827643045, 0.0171544839222266, 0.014888292328598104, 0.01586831736644189, 0.01597199729784965, 0.015968594514947445, 0.015968774654470448, 0.0162502359030901, 0.015891542467739446, 0.016351494051088808, 0.016405078730150967, 0.016242305019118438, 0.015917805154854907, 0.01623781368592676, 0.01696539196661108, 0.016001763024811384, 0.01588400971978497, 0.017825518085549105, 0.017097098609942993, 0.01666508094763779, 0.015891332039568624, 0.01563602349989532, 0.015169985321358905, 0.015653316080329962, 0.01546538678513791, 0.016053019180422224, 0.015188987687165492, 0.014859404185665327, 0.015656399810560818, 0.016421410715216724, 0.016577863277132617, 0.01558049966637955, 0.015432457959205587, 0.015395291407155957, 0.015102000525073558, 0.015093011926485114, 0.01473609681068844, 0.014920568091420231, 0.01578682616361318, 0.015988304294157384, 0.015709530291661042, 0.015282620833455936, 0.016200569072055866, 0.015021035805733312, 0.015441005003764541, 0.015110608511472487, 0.014308813031400604, 0.015670642599204237, 0.014971721125336096, 0.014553914190878422, 0.015351790318668183, 0.015039277812452786, 0.014961302832510837, 0.014094453805887495, 0.015234675229142215, 0.015061463384015119, 0.01662319260912784, 0.015281393485098736, 0.01470393488207667, 0.015084327761101145, 0.014424773370923759, 0.013334419233508924, 0.013572189101048782, 0.015044247148205233, 0.014718838817719529, 0.015288563722808696, 0.015214438372174514, 0.014136323122423113, 0.016483818615919396, 0.016556629095619092, 0.016730146600787338, 0.01689783838237795, 0.016104988240791637, 0.016290979317444224, 0.015936219035317778, 0.01617482441031911, 0.016026487594962856, 0.016019958941528318, 0.015875454958994957, 0.01549279739702247, 0.01586767718524628, 0.015576902090037422, 0.015937869331548837, 0.016140157742816425, 0.01657652390548574, 0.017185956237268922, 0.015916653547887797, 0.017094295352707328, 0.01672047898062162, 0.015731768500563216, 0.015489786280141454, 0.016494277700533626, 0.01710943877838631, 0.016009196800888397, 0.01536129405833108, 0.016852815496784218, 0.016126211590155752, 0.016862665156099386, 0.01582077367586888, 0.01581252035942727, 0.015922310774340497, 0.015419186275531089, 0.015493823367154623, 0.014912068749443171, 0.015215333594576743, 0.015203422816124367, 0.015534757930297374, 0.016346011913868738, 0.015811653996818272, 0.016269051269955707, 0.016803969671323873, 0.015923994645474036, 0.01712802693838307, 0.016436911357985393, 0.017221331876260793, 0.018157394269651798, 0.017913626810040603, 0.017271603266168396, 0.01680756006779359, 0.01694375878724268, 0.015943503489214497, 0.016006130222671618, 0.01642480868180458, 0.015490566195626169, 0.01529592910901226, 0.015993885379546373, 0.016196656318165567, 0.016281909541239856, 0.018239454055853647, 0.02050040258873432, 0.022632147006613337, 0.025482699782124845, 0.027508478313641834, 0.028981133100457905, 0.029977587500024442, 0.029538178167254934, 0.02712049589143841, 0.02333926135367972, 0.019886794480651945, 0.01800430262445711, 0.016063145493437993, 0.016028727054502756, 0.015247339533310207, 0.015113299119504448, 0.015578638753365313, 0.01572663766654512, 0.015883290463276186, 0.015647682239347, 0.01541010359872514, 0.015725332105463785, 0.016274583871052264, 0.015552768437880806, 0.015357429759861551, 0.015234894406197363, 0.015034915686169183, 0.014702053343457668, 0.014924352636546179, 0.014724964376062587, 0.01496730063138586, 0.014367493946116656, 0.01565359818011653, 0.015380478466222154, 0.015236971724643798, 0.01483941548419019, 0.014571848825315824, 0.014314614469735944, 0.014978511636156558, 0.015638619532968193, 0.016146782316701167, 0.015588724263814215, 0.01621744765070487, 0.015614756862614813, 0.015793136533160407, 0.016164381448318263, 0.01601885457380781, 0.015608285469034942, 0.015992426415972635, 0.016080554517406385, 0.016633954963818053, 0.016051600751082126, 0.014489616967037901, 0.01588658887306672, 0.01594107645143702, 0.014122816361402404, 0.015403624550135785, 0.015722462898524435, 0.015203795533217181, 0.015288683229090796, 0.0159009890344216, 0.015107598018933972, 0.014552006039372897, 0.014801300743171441, 0.014744213306300852, 0.014547319153041985, 0.01691095947032047, 0.01624762661966923, 0.015056676391860684, 0.01584591047893204, 0.016498673717240085, 0.015970016336647495, 0.015818218979927707, 0.015595480675419389, 0.01560716212214307, 0.01567397578418085, 0.016663766865440983, 0.015551648823293747, 0.015441927685381697, 0.01579339018617709, 0.016219605945689875, 0.0164624980257029, 0.01558004400119425, 0.016007883273313678, 0.01615877843938482, 0.016234074400553265, 0.015847171436262485, 0.016908848620126708, 0.016621853023930634, 0.017056445169663908, 0.017647539582507376, 0.016407482508894018, 0.01646776039072629, 0.016559517056155548, 0.0158179159901756, 0.015616656108150696, 0.016445442483103142, 0.01608448803730824, 0.01581425523334174, 0.016574810099443754, 0.01565152413028511, 0.0159225800646279, 0.015974321225100212, 0.016001496435244456, 0.016062036644545686, 0.01669748429926039, 0.016099442666189165, 0.016052251431270925, 0.015512752621403631, 0.015288840466920906, 0.014953265455981666, 0.015832872567238542, 0.014974682394325402, 0.014785641111154477, 0.015311374108287305, 0.015505943739988662, 0.01545911537667874, 0.015337321286816277, 0.01585588445888671, 0.015877899808037457, 0.01502028739051026, 0.015165078763969102, 0.014953636684618198, 0.01456271263449144, 0.015152686716493509, 0.01574124001250195, 0.014760934178344134, 0.015036308013109557, 0.01488077353759057, 0.014326487547144967, 0.01532823407840855, 0.015442235684590223, 0.01447636511757134, 0.01450977833476648, 0.01635192764377185, 0.015234686024197423, 0.014556085972308851, 0.014002756389054807, 0.014337426005063915, 0.01521050483814105, 0.015932193672614066, 0.015066118348668944, 0.0148499698479935, 0.01516361292838939, 0.015072445019652853, 0.014874977003290896, 0.01532943749190975, 0.014376628396981877, 0.014747117706593645, 0.015419332996552862, 0.015434888654028995, 0.016053045245879957, 0.01597085311893721, 0.016248159438756876, 0.015554120186676578, 0.015517580975422888, 0.016728122764203806, 0.015930636047970317, 0.016107145633019473, 0.015266561487263946, 0.015547314388937965, 0.015339341810715511, 0.015736487773284385, 0.015646852839957603, 0.014583654597344693, 0.015218563638939298, 0.01509263560376856, 0.014793216426371426, 0.01540914029858648, 0.01423724351828409, 0.01389361250760435, 0.014361100725177375, 0.014596092445121594, 0.0135669543569539, 0.013079670182655719, 0.013868948876024603, 0.014386883080414282, 0.015446387509873299, 0.014885115112541477, 0.014483373458425288, 0.014902489079524465, 0.01484637165350067, 0.014988708082260663, 0.015673266745115023, 0.015143177118787338, 0.015675636776327585, 0.015802115966351796, 0.017336655168572582, 0.015896527610657567, 0.01614138731443109, 0.015004259781941615, 0.01445411474828449, 0.01399983860197452, 0.01412143704961085, 0.01382970544042958, 0.014336483065216735, 0.014546179416199224, 0.01422110333144063, 0.015417478689370809, 0.014960188976988278, 0.015163671590896984, 0.014635315056835744, 0.014717617353747218, 0.015114811970586398, 0.015412459759484971, 0.01509714232092325, 0.01471601286651298, 0.01652735220447497, 0.01674931267850778, 0.016989936204373376, 0.017530223553524255, 0.017824384687874797, 0.018621928941202452, 0.017959020510453515, 0.019297098784605848, 0.016673038642149373, 0.017188556920046325, 0.016993677525443708, 0.015302936095269701, 0.01610709302698264, 0.015210395458054315, 0.015252991194073823, 0.015348102238497335, 0.016009682004585867, 0.015265219246217647, 0.01449374097961698, 0.0149842191851104, 0.013996084094102874, 0.01392744770250523, 0.014568751094025282, 0.01400291994849548, 0.014317958752321575, 0.014730482500704547, 0.014821781306621748, 0.015374610098017528, 0.015067101321202769, 0.015431231398764088, 0.015628295133541834, 0.015009414184726434, 0.015292244850139664, 0.015273689000125795, 0.014492658840889749, 0.015684119799532742, 0.016647356821702163, 0.015305228921722543, 0.015236393657099088, 0.0156845854994986, 0.014894928586016713, 0.015007326937803628, 0.01540815859398122, 0.014453231167581855, 0.013912877117214499, 0.014053678758006845, 0.013534006688585266, 0.014789224713179425, 0.014818298666834848, 0.014145516209945246, 0.013755969860831555, 0.014115336650169171, 0.01399453497617554, 0.014815962957943348, 0.014588925520642868, 0.014954822528428755, 0.014276615127672018, 0.015127776883085427, 0.014551071005087127, 0.013851208169007208, 0.01376107495805922, 0.014090856548361112, 0.014347421954485445, 0.014312330310539741, 0.015225774992437973, 0.014095011862152278, 0.01388440979213204, 0.014106086602260537, 0.0132798923530257, 0.01405088483914331, 0.014678373420561528, 0.014166456906039931, 0.01384295178131124, 0.014785001831940262, 0.014845782613980018, 0.014197551646269395, 0.013231526202425747, 0.013975337349443794, 0.01448525156016459, 0.014483861624695876, 0.0143858833838836, 0.013443271536214881, 0.01361066849267513, 0.014425875469348572, 0.014161093124543483, 0.0141908876222922, 0.014798966843750323, 0.01487720412794178, 0.01537180934380961, 0.01475533125419649, 0.014837450045154629, 0.013873621363396513, 0.014524621078851788, 0.013878098999196682, 0.013393845675721626, 0.014040599227670172, 0.012759058439018901, 0.013225435430623957, 0.013639794049716207, 0.014220228478363146, 0.014450780427043487, 0.013472064734000207, 0.01607108681713547, 0.01380901449356918, 0.01407251854653923, 0.014475103848764808, 0.014890711720712473, 0.013377353721914544, 0.014701239854949592, 0.014687467223807947, 0.014542761067819234, 0.014388162702951176, 0.014799992013883323, 0.014394846359530058, 0.015398228302698599, 0.014881083877564514, 0.014487862801417294, 0.013120537181163357, 0.013584522420215676, 0.014715638808047299, 0.014569869281219464, 0.014485677118389904, 0.014367187331741763, 0.014633279334850344, 0.01462149371947118, 0.015196700252884214, 0.014365478450737181, 0.014286809771117254, 0.014598033192318963, 0.015097021982794917, 0.015257486050207714, 0.015553113289215076, 0.015485594946409945, 0.01635083645315592, 0.016185031721348556, 0.015652279017799812, 0.015141288083954756, 0.015827604724953145, 0.017878306792045832, 0.01838186387560813, 0.01648629294691549, 0.016280806921658997, 0.018560053362686353, 0.019139224427112213, 0.017646897515331238, 0.017429828408693365, 0.019257918381350436, 0.025896517376301862, 0.025033155415833466, 0.02556561567989975, 0.026319879907416705, 0.026292471564568088, 0.026474199957683964, 0.027278018652193394, 0.027754611163449284, 0.028660732237356372, 0.02948628872566928, 0.02726680140545511, 0.02932106862171257, 0.028745307773505212, 0.026371346109773815, 0.020948182620594988, 0.025861283035226328]
BKG_MEAN_ELLIPSE = [1.2427036817019524e-05, 0.00021474267492259153, 0.00033317988987521525, 0.0003051259246161173, 0.0003204574106038204, 0.00032368334987559373, 0.00031869510251284725, 0.00031443128680117406, 0.00045814806695923635, 0.0007141977365373056, 0.0007542377935631135, 0.000735141151875375, 0.0007387042930267443, 0.000868320286420701, 0.001522609513955828, 0.001707570515907916, 0.0016470102830061116, 0.0019120318765114945, 0.001967744675542169, 0.00206445562924619, 0.002482570288298988, 0.0030819868771332086, 0.0033237216080360087, 0.0036040477974782254, 0.003684864231892592, 0.0036324708999897087, 0.0036653605220216844, 0.003732417972798619, 0.004212024073599774, 0.004235705333015447, 0.004189689877114959, 0.004311656173417787, 0.004371490818071302, 0.004926787094784642, 0.0049597591972402695, 0.0052339139583603205, 0.005239627893759946, 0.0053730669560851105, 0.005410837857673065, 0.005444207074300698, 0.005467056247154083, 0.005472249113709823, 0.005482563357094807, 0.005461674012911178, 0.005461473696175264, 0.00547475191960653, 0.005467706083705093, 0.00548935979067805, 0.005510552844008937, 0.005509544194062838, 0.005507565110658489, 0.005537261461233963, 0.005511266311736958, 0.005528927196138535, 0.005491028899846153, 0.005490217715951596, 0.00554200537294035, 0.005506665455632719, 0.005503953793323249, 0.005543781870354147, 0.0054921052301900265, 0.005508169211515794, 0.005511378975468323, 0.0055223035574548185, 0.005539283196986726, 0.005506561204899678, 0.005555965767287932, 0.00552981009673773, 0.005538649646753272, 0.005510076603056342, 0.005529194159361419, 0.005549525082179137, 0.005508855037682462, 0.005514408210272892, 0.005526036562019009, 0.00554918666025419, 0.005603672407833963, 0.005614719411504276, 0.005640733086174866, 0.005584736803189997, 0.005594736696009048, 0.0056281744423046405, 0.005655700347406617, 0.0056107137438927285, 0.00562591757865128, 0.005579234031581222, 0.0056011964970003845, 0.005611979648915641, 0.005628368549847075, 0.005680760385758481, 0.005692965735405307, 0.0056799520288095175, 0.0056580528497571, 0.005614082740980654, 0.005653115648414041, 0.005639961509240195, 0.005654532672967792, 0.005655590026093978, 0.005694038958274475, 0.005710652640188602, 0.005736422615236651, 0.0057336014184324715, 0.0057549278838128805, 0.005743906008500209, 0.005721359195549523, 0.005735067609703018, 0.005705861292604834, 0.005710022060965892, 0.005737355603557576, 0.005726766038581517, 0.005734282661859805, 0.005795494405974994, 0.00573080673004405, 0.005763118728152219, 0.005737503530732405, 0.005761404460873982, 0.005773446514358555, 0.0057203645657151496, 0.005787183926780082, 0.005789061173318262, 0.005808517031194202, 0.005744289607491437, 0.005792804460817489, 0.0058277567590154225, 0.005823167630641175, 0.005851616374225666, 0.005818489509754762, 0.005837593233410279, 0.005846436363340521, 0.005811798840988937, 0.005846033591931208, 0.005837153923123112, 0.00583693947665331, 0.005837512838221218, 0.005833073287766464, 0.005885588502415304, 0.005898190512675904, 0.00588156536082703, 0.005874822666695639, 0.005861284103583917, 0.005871652404335528, 0.00591284374111743, 0.005867946541164233, 0.005869900353366183, 0.005878998487973977, 0.005925258677525701, 0.005918598174414243, 0.005907871265244201, 0.005940812025053858, 0.005941752403503286, 0.005907991823719321, 0.005914584204039001, 0.005932841743809939, 0.005946949166551435, 0.005921812135608956, 0.0059376519597143535, 0.005954685206583237, 0.005953052985278091, 0.00599231473070616, 0.006000812200050923, 0.006000713598730543, 0.0059981596885114175, 0.005966219690165559, 0.005987342468697322, 0.005992538115434756, 0.005976659526628736, 0.00600709975227109, 0.006022689630542466, 0.006020240438023131, 0.006026826332546211, 0.006037360595207798, 0.006049482275580458, 0.006012241649235906, 0.006047547417373923, 0.006059937771363623, 0.006032046523415169, 0.0060669340713625525, 0.006040321520572442, 0.00606704760652349, 0.0060331813263998346, 0.006056630553666644, 0.0060712950131332245, 0.006091691228821218, 0.006032397899269884, 0.006135127480089471, 0.006104834210713729, 0.006093401422424912, 0.00606230603162446, 0.006090918486856058, 0.006090195115235951, 0.006148376780663376, 0.0061166071335033104, 0.006159250510004577, 0.006148303359966472, 0.006137912746183404, 0.006187700722852152, 0.006206353953195187, 0.006165772221458849, 0.006185352077708245, 0.006150445718632001, 0.006169969124312404, 0.006176888095503821, 0.006168785932019792, 0.006147391734946179, 0.00617238233389345, 0.006187230886837976, 0.006212501788872753, 0.006207434009515277, 0.006200818398573932, 0.006200981831608026, 0.0062029095060463545, 0.006188726968621208, 0.006242347140745403, 0.00620547827116285, 0.006220248158928631, 0.006255764375498231, 0.006240491202176466, 0.006269344127399041, 0.006301491268542218, 0.006282018745336951, 0.006241540884646422, 0.006243850971164044, 0.006263420940261977, 0.006238295966341513, 0.006239644393881602, 0.006247434253583369, 0.0062483775229823235, 0.0062859392914822645, 0.006301564312242745, 0.006330356412614831, 0.006334769198882189, 0.006285345375273206, 0.006282041033672803, 0.006285570880480883, 0.00628880744695166, 0.006257436783592247, 0.006292573016686461, 0.0062953805798733236, 0.006330385707121336, 0.006343407536403589, 0.0063437406283922354, 0.006282890075494115, 0.006338714904908142, 0.006351996768805771, 0.0063753593451406085, 0.006380567347316627, 0.0063433892726324935, 0.006356097774858712, 0.006363417927183382, 0.006374904310175271, 0.00634772743977936, 0.00638664122546963, 0.006415034814031747, 0.006440456762783819, 0.006399652231229525, 0.006423703754186935, 0.0063783418345640325, 0.00645253849971304, 0.006408066755593424, 0.006393794539338398, 0.006393390135213695, 0.006379342714409644, 0.006444804835543791, 0.006459244138076673, 0.006437450478277754, 0.0064812172515566376, 0.006488068818917242, 0.006462930420405084, 0.006418625212841056, 0.006438595848485977, 0.006463834249967538, 0.006440259342782919, 0.006428301927638274, 0.00648439367946399, 0.006472016407672821, 0.00652713012160691, 0.0065541416963760335, 0.00650575465598674, 0.006472228074571851, 0.006534552557866982, 0.006517814786579334, 0.006522541910830592, 0.006545223306338638, 0.0065594871826372666, 0.006511991082989203, 0.006530055038118137, 0.006552372727304213, 0.006540213935146302, 0.006519658184299451, 0.006553370952979044, 0.0065920643632040015, 0.0066116467942263345, 0.006562709519474427, 0.006532252458279798, 0.006531479752904946, 0.0065430632201311685, 0.006540489924020642, 0.006585043737603495, 0.006619874361627042, 0.006570587910103387, 0.006609269240309641, 0.006657264256476412, 0.006633872270139546, 0.006632755571314089, 0.006632224745615241, 0.006654372851690595, 0.0066780287623488714, 0.0066692893062896535, 0.006657418792886564, 0.006668166178463566, 0.006632081378441323, 0.006658286634690171, 0.006669522150834915, 0.006664724146978407, 0.0067156666727072765, 0.006692862946720609, 0.006737286307871078, 0.006723443858026506, 0.006687713425925907, 0.006729475377254177, 0.006726786029760382, 0.00670555428395664, 0.006705530547231733, 0.006715098078827341, 0.006714917021802767, 0.00675382384187861, 0.006766817359934962, 0.006734388134389525, 0.00680806140572901, 0.0067926804185499835, 0.006774877498174023, 0.006773525591472315, 0.0067578019468761096, 0.006798863592533127, 0.006825034071172555, 0.006807310364494336, 0.0067695915910147885, 0.006766278271976974, 0.006794950933478671, 0.006814169061290039, 0.0067867596627264265, 0.006810469012412232, 0.006790339346459037, 0.00683103404026166, 0.0068144253765796475, 0.00678943217059285, 0.0068126047894884485, 0.006805359836706911, 0.006826661975032123, 0.0068751716713590745, 0.006924262981045813, 0.006895658506047461, 0.0068735673305124565, 0.006860574607949836, 0.006861871175410261, 0.006866645897881412, 0.006884725969751309, 0.006876011076570576, 0.006897943830377312, 0.006909373668327127, 0.006899773268323979, 0.006887299822018475, 0.006909253250142286, 0.006911177378516777, 0.007009738937503188, 0.00694721171106258, 0.006958486632997327, 0.006943251518445816, 0.006897590975835229, 0.006896362002743818, 0.006899489495372287, 0.006897649671202398, 0.0068737005251954236, 0.006929382329903496, 0.006967322921356904, 0.006957354485880095, 0.007015519838666622, 0.006998357573616478, 0.006981658285274197, 0.006982322663599008, 0.006937444712517625, 0.006945008623879773, 0.006920006470559742, 0.006942363123736987, 0.00694393366133292, 0.0069654570488026845, 0.006978735248366437, 0.007055520089732135, 0.0069753159825355696, 0.0070013521028289005, 0.007051033387204625, 0.006969516551017332, 0.007016096353044791, 0.007091260174191617, 0.007026644730239296, 0.007022644585649893, 0.007042302810703657, 0.007036842381124502, 0.007042493763969613, 0.006998966804662303, 0.007047212372063907, 0.00702508725266661, 0.007067141482194558, 0.0070546021158853, 0.007057365118051132, 0.007058464722986822, 0.007083047811203213, 0.007064760995173778, 0.007046876295405843, 0.007054370761945773, 0.007065203148614831, 0.007066251445714636, 0.007118680662725411, 0.007156064527964163, 0.007115381834638251, 0.0071237337212606226, 0.007186006771267466, 0.007216097904110164, 0.0071984205316496, 0.007137828644119456, 0.0071294020027500545, 0.007132209063619334, 0.007153748698257209, 0.007097020481989017, 0.007169035642545642, 0.007177288397144575, 0.007230774474691735, 0.0072193804000063285, 0.00728444188731645, 0.007271679469409071, 0.0072069515473354735, 0.007156654141948384, 0.007169067443578285, 0.0072242790998244075, 0.007176180716450393, 0.007167634417602836, 0.0072230504978786384, 0.007241827430419358, 0.007291537458198696, 0.007287470736411208, 0.007283900010771496, 0.007296107006596553, 0.0072564517656666305, 0.007244284491388512, 0.007256063212133168, 0.007287778295656109, 0.0072250893841848554, 0.007278138334895897, 0.007269092330256879, 0.0073061913465147866, 0.007351690819372417, 0.007350249346917615, 0.007379577538811768, 0.007402732217668601, 0.007410873696743743, 0.0074565060508385884, 0.007390709145715306, 0.0074433614480785455, 0.007388255999236135, 0.007376059617682691, 0.007375586416992136, 0.007313281457945414, 0.0073702781903837635, 0.007358939544782985, 0.007380601763048584, 0.007369423644019565, 0.0073643729110387714, 0.007330217466170645, 0.007379539324227287, 0.007375178670296487, 0.007326425670232802, 0.0073922239255995075, 0.007392610258688956, 0.007398914678889527, 0.007398888701958873, 0.007345799441298555, 0.007381023034226097, 0.007368398182140071, 0.007402724642017694, 0.007411238296188514, 0.007377124408319082, 0.007445944475649337, 0.007506951995567801, 0.007395774099277905, 0.007429778367040761, 0.007414054284495345, 0.007453652363258041, 0.007468839820212782, 0.007440554102262059, 0.007473785386684598, 0.007471794406572006, 0.0074936635705919056, 0.00750308630256517, 0.007501207367507242, 0.007484795241981582, 0.007482043911404121, 0.007454669489420008, 0.007458335002446266, 0.007455955573412153, 0.007437076035277698, 0.007449663377707091, 0.007488973860405259, 0.00748607661788154, 0.007509785597433441, 0.007538897844108398, 0.007498725546153337, 0.007561301939734602, 0.007523008475816218, 0.0075392710875051665, 0.007524583064010849, 0.007485874659712101, 0.007478817075162743, 0.007489744648721965, 0.007477210635130832, 0.007510142814376252, 0.007470997761269007, 0.007496212403264442, 0.007548585770383558, 0.007585717212435053, 0.0076433169969047435, 0.0076670315423954865, 0.007572452422961183, 0.007569372202499661, 0.007600074310204579, 0.007576634968349361, 0.00759028193505465, 0.00758747472018287, 0.007618609022432334, 0.007650327583964495, 0.007684022592826533, 0.007635712252257037, 0.00763441557224583, 0.007644820255350311, 0.007693064339383858, 0.007668953263558829, 0.007656029729132436, 0.007630058404848604, 0.007638922859757331, 0.0075934538653606425, 0.007608604942849723, 0.007592160966288325, 0.007659034711345624, 0.007639998590277554, 0.007632298222448604, 0.0077253494830229275, 0.00774734307952456, 0.007771324776679889, 0.007726302477640198, 0.007717700284367305, 0.007765968796496113, 0.007720700007294219, 0.007694287913889391, 0.007625121259945713, 0.007632883632993243, 0.007655941874096412, 0.007677833015829028, 0.007701009562840046, 0.007793641619581531, 0.007805616213256844, 0.007844367769670601, 0.007833026768723585, 0.00781486831746098, 0.007781603654396139, 0.00780575219488455, 0.007774932343858937, 0.007745625987973617, 0.007767395269453391, 0.007721037435752512, 0.007728201584515934, 0.007782679546234976, 0.007780011885262127, 0.007818546163854417, 0.00783882493782434, 0.007887521098564509, 0.007847430524653292, 0.007813106903376176, 0.00781361518250137, 0.007837237137326071, 0.0077856168808195575, 0.007800418643584181, 0.0077960830781920645, 0.0077952133223810486, 0.007816383730252984, 0.007843620736783132, 0.00783191583496423, 0.00780950516931289, 0.007815994907869227, 0.00786825979068541, 0.007988386785134466, 0.007904633834074951, 0.007896980807572616, 0.007889204427944512, 0.007868915361676726, 0.007909552337289363, 0.0078029023191341145, 0.007820964641200648, 0.007880959554183055, 0.00784462967854484, 0.007826648264969148, 0.007930799528103405, 0.00790251416644459, 0.007937087377455191, 0.007914924096407346, 0.007896398064679771, 0.007910096948693542, 0.007928464253668187, 0.007928667777856667, 0.00792675570369176, 0.007917799464310253, 0.007939632392893274, 0.007955644242695148, 0.008020756017073251, 0.008022382235026725, 0.007955785240691992, 0.007952067298360265, 0.008070407609778795, 0.008002567916293963, 0.007977490063339907, 0.007945118873815148, 0.008007453351868402, 0.007999398666721695, 0.007962887489632826, 0.007959250722409994, 0.007954095052240153, 0.008005688161381369, 0.007966603496646735, 0.007965724598437343, 0.00800100370701891, 0.008064897448533438, 0.008034379296245201, 0.008049968729498843, 0.008056217929595285, 0.008072212858560147, 0.008029763544251743, 0.008045178284269892, 0.008020378911347091, 0.008035021115697536, 0.008059172704639387, 0.008085419213273323, 0.008081604782061241, 0.008100038357048043, 0.008087142668743412, 0.008037942995541912, 0.008085185910015611, 0.008137908597082081, 0.008134383768867121, 0.008151811333542088, 0.008083831558424903, 0.008086144333412823, 0.008067876299888045, 0.00810352782593604, 0.00806357261862714, 0.008093580329352446, 0.008100293769333633, 0.008145598213693643, 0.00811074465409786, 0.008185141320704756, 0.008145193695302174, 0.008160507047920344, 0.007922146787394661, 0.008043565461967387, 0.008133652872128727, 0.008144102476432089, 0.008123284824081539, 0.00810985439553843, 0.008160123413262346, 0.008151278066923251, 0.008151070342456284, 0.008220756218247995, 0.00825382615430913, 0.008234157337334704, 0.008232695786113206, 0.00827383251357065, 0.008289212560308625, 0.008254158962225418, 0.008204702554809455, 0.008208347970878412, 0.008213772936718343, 0.008229823466237225, 0.00819385326632145, 0.008189002365271432, 0.008226361597982384, 0.008242967162867145, 0.008237595537323674, 0.008267842700754225, 0.008262424549793184, 0.008210734839382798, 0.008251993124298983, 0.008241650061482437, 0.008333004100621377, 0.008305127143378893, 0.008299937267318013, 0.008328409015915498, 0.00825423888273789, 0.00826577977600172, 0.00827733212911859, 0.008255801274680319, 0.00828860343555383, 0.008341912881680446, 0.008376578579415149, 0.008345436566802271, 0.008400462947302735, 0.008378854359044454, 0.00829232947151314, 0.008358042476303921, 0.008373563247534709, 0.008293910908671496, 0.00832745215431687, 0.008329123041928716, 0.008326288996244864, 0.00829236145601076, 0.008318336693631237, 0.00837154838065287, 0.008375728846458718, 0.008366586439164565, 0.008443088355201694, 0.008453957955175003, 0.008427523645270685, 0.008394665842155053, 0.008403526788204942, 0.00845776802694514, 0.008389075457535795, 0.008395656291653081, 0.008380603485505816, 0.008418650145292942, 0.008425204372075832, 0.008419838414571808, 0.00838967697636099, 0.008418276736135584, 0.008438847747051843, 0.008461814480216785, 0.008468427893789562, 0.008499247543695417, 0.008524901055550834, 0.008480884769537376, 0.008460284358641445, 0.00832540853560359, 0.008305952550485933, 0.008731627985808663, 0.008496291697849321, 0.008417557676289572, 0.008427307787594816, 0.008432414511010851, 0.008437645027188563, 0.008519842390072993, 0.008519652371904206, 0.008521871277984578, 0.008531871595953163, 0.008532568392883976, 0.008518815971417187, 0.008469502647694381, 0.008499704350966177, 0.008494425149568927, 0.0084199666003008, 0.00847985938750195, 0.008512756875854167, 0.008436362610118028, 0.008465064889258174, 0.008487660075301318, 0.008790325295083255, 0.008307625905099892, 0.008699759575757878, 0.008538925510990602, 0.008565432586846554, 0.00853468340214369, 0.008519013289269187, 0.008551165843070509, 0.008525779192936189, 0.008516848605469172, 0.00852309500190196, 0.00852438750576885, 0.008535042796985678, 0.008536286196460253, 0.008551670097254218, 0.008594962915684847, 0.008651802264296684, 0.008611665200160797, 0.008643904793437279, 0.008664843423504487, 0.008682765961458663, 0.008614124659131599, 0.008630016482575845, 0.008604395610229021, 0.008651153176664272, 0.008594968457019911, 0.008605341009283349, 0.008634082685936397, 0.00860896004377125, 0.008428296064459388, 0.008430601158267019, 0.008492188368619532, 0.008437280057404148, 0.008566913894800429, 0.00859819837730488, 0.008602642032046007, 0.008343822341710555, 0.008315486844357184, 0.008335437985047142, 0.008200211848378283, 0.00813242099323231, 0.007980840926013477, 0.00794800552507529, 0.007987163704647205, 0.00796989784413149, 0.007147217989280534, 0.005088284489321897, 0.005277951983420761, 0.005260961679188934, 0.005182999648440042, 0.005149151677897839, 0.005209661274769658, 0.005196777672477388, 0.0052462314608860946, 0.005159448685147632, 0.005103864577519512, 0.005002043361733512, 0.004459467633120807, 0.00455924455122772, 0.004326497091730501, 0.0038101572380420897, 0.002366907447821624]



def test_rectangle_background():
    units, cubeObj= get_miri_cube_data(os.path.join(DATA,'dither_ch2-medium_s3d.fits'))

    #Set center of ellipse, the center of the image
    fValues, wValues, aperture = transform_xy_rectangle(centerX = 20., centerY = 15., width = 3., height= 3., cubeObj = cubeObj )
    fValues_sub, bkg_mean = background_subtraction(centerX = 20., centerY = 15., r_in = 5., r_out = 10., aperture = aperture, cubeObj = cubeObj, spectrumValues = fValues)

    assert fValues_sub == pytest.approx(FVALUES_SUB_RECTANGLE)
    assert bkg_mean == pytest.approx(BKG_MEAN_RECTANGLE)

def test_ellipse_background():
    units, cubeObj= get_miri_cube_data(os.path.join(DATA,'dither_ch2-medium_s3d.fits'))

    #Set center of ellipse, the center of the image
    fValues, wValues, aperture = transform_xy_ellipse(centerX = 20., centerY = 15.,aAxis = 2., bAxis= 2., cubeObj = cubeObj )
    fValues_sub, bkg_mean = background_subtraction(centerX = 20., centerY = 15., r_in = 5., r_out = 10., aperture = aperture, cubeObj = cubeObj, spectrumValues = fValues)

    assert fValues_sub == pytest.approx(FVALUES_SUB_ELLIPSE)
    assert bkg_mean == pytest.approx(BKG_MEAN_ELLIPSE)
